/* Copyright (C) 2001 Dmitry Diky <diwil@mail.ru>

This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
author gives you unlimited permission to link the
compiled version of this file into combinations with other programs,
and to distribute those combinations without any restriction coming
from the use of this file.  (The General Public License restrictions
do apply in other respects; for example, they cover modification of
the file, and distribution when not linked into a combine
executable.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.  */


;; -*- mode: asm -*-

#include <io.h>

/***************************************************************
 *	Interrupt Vectors:
 *	WARNING!!! All vectors must be defined here!!!
 *	User may not define its interrupt service routines!
 ***************************************************************/

        .weak _unexpected_
	.global _unexpected_1_
	
	.text
        .p2align 1,0

_unexpected_1_:
	br	#_unexpected_
_unexpected_:
        reti

.section .vectors, "ax", @progbits

.macro  VEC name
	.weak   \name
        .set    \name, _unexpected_1_
        .word   \name
.endm

.global InterruptVectors
        .type   InterruptVectors, @object
	.size InterruptVectors, 0x20


InterruptVectors:
/* e0 */	VEC vector_ffe0
/* e2 */	VEC vector_ffe2
/* e4 */	VEC vector_ffe4
/* e6 */	VEC vector_ffe6
/* e8 */	VEC vector_ffe8
/* ea */	VEC vector_ffea
/* ec */	VEC vector_ffec
/* ee */	VEC vector_ffee
/* f0 */	VEC vector_fff0
/* f2 */	VEC vector_fff2
/* f4 */	VEC vector_fff4
/* f6 */	VEC vector_fff6
/* f8 */	VEC vector_fff8
/* fa */	VEC vector_fffa
/* fc */	VEC vector_fffc

		.word _reset_vector__
/* end of Interrupt vectors decloration */
