
/* Definitions of target machine for GNU compiler,
   for Texas Instruments MSP430 microcontrollers.
   Copyright (C) 2001,2002,2003 Free Software Foundation, Inc.
   Contributed by Dmitry Diky <diwil@mail.ru>

   This file is part of GCC.

   GCC is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GCC is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GCC; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* $Id: */

#ifndef __MSP430_H__
#define __MSP430_H__

extern const char *msp430_endup;
extern const char *msp430_init_stack;
extern const char *msp430_mcu_name;
extern int msp430_has_hwmul;

#define TARGET_CPU_CPP_BUILTINS()                       \
do{							\
  builtin_define_std ("MSP430");			\
  builtin_define_std ("__MSP430__");			\
  if(msp430_has_hwmul)					\
    builtin_define ("MSP430_HAS_HWMUL");		        \
  else							\
    builtin_define ("MSP430_NO_HWMUL");		\
}while(0)

extern int target_flags;

#define MASK_ALL_DEBUG		0x00000FE0
#define MASK_FORCE_HWMUL	0x00001000
#define MASK_STRICT_ALIGN	0x00002000
#define MASK_NO_STACK_INIT	0x00008000
#define MASK_NO_VOLAT_WRKAR	0x00010000
#define MASK_INLINE_HWMUL	0x00040000
#define MASK_NO_HWMUL		0x00100000
#define MASK_NOINT_HWMUL	0x00200000
#define MASK_SAVE_PROLOGUE	0x00400000

#define TARGET_STRICT_ALIGN	(target_flags & MASK_STRICT_ALIGN)
#define TARGET_NO_HWMUL	        (target_flags & MASK_NO_HWMUL)
#define TARGET_HWMUL		(target_flags & MASK_FORCE_HWMUL)
#define TARGET_NOINT_HWMUL	(target_flags & MASK_NOINT_HWMUL)
#define TARGET_ALL_DEBUG 	(target_flags & MASK_ALL_DEBUG)
#define TARGET_NSI		(target_flags & MASK_NO_STACK_INIT)
#define TARGET_NVWA		(target_flags & MASK_NO_VOLAT_WRKAR)
#define TARGET_INLINE_HWMUL	(target_flags & MASK_INLINE_HWMUL)
#define TARGET_SAVE_PROLOGUE	(target_flags & MASK_SAVE_PROLOGUE)


#define TARGET_SWITCHES {						\
  { "deb", MASK_ALL_DEBUG, NULL },					\
  { "strict-align", MASK_STRICT_ALIGN, N_("Force data to be aligned at the word boundary") },	\
  { "force-hwmul", MASK_FORCE_HWMUL,N_("Force hardware multiplier") },\
  { "no-stack-init",MASK_NO_STACK_INIT,N_("No stack init in main()") },	\
  { "no-volatile-workaround",MASK_NO_STACK_INIT,N_("Do not perform volatile workaround for bitwise operations") }, \
  { "inline-hwmul", MASK_INLINE_HWMUL, N_("Issue inline multiplication code for 32-bit integers") }, \
  { "disable-hwmul", MASK_NO_HWMUL, N_("Disable hardware multiplier") }, \
  { "noint-hwmul", MASK_NOINT_HWMUL, N_("Assume deeper interrupt routines does not do hardware multiply")}, \
  { "save-prologue",MASK_SAVE_PROLOGUE, N_("Use subroutine call for function prologue/epilogue when possible")}, \
  { "", 0, NULL } \
}


int msp430_current_function_hwmul_no_int_function_p(void);
#define MSP430_NOINT_HWMUL (msp430_current_function_noint_hwmul_function_p())

#define TARGET_OPTIONS {						      \
 { "init-stack=", &msp430_init_stack, N_("Specify the initial stack address") }, \
 { "mcu=", &msp430_mcu_name, N_("Specify the MCU name") }, \
 { "endup-at=",&msp430_endup,N_("Jump to specified routine at the end of main()")} \
}

#define TARGET_VERSION fprintf (stderr, " (GNU assembler syntax)");

#define OVERRIDE_OPTIONS msp430_override_options()

#define CAN_DEBUG_WITHOUT_FP

#define BITS_BIG_ENDIAN 0
#define BYTES_BIG_ENDIAN 0
#define WORDS_BIG_ENDIAN 0
#define BITS_PER_UNIT 8
#define BITS_PER_WORD 16

#define UNITS_PER_WORD 2

#define POINTER_SIZE 16
#define MAX_FIXED_MODE_SIZE 32
#define PARM_BOUNDARY 16
#define FUNCTION_BOUNDARY 16
#define EMPTY_FIELD_BOUNDARY 16
#define BIGGEST_ALIGNMENT 16
#define STRICT_ALIGNMENT TARGET_STRICT_ALIGN
#define INT_TYPE_SIZE  16
#define SHORT_TYPE_SIZE 16
#define LONG_TYPE_SIZE 32
#define MAX_LONG_TYPE_SIZE 32
#define LONG_LONG_TYPE_SIZE 64
#define  CHAR_TYPE_SIZE 8
#define FLOAT_TYPE_SIZE 32
#define DOUBLE_TYPE_SIZE 32
#define LONG_DOUBLE_TYPE_SIZE 32
#define DEFAULT_SIGNED_CHAR 1

#define SIZE_TYPE ("unsigned int")
#define PTRDIFF_TYPE ("int")
#define WCHAR_TYPE_SIZE 16


#define FIRST_PSEUDO_REGISTER 16

#define FIXED_REGISTERS {\
  1,1,/* r0 r1 == PC  SP */\
  1,1,/* r2 r3 == CG1(SR) CG2*/\
  0,0,/* r4 r5 */\
  0,0,/* r6 r7 */\
  0,0,/* r8 r9 */\
  0,0,/* r10 r11 */\
  0,0,/* r12 r13 */\
  0,0,/* r14 r15 */\
}

#define CALL_USED_REGISTERS {			\
    1,1,/* r0 r1 */				\
    1,1,/* r2 r3 */				\
    0,0,/* r4 r5 */				\
    0,0,/* r6 r7 */				\
    0,0,/* r8 r9 */				\
    0,0,/* r10 r11 */				\
    1,1,/* r12 r13 */				\
    1,1,/* r14 r15 */				\
}

#define NON_SAVING_SETJMP 0

#define REG_ALLOC_ORDER { 15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0 }

#define ORDER_REGS_FOR_LOCAL_ALLOC order_regs_for_local_alloc ()

#define HARD_REGNO_NREGS(REGNO, MODE) \
((GET_MODE_SIZE (MODE) + UNITS_PER_WORD - 1) / UNITS_PER_WORD)

#define HARD_REGNO_MODE_OK(REGNO, MODE) 1

#define MODES_TIEABLE_P(MODE1, MODE2)           	0

enum reg_class {
  NO_REGS,
  PC_REG,			/* r0  - PC	*/
  SP_REG,			/* r1  - SP	*/
  STACK_REGS,			/* r2  - SR	*/
  CG1_REG,			/* r2  - CG1	*/
  CG2_REG,			/* r3  - CG2	*/
  CG_REGS,			/* r2, r3	*/
  GENERAL_REGS,			/* r4 - r15 	*/
  POINTER_REGS,
  FFOUR_REG,
  ALL_REGS, LIM_REG_CLASSES
};
  
#define N_REG_CLASSES (int) LIM_REG_CLASSES

#define REG_CLASS_NAMES {		\
		"NO_REGS",		\
		"PC_REG",		\
		"SP_REG",		\
		"STACK_REGS",		\
		"CG1_REG",		\
		"CG2_REG",		\
		"CG_REGS",		\
		"GENERAL_REGS",		\
		"POINTER_REGS",		\
		"FFOUR_REG",		\
		"ALL_REGS" 		\
}


#define REG_CLASS_CONTENTS {				\
  {0x00000000ul},	/* NO_REGS	*/	\
  {0x00000001ul},	/* PC_REG 	*/	\
  {0x00000002ul},	/* SP_REG 	*/	\
  {0x00000004ul},	/* r2		*/	\
  {0x00000004ul},	/* r2		*/	\
  {0x00000008ul},	/* r3		*/	\
  {0x0000000cul},	/* r2,r3	*/	\
  {0x0000fff2ul}, /* r4 - r15,r1  */      \
  {0x0000fff2ul}, /* r4 - r15,r1  */      \
  {0x0000fff0ul},	/* r4 - r15	*/	\
  {0x0000fffful}	/* ALL_REGS */		\
}

enum reg_class msp430_regno_reg_class (int);
#define REGNO_REG_CLASS(R) msp430_regno_reg_class(R)

#define BASE_REG_CLASS POINTER_REGS

#define INDEX_REG_CLASS NO_REGS

#define REG_CLASS_FROM_LETTER(C) msp430_reg_class_from_letter(C)

#define REGNO_OK_FOR_BASE_P(r) msp430_regno_ok_for_base_p(r) 
					
#define REGNO_OK_FOR_INDEX_P(NUM) 0

#define PREFERRED_RELOAD_CLASS(X, CLASS) FFOUR_REG

#define SMALL_REGISTER_CLASSES 1

#define CLASS_MAX_NREGS(CLASS, MODE)	\
	((GET_MODE_SIZE (MODE) + UNITS_PER_WORD - 1) / UNITS_PER_WORD)

/* In the following defenition only 'P' matters. All other left here for 
 backward compatibility */
#define CONST_OK_FOR_LETTER_P(VALUE, C)				\
   ((C) == 'P' ? ((VALUE)==-1||(VALUE)==1||(VALUE)==2||(VALUE)==4||(VALUE)==8 ||(VALUE)==0) : 0)

#define CONST_DOUBLE_OK_FOR_LETTER_P(VALUE, C) \
  ((C) == 'G' ? (VALUE) == CONST0_RTX (SFmode)	\
   : 0)

#define EXTRA_CONSTRAINT(x, c) extra_constraint(x, c)

#define STACK_PUSH_CODE POST_DEC

#define STACK_GROWS_DOWNWARD

#define STARTING_FRAME_OFFSET 0

#define STACK_POINTER_OFFSET 0

#define FIRST_PARM_OFFSET(FUNDECL) 0

#define STACK_BOUNDARY 16

#define STACK_POINTER_REGNUM 1

#define FRAME_POINTER_REGNUM 4

#define ARG_POINTER_REGNUM 5

#define STATIC_CHAIN_REGNUM 6

#define FRAME_POINTER_REQUIRED   frame_pointer_required_p()

#define ELIMINABLE_REGS {			\
   {FRAME_POINTER_REGNUM, STACK_POINTER_REGNUM}, \
   {ARG_POINTER_REGNUM, STACK_POINTER_REGNUM} \
}

#define CAN_ELIMINATE(FROM, TO) 1

#define INITIAL_ELIMINATION_OFFSET(FROM, TO, OFFSET)			\
     OFFSET = initial_elimination_offset (FROM, TO)

#define PUSH_ROUNDING(NPUSHED) ((NPUSHED+1) & ~1)

#define RETURN_POPS_ARGS(FUNDECL, FUNTYPE, STACK_SIZE) 0

#define FUNCTION_ARG(CUM, MODE, TYPE, NAMED) \
(function_arg (&(CUM), MODE, TYPE, NAMED))

typedef struct msp430_args {
  int nregs;			/* # registers available for passing */
  int regno;			/* next available register number */
} CUMULATIVE_ARGS;

#define INIT_CUMULATIVE_ARGS(CUM, FNTYPE, LIBNAME, FNDECL, N_NAMED_ARGS ) \
init_cumulative_args (&(CUM), FNTYPE, LIBNAME, FNDECL)

#define  INIT_CUMULATIVE_INCOMING_ARGS(CUM, FNTYPE, LIBNAME) \
init_cumulative_incoming_args(&(CUM), FNTYPE, LIBNAME)

#define FUNCTION_ARG_ADVANCE(CUM, MODE, TYPE, NAMED)	\
  (function_arg_advance (&CUM, MODE, TYPE, NAMED))

#define FUNCTION_ARG_REGNO_P(r) (r >= 12 && r <= 15)

extern int msp430_reg_order[];

#define RET_REGISTER  15 /* msp430_ret_register ()*/

#define FUNCTION_VALUE(VALTYPE, FUNC) msp430_function_value (VALTYPE, FUNC)

#define LIBCALL_VALUE(MODE)  msp430_libcall_value (MODE)

#define FUNCTION_VALUE_REGNO_P(N) ((N) == RET_REGISTER)

#define RETURN_IN_MEMORY(TYPE) ((TYPE_MODE (TYPE) == BLKmode)	\
				? int_size_in_bytes (TYPE) > 8	\
				: 0)

#define DEFAULT_PCC_STRUCT_RETURN 0

#define STRUCT_VALUE 0
#define STRUCT_VALUE_INCOMING 0

#define STRICT_ARGUMENT_NAMING 1

#define HAVE_POST_INCREMENT 	1

#define CONSTANT_ADDRESS_P(X) CONSTANT_P (X)

#define MAX_REGS_PER_ADDRESS 1

#ifdef REG_OK_STRICT
#  define GO_IF_LEGITIMATE_ADDRESS(mode, operand, ADDR)	\
{							\
  if (legitimate_address_p (mode, operand, 1))		\
    goto ADDR;						\
}
#  else
#  define GO_IF_LEGITIMATE_ADDRESS(mode, operand, ADDR)	\
{							\
  if (legitimate_address_p (mode, operand, 0))		\
    goto ADDR;						\
}
#endif

#define REG_OK_FOR_BASE_NOSTRICT_P(X) \
  (REGNO (X) >= FIRST_PSEUDO_REGISTER || REG_OK_FOR_BASE_STRICT_P(X))

#define REG_OK_FOR_BASE_STRICT_P(X) REGNO_OK_FOR_BASE_P (REGNO (X))

#ifdef REG_OK_STRICT
#  define REG_OK_FOR_BASE_P(X) REG_OK_FOR_BASE_STRICT_P (X)
#else
#  define REG_OK_FOR_BASE_P(X) REG_OK_FOR_BASE_NOSTRICT_P (X)
#endif

#define REG_OK_FOR_INDEX_P(X) 0 /*( REGNO(X)!=3 && REGNO(X)!=2 &&REGNO(X)<=15) */

#define LEGITIMIZE_ADDRESS(X, OLDX, MODE, WIN)				\
GO_IF_LEGITIMATE_ADDRESS (MODE, X, WIN)

#define GO_IF_MODE_DEPENDENT_ADDRESS(ADDR,LABEL)			{}

#define LEGITIMATE_CONSTANT_P(X) 1

#define REGISTER_MOVE_COST(MODE, FROM, TO) ((MODE)==QImode ? 4 :   \
					    (MODE)==HImode ? 4 :   \
					    (MODE)==SImode ? 8 :   \
					    (MODE)==SFmode ? 8 : 16)

#define MEMORY_MOVE_COST(MODE,CLASS,IN) ((MODE)==QImode ? 8 :	\
					 (MODE)==HImode ? 8 :	\
					 (MODE)==SImode ? 18:	\
					 (MODE)==SFmode ? 18: 32)
#define BRANCH_COSTS 0
#define SLOW_BYTE_ACCESS 0


#define TEXT_SECTION_ASM_OP "\t.text"
#define DATA_SECTION_ASM_OP "\t.data"
#define TARGET_ASM_NAMED_SECTION default_elf_asm_named_section
#define EXTRA_SECTIONS in_bootloader, in_infomem

#undef CTORS_SECTION_ASM_OP
#define CTORS_SECTION_ASM_OP "\t.section .ctors,\"a\",@progbits"

#undef DTORS_SECTION_ASM_OP
#define DTORS_SECTION_ASM_OP "\t.section .dtors,\"a\",@progbits"

#define TARGET_ASM_CONSTRUCTOR msp430_asm_out_ctor

#define TARGET_ASM_DESTRUCTOR msp430_asm_out_dtor
  
#define EXTRA_SECTION_FUNCTIONS						      \
									      \
void									      \
bootloader_section (void)							\
{									      \
  if (in_section != in_bootloader)						\
    {									      \
      fprintf (asm_out_file,						      \
	       "\t.section .bootloader, \"ax\", @progbits\n");	      		\
      /* Should already be aligned, this is just to be safe if it isn't.  */  \
      fprintf (asm_out_file, "\t.p2align 1\n");				      \
      in_section = in_bootloader;						\
    }									      \
}										\
									      \
void									      \
infomem_section (void)							      \
{									      \
  if (in_section != in_infomem)						      \
    {									      \
      fprintf (asm_out_file,						      \
	       "\t.section .infomem, \"a\", @progbits\n");	      		\
      /* Should already be aligned, this is just to be safe if it isn't.  */  \
      fprintf (asm_out_file, "\t.p2align 1\n");				      \
      in_section = in_infomem;						      \
    }									      \
}

#define JUMP_TABLES_IN_TEXT_SECTION 0


#define ASM_COMMENT_START " ; "
#define ASM_APP_ON ";; APP\n"
#define ASM_APP_OFF ";; NOAPP\n"

#define ASM_OUTPUT_INT(FILE, VALUE)			\
 ( fprintf (FILE, "\t.long "),				\
   output_addr_const (FILE, (VALUE)),			\
   fputs ("\n", FILE))

#define ASM_OUTPUT_SHORT(FILE,VALUE) asm_output_short(FILE,VALUE)
#define ASM_OUTPUT_CHAR(FILE,VALUE) asm_output_char(FILE,VALUE)
#define ASM_OUTPUT_BYTE(FILE,VALUE) asm_output_byte (FILE,VALUE)
#define ASM_BYTE_OP "\t.byte "
#define ASM_OUTPUT_ASCII(FILE, P, SIZE)	 gas_output_ascii (FILE,P,SIZE)
#define IS_ASM_LOGICAL_LINE_SEPARATOR(C) ((C) == '\n')

#define ASM_OUTPUT_LABELREF(FILE,NAME) 			\
do{							\
	const char *p = NAME;					\
	while(*p == '_') p++;				\
	if(*p == 'r' || *p == 'R')			\
	{						\
	    int val;					\
	    char *endptr;				\
	    p++;					\
	    val = strtol (p, &endptr, 10);		\
	    if(val >= 0 && val <= 15 &&			\
	    	*endptr == 0 )				\
	    {						\
	    	asm_fprintf ((FILE), "_%U%s", (NAME));	\
	    }						\
	    else					\
	    	asm_fprintf ((FILE), "%U%s", (NAME));   \
	}						\
	else						\
		asm_fprintf ((FILE), "%U%s", (NAME));	\
} while(0)

#define ASM_OUTPUT_COMMON(STREAM, NAME, SIZE, ROUNDED)	\
do {							\
     const char *p = NAME;					\
     if(*p == '*' || *p == '@' ) p++;			\
     if(*p >= '0' && *p <= '9' ) break;			\
     fputs ("\t.comm ", (STREAM));			\
     assemble_name ((STREAM), (NAME));			\
     fprintf ((STREAM), ",%d%s", (SIZE), (SIZE)>1?",2\n":"\n");\
} while (0)

#define ASM_OUTPUT_LOCAL(STREAM, NAME, SIZE, ROUNDED)	\
do {							\
     const char *p = NAME;					\
     if(*p == '*' || *p == '@' ) p++;			\
     if(*p >= '0' && *p <= '9' ) break;			\
     fputs ("\t.local ", (STREAM));			\
     assemble_name ((STREAM), (NAME));			\
     fputs ("\n",(STREAM));				\
     fputs ("\t.comm ", (STREAM));                     	\
     assemble_name ((STREAM), (NAME));			\
     fprintf ((STREAM), ",%d%s", (SIZE),(SIZE)>1?",2\n":"\n");\
} while (0)

#define BSS_SECTION_ASM_OP	"\t.section\t.bss"

#define ASM_OUTPUT_BSS(FILE, DECL, NAME, SIZE, ROUNDED)                 \
do { \
  const char *p = (NAME); \
  if(*p == '*' || *p == '@' ) p++; \
  if(*p >= '0' && *p <= '9' ) break; \
  asm_output_bss ((FILE), (DECL), (NAME), (SIZE), (ROUNDED)); \
} while(0)
  


#define ASM_OUTPUT_LABEL(STREAM, NAME)		\
{						\
  assemble_name (STREAM, NAME);			\
  fprintf (STREAM, ":\n");			\
}

#undef TYPE_ASM_OP
#undef SIZE_ASM_OP
#undef WEAK_ASM_OP
#define TYPE_ASM_OP	"\t.type\t"
#define SIZE_ASM_OP	"\t.size\t"
#define WEAK_ASM_OP	"\t.weak\t"

#undef TYPE_OPERAND_FMT
#define TYPE_OPERAND_FMT	"@%s"

#define ASM_DECLARE_FUNCTION_NAME(FILE, NAME, DECL) \
asm_declare_function_name (FILE, NAME, DECL)

#define ASM_DECLARE_FUNCTION_SIZE(FILE, FNAME, DECL)			\
  do {									\
    if (!flag_inhibit_size_directive)					\
      {									\
        char label[256];						\
	static int labelno;						\
	labelno++;							\
	ASM_GENERATE_INTERNAL_LABEL (label, "Lfe", labelno);		\
	fprintf(FILE, ".%s%d:\n", "Lfe", labelno) ;		\
	fprintf (FILE, "%s", SIZE_ASM_OP);				\
	assemble_name (FILE, (FNAME));					\
        fprintf (FILE, ",");						\
	assemble_name (FILE, label);					\
        fprintf (FILE, "-");						\
	assemble_name (FILE, (FNAME));					\
	fprintf (FILE,"\n;; End of function \n\n");	\
      }									\
  } while (0)

#define ASM_DECLARE_OBJECT_NAME(FILE, NAME, DECL)			  \
do {									  \
      fprintf (FILE, "%s", TYPE_ASM_OP);				  \
      assemble_name (FILE, NAME);					  \
      putc (',', FILE);							  \
      fprintf (FILE, TYPE_OPERAND_FMT, "object");			  \
      putc ('\n', FILE);						  \
      size_directive_output = 0;					  \
      if (!flag_inhibit_size_directive && DECL_SIZE (DECL))		  \
	{								  \
	  size_directive_output = 1;					  \
	  fprintf (FILE, "%s", SIZE_ASM_OP);				  \
	  assemble_name (FILE, NAME);					  \
	  fprintf (FILE, ",%ld\n",  int_size_in_bytes (TREE_TYPE (DECL))); \
    }									  \
  ASM_OUTPUT_LABEL(FILE, NAME);						  \
} while (0)

#define ASM_FINISH_DECLARE_OBJECT(FILE, DECL, TOP_LEVEL, AT_END)	 \
do {									 \
     const char *name = XSTR (XEXP (DECL_RTL (DECL), 0), 0);		 \
     if (!flag_inhibit_size_directive && DECL_SIZE (DECL)		 \
         && ! AT_END && TOP_LEVEL					 \
	 && DECL_INITIAL (DECL) == error_mark_node			 \
	 && !size_directive_output)					 \
       {								 \
	 size_directive_output = 1;					 \
	 fprintf (FILE, "%s", SIZE_ASM_OP);				 \
	 assemble_name (FILE, name);					 \
	 fprintf (FILE, ",%d\n",  int_size_in_bytes (TREE_TYPE (DECL))); \
       }								 \
   } while (0)

#define ESCAPES \
"\1\1\1\1\1\1\1\1btn\1fr\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\
\0\0\"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\\\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\
\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\
\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\
\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\
\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"

#define STRING_LIMIT	((unsigned) 64)
#define STRING_ASM_OP	"\t.string\t"
#define GLOBAL_ASM_OP ".global\t"
     
#define ASM_WEAKEN_LABEL(FILE, NAME) 	\
  do					\
    {					\
      fputs ("\t.weak\t", (FILE));	\
      assemble_name ((FILE), (NAME)); 	\
      fputc ('\n', (FILE));		\
    }					\
  while (0)

#define SUPPORTS_WEAK 1

#define ASM_GENERATE_INTERNAL_LABEL(STRING, PREFIX, NUM)	\
sprintf (STRING, "*.%s%d", PREFIX, NUM)

#define ASM_FORMAT_PRIVATE_NAME(OUTPUT, NAME, LABELNO)	\
( (OUTPUT) = (char *) alloca (strlen ((NAME)) + 10),	\
  sprintf ((OUTPUT), "%s.%ld", (NAME), (LABELNO)))

#define HAS_INIT_SECTION 1

#define REGISTER_NAMES {				\
  "r0","r1","r2","r3","r4","r5","r6","r7",		\
  "r8","r9","r10","r11","r12","r13","r14","r15"		\
}

#define FINAL_PRESCAN_INSN(insn, operand, nop) final_prescan_insn (insn, operand,nop)

#define PRINT_OPERAND(STREAM, X, CODE) print_operand (STREAM, X, CODE)
#define PRINT_OPERAND_PUNCT_VALID_P(CODE) ((CODE) == '~')
#define PRINT_OPERAND_ADDRESS(STREAM, X) print_operand_address(STREAM, X)
#define USER_LABEL_PREFIX ""

#define ASM_OUTPUT_REG_PUSH(STREAM, REGNO)	\
{						\
  if (REGNO > 15)				\
    abort ();					\
  fprintf (STREAM, "\tpush\tr%d", REGNO);	\
}

#define ASM_OUTPUT_REG_POP(STREAM, REGNO)	\
{						\
  if (REGNO > 15)				\
    abort ();					\
  fprintf (STREAM, "\tpop\tr%d", REGNO);	\
}

#define ASM_OUTPUT_ADDR_VEC_ELT(STREAM, VALUE)		\
  msp430_output_addr_vec_elt(STREAM, VALUE)

#define ASM_OUTPUT_SKIP(STREAM, N)		\
  fprintf (STREAM, "\t.skip %d,0\n", N)
#define ASM_OUTPUT_ALIGN(STREAM, POWER) \
  fprintf (STREAM, "\t.p2align %d,0\n", POWER)

#define CASE_VECTOR_MODE HImode

/* the X_msp430 have the same meaning as X, except
   operands can be volatile */
#define PREDICATE_CODES \
{"memory_operand_msp430", {SUBREG, MEM}},	\
{"nonimmediate_operand_msp430", {SUBREG, REG, MEM}},\
{"general_operand_msp430", {CONST_INT, CONST_DOUBLE, CONST, SYMBOL_REF, LABEL_REF, SUBREG, REG, MEM}},\
{"three_operands_msp430", {PLUS, MINUS, AND, IOR, XOR}}, \
{"equality_operator", {EQ, NE }},                     \
{"inequality_operator", {GE, GT, LE, LT, GEU, GTU, LEU, LTU }},

extern struct rtx_def *msp430_compare_op0, *msp430_compare_op1;
extern int msp430_case_values_threshold;
#define CASE_VALUES_THRESHOLD msp430_case_values_threshold

#undef WORD_REGISTER_OPERATIONS

#define MOVE_MAX 2

#define TRULY_NOOP_TRUNCATION(OUTPREC, INPREC) 1

#define Pmode HImode
#define FUNCTION_MODE HImode
     
/*                            1        3 */
#define INTEGRATE_THRESHOLD(DECL) (1 + (3 * list_length (DECL_ARGUMENTS (DECL)) / 2))


#define DOLLARS_IN_IDENTIFIERS 0

#define NO_DOLLAR_IN_LABEL 1


#define GIV_SORT_CRITERION(X, Y)	\
  if (GET_CODE ((X)->add_val) == CONST_INT		\
      && GET_CODE ((Y)->add_val) == CONST_INT)		\
    return INTVAL ((X)->add_val) - INTVAL ((Y)->add_val);

#define TARGET_BELL 007
#define TARGET_BS 010
#define TARGET_TAB 011
#define TARGET_NEWLINE 012
#define TARGET_VT 013
#define TARGET_FF 014
#define TARGET_CR 015
#define TARGET_ESC 033

#define TRAMPOLINE_TEMPLATE(FILE) msp430_trampoline_template((FILE))

#define TRAMPOLINE_SIZE 8
#define TRAMPOLINE_ALIGNMENT 16


#define INITIALIZE_TRAMPOLINE(TRAMP, FNADDR, CXT)	\
	msp430_initialize_trampoline (TRAMP, FNADDR, CXT)

#define NOTICE_UPDATE_CC(EXP, INSN) notice_update_cc(EXP, INSN)

#define CC_OVERFLOW_UNUSABLE 01000
/* The mov,and,or,xor insns don't set carry.  That's ok though as the
   Z bit is all we need when doing unsigned comparisons on the result of
   these insns (since they're always with 0).  However, conditions.h has
   CC_NO_OVERFLOW defined for this purpose.  Rename it to something more
   understandable.  */
#define CC_NO_CARRY CC_NO_OVERFLOW

#define FUNCTION_PROFILER(FILE, LABELNO)  \
  fprintf (FILE, "/* profiler %d */", (LABELNO))

#define ADJUST_INSN_LENGTH(INSN, LENGTH) (LENGTH =\
					  adjust_insn_length (INSN, LENGTH))

#define TARGET_MEM_FUNCTIONS

#define CPP_SPEC "\
%{!mmcu*|mmcu=msp1:%(cpp_msp1)} \
  %{mmcu=msp2:%(cpp_msp2)} \
  %{mmcu=msp430x110:%(cpp_msp1) -D__MSP430_110__} \
  %{mmcu=msp430x112:%(cpp_msp1) -D__MSP430_112__} \
  %{mmcu=msp430x1101:%(cpp_msp1) -D__MSP430_1101__} \
  %{mmcu=msp430x1111:%(cpp_msp1) -D__MSP430_1111__} \
  %{mmcu=msp430x1121:%(cpp_msp1) -D__MSP430_1121__} \
  %{mmcu=msp430x1122:%(cpp_msp1) -D__MSP430_1122__} \
  %{mmcu=msp430x1132:%(cpp_msp1) -D__MSP430_1132__} \
  %{mmcu=msp430x122:%(cpp_msp1) -D__MSP430_122__} \
  %{mmcu=msp430x123:%(cpp_msp1) -D__MSP430_123__} \
  %{mmcu=msp430x1222:%(cpp_msp1) -D__MSP430_1222__} \
  %{mmcu=msp430x1232:%(cpp_msp1) -D__MSP430_1232__} \
  %{mmcu=msp430x133:%(cpp_msp1) -D__MSP430_133__} \
  %{mmcu=msp430x135:%(cpp_msp1) -D__MSP430_135__} \
  %{mmcu=msp430x1331:%(cpp_msp1) -D__MSP430_1331__} \
  %{mmcu=msp430x1351:%(cpp_msp1) -D__MSP430_1351__} \
  %{mmcu=msp430x147:%(cpp_msp2) -D__MSP430_147__} \
  %{mmcu=msp430x148:%(cpp_msp2) -D__MSP430_148__} \
  %{mmcu=msp430x149:%(cpp_msp2) -D__MSP430_149__} \
  %{mmcu=msp430x1471:%(cpp_msp2) -D__MSP430_1471__} \
  %{mmcu=msp430x1481:%(cpp_msp2) -D__MSP430_1481__} \
  %{mmcu=msp430x1491:%(cpp_msp2) -D__MSP430_1491__} \
  %{mmcu=msp430x155:%(cpp_msp1) -D__MSP430_155__} \
  %{mmcu=msp430x156:%(cpp_msp1) -D__MSP430_156__} \
  %{mmcu=msp430x157:%(cpp_msp1) -D__MSP430_157__} \
  %{mmcu=msp430x167:%(cpp_msp2) -D__MSP430_167__} \
  %{mmcu=msp430x168:%(cpp_msp2) -D__MSP430_168__} \
  %{mmcu=msp430x169:%(cpp_msp2) -D__MSP430_169__} \
  %{mmcu=msp430x1610:%(cpp_msp2) -D__MSP430_1610__} \
  %{mmcu=msp430x1611:%(cpp_msp2) -D__MSP430_1611__} \
  %{mmcu=msp430x1612:%(cpp_msp2) -D__MSP430_1612__} \
  %{mmcu=msp430x2101:%(cpp_msp1) -D__MSP430_2101__} \
  %{mmcu=msp430x2111:%(cpp_msp1) -D__MSP430_2111__} \
  %{mmcu=msp430x2121:%(cpp_msp1) -D__MSP430_2121__} \
  %{mmcu=msp430x2131:%(cpp_msp1) -D__MSP430_2131__} \
  %{mmcu=msp430x311:%(cpp_msp1) -D__MSP430_311__} \
  %{mmcu=msp430x312:%(cpp_msp1) -D__MSP430_312__} \
  %{mmcu=msp430x313:%(cpp_msp1) -D__MSP430_313__} \
  %{mmcu=msp430x314:%(cpp_msp1) -D__MSP430_314__} \
  %{mmcu=msp430x315:%(cpp_msp1) -D__MSP430_315__} \
  %{mmcu=msp430x323:%(cpp_msp1) -D__MSP430_323__} \
  %{mmcu=msp430x325:%(cpp_msp1) -D__MSP430_325__} \
  %{mmcu=msp430x336:%(cpp_msp2) -D__MSP430_336__} \
  %{mmcu=msp430x337:%(cpp_msp2) -D__MSP430_337__} \
  %{mmcu=msp430x412:%(cpp_msp1) -D__MSP430_412__} \
  %{mmcu=msp430x413:%(cpp_msp1) -D__MSP430_413__} \
  %{mmcu=msp430x415:%(cpp_msp1) -D__MSP430_415__} \
  %{mmcu=msp430x417:%(cpp_msp1) -D__MSP430_417__} \
  %{mmcu=msp430x423:%(cpp_msp2) -D__MSP430_423__} \
  %{mmcu=msp430x425:%(cpp_msp2) -D__MSP430_425__} \
  %{mmcu=msp430x427:%(cpp_msp2) -D__MSP430_427__} \
  %{mmcu=msp430x4250:%(cpp_msp1) -D__MSP430_4250__} \
  %{mmcu=msp430x4260:%(cpp_msp1) -D__MSP430_4260__} \
  %{mmcu=msp430x4270:%(cpp_msp1) -D__MSP430_4270__} \
  %{mmcu=msp430xE423:%(cpp_msp2) -D__MSP430_E423__} \
  %{mmcu=msp430xE425:%(cpp_msp2) -D__MSP430_E425__} \
  %{mmcu=msp430xE427:%(cpp_msp2) -D__MSP430_E427__} \
  %{mmcu=msp430xW423:%(cpp_msp1) -D__MSP430_W423__} \
  %{mmcu=msp430xW425:%(cpp_msp1) -D__MSP430_W425__} \
  %{mmcu=msp430xW427:%(cpp_msp1) -D__MSP430_W427__} \
  %{mmcu=msp430xG437:%(cpp_msp1) -D__MSP430_G437__} \
  %{mmcu=msp430xG438:%(cpp_msp1) -D__MSP430_G438__} \
  %{mmcu=msp430xG439:%(cpp_msp1) -D__MSP430_G439__} \
  %{mmcu=msp430x435:%(cpp_msp1) -D__MSP430_435__} \
  %{mmcu=msp430x436:%(cpp_msp1) -D__MSP430_436__} \
  %{mmcu=msp430x437:%(cpp_msp1) -D__MSP430_437__} \
  %{mmcu=msp430x447:%(cpp_msp2) -D__MSP430_447__} \
  %{mmcu=msp430x448:%(cpp_msp2) -D__MSP430_448__} \
  %{mmcu=msp430x449:%(cpp_msp2) -D__MSP430_449__} \
  %{posix:-D_POSIX_SOURCE}"


#define CC1_SPEC "%{profile:-p}"

#define CC1PLUS_SPEC "%{!frtti:-fno-rtti} \
%{!fenforce-eh-specs:-fno-enforce-eh-specs} \
%{!fexceptions:-fno-exceptions}"

#define ASM_SPEC ""
#define ASM_FINAL_SPEC ""

#define LINK_SPEC "\
%{!mmcu*:-m msp430x110} \
  %{mmcu=msp1:-m msp430x110} \
  %{mmcu=msp2:-m msp430x336} \
  %{mmcu=msp430x110:-m msp430x110 } \
  %{mmcu=msp430x112:-m msp430x112 } \
  %{mmcu=msp430x1101:-m msp430x1101 } \
  %{mmcu=msp430x1111:-m msp430x1111 } \
  %{mmcu=msp430x1121:-m msp430x1121 } \
  %{mmcu=msp430x1122:-m msp430x1122 } \
  %{mmcu=msp430x1132:-m msp430x1132 } \
  %{mmcu=msp430x122:-m msp430x122 } \
  %{mmcu=msp430x123:-m msp430x123 } \
  %{mmcu=msp430x1222:-m msp430x1222 } \
  %{mmcu=msp430x1232:-m msp430x1232 } \
  %{mmcu=msp430x133:-m msp430x133 } \
  %{mmcu=msp430x135:-m msp430x135 } \
  %{mmcu=msp430x1331:-m msp430x1331 } \
  %{mmcu=msp430x1351:-m msp430x1351 } \
  %{mmcu=msp430x147:-m msp430x147 } \
  %{mmcu=msp430x148:-m msp430x148 } \
  %{mmcu=msp430x149:-m msp430x149 } \
  %{mmcu=msp430x1471:-m msp430x1471 } \
  %{mmcu=msp430x1481:-m msp430x1481 } \
  %{mmcu=msp430x1491:-m msp430x1491 } \
  %{mmcu=msp430x155:-m msp430x155 } \
  %{mmcu=msp430x156:-m msp430x156 } \
  %{mmcu=msp430x157:-m msp430x157 } \
  %{mmcu=msp430x167:-m msp430x167 } \
  %{mmcu=msp430x168:-m msp430x168 } \
  %{mmcu=msp430x169:-m msp430x169 } \
  %{mmcu=msp430x1610:-m msp430x1610 } \
  %{mmcu=msp430x1611:-m msp430x1611 } \
  %{mmcu=msp430x1612:-m msp430x1612 } \
  %{mmcu=msp430x2101:-m msp430x2101 } \
  %{mmcu=msp430x2111:-m msp430x2111 } \
  %{mmcu=msp430x2121:-m msp430x2121 } \
  %{mmcu=msp430x2131:-m msp430x2131 } \
  %{mmcu=msp430x311:-m msp430x311 } \
  %{mmcu=msp430x312:-m msp430x312 } \
  %{mmcu=msp430x313:-m msp430x313 } \
  %{mmcu=msp430x314:-m msp430x314 } \
  %{mmcu=msp430x315:-m msp430x315 } \
  %{mmcu=msp430x323:-m msp430x323 } \
  %{mmcu=msp430x325:-m msp430x325 } \
  %{mmcu=msp430x336:-m msp430x336 } \
  %{mmcu=msp430x337:-m msp430x337 } \
  %{mmcu=msp430x412:-m msp430x412 } \
  %{mmcu=msp430x413:-m msp430x413 } \
  %{mmcu=msp430x415:-m msp430x415 } \
  %{mmcu=msp430x417:-m msp430x417 } \
  %{mmcu=msp430x423:-m msp430x423 } \
  %{mmcu=msp430x425:-m msp430x425 } \
  %{mmcu=msp430x427:-m msp430x427 } \
  %{mmcu=msp430x4250:-m msp430x4250 } \
  %{mmcu=msp430x4260:-m msp430x4260 } \
  %{mmcu=msp430x4270:-m msp430x4270 } \
  %{mmcu=msp430xE423:-m msp430xE423 } \
  %{mmcu=msp430xE425:-m msp430xE425 } \
  %{mmcu=msp430xE427:-m msp430xE427 } \
  %{mmcu=msp430xW423:-m msp430xW423 } \
  %{mmcu=msp430xW425:-m msp430xW425 } \
  %{mmcu=msp430xW427:-m msp430xW427 } \
  %{mmcu=msp430xG437:-m msp430xG437 } \
  %{mmcu=msp430xG438:-m msp430xG438 } \
  %{mmcu=msp430xG439:-m msp430xG439 } \
  %{mmcu=msp430x435:-m msp430x435 } \
  %{mmcu=msp430x436:-m msp430x436 } \
  %{mmcu=msp430x437:-m msp430x437 } \
  %{mmcu=msp430x447:-m msp430x447 } \
  %{mmcu=msp430x448:-m msp430x448 } \
  %{mmcu=msp430x449:-m msp430x449 }"
  


#define LIB_SPEC "-lc"
#define LIBGCC_SPEC "-lgcc"
#define LIBSTDCXX "-lgcc"

#define STARTFILE_SPEC "%(crt_binutils)"
#define ENDFILE_SPEC ""

#define CRT_BINUTILS_SPECS "\
%{!mmcu=*|mmcu=msp430x110|mmcu=msp1:crt430x110.o%s} \
  %{mmcu=msp430x112:crt430x112.o%s} \
  %{mmcu=msp430x1101:crt430x1101.o%s} \
  %{mmcu=msp430x1111:crt430x1111.o%s} \
  %{mmcu=msp430x1121:crt430x1121.o%s} \
  %{mmcu=msp430x1122:crt430x1122.o%s} \
  %{mmcu=msp430x1132:crt430x1132.o%s} \
  %{mmcu=msp430x122:crt430x122.o%s} \
  %{mmcu=msp430x123:crt430x123.o%s} \
  %{mmcu=msp430x1222:crt430x1222.o%s} \
  %{mmcu=msp430x1232:crt430x1232.o%s} \
  %{mmcu=msp430x133:crt430x133.o%s} \
  %{mmcu=msp430x135:crt430x135.o%s} \
  %{mmcu=msp430x1331:crt430x1331.o%s} \
  %{mmcu=msp430x1351:crt430x1351.o%s} \
  %{mmcu=msp430x147:crt430x147.o%s} \
  %{mmcu=msp430x148:crt430x148.o%s} \
  %{mmcu=msp430x149:crt430x149.o%s} \
  %{mmcu=msp430x1471:crt430x1471.o%s} \
  %{mmcu=msp430x1481:crt430x1481.o%s} \
  %{mmcu=msp430x1491:crt430x1491.o%s} \
  %{mmcu=msp430x155:crt430x155.o%s} \
  %{mmcu=msp430x156:crt430x156.o%s} \
  %{mmcu=msp430x157:crt430x157.o%s} \
  %{mmcu=msp430x167:crt430x167.o%s} \
  %{mmcu=msp430x168:crt430x168.o%s} \
  %{mmcu=msp430x169:crt430x169.o%s} \
  %{mmcu=msp430x1610:crt430x1610.o%s} \
  %{mmcu=msp430x1611:crt430x1611.o%s} \
  %{mmcu=msp430x1612:crt430x1612.o%s} \
  %{mmcu=msp430x2101:crt430x2101.o%s} \
  %{mmcu=msp430x2111:crt430x2111.o%s} \
  %{mmcu=msp430x2121:crt430x2121.o%s} \
  %{mmcu=msp430x2131:crt430x2131.o%s} \
  %{mmcu=msp430x311:crt430x311.o%s} \
  %{mmcu=msp430x312:crt430x312.o%s} \
  %{mmcu=msp430x313:crt430x313.o%s} \
  %{mmcu=msp430x314:crt430x314.o%s} \
  %{mmcu=msp430x315:crt430x315.o%s} \
  %{mmcu=msp430x323:crt430x323.o%s} \
  %{mmcu=msp430x325:crt430x325.o%s} \
  %{mmcu=msp430x336|mmcu=msp2:crt430x336.o%s} \
  %{mmcu=msp430x337:crt430x337.o%s} \
  %{mmcu=msp430x412:crt430x412.o%s} \
  %{mmcu=msp430x413:crt430x413.o%s} \
  %{mmcu=msp430x415:crt430x415.o%s} \
  %{mmcu=msp430x417:crt430x417.o%s} \
  %{mmcu=msp430x423:crt430x423.o%s} \
  %{mmcu=msp430x425:crt430x425.o%s} \
  %{mmcu=msp430x427:crt430x427.o%s} \
  %{mmcu=msp430x4250:crt430x4250.o%s} \
  %{mmcu=msp430x4260:crt430x4260.o%s} \
  %{mmcu=msp430x4270:crt430x4270.o%s} \
  %{mmcu=msp430xE423:crt430xE423.o%s} \
  %{mmcu=msp430xE425:crt430xE425.o%s} \
  %{mmcu=msp430xE427:crt430xE427.o%s} \
  %{mmcu=msp430xW423:crt430xW423.o%s} \
  %{mmcu=msp430xW425:crt430xW425.o%s} \
  %{mmcu=msp430xW427:crt430xW427.o%s} \
  %{mmcu=msp430xG437:crt430xG437.o%s} \
  %{mmcu=msp430xG438:crt430xG438.o%s} \
  %{mmcu=msp430xG439:crt430xG439.o%s} \
  %{mmcu=msp430x435:crt430x435.o%s} \
  %{mmcu=msp430x436:crt430x436.o%s} \
  %{mmcu=msp430x437:crt430x437.o%s} \
  %{mmcu=msp430x447:crt430x447.o%s} \
  %{mmcu=msp430x448:crt430x448.o%s} \
  %{mmcu=msp430x449:crt430x449.o%s}"


#define EXTRA_SPECS                           	\
{"crt_binutils", CRT_BINUTILS_SPECS},

#define MULTILIB_DEFAULTS { "mmcu=msp430x110" }
#define LINKER_NAME "msp430-ld"

#define TEST_HARD_REG_CLASS(CLASS, REGNO) \
  TEST_HARD_REG_BIT (reg_class_contents[ (int) (CLASS)], REGNO)

#define TARGET_FLOAT_FORMAT IEEE_FLOAT_FORMAT

#define PREFERRED_DEBUGGING_TYPE DWARF2_DEBUG
#define DWARF2_DEBUGGING_INFO
#define OBJECT_FORMAT_ELF

#endif

