/* Prototypes for exported functions defined in msp430.c
   
   Copyright (C) 2000, 2001, 2002, 2003 Free Software Foundation, Inc.
   Contributed by Dmitry Diky <diwil@mail.ru>

   This file is part of GCC.

   GCC is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GCC is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GCC; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */


extern void   bootloader_section (void);
extern void   infomem_section (void);

extern void   asm_file_start            (FILE *file);
extern void   asm_file_end              (FILE *file);
extern void   msp430_init_once          (void);
extern void   msp430_override_options   (void);
extern void   gas_output_limited_string (FILE *file, const char *str);
extern void   gas_output_ascii          (FILE *file, const char *str,
							 size_t length);
extern void   order_regs_for_local_alloc (void);
extern void   msp430_trampoline_template (FILE *fd);

int msp430_current_function_noint_hwmul_function_p PARAMS((void));

extern int frame_pointer_required_p (void);
extern int msp430_empty_epilogue (void);

int msp430_regno_ok_for_base_p (int);

#ifdef HAVE_MACHINE_MODES
extern int    msp430_hard_regno_mode_ok (int regno,
					     enum machine_mode mode);
#endif

extern int initial_elimination_offset (int, int);



#ifdef TREE_CODE
extern void   asm_output_external          (FILE *file, tree decl,
						   char *name);
extern void   unique_section               (tree decl, int reloc);
extern void   encode_section_info          (tree decl);
extern void   asm_output_section_name      (FILE *file, tree decl,
						   const char *name,
						   int reloc);
extern int    valid_machine_type_attribute (tree type, tree attributes,
						   tree identifier,
						   tree args);
extern int    valid_machine_decl_attribute (tree decl, tree attributes,
						   tree attr, tree args);
extern void asm_declare_function_name (FILE *, const char *, tree);
unsigned int msp430_section_type_flags ( tree DECL, const char *NAME, int RELOC);


#ifdef RTX_CODE /* inside TREE_CODE */
extern rtx    msp430_function_value          (tree type, tree func);
extern void   init_cumulative_args           (CUMULATIVE_ARGS *cum,
						   tree fntype, rtx libname,
						   int indirect);
extern rtx    function_arg         (CUMULATIVE_ARGS *cum,
					   enum machine_mode mode,
					   tree type, int named);
extern void   init_cumulative_incoming_args           (CUMULATIVE_ARGS *cum,
						   tree fntype, rtx libname);
extern rtx    function_incoming_arg         (CUMULATIVE_ARGS *cum,
					   enum machine_mode mode,
					   tree type, int named);



#endif /* RTX_CODE inside TREE_CODE */

#ifdef HAVE_MACHINE_MODES /* inside TREE_CODE */
extern void   function_arg_advance (CUMULATIVE_ARGS *cum,
					   enum machine_mode mode, tree type,
					   int named);
#endif /* HAVE_MACHINE_MODES inside TREE_CODE*/
#endif /* TREE_CODE */

#ifdef RTX_CODE


extern enum rtx_code msp430_canonicalize_comparison (enum rtx_code,rtx *,rtx *);


extern void msp430_emit_cbranch (enum rtx_code, rtx);
extern void msp430_emit_cset (enum rtx_code, rtx);

extern int dead_or_set_in_peep (int, rtx, rtx);
extern void msp430_initialize_trampoline (rtx,rtx,rtx);   


extern enum reg_class msp430_reg_class_from_letter (int);
extern enum reg_class preferred_reload_class (rtx,enum reg_class);
enum reg_class msp430_regno_reg_class (int);

extern RTX_CODE followed_compare_condition (rtx);

extern const char * msp430_movesi_code (rtx insn, rtx operands[], int *l);
extern const char * msp430_movedi_code (rtx insn, rtx operands[], int *l);
extern const char * msp430_addsi_code (rtx insn, rtx operands[], int *l);
extern const char * msp430_subsi_code (rtx insn, rtx operands[], int *l);
extern const char * msp430_andsi_code (rtx insn, rtx operands[], int *l);
extern const char * msp430_iorsi_code (rtx insn, rtx operands[], int *l);
extern const char * msp430_xorsi_code (rtx insn, rtx operands[], int *l);
extern const char * msp430_adddi_code (rtx insn, rtx operands[], int *l);
extern const char * msp430_subdi_code (rtx insn, rtx operands[], int *l);
extern const char * msp430_anddi_code (rtx insn, rtx operands[], int *l);
extern const char * msp430_iordi_code (rtx insn, rtx operands[], int *l);
extern const char * msp430_xordi_code (rtx insn, rtx operands[], int *l);


extern int zero_shifted (rtx );
extern int indexed_location (rtx );


extern int regsi_ok_safe (rtx operands[]);
extern int regsi_ok_clobber (rtx operands[]);
extern int regdi_ok_safe (rtx operands[]);
extern int regdi_ok_clobber (rtx operands[]);
extern int sameoperand (rtx operands[], int);

extern int general_operand_msp430 (rtx, enum machine_mode ); 
extern int nonimmediate_operand_msp430 (rtx, enum machine_mode );
extern int memory_operand_msp430 (rtx, enum machine_mode );
extern int halfnibble_constant (rtx, enum machine_mode );
extern int halfnibble_integer (rtx, enum machine_mode );
extern int halfnibble_constant_shift (rtx, enum machine_mode );
extern int halfnibble_integer_shift (rtx, enum machine_mode );
extern int which_nibble (int);
extern int which_nibble_shift (int);


extern void   asm_output_external_libcall (FILE *file, rtx symref);
extern int    legitimate_address_p    (enum machine_mode mode, rtx x,
					int strict);
extern int    compare_diff_p  (rtx insn);

extern int    emit_indexed_arith (rtx insn, rtx operands[], int, const char *, int);

extern const char * msp430_emit_abssi    (rtx insn, rtx operands[], int *l);
extern const char * msp430_emit_absdi    (rtx insn, rtx operands[], int *l);

extern const char * msp430_emit_indexed_add2 (rtx insn, rtx op[], int *l);
extern const char * msp430_emit_indexed_add4 (rtx insn, rtx op[], int *l);

extern const char * msp430_emit_indexed_sub2 (rtx insn, rtx operands[], int *len);
extern const char * msp430_emit_indexed_sub4 (rtx insn, rtx operands[], int *len);

extern const char * msp430_emit_indexed_and2 (rtx insn, rtx op[], int *l);
extern const char * msp430_emit_indexed_and4 (rtx insn, rtx op[], int *l);
extern const char * msp430_emit_immediate_and2 (rtx insn, rtx op[], int *l);
extern const char * msp430_emit_immediate_and4 (rtx insn, rtx op[], int *l);

extern const char * msp430_emit_indexed_ior2 (rtx insn, rtx operands[], int *len);
extern const char * msp430_emit_indexed_ior4 (rtx insn, rtx operands[], int *len);
extern const char * msp430_emit_immediate_ior2 (rtx insn, rtx op[], int *l);
extern const char * msp430_emit_immediate_ior4 (rtx insn, rtx op[], int *l);


extern int msp430_emit_indexed_mov (rtx insn, rtx operands[], int len, const char *);       
extern const char * movstrsi_insn (rtx insn, rtx operands[], int *len);
extern const char * clrstrsi_insn (rtx insn, rtx operands[], int *len);
extern const char * movstrhi_insn (rtx insn, rtx operands[], int *len);
extern const char * clrstrhi_insn (rtx insn, rtx operands[], int *len);
extern const char * msp430_emit_indexed_mov2 (rtx insn, rtx operands[], int *len);
extern const char * msp430_emit_indexed_mov4 (rtx insn, rtx operands[], int *len);
extern const char * movsisf_regmode (rtx insn, rtx operands[], int *len);
extern const char * movdidf_regmode (rtx insn, rtx operands[], int *len);


extern int is_shift_better_in_reg (rtx operands[]);
extern int msp430_emit_shift_cnt (int (*funct)(rtx, int, int), const char *, rtx insn, rtx operands[], int *len, int);
extern const char * msp430_emit_ashlqi3 (rtx insn, rtx operands[], int *len);
extern const char * msp430_emit_ashlhi3 (rtx insn, rtx operands[], int *len);
extern const char * msp430_emit_ashlsi3 (rtx insn, rtx operands[], int *len);
extern const char * msp430_emit_ashldi3 (rtx insn, rtx operands[], int *len);
extern const char * msp430_emit_ashrqi3 (rtx insn, rtx operands[], int *len);
extern const char * msp430_emit_ashrhi3 (rtx insn, rtx operands[], int *len);
extern const char * msp430_emit_ashrsi3 (rtx insn, rtx operands[], int *len);
extern const char * msp430_emit_ashrdi3 (rtx insn, rtx operands[], int *len);
extern const char * msp430_emit_lshrqi3 (rtx insn, rtx operands[], int *len);
extern const char * msp430_emit_lshrhi3 (rtx insn, rtx operands[], int *len);
extern const char * msp430_emit_lshrsi3 (rtx insn, rtx operands[], int *len);
extern const char * msp430_emit_lshrdi3 (rtx insn, rtx operands[], int *len);

extern const char * signextendqihi (rtx insn, rtx operands[], int *len);
extern const char * signextendqisi (rtx insn, rtx operands[], int *len);
extern const char * signextendqidi (rtx insn, rtx operands[], int *len);
extern const char * signextendhisi (rtx insn, rtx operands[], int *len);
extern const char * signextendhidi (rtx insn, rtx operands[], int *len);
extern const char * signextendsidi (rtx insn, rtx operands[], int *len);

extern const char * msp430_emit_indexed_sub2 (rtx insn, rtx operands[], int *len);
extern const char * msp430_emit_indexed_sub4 (rtx insn, rtx operands[], int *len);

extern const char * msp430_emit_indexed_xor2 (rtx insn, rtx operands[], int *len);
extern const char * msp430_emit_indexed_xor4 (rtx insn, rtx operands[], int *len);
extern const char * msp430_emit_indexed_xor2_3 (rtx insn, rtx operands[], int *len);
extern const char * msp430_emit_indexed_xor4_3 (rtx insn, rtx operands[], int *len);

extern const char * zeroextendqihi (rtx insn, rtx operands[], int *len);
extern const char * zeroextendqisi (rtx insn, rtx operands[], int *len);
extern const char * zeroextendqidi (rtx insn, rtx operands[], int *len);
extern const char * zeroextendhisi (rtx insn, rtx operands[], int *len);
extern const char * zeroextendhidi (rtx insn, rtx operands[], int *len);
extern const char * zeroextendsidi (rtx insn, rtx operands[], int *len);

extern const char * msp430_emit_blt0si (rtx operands[], int len);
extern const char * msp430_emit_beq (rtx operands[], int len);
extern const char * msp430_emit_bne (rtx operands[], int len);          
extern const char * msp430_emit_bgt (rtx operands[], int len);          
extern const char * msp430_emit_bgtu (rtx operands[], int len);          
extern const char * msp430_emit_blt (rtx operands[], int len);          
extern const char * msp430_emit_bltu (rtx operands[], int len);          
extern const char * msp430_emit_bge (rtx operands[], int len);          
extern const char * msp430_emit_bgeu (rtx operands[], int len);          
extern const char * msp430_emit_ble (rtx operands[], int len);          
extern const char * msp430_emit_bleu (rtx operands[], int len);          

extern const char * msp430_pushsisf (rtx insn, rtx operands[], int *len);
extern const char * msp430_pushdi   (rtx insn, rtx operands[], int *len);
extern const char * msp430_pushhi   (rtx insn, rtx operands[], int *len);
extern const char * msp430_pushqi   (rtx insn, rtx operands[], int *len);

extern const char * msp430_emit_return (rtx insn, rtx operands[], int *len);
extern const char *msp430_cbranch (rtx insn, rtx operands[], int *len);
extern const char *msp430_cset (rtx insn, rtx operands[], int *len);

extern void   notice_update_cc       (rtx body, rtx insn);
extern int    msp430_peep2_scratch_safe (rtx reg_rtx);
extern int    test_hard_reg_class    (enum reg_class class, rtx x);
extern void   machine_dependent_reorg (rtx first_insn);
extern void msp430_output_addr_vec_elt (FILE *stream, int value);
extern void   final_prescan_insn     (rtx insn, rtx *operand,
							int num_operands);
extern int    adjust_insn_length     (rtx insn, int len);


extern int    msp430_address_cost    (rtx x);
extern int    extra_constraint       (rtx x, int c);
extern rtx    legitimize_address     (rtx x, rtx oldx,
					     enum machine_mode mode);
extern rtx    msp430_libcall_value   (enum machine_mode mode);
extern int    default_rtx_costs      (rtx X, RTX_CODE code,
					     RTX_CODE outer_code);
extern void   asm_output_char        (FILE *file, rtx value);
extern void   asm_output_short       (FILE *file, rtx value);
extern void   asm_output_byte        (FILE *file, int value);

extern void   print_operand          (FILE *file, rtx x, int code);
extern void   print_operand_address  (FILE *file, rtx addr);
extern int    reg_unused_after       (rtx insn, rtx reg);
extern int    msp430_jump_dist       (rtx x, rtx insn);
extern int    call_insn_operand      (rtx op, enum machine_mode mode);
extern int    msp430_branch_mode     (rtx x, rtx insn);

extern int 	msp430_easy_mul (rtx [],int);
extern int	msp430_mul3_guard (rtx [], int );
extern int      msp430_umul3_guard       (rtx [], int );
extern int	msp430_mulhisi_guard (rtx [] );
extern int	msp430_umulhisi_guard (rtx [] );
extern int	msp430_ashlhi3 	 (rtx [] );
extern int      msp430_ashlsi3          (rtx [] );
extern int      msp430_ashrhi3          (rtx [] );
extern int      msp430_ashrsi3          (rtx [] );
extern int      msp430_lshrhi3          (rtx [] );
extern int      msp430_lshrsi3          (rtx [] );


#endif /* RTX_CODE */

#ifdef HAVE_MACHINE_MODES
extern int    class_max_nregs        (enum reg_class class,
					     enum machine_mode mode);
#endif /* HAVE_MACHINE_MODES */

#ifdef REAL_VALUE_TYPE

extern void   asm_output_float       (FILE *file, REAL_VALUE_TYPE n);

#endif


