;; -*- Mode: Scheme -*-
;;   Machine description for GNU compiler,
;;   for Texas Instruments msp430 MCUs
;;   Copyright (C) 2001 Free Software Foundation, Inc.
;;   Contributed by Dmitry Diky <diwil@mail.ru>

;; This file is part of GNU CC.

;; GNU CC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU CC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU CC; see the file COPYING.  If not, write to
;; the Free Software Foundation, 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;; Special characters after '%':
;;  A  No effect (add 0).
;;  B  Add 1 to REG number, 2 to MEM address or CONST_INT.
;;  C	   2		    4
;;  D	   3		    6
;;  E  adds nothing to reg but used only with (mem:hi (reg:hi))
;;  F  no trim array
;;  Extra constarains:
;;  P  hardware constants: -1,0,+1,+2,+4,+8
;;  Q  Indexed destination register as X(Rn)
;;  R  Indexed source register as @Rn+
;;  S  Symbol reference for 'C' like: a = *b;
;;

;; Unspec usage:
;; 33 - strlen  
;; 0  - addc_reg
;; 5  - addc_any
;; 1  - bittest_lo
;; 2  - bittest_hi
;; 6  - bittest   
;; 4  - swpb      
;; 



;; Condition code settings.


(define_attr "cc" "none,set_czn,set_zn,set_n,compare,clobber"
  (const_string "none"))

(define_attr "type" "branch,branch1,arith"
  (const_string "arith"))

(define_attr "msp430_has_hwmul" "yes,no"
  (const (if_then_else (symbol_ref "MSP430_HAS_HWMUL")
		       (const_string "yes")
		       (const_string "no"))))

;; The size of instructions in bytes.
;; XXX may depend from "cc"

;; for confitional branches
(define_attr "length" ""
  (cond [(eq_attr "type" "branch")
         (if_then_else  (and (ge (minus (pc) (match_dup 0)) 
	 				(const_int -511))
                             (le (minus (pc) (match_dup 0)) 
			     		(const_int  512)))
                        (const_int 1)
			(const_int 2))]
	(const_int 2)
))


;;========================================================================
;;  PUSH/POP helper functions
;;

(define_insn "*pushqi"
  [(set (mem:QI (post_dec (reg:HI 1)))
        (match_operand:QI 0 "general_operand" "rP,im"))]
  "!indexed_location(operands[0])"
  "push.b	%0"
  [(set_attr "length" "1,2")])

(define_insn "*pushqi"
  [(set (mem:QI (post_dec (reg:HI 1))) 
        (match_operand:QI 0 "general_operand" "m"))]
  "indexed_location(operands[0])"
  "push.b	%0"
  [(set_attr "length" "1")])


(define_insn "*pushhi"
  [(set (mem:HI (post_dec (reg:HI 1))) 
        (match_operand:HI 0 "general_operand" "rP,im"))]
  "!indexed_location(operands[0])"
  "push	%0"
  [(set_attr "length" "1,2")])

(define_insn "*pushhi"
  [(set (mem:HI (post_dec (reg:HI 1))) 
        (match_operand:HI 0 "general_operand" "m"))]    
  "indexed_location(operands[0])" 
  "push	%0"
  [(set_attr "length" "1")])  


(define_insn "*pushsi"
  [(set (mem:SI (post_dec (reg:HI 1))) 
        (match_operand:SI 0 "general_operand" "rmi"))]
  ""
  "* return msp430_pushsisf(insn, operands, NULL);"
  [(set_attr "length" "4")])


(define_insn "*pushdi"
  [(set (mem:DI (post_dec (reg:HI 1)))
        (match_operand:DI 0 "general_operand" "rmi"))]
  ""
  "* return msp430_pushdi(insn, operands, NULL);"
  [(set_attr "length" "8")])


(define_insn "*pushsf"
  [(set (mem:SF (post_dec (reg:HI 1)))
        (match_operand:SF 0 "general_operand" "rmi"))]
  ""
  "* return msp430_pushsisf(insn, operands, NULL);"
  [(set_attr "length" "4")])


(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "") 
	(match_operand:HI 1 "general_operand" ""))
   (set (mem:HI (post_dec (reg:HI 1)))
	(match_dup 0))]
"dead_or_set_in_peep(1, insn, operands[0])"
  [(set (mem:HI (post_dec (reg:HI 1)))
	(match_dup 1))]
"")

(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "") 
	(match_operand:SI 1 "general_operand" ""))
   (set (mem:SI (post_dec (reg:HI 1)))
	(match_dup 0))]
"dead_or_set_in_peep(1, insn, operands[0])"
  [(set (mem:SI (post_dec (reg:HI 1)))
	(match_dup 1))]
"")

(define_peephole2
  [(set (match_operand:SF 0 "register_operand" "") 
	(match_operand:SF 1 "general_operand" ""))
   (set (mem:SF (post_dec (reg:HI 1)))
	(match_dup 0))]
"dead_or_set_in_peep(1, insn, operands[0])"
  [(set (mem:SF (post_dec (reg:HI 1)))
	(match_dup 1))]
"")


/*

(define_insn "*pop2"
  [(set (reg:HI 1) (plus:HI (reg:HI 1) (const_int 2)))]
  ""
  "add	#2, r1"
  [(set_attr "length" "1")])

(define_insn "*pop4"
  [(set (reg:HI 1) (plus:HI (reg:HI 1) (const_int 4)))]  
  ""
  "add	#4, r1"    
  [(set_attr "length" "1")])

(define_insn "*pop8"
  [(set (reg:HI 1) (plus:HI (reg:HI 1) (const_int 8)))]  
  ""
  "add	#8, r1"    
  [(set_attr "length" "1")])

*/



;; ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
;; This instructin sets Z flag

(define_insn "sez"
  [(set (cc0) (const_int 0))]
""
"setz"
  [(set_attr "length" "1")
   (set_attr "cc" "compare")])



;;========================================================================
;; compare

(define_insn "cmpqi"
  [(set (cc0)
        (compare:QI (match_operand:QI 0 "nonimmediate_operand_msp430" "rm")   
                    (match_operand:QI 1 "general_operand" "rmi")))]
 ""
 "* return msp430_emit_cmpqi(insn, operands, NULL);"
[(set_attr "length" "3")
   (set_attr "cc" "compare")])


(define_insn "cmphi"
  [(set (cc0)
        (compare:HI (match_operand:HI 0 "nonimmediate_operand_msp430" "rm")
                    (match_operand:HI 1 "general_operand" "rmi")))]
 ""
 "* return msp430_emit_cmphi(insn, operands, NULL);"
[(set_attr "length" "3")      
   (set_attr "cc" "compare")])

(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "") 
	(match_operand:HI 1 "nonimmediate_operand_msp430" ""))
   (set (cc0) 
	(compare:HI (match_dup 0) 
		    (match_operand:HI 2 "general_operand_msp430" "")))]
"dead_or_set_in_peep(1,insn,operands[0])"
  [(set (cc0) (compare:HI (match_dup 1) (match_dup 2)))]
"")

(define_insn "cmpsi"
  [(set (cc0)
        (compare:SI (match_operand:SI 0 "nonimmediate_operand_msp430" "rm")
                    (match_operand:SI 1 "general_operand_msp430" "rmi")))
        (clobber (match_scratch:SI 2 "=&r"))]
""
"* return msp430_emit_cmpsi(insn, operands, NULL);"
  [(set_attr "length" "5") 
   (set_attr "cc" "compare")])


(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "")
        (match_operand:SI 1 "register_operand" ""))
   (parallel [(set (cc0)
        (compare:SI (match_dup 0)
		    (match_operand:SI 2 "general_operand_msp430" "")))
	(clobber (match_dup 1))])]
""
  [(parallel [(set (cc0)
        (compare:SI (match_dup 1)
                    (match_operand:SI 2 "general_operand_msp430" "")))
        (clobber (match_dup 0))])]
"")

(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "") 
	(match_operand:SI 1 "general_operand_msp430" ""))
   (parallel [(set (cc0)
        (compare:SI (match_dup 0)
                    (match_operand:SI 2 "general_operand_msp430" "")))
        (clobber (match_scratch:SI 3 ""))])]
"dead_or_set_in_peep(1,insn,operands[0])"
  [(parallel [(set (cc0)
        (compare:SI (match_dup 1)
                    (match_dup 2))) 
        (clobber (match_dup 3))])]
"")



;;========================================================================
;; test

 
(define_insn "tstqi"
  [(set (cc0) (match_operand:QI 0 "nonimmediate_operand_msp430" "rm"))]
  ""
  "* return msp430_emit_tstqi(insn, operands, NULL);"
[(set_attr "length" "4")
 (set_attr "cc" "compare")])

(define_insn "tsthi"
  [(set (cc0) (match_operand:HI 0 "nonimmediate_operand_msp430" "rm"))]
  ""
  "* return msp430_emit_tsthi(insn, operands, NULL);"
[(set_attr "length" "4")
 (set_attr "cc" "compare")])


(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "") 
	(match_operand:HI 1 "nonimmediate_operand_msp430" ""))
   (set (cc0) (match_dup 0))]
"dead_or_set_in_peep(1,insn,operands[0])"
  [(set (cc0) (match_dup 1))]
"")


(define_insn "tstsi"
  [(parallel [(set (cc0) (match_operand:SI 0 "nonimmediate_operand_msp430" "rm"))
	(clobber (match_scratch:SI 1 "=&r"))])]
  ""
  "* return msp430_emit_tstsi(insn, operands, NULL);"
[(set_attr "length" "4")
 (set_attr "cc" "set_zn")])

(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "")
        (match_operand:SI 1 "register_operand" ""))
   (parallel [(set (cc0) (match_dup 0)) (clobber (match_dup 1))])]
"dead_or_set_in_peep(1,insn,operands[0])"
  [(parallel [(set (cc0) (match_dup 1)) (clobber (match_dup 0))])]
"")



;;========================================================================
;; noop
(define_insn "nop"
  [(const_int 0)]
  ""
  "nop"
  [(set_attr "cc" "none")
   (set_attr "length" "1")])



;;============================================================================
;; call
;;

(define_expand "call"
  [(call (match_operand:HI 0 "general_operand" "")
         (match_operand:HI 1 "general_operand" ""))]
  ""
  "")

(define_insn "*call_insn"
  [(call (mem:HI (match_operand:HI 0 "general_operand" "r,P,mi"))
         (match_operand:HI 1 "general_operand" "X,X,X"))]
""
"call\\t%0"
[ (set_attr "length" "1,1,2")
   (set_attr "cc" "clobber")])


(define_expand "call_value"
  [(set (match_operand 0 "register_operand" "")
        (call (match_operand:HI 1 "general_operand" "")
              (match_operand:HI 2 "general_operand" "")))]
  ""
  "")

(define_insn "*call_value_insn"
  [( set (match_operand 0 "register_operand" "=r,r,r")
   (call (mem:HI (match_operand:HI 1 "general_operand" "r,P,mi"))
	 (match_operand:HI 2 "general_operand" "X,X,X")))]
""
 "call\\t%1"
[ (set_attr "length" "1,1,2")
   (set_attr "cc" "clobber")])





;;========================================================================
;;========================================================================
;;========================================================================
;;========================================================================
;;========================================================================
;;
;;  Multiplication 
;;
;;  We simplify the thing:
;;  assume, that in any case destination operand is a register.
;;  Then, in case of msp2 (mcu with hw multiplier) the insn pattern is
;;  simple. In case of mcu1, we'll perform mult via library call.
;;  In this case we know exactly which registers are clobbered.
;;

;;========================================================================
;; 8 = 8x8 and 16 = 8x8

(define_expand "mulqi3"
  [(set (match_operand:QI 0 "register_operand" "")
        (mult:QI (match_operand:QI 1 "nonimmediate_operand" "")
                 (match_operand:QI 2 "nonimmediate_operand" "")))]  
  ""             
  "{ 
  if (!MSP430_HAS_HWMUL)
    {
      /* all ops have to be registers */
      if(!register_operand(operand1, QImode))
		operands[1] = copy_to_mode_reg(QImode,operand1);
      if(!register_operand(operand2, QImode))
		operands[2] = copy_to_mode_reg(QImode,operand2);
      emit_insn (gen_mulqi3_call (operands[0], operands[1], operands[2]));
      DONE;
    }
}")

(define_insn "*mulqi3_hw"
  [(set (match_operand:QI 0 "register_operand"        "=r,r,r,r") 
        (mult:QI (match_operand:QI 1 "nonimmediate_operand" "r,r,m,m")
                 (match_operand:QI 2 "nonimmediate_operand" "r,m,r,m")))]
  "MSP430_HAS_HWMUL"
  "mov.b %1, &__MPYS
	mov.b	%2, &__OP2
	mov.b	&__RESLO, %0"
  [(set_attr "length" "6,7,7,8")
   (set_attr "cc" "clobber,clobber,clobber,clobber")])

(define_expand "mulqi3_call"
  [(set (reg:QI 10) (match_operand:QI 1 "register_operand" ""))
   (set (reg:QI 12) (match_operand:QI 2 "register_operand" ""))
   (parallel [(set (reg:QI 14) (mult:QI (reg:QI 10) (reg:QI 12)))
	(clobber (reg:QI 10))
	(clobber (reg:QI 12))])
   (set (match_operand:QI 0 "register_operand" "") (reg:QI 14))]
  "!MSP430_HAS_HWMUL"
  "")

(define_insn "*mulqi3_call"
  [(set (reg:QI 14) (mult:QI (reg:QI 10) (reg:QI 12)))
	(clobber (reg:QI 10))
	(clobber (reg:QI 12))]
  "!MSP430_HAS_HWMUL"
  "call	#__mulqi3"
  [(set_attr "length" "2")
   (set_attr "cc" "clobber")])


(define_expand "mulqihi3"
  [(set (match_operand:HI 0 "register_operand" "")
        (mult:HI (sign_extend:HI (match_operand:QI 1 "nonimmediate_operand" ""))
                 (sign_extend:HI (match_operand:QI 2 "nonimmediate_operand" ""))))]
  ""
  "{
  if (!MSP430_HAS_HWMUL)
    {
     
      /* all ops have to be registers */
      if(!register_operand(operand1, QImode))
		operands[1] = copy_to_mode_reg(QImode,operand1);
      if(!register_operand(operand2, QImode))
		operands[2] = copy_to_mode_reg(QImode,operand2);
      emit_insn (gen_mulqihi3_call (operands[0], operands[1], operands[2]));
      DONE;
    }
}")


(define_insn "*mulqihi3_hw"
  [(set (match_operand:HI 0 "register_operand" "=r,r,r,r")
        (mult:HI (sign_extend:HI (match_operand:QI 1 "nonimmediate_operand" "r,r,m,m"))
                 (sign_extend:HI (match_operand:QI 2 "nonimmediate_operand" "r,m,r,m"))))]
  "MSP430_HAS_HWMUL"
  "mov	%1, &__MPYS
	mov	%2, &__OP2
	mov	&__RESLO, %0"
  [(set_attr "length" "6,7,7,8")
   (set_attr "cc" "clobber,clobber,clobber,clobber")])


(define_expand "mulqihi3_call"
  [(set (reg:QI 10) (match_operand:QI 1 "register_operand" ""))
   (set (reg:QI 12) (match_operand:QI 2 "register_operand" ""))
   (parallel [(set (reg:HI 14) (mult:HI 
				(sign_extend:HI (reg:QI 10)) 
				(sign_extend:HI (reg:QI 12))))
        (clobber (reg:QI 10))
        (clobber (reg:QI 12))])
   (set (match_operand:HI 0 "register_operand" "") (reg:HI 14))]
  "!MSP430_HAS_HWMUL"
  "")

(define_insn "*mulqihi3_call"
  [(set (reg:HI 14) (mult:HI 
		(sign_extend:HI (reg:QI 10))
		(sign_extend:HI (reg:QI 12))))
        (clobber (reg:QI 10))
        (clobber (reg:QI 12))]
  "!MSP430_HAS_HWMUL"
  "call	#__mulqihi3"   
  [(set_attr "length" "2")
   (set_attr "cc" "clobber")])


(define_expand "umulqihi3"
  [(set (match_operand:HI 0 "register_operand" "")
        (mult:HI (zero_extend:HI (match_operand:QI 1 "nonimmediate_operand" ""))
                 (zero_extend:HI (match_operand:QI 2 "nonimmediate_operand" ""))))]
  ""
  "{
  if (!MSP430_HAS_HWMUL)
    {
      /* all ops have to be registers */
      if(!register_operand(operand1, QImode))
                operands[1] = copy_to_mode_reg(QImode,operand1);
      if(!register_operand(operand2, QImode))
                operands[2] = copy_to_mode_reg(QImode,operand2);

      emit_insn (gen_umulqihi3_call (operands[0], operands[1], operands[2]));
      DONE;
    }
}")  
     

(define_insn "*umulqihi3_hw"
  [(set (match_operand:HI 0 "register_operand" "=r,r,r,r")
        (mult:HI (zero_extend:HI (match_operand:QI 1 "nonimmediate_operand" "r,r,m,m"))
                 (zero_extend:HI (match_operand:QI 2 "nonimmediate_operand" "r,m,r,m"))))]
  "MSP430_HAS_HWMUL"
  "mov	%1, &__MPY
	mov     %2, &__OP2
	mov     &__RESLO, %0"
  [(set_attr "length" "6,7,7,8")
   (set_attr "cc" "clobber,clobber,clobber,clobber")])
     
(define_expand "umulqihi3_call"
  [(set (reg:QI 10) (match_operand:QI 1 "register_operand" ""))
   (set (reg:QI 12) (match_operand:QI 2 "register_operand" ""))
   (parallel [(set (reg:HI 14) (mult:HI 
                                (zero_extend:HI (reg:QI 10))
                                (zero_extend:HI (reg:QI 12))))
        (clobber (reg:QI 10))
        (clobber (reg:QI 12))])
   (set (match_operand:HI 0 "register_operand" "") (reg:HI 14))]
  "!MSP430_HAS_HWMUL"
  "")

(define_insn "*umulqihi3_call"
  [(set (reg:HI 14) (mult:HI (zero_extend:HI (reg:QI 10))
                	     (zero_extend:HI (reg:QI 12))))
        (clobber (reg:QI 10))
        (clobber (reg:QI 12))]
  "!MSP430_HAS_HWMUL"
  "call	#__umulqihi3" 
  [(set_attr "length" "2")
   (set_attr "cc" "clobber")])



;;========================================================================
;; 16 = 16x16 and 32 = 16x16

(define_expand "mulhi3"
  [(set (match_operand:HI 0 "register_operand" "")
        (mult:HI (match_operand:HI 1 "nonimmediate_operand" "")
                 (match_operand:HI 2 "nonimmediate_operand" "")))]  
  ""             
  "{ 
  if (!MSP430_HAS_HWMUL)
    {
      /* all ops have to be registers */
      if(!register_operand(operand1, HImode))
		operands[1] = copy_to_mode_reg(HImode,operand1);
      if(!register_operand(operand2, HImode))
		operands[2] = copy_to_mode_reg(HImode,operand2);
      emit_insn (gen_mulhi3_call (operands[0], operands[1], operands[2]));
      DONE;
    }
}")

(define_insn "*mulhi3_hw"
  [(set (match_operand:HI 0 "register_operand"        "=r,r,r,r") 
        (mult:HI (match_operand:HI 1 "nonimmediate_operand" "r,r,m,m")
                 (match_operand:HI 2 "nonimmediate_operand" "r,m,r,m")))]
  "MSP430_HAS_HWMUL"
  "mov	%1, &__MPYS
	mov	%2, &__OP2
	mov	&__RESLO, %0"
  [(set_attr "length" "6,7,7,8")
   (set_attr "cc" "clobber,clobber,clobber,clobber")])

(define_expand "mulhi3_call"
  [(set (reg:HI 10) (match_operand:HI 1 "register_operand" ""))
   (set (reg:HI 12) (match_operand:HI 2 "register_operand" ""))
   (parallel [(set (reg:HI 14) (mult:HI (reg:HI 10) (reg:HI 12)))
	(clobber (reg:HI 10))
	(clobber (reg:HI 12))])
   (set (match_operand:HI 0 "register_operand" "") (reg:HI 14))]
  "!MSP430_HAS_HWMUL"
  "")

(define_insn "*mulhi3_call"
  [(set (reg:HI 14) (mult:HI (reg:HI 10) (reg:HI 12)))
	(clobber (reg:HI 10))
	(clobber (reg:HI 12))]
  "!MSP430_HAS_HWMUL"
  "call	#__mulhi3"
  [(set_attr "length" "2")
   (set_attr "cc" "clobber")])


(define_expand "mulhisi3"
  [(set (match_operand:SI 0 "register_operand" "")
        (mult:SI (sign_extend:SI (match_operand:HI 1 "nonimmediate_operand" ""))
                 (sign_extend:SI (match_operand:HI 2 "nonimmediate_operand" ""))))]
  ""
  "{
  if (!MSP430_HAS_HWMUL)
    {
     
      /* all ops have to be registers */
      if(!register_operand(operand1, HImode))
		operands[1] = copy_to_mode_reg(HImode,operand1);
      if(!register_operand(operand2, HImode))
		operands[2] = copy_to_mode_reg(HImode,operand2);
      emit_insn (gen_mulhisi3_call (operands[0], operands[1], operands[2]));
      DONE;
    }
}")


(define_insn "*mulhisi3_hw"
  [(set (match_operand:SI 0 "register_operand" "=r,r,r,r")
        (mult:SI (sign_extend:SI (match_operand:HI 1 "nonimmediate_operand" "r,r,m,m"))
                 (sign_extend:SI (match_operand:HI 2 "nonimmediate_operand" "r,m,r,m"))))]
  "MSP430_HAS_HWMUL"
  "mov	%1, &__MPYS
	mov	%2, &__OP2
	mov	&__RESLO, %A0
	mov	&__RESHI, %B0"
  [(set_attr "length" "8,9,9,10")
   (set_attr "cc" "clobber,clobber,clobber,clobber")])


(define_expand "mulhisi3_call"
  [(set (reg:HI 10) (match_operand:HI 1 "register_operand" ""))
   (set (reg:HI 12) (match_operand:HI 2 "register_operand" ""))
   (parallel [(set (reg:SI 14) (mult:SI (sign_extend:SI (reg:HI 10)) 
				        (sign_extend:SI (reg:HI 12))))
        (clobber (reg:HI 10))
        (clobber (reg:HI 11))
	(clobber (reg:HI 12))
	(clobber (reg:HI 13))])
   (set (match_operand:SI 0 "register_operand" "") (reg:SI 14))]
  "!MSP430_HAS_HWMUL"
  "")

(define_insn "*mulhisi3_call"
  [(set (reg:SI 14) (mult:SI (sign_extend:SI (reg:HI 10))
			     (sign_extend:SI (reg:HI 12))))
        (clobber (reg:HI 10))
        (clobber (reg:HI 11))
	(clobber (reg:HI 12))  
	(clobber (reg:HI 13))]
  "!MSP430_HAS_HWMUL"
  "tst	r10
	jge	+2
	mov	#-1, r11
	tst	r12
	jge	+2
	mov	#-1, r13
	call	#__mulhisi3"
  [(set_attr "length" "8")
   (set_attr "cc" "clobber")])


(define_expand "umulhisi3"
  [(set (match_operand:SI 0 "register_operand" "")
        (mult:SI (zero_extend:SI (match_operand:HI 1 "nonimmediate_operand" ""))
                 (zero_extend:SI (match_operand:HI 2 "nonimmediate_operand" ""))))]
  ""
  "{
  if (!MSP430_HAS_HWMUL)
    {
      /* all ops have to be registers */
      if(!register_operand(operand1, HImode))
                operands[1] = copy_to_mode_reg(HImode,operand1);
      if(!register_operand(operand2, HImode))
                operands[2] = copy_to_mode_reg(HImode,operand2);

      emit_insn (gen_umulhisi3_call (operands[0], operands[1], operands[2]));
      DONE;
    }
}")  
     

(define_insn "*umulhisi3_hw"
  [(set (match_operand:SI 0 "register_operand" "=r,r,r,r")
        (mult:SI (zero_extend:SI (match_operand:HI 1 "nonimmediate_operand" "r,r,m,m"))
                 (zero_extend:SI (match_operand:HI 2 "nonimmediate_operand" "r,m,r,m"))))]
  "MSP430_HAS_HWMUL"
  "mov	%1, &__MPY
	mov     %2, &__OP2
	mov     &__RESLO, %A0
	mov	&__RESHI, %B0"
  [(set_attr "length" "8,9,9,10")
   (set_attr "cc" "clobber,clobber,clobber,clobber")])
     
(define_expand "umulhisi3_call"
  [(set (reg:HI 10) (match_operand:HI 1 "register_operand" ""))
   (set (reg:HI 12) (match_operand:HI 2 "register_operand" ""))
   (parallel [(set (reg:SI 14) (mult:SI (zero_extend:SI (reg:HI 10))
                                        (zero_extend:SI (reg:HI 12))))
        (clobber (reg:HI 10))
        (clobber (reg:HI 11))
	(clobber (reg:HI 12))
	(clobber (reg:HI 13))])
   (set (match_operand:SI 0 "register_operand" "") (reg:SI 14))]
  "!MSP430_HAS_HWMUL"
  "")

(define_insn "*umulhisi3_call"
  [(set (reg:SI 14) (mult:SI (zero_extend:SI (reg:HI 10))
                	     (zero_extend:SI (reg:HI 12))))
        (clobber (reg:HI 10))
        (clobber (reg:HI 11))
	(clobber (reg:HI 12))  
	(clobber (reg:HI 13))]
  "!MSP430_HAS_HWMUL"
  "clr	r11
	clr	r13
	call	#__umulhisi3" 
  [(set_attr "length" "2")
   (set_attr "cc" "clobber")])


;;========================================================================
;; 32 = 32x32.      64 = 32x32 <- via library calls only

(define_expand "mulsi3"
  [(set (reg:SI 10) (match_operand:SI 1 "register_operand" ""))
   (set (reg:SI 12) (match_operand:SI 2 "register_operand" ""))
   (set (reg:SI 14) (mult:SI (reg:SI 10) (reg:SI 12)))
   (set (match_operand:SI 0 "register_operand" "") (reg:SI 14))]
""
"{ 
  if (!MSP430_HAS_HWMUL)
    {
      /* all ops have to be registers */
      emit_insn (gen_mulsi3_call (operands[0], operands[1], operands[2]));
      DONE;
    }
}")

(define_insn "*mulsi3hw_call"
  [(set (reg:SI 14) (mult:SI (reg:SI 10) (reg:SI 12)))]
  "!TARGET_INLINESIHWMUL"
  "call	#__umulsi3hw"
[(set_attr "length" "2")
   (set_attr "cc" "clobber")])

(define_insn "*mulsi3hw_inline"
  [(set (reg:SI 14) (mult:SI (reg:SI 10) (reg:SI 12)))]
  "TARGET_INLINESIHWMUL && MSP430_HAS_HWMUL"
"mov	r12, &__MPY
	mov	r10, &__OP2
	mov	r12, &__MAC
	mov	&__RESLO, r14
	mov	&__RESHI, &__RESLO
	mov	r11, &__OP2
	mov	r13, &__MAC
	mov	r10, &__OP2
	mov	&__RESLO, r15"
[(set_attr "length" "19")  
   (set_attr "cc" "clobber")])


(define_expand "mulsi3_call"
  [(set (reg:SI 10) (match_operand:SI 1 "register_operand" ""))
   (set (reg:SI 12) (match_operand:SI 2 "register_operand" "")) 
   (parallel [(set (reg:SI 14) (mult:SI (reg:SI 10) (reg:SI 12)))
        (clobber (reg:SI 10))
        (clobber (reg:SI 12))])
   (set (match_operand:SI 0 "register_operand" "") (reg:SI 14))]
"!MSP430_HAS_HWMUL"
"")


(define_insn "*mulsi3_call"
  [(set (reg:SI 14) (mult:SI (reg:SI 10) (reg:SI 12)))
	(clobber (reg:SI 10))
	(clobber (reg:SI 12))]
  "!MSP430_HAS_HWMUL"
  "call	#__mulsi3"
  [(set_attr "length" "2")
   (set_attr "cc" "clobber")])


;; / % / % / % / % / % / % / % / % / % / % / % / % / % / % / % / % / % / % /
;; / % / % / % / % / % / % / % / % / % / % / % / % / % / % / % / % / % / % /
;; / % / % / % / % / % / % / % / % / % / % / % / % / % / % / % / % / % / % /
;; / % / % / % / % / % / % / % / % / % / % / % / % / % / % / % / % / % / % /

(define_expand "divmodqi4"
  [(set (reg:QI 12) (match_operand:QI 1 "register_operand" ""))
   (set (reg:QI 10) (match_operand:QI 2 "register_operand" ""))
   (parallel [(set (reg:QI 12) (div:QI (reg:QI 12) (reg:QI 10)))
              (set (reg:QI 14) (mod:QI (reg:QI 12) (reg:QI 10)))
              (clobber (reg:QI 10))
              (clobber (reg:QI 11))
	      (clobber (reg:QI 13))])
   (set (match_operand:QI 0 "register_operand" "") (reg:QI 12))
   (set (match_operand:QI 3 "register_operand" "") (reg:QI 14))]
  ""
  "")

(define_insn "*divmodqi4_call"
  [(set (reg:QI 12) (div:QI (reg:QI 12) (reg:QI 10)))
   (set (reg:QI 14) (mod:QI (reg:QI 12) (reg:QI 10)))
   (clobber (reg:QI 10))
   (clobber (reg:QI 11))
   (clobber (reg:QI 13))]
  ""
  "call	#__divmodqi4"
   [(set_attr "length" "2")
   (set_attr "cc" "clobber")])

(define_expand "udivmodqi4"
  [(set (reg:QI 12) (match_operand:QI 1 "register_operand" ""))
   (set (reg:QI 10) (match_operand:QI 2 "register_operand" ""))
   (parallel [(set (reg:QI 12) (udiv:QI (reg:QI 12) (reg:QI 10)))
              (set (reg:QI 14) (umod:QI (reg:QI 12) (reg:QI 10)))
              (clobber (reg:QI 10))
              (clobber (reg:QI 11)) 
              (clobber (reg:QI 13))])
   (set (match_operand:QI 0 "register_operand" "") (reg:QI 12))
   (set (match_operand:QI 3 "register_operand" "") (reg:QI 14))]
  ""
  "")

(define_insn "*udivmodqi4_call"
  [(set (reg:QI 12) (udiv:QI (reg:QI 12) (reg:QI 10)))
   (set (reg:QI 14) (umod:QI (reg:QI 12) (reg:QI 10)))
   (clobber (reg:QI 10))
   (clobber (reg:QI 11)) 
   (clobber (reg:QI 13))]
  ""
  "call	#__udivmodqi4"
   [(set_attr "length" "2")
   (set_attr "cc" "clobber")])


(define_expand "divmodhi4"
  [(set (reg:HI 12) (match_operand:HI 1 "register_operand" ""))
   (set (reg:HI 10) (match_operand:HI 2 "register_operand" ""))
   (parallel [(set (reg:HI 12) (div:HI (reg:HI 12) (reg:HI 10)))
              (set (reg:HI 14) (mod:HI (reg:HI 12) (reg:HI 10)))
              (clobber (reg:HI 10))
              (clobber (reg:HI 11))
	      (clobber (reg:HI 13))])
   (set (match_operand:HI 0 "register_operand" "") (reg:HI 12))
   (set (match_operand:HI 3 "register_operand" "") (reg:HI 14))]
  ""
  "")

(define_insn "*divmodhi4_call"
  [(set (reg:HI 12) (div:HI (reg:HI 12) (reg:HI 10)))
   (set (reg:HI 14) (mod:HI (reg:HI 12) (reg:HI 10)))
   (clobber (reg:HI 10))
   (clobber (reg:HI 11))
   (clobber (reg:HI 13))]
  ""
  "call	#__divmodhi4"
   [(set_attr "length" "2")
   (set_attr "cc" "clobber")])

(define_expand "udivmodhi4"
  [(set (reg:HI 12) (match_operand:HI 1 "register_operand" ""))
   (set (reg:HI 10) (match_operand:HI 2 "register_operand" ""))
   (parallel [(set (reg:HI 12) (udiv:HI (reg:HI 12) (reg:HI 10)))
              (set (reg:HI 14) (umod:HI (reg:HI 12) (reg:HI 10)))
              (clobber (reg:HI 10))
              (clobber (reg:HI 11)) 
              (clobber (reg:HI 13))])
   (set (match_operand:HI 0 "register_operand" "") (reg:HI 12))
   (set (match_operand:HI 3 "register_operand" "") (reg:HI 14))]
  ""
  "")

(define_insn "*udivmodhi4_call"
  [(set (reg:HI 12) (udiv:HI (reg:HI 12) (reg:HI 10)))
   (set (reg:HI 14) (umod:HI (reg:HI 12) (reg:HI 10)))
   (clobber (reg:HI 10))
   (clobber (reg:HI 11)) 
   (clobber (reg:HI 13))]
  ""
  "call	#__udivmodhi4"
   [(set_attr "length" "2")
   (set_attr "cc" "clobber")])


;; ///////////////// SINGLE INTEGER %%%%%%%%%%%%%%%%%

(define_expand "divmodsi4"
  [(set (reg:SI 12) (match_operand:SI 1 "register_operand" ""))
   (set (reg:SI 10) (match_operand:SI 2 "register_operand" ""))
   (parallel [(set (reg:SI 12) (div:SI (reg:SI 12) (reg:SI 10)))
              (set (reg:SI 14) (mod:SI (reg:SI 12) (reg:SI 10)))
              (clobber (reg:SI 10))
              (clobber (reg:HI 9))
	      (clobber (reg:HI 8))])
   (set (match_operand:SI 0 "register_operand" "") (reg:SI 12))
   (set (match_operand:SI 3 "register_operand" "") (reg:SI 14))]
  ""
  "")

(define_insn "*divmodsi4_call"
  [(set (reg:SI 12) (div:SI (reg:SI 12) (reg:SI 10)))
   (set (reg:SI 14) (mod:SI (reg:SI 12) (reg:SI 10)))
   (clobber (reg:SI 10))
   (clobber (reg:HI 9))
   (clobber (reg:HI 8))]
  ""
  "call	#__divmodsi4"
   [(set_attr "length" "2")
   (set_attr "cc" "clobber")])

(define_expand "udivmodsi4"
  [(set (reg:SI 12) (match_operand:SI 1 "register_operand" ""))
   (set (reg:SI 10) (match_operand:SI 2 "register_operand" ""))
   (parallel [(set (reg:SI 12) (udiv:SI (reg:SI 12) (reg:SI 10)))
              (set (reg:SI 14) (umod:SI (reg:SI 12) (reg:SI 10)))
              (clobber (reg:SI 10))
              (clobber (reg:HI 9)) 
              (clobber (reg:HI 8))])
   (set (match_operand:SI 0 "register_operand" "") (reg:SI 12))
   (set (match_operand:SI 3 "register_operand" "") (reg:SI 14))]
  ""
  "")

(define_insn "*udivmodsi4_call"
  [(set (reg:SI 12) (udiv:SI (reg:SI 12) (reg:SI 10)))
   (set (reg:SI 14) (umod:SI (reg:SI 12) (reg:SI 10)))
   (clobber (reg:SI 10))
   (clobber (reg:HI 9)) 
   (clobber (reg:HI 8))]
  ""
  "call	#__udivmodsi4"
   [(set_attr "length" "2")
   (set_attr "cc" "clobber")])




;;========================================================================
;; MOV STRING
;;   structures and stuff are word aligned.
;;   so, QI mode only defined (as HI actually)
;;

(define_expand "movstrhi"
  [(parallel [(set (match_operand:BLK 0 "memory_operand" "")
                   (match_operand:BLK 1 "memory_operand" ""))
              (use (match_operand:HI 2 "const_int_operand" ""))
              (use (match_operand:HI 3 "const_int_operand" ""))
              (clobber (match_dup 4))
              (clobber (match_dup 5))
              (clobber (match_dup 6))])]
  ""
  " 
{   
  rtx addr0, addr1;
  if (GET_CODE (operands[2]) != CONST_INT) FAIL;
   
  operands[2] = copy_to_mode_reg (HImode, operands[2]);
  operands[4] = operands[2];
  addr0 = copy_to_mode_reg (Pmode, XEXP (operands[0], 0));
  addr1 = copy_to_mode_reg (Pmode, XEXP (operands[1], 0));

  operands[5] = addr0;
  operands[6] = addr1;

  operands[0] = gen_rtx (MEM, BLKmode, addr0);
  operands[1] = gen_rtx (MEM, BLKmode, addr1);
}
 
")
  
(define_insn "*movstrhi_insn"
  [(set (mem:BLK (match_operand:HI 0 "register_operand" "r"))
        (mem:BLK (match_operand:HI 1 "register_operand" "r")))
   (use (match_operand:HI 2 "register_operand" "r"))
   (use (match_operand:HI 3 "const_int_operand" "i"))
   (clobber (match_dup 2))
   (clobber (match_dup 0))
   (clobber (match_dup 1))]
  ""
  "* return movstrhi_insn(insn, operands, NULL);"
  [(set_attr "length" "6")
   (set_attr "cc" "clobber")])

(define_insn "*movstrqi_insn"
  [(set (mem:BLK (match_operand:HI 0 "register_operand" "r"))
        (mem:BLK (match_operand:HI 1 "register_operand" "r")))
   (use (match_operand:QI 2 "register_operand" "r"))
   (use (match_operand:QI 3 "const_int_operand" "i"))
   (clobber (match_dup 2))
   (clobber (match_dup 0))
   (clobber (match_dup 1))]
  ""
  "* return movstrhi_insn(insn, operands, NULL);"
  [(set_attr "length" "6")
   (set_attr "cc" "clobber")])




;;========================================================================
;; CLEAR STRING

(define_expand "clrstrhi"
  [(parallel [(set (match_operand:BLK 0 "memory_operand" "")
                   (const_int 0))
              (use (match_operand:HI 1 "const_int_operand" ""))
              (use (match_operand:HI 2 "const_int_operand" "i"))
              (clobber (match_dup 3))
              (clobber (match_dup 4))])]
  ""
  " 
{
  rtx addr0;

  if (GET_CODE (operands[1]) != CONST_INT) FAIL;
  operands[1] = copy_to_mode_reg (HImode, operands[1]);
  operands[3] = operands[1];
  addr0 = copy_to_mode_reg (Pmode, XEXP (operands[0], 0));
  operands[4] = addr0;
  operands[0] = gen_rtx (MEM, BLKmode, addr0);
}")


(define_insn "*clrstrhi_insn"
  [(set (mem:BLK (match_operand:HI 0 "register_operand" "r"))
        (const_int 0))
   (use (match_operand:HI 1 "register_operand" "r")) 
   (use (match_operand:HI 2 "const_int_operand" "i"))
   (clobber (match_dup 1)) 
   (clobber (match_dup 0))]
  ""
  "* return clrstrhi_insn(insn, operands, NULL);"
[(set_attr "length" "6")
   (set_attr "cc" "clobber")])


;;========================================================================
;; %0 = strchr(%1,%2) - %1

(define_expand "strlenhi"
  [(set (match_dup 4)
            (unspec:HI [(match_operand:BLK 1 "memory_operand" "")
                        (match_operand:QI 2 "const_int_operand" "")
                        (match_operand:HI 3 "immediate_operand" "")] 33))
     (set (match_operand:HI 0 "register_operand" "")
          (minus:HI (match_dup 4)
                    (match_dup 5)))]
   ""
   "
{
  rtx addr;

  if (! (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 0))
        FAIL;
  addr = copy_to_mode_reg (Pmode, XEXP (operands[1],0));
  operands[1] = gen_rtx (MEM, BLKmode, addr);
  operands[5] = addr;
  operands[4] = gen_reg_rtx (HImode);

}")


(define_insn "*strlenhi"
 [(set (match_operand:HI 0 "register_operand" "=r")
        (unspec:HI [(mem:BLK (match_operand:HI 1 "register_operand" "0"))
                    (const_int 0)
                    (match_operand:HI 2 "immediate_operand" "i") ] 33))]
  ""
"dec    %0
.L__strlenhi__%=:
        inc     %0
        tst.b   0(%0)
        jne     .L__strlenhi__%="
[(set_attr "length" "5")
   (set_attr "cc" "clobber")])


;;========================================================================
;; MOV code
;;
;;


;;========================================================================
;; move byte
;; nothing much special
;; all addressing modes allowed
;; fits perfectly into a single instruction 

(define_expand "movqi" 
  [(set (match_operand:QI 0 "nonimmediate_operand_msp430" "")
        (match_operand:QI 1 "general_operand" ""))]
  ""
  "")

(define_insn "*movqi3"
  [(set (match_operand:QI 0 "nonimmediate_operand"	"=m,m,m,m,r,r,r,r")
	(match_operand:QI 1 "general_operand_msp430"	" m,r,P,i,m,r,P,i"))]
  ""
  "mov.b\\t%1, %0"
  [(set_attr "length" "3,2,2,3,2,1,1,2")
   (set_attr "cc" "none")])



;;============================================================================
;; move word (16 bit)
;; the same as above

(define_expand "movhi" 
  [(set (match_operand:HI 0 "nonimmediate_operand_msp430" "")
        (match_operand:HI 1 "general_operand_msp430" ""))]
  ""
  "")

(define_insn "*movhi3"
  [(set (match_operand:HI 0 "nonimmediate_operand_msp430"	"=m,m,m,m,r,r,r,r")
	(match_operand:HI 1 "general_operand_msp430"		" r,m,P,i,r,m,P,i"))]
  ""
  "mov\\t%1, %0 "
  [(set_attr "length" "2,3,2,3,1,2,1,2")
   (set_attr "cc" "none")])



;;============================================================================
;; move long (32 bit)
;; the same as above

(define_expand "movsi" 
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
        (match_operand:SI 1 "general_operand" ""))]
  ""
  "")

(define_insn "*movsi3"
  [(set (match_operand:SI 0 "nonimmediate_operand"	"=rm")
	(match_operand:SI 1 "general_operand"		" rmi"))]
""
"* return msp430_movesi_code(insn,operands,NULL);"
  [(set_attr "length" "6")
   (set_attr "cc" "none")])


;;============================================================================
;; floats are the SI

(define_expand "movsf" 
  [(set (match_operand:SF 0 "nonimmediate_operand" "")
        (match_operand:SF 1 "general_operand" ""))]
  ""
  "")

(define_insn "*movsf3"
  [(set (match_operand:SF 0 "nonimmediate_operand"	"=rm")
	(match_operand:SF 1 "general_operand"		"rmi"))]
""
"* return msp430_movesi_code(insn,operands,NULL);"
  [(set_attr "length" "6")
   (set_attr "cc" "none")])

;;============================================================================
;; move long long (64 bit)
;; the same as above
(define_expand "movdi" 
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
        (match_operand:DI 1 "general_operand" ""))]
  ""
  "")

(define_insn "*movdi3"
  [(set (match_operand:DI 0 "nonimmediate_operand" 	"=rm")
	(match_operand:DI 1 "general_operand"		"rmi"))]
""
"* return msp430_movedi_code(insn,operands,NULL);"
  [(set_attr "length" "12")
   (set_attr "cc" "none")])



;;============================================================================
;;  ARITHMETIC CODE
;;


;;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;; add 1 byte 


(define_expand "addqi3" 
  [(set (match_operand:QI 0 "nonimmediate_operand_msp430" "")
        (plus:QI (match_operand:QI 1 "nonimmediate_operand_msp430" "")   
                 (match_operand:QI 2 "general_operand_msp430" "")))]
  "" 
  "")

(define_insn "*addqi3_cg"
  [(set (match_operand:QI 0 "nonimmediate_operand_msp430" "=m,r")   
        (plus:QI (match_operand:QI 1 "nonimmediate_operand_msp430" "%0,0")   
                 (match_operand:QI 2 "const_int_operand"      "i,i")))]
"(INTVAL(operands[2]) == -2 
  || INTVAL(operands[2]) == -4 
  || INTVAL(operands[2]) == -8 )"
"* {
	operands[2] = gen_rtx_CONST_INT(QImode, -INTVAL(operands[2]));
	return \"sub.b\\t%2, %0\";
}"
[(set_attr "length" "2,1")
 (set_attr "cc" "set_czn,set_czn")])



(define_insn "*addqi3_3"
  [(set (match_operand:QI 0 "nonimmediate_operand_msp430"          "=m,m,m,m,r,r,r,r")  
        (plus:QI (match_operand:QI 1 "nonimmediate_operand_msp430" "%0,0,0,0,0,0,0,0")  
                 (match_operand:QI 2 "general_operand_msp430"      " m,r,P,i,m,r,P,i")))]  
""
  "add.b	%2, %0"
  [(set_attr "length" "3,2,2,3,2,1,1,2")
   (set_attr "cc" "set_czn,set_czn,set_czn,set_czn,set_czn,set_czn,set_czn,set_czn")])


;;============================================================================
;; add 1 word (16 bits)
;; same as above


(define_expand "addhi3" 
  [(set (match_operand:HI 0 "nonimmediate_operand_msp430" "")
        (plus:HI (match_operand:HI 1 "nonimmediate_operand_msp430" "")
                 (match_operand:HI 2 "general_operand_msp430" "")))]
  ""
  "")

(define_insn "*addhi3_cg"
  [(set (match_operand:HI 0 "nonimmediate_operand_msp430" "=m,r")
        (plus:HI (match_operand:HI 1 "nonimmediate_operand_msp430" "%0,0")
                 (match_operand:HI 2 "const_int_operand"      "i,i")))]
"(INTVAL(operands[2]) == -2
  || INTVAL(operands[2]) == -4 
  || INTVAL(operands[2]) == -8 )"
"* {
        operands[2] = gen_rtx_CONST_INT(HImode, -INTVAL(operands[2]));
        return \"sub\\t%2, %0\" ;
}"
[(set_attr "length" "2,1")
 (set_attr "cc" "set_czn,set_czn")])


(define_insn "*addhi3_3"
  [(set (match_operand:HI 0 "nonimmediate_operand_msp430"          "=m,m,m,m,r,r,r,r")
        (plus:HI (match_operand:HI 1 "nonimmediate_operand_msp430" "%0,0,0,0,0,0,0,0")
                 (match_operand:HI 2 "general_operand_msp430"      " m,r,P,i,m,r,P,i")))]
""
  "add	%2, %0"
  [(set_attr "length" "3,2,2,3,2,1,1,2")
   (set_attr "cc"
"set_czn,set_czn,set_czn,set_czn,set_czn,set_czn,set_czn,set_czn")])


;;============================================================================
;; add 2 words (32 bits)
;; same as above

(define_expand "addsi3"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
        (plus:SI (match_operand:SI 1 "nonimmediate_operand" "")
                 (match_operand:SI 2 "general_operand" "")))]
  "" 
  "")

(define_insn "*addsi3_cg"
  [(set (match_operand:SI 0 "nonimmediate_operand_msp430" "=m,r")
        (plus:SI (match_operand:SI 1 "nonimmediate_operand_msp430" "%0,0")
                 (match_operand:SI 2 "const_int_operand"      "i,i")))]
"(INTVAL(operands[2]) == -2
  || INTVAL(operands[2]) == -4 
  || INTVAL(operands[2]) == -8 )"
"* {
        operands[2] = gen_rtx_CONST_INT(SImode, -INTVAL(operands[2]));
        return \"sub\\t%A2, %A0\\n\\tsubc\\t%B2, %B0\" ;
}"
[(set_attr "length" "4,2")
 (set_attr "cc" "set_czn,set_czn")])




(define_insn "*addsi3_3"
  [(set (match_operand:SI 0 "nonimmediate_operand"      "=rm")
        (plus:SI (match_operand:SI 1 "general_operand"  "%0")
                 (match_operand:SI 2 "general_operand"  " rmi")))]
""
"* return msp430_addsi_code(insn, operands, NULL);"
  [(set_attr "length" "6")
   (set_attr "cc" "set_czn")])


;;============================================================================
;; add 4 words (64 bits)
;; same as above

(define_expand "adddi3"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
        (plus:DI (match_operand:DI 1 "nonimmediate_operand" "")   
                 (match_operand:DI 2 "general_operand" "")))]
  "" 
  "")

(define_insn "*adddi3_cg"
  [(set (match_operand:DI 0 "nonimmediate_operand_msp430" "=m,r")
        (plus:DI (match_operand:DI 1 "nonimmediate_operand_msp430" "%0,0")
                 (match_operand:DI 2 "const_int_operand"      "i,i")))]
"(INTVAL(operands[2]) == -2
  || INTVAL(operands[2]) == -4 
  || INTVAL(operands[2]) == -8 )"
"* {
        operands[2] = gen_rtx_CONST_INT(DImode, -INTVAL(operands[2]));
        return \"sub\\t%A2, %A0\\n\\tsubc\\t%B2, %B0\\n\\tsubc\\t%C2, %C0\\n\\tsubc\\t%D2, %D0\" ;
}"
[(set_attr "length" "4,2")
 (set_attr "cc" "set_czn,set_czn")])


(define_insn "*adddi3_3"
  [(set (match_operand:DI 0 "nonimmediate_operand"      	"=rm")
        (plus:DI (match_operand:DI 1 "nonimmediate_operand"  	"%0")
                 (match_operand:DI 2 "general_operand"  	" rmi")))]
""
"* return msp430_adddi_code(insn, operands, NULL);"
  [(set_attr "length" "12")
   (set_attr "cc" "set_czn")])


;;-----------------------------------------------------------------------
;;-----------------------------------------------------------------------
;;-----------------------------------------------------------------------
;;-----------------------------------------------------------------------
;;-----------------------------------------------------------------------
;; sub 1 byte 


(define_expand "subqi3" 
  [(set (match_operand:QI 0 "nonimmediate_operand_msp430" "")
        (minus:QI (match_operand:QI 1 "nonimmediate_operand_msp430" "")   
                  (match_operand:QI 2 "general_operand_msp430" "")))]
  "" 
  "")

(define_insn "*subqi3_3"
  [(set (match_operand:QI 0 "nonimmediate_operand_msp430"          "=m,m,m,m,r,r,r,r")  
        (minus:QI (match_operand:QI 1 "nonimmediate_operand_msp430" "0,0,0,0,0,0,0,0")  
                 (match_operand:QI 2 "general_operand_msp430"      " m,r,P,i,m,r,P,i")))]  
""
  "sub.b	%2, %0"
  [(set_attr "length" "3,2,2,3,2,1,1,2")
   (set_attr "cc" "set_czn,set_czn,set_czn,set_czn,set_czn,set_czn,set_czn,set_czn")])


;;============================================================================
;; sub 1 word (16 bits)
;; same as above


(define_expand "subhi3" 
  [(set (match_operand:HI 0 "nonimmediate_operand_msp430" "")
        (minus:HI (match_operand:HI 1 "nonimmediate_operand_msp430" "")
                  (match_operand:HI 2 "general_operand_msp430" "")))]
  ""
  "")

(define_insn "*subhi3_3"
  [(set (match_operand:HI 0 "nonimmediate_operand_msp430"          "=m,m,m,m,r,r,r,r")
        (minus:HI (match_operand:HI 1 "nonimmediate_operand_msp430" "0,0,0,0,0,0,0,0")
                  (match_operand:HI 2 "general_operand_msp430"      "m,r,P,i,m,r,P,i")))]
""
  "sub	%2, %0"
  [(set_attr "length" "3,2,2,3,2,1,1,2")
   (set_attr "cc"
"set_czn,set_czn,set_czn,set_czn,set_czn,set_czn,set_czn,set_czn")])


;;============================================================================
;; sub 2 words (32 bits)
;; same as above

(define_expand "subsi3"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
        (minus:SI (match_operand:SI 1 "nonimmediate_operand" "")
                 (match_operand:SI 2 "general_operand" "")))]
  "" 
  "")


(define_insn "*subsi3_3"
  [(set (match_operand:SI 0 "nonimmediate_operand"      "=rm")
        (minus:SI (match_operand:SI 1 "general_operand"  "0")
                 (match_operand:SI 2 "general_operand"  " rmi")))]
""
"* return msp430_subsi_code(insn, operands, NULL);"
  [(set_attr "length" "6")
   (set_attr "cc" "set_n")])


;;============================================================================
;; sub 4 words (64 bits)
;; same as above

(define_expand "subdi3"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
        (minus:DI (match_operand:DI 1 "nonimmediate_operand" "")   
                 (match_operand:DI 2 "general_operand" "")))]
  "" 
  "")

(define_insn "*subdi3_3"
  [(set (match_operand:DI 0 "nonimmediate_operand"      	"=rm")
        (minus:DI (match_operand:DI 1 "nonimmediate_operand"  	"0")
                 (match_operand:DI 2 "general_operand"  	" rmi")))]
""
"* return msp430_subdi_code(insn, operands,NULL);"
  [(set_attr "length" "12")
   (set_attr "cc" "set_n")])





;;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;; and 1 byte 
;; looks like a 'mov' insn


(define_expand "andqi3" 
  [(set (match_operand:QI 0 "nonimmediate_operand_msp430" "")
        (and:QI (match_operand:QI 1 "nonimmediate_operand_msp430" "")   
                 (match_operand:QI 2 "general_operand_msp430" "")))]
  "" 
  "")


(define_insn "*andqi3_inv"
  [(set (match_operand:QI 0 "nonimmediate_operand_msp430"         "=r,m")   
        (and:QI (match_operand:QI 1 "nonimmediate_operand_msp430" "%0,0")
                (match_operand:QI 2 "immediate_operand"    " i,i")))]
"(INTVAL(operands[2])==~1
  || INTVAL(operands[2])==~2
  || INTVAL(operands[2])==~4
  || INTVAL(operands[2])==~8)"
"* {
	operands[2] = gen_rtx_CONST_INT(QImode, ~(INTVAL(operands[2])));
	return \"bic.b	%2,%0\";
}"
  [(set_attr "length" "1,2")
   (set_attr "cc" "none,none")])


(define_insn "*andqi3_3"
  [(set (match_operand:QI 0 "nonimmediate_operand_msp430"      	"=r,m,r,m,r,m,m,r")
        (and:QI (match_operand:QI 1 "nonimmediate_operand_msp430"  	"%0,0,0,0,0,0,0,0")
                (match_operand:QI 2 "general_operand_msp430"  		" r,m,P,P,m,r,i,i")))]
""
"and.b	%2, %0"
  [(set_attr "length" "1,3,1,2,2,2,3,2")
   (set_attr "cc" "set_czn,set_czn,set_czn,set_czn,set_czn,set_czn,set_czn,set_czn")])




;;============================================================================
;; and 1 word (16 bits)
;; same as above

(define_expand "andhi3" 
  [(set (match_operand:HI 0 "nonimmediate_operand_msp430" "")
        (and:HI (match_operand:HI 1 "nonimmediate_operand_msp430" "")   
                 (match_operand:HI 2 "general_operand_msp430" "")))]
  "" 
  "")


(define_insn "*andhi3_inv"
  [(set (match_operand:HI 0 "nonimmediate_operand_msp430"         "=r,m")   
        (and:HI (match_operand:HI 1 "nonimmediate_operand_msp430" "%0,0")   
                (match_operand:HI 2 "immediate_operand"    " i,i")))]
"(INTVAL(operands[2])==~1
  || INTVAL(operands[2])==~2
  || INTVAL(operands[2])==~4
  || INTVAL(operands[2])==~8)"
"* {
	operands[2] = gen_rtx_CONST_INT(HImode, ~(INTVAL(operands[2])));
	return \"bic	%2,%0\";
}"
  [(set_attr "length" "1,2")
   (set_attr "cc" "none,none")])


(define_insn "*andhi3_3"
  [(set (match_operand:HI 0 "nonimmediate_operand_msp430"      		"=r,m,r,m,r,m,m,r")
        (and:HI (match_operand:HI 1 "nonimmediate_operand_msp430"  	"%0,0,0,0,0,0,0,0")
                (match_operand:HI 2 "general_operand_msp430"  		" r,m,P,P,m,r,i,i")))]
""
"and	%2, %0"
  [(set_attr "length" "1,3,1,2,2,2,3,2")
   (set_attr "cc" "set_czn,set_czn,set_czn,set_czn,set_czn,set_czn,set_czn,set_czn")])





;;============================================================================
;; and 2 words (32 bits)
;; same as above

(define_expand "andsi3"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
        (and:SI (match_operand:SI 1 "nonimmediate_operand" "")
                (match_operand:SI 2 "general_operand" "")))]
  "" 
  "")

(define_insn "*andsi3_3"
  [(set (match_operand:SI 0 "nonimmediate_operand"          "=rm")
        (and:SI (match_operand:SI 1 "nonimmediate_operand"  "%0")
                (match_operand:SI 2 "general_operand"       " rmi")))]
""
"* return msp430_andsi_code(insn, operands, NULL);"
  [(set_attr "length" "6")
   (set_attr "cc" "clobber")])



;;============================================================================
;; and 4 words (64 bits)
;; same as above

(define_expand "anddi3"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
        (and:DI (match_operand:DI 1 "nonimmediate_operand" "")   
                (match_operand:DI 2 "general_operand" "")))]
  "" 
  "")

(define_insn "*anddi3_3"
  [(set (match_operand:DI 0 "nonimmediate_operand"         "=rm")
        (and:DI (match_operand:DI 1 "nonimmediate_operand" "%0")
                (match_operand:DI 2 "general_operand"      " rmi")))]
""
"* return msp430_anddi_code(insn, operands, NULL);"
  [(set_attr "length" "14")
   (set_attr "cc" "clobber")])



;;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;; ior 1 byte 
;; looks like a 'mov' insn

(define_expand "iorqi3" 
  [(set (match_operand:QI 0 "nonimmediate_operand_msp430" "")
        (ior:QI (match_operand:QI 1 "nonimmediate_operand_msp430" "")   
                 (match_operand:QI 2 "general_operand_msp430" "")))]
  "" 
  "")

(define_insn "*iorqi3_3"
  [(set (match_operand:QI 0 "nonimmediate_operand_msp430"      	"=r,m,r,m,r,m,m,r")
        (ior:QI (match_operand:QI 1 "nonimmediate_operand_msp430"  	"%0,0,0,0,0,0,0,0")
                (match_operand:QI 2 "general_operand_msp430"  		" r,m,P,P,m,r,i,i")))]
""
  "bis.b	%2, %0"
  [(set_attr "length" "1,3,1,2,2,2,3,2")
   (set_attr "cc" "none,none,none,none,none,none,none,none")])



;;============================================================================
;; ior 1 word (16 bits)
;; same as above

(define_expand "iorhi3" 
  [(set (match_operand:HI 0 "nonimmediate_operand_msp430" "")
        (ior:HI (match_operand:HI 1 "nonimmediate_operand_msp430" "")   
                 (match_operand:HI 2 "general_operand_msp430" "")))]
  "" 
  "")

(define_insn "*iorhi3_3"
  [(set (match_operand:HI 0 "nonimmediate_operand_msp430"      	"=r,m,r,m,r,m,m,r")
        (ior:HI (match_operand:HI 1 "nonimmediate_operand_msp430"  	"%0,0,0,0,0,0,0,0")
                (match_operand:HI 2 "general_operand_msp430"  		" r,m,P,P,m,r,i,i")))]
""
  "bis	%2, %0"
  [(set_attr "length" "1,3,1,2,2,2,3,2")
   (set_attr "cc" "none,none,none,none,none,none,none,none")])



;;============================================================================
;; ior 2 words (32 bits)
;; same as above


(define_expand "iorsi3"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
        (ior:SI (match_operand:SI 1 "nonimmediate_operand" "")
                 (match_operand:SI 2 "general_operand" "")))]
  "" 
  "")

(define_insn "*iorsi3_3"
  [(set (match_operand:SI 0 "nonimmediate_operand"      "=rm")
        (ior:SI (match_operand:SI 1 "nonimmediate_operand"   "%0")
                (match_operand:SI 2 "general_operand"   " rmi")))]
""
"* return msp430_iorsi_code(insn, operands, NULL);"
  [(set_attr "length" "6")
   (set_attr "cc" "none")])


;;============================================================================
;; ior 4 words (64 bits)
;; same as above

(define_expand "iordi3"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
        (ior:DI (match_operand:DI 1 "nonimmediate_operand" "")   
                (match_operand:DI 2 "general_operand" "")))]
  "" 
  "")

(define_insn "*iordi3_3"
  [(set (match_operand:DI 0 "nonimmediate_operand"          "=rm")
        (ior:DI (match_operand:DI 1 "nonimmediate_operand"  "%0")
                (match_operand:DI 2 "general_operand"  " rmi")))]
""
"* return msp430_iordi_code(insn, operands, NULL);"
  [(set_attr "length" "12")
   (set_attr "cc" "none")])



;;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
;;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
;;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
;;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
;;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
;;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
;; xor 1 byte 
;; looks like a 'mov' insn

(define_expand "xorqi3" 
  [(set (match_operand:QI 0 "nonimmediate_operand_msp430" "")
        (xor:QI (match_operand:QI 1 "nonimmediate_operand_msp430" "")   
                 (match_operand:QI 2 "general_operand_msp430" "")))]
  "" 
  "")

(define_insn "*xorqi3_3"
  [(set (match_operand:QI 0 "nonimmediate_operand_msp430"      	"=r,m,r,m,r,m,m,r")
        (xor:QI (match_operand:QI 1 "nonimmediate_operand_msp430"  	"%0,0,0,0,0,0,0,0")
                (match_operand:QI 2 "general_operand_msp430"  		" r,m,P,P,m,r,i,i")))]
""
  "xor.b	%2, %0"
  [(set_attr "length" "1,3,1,2,2,2,3,2")
   (set_attr "cc" "set_czn,set_czn,set_czn,set_czn,set_czn,set_czn,set_czn,set_czn")])



;;============================================================================
;; xor 1 word (16 bits)
;; same as above

(define_expand "xorhi3" 
  [(set (match_operand:HI 0 "nonimmediate_operand_msp430" "")
        (xor:HI (match_operand:HI 1 "nonimmediate_operand_msp430" "")   
                 (match_operand:HI 2 "general_operand_msp430" "")))]
  "" 
  "")

(define_insn "*xorhi3_3"
  [(set (match_operand:HI 0 "nonimmediate_operand_msp430"      	"=r,m,r,m,r,m,m,r")
        (xor:HI (match_operand:HI 1 "nonimmediate_operand_msp430"  	"%0,0,0,0,0,0,0,0")
                (match_operand:HI 2 "general_operand_msp430"  		" r,m,P,P,m,r,i,i")))]
""
  "xor	%2, %0"
  [(set_attr "length" "1,3,1,2,2,2,3,2")
   (set_attr "cc" "set_czn,set_czn,set_czn,set_czn,set_czn,set_czn,set_czn,set_czn")])



;;============================================================================
;; xor 2 words (32 bits)
;; same as above

(define_expand "xorsi3"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
        (xor:SI (match_operand:SI 1 "nonimmediate_operand" "")
                 (match_operand:SI 2 "general_operand" "")))]
  "" 
  "")


(define_insn "*xorsi3_3"
  [(set (match_operand:SI 0 "nonimmediate_operand"      "=rm")
        (xor:SI (match_operand:SI 1 "nonimmediate_operand"   "%0")
                 (match_operand:SI 2 "general_operand"  " rmi")))]
""
"* return msp430_xorsi_code(insn, operands, NULL);"
  [(set_attr "length" "6")
   (set_attr "cc" "set_n")])



;;============================================================================
;; xor 4 words (64 bits)
;; same as above

(define_expand "xordi3"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
        (xor:DI (match_operand:DI 1 "nonimmediate_operand" "")   
                (match_operand:DI 2 "general_operand" "")))]
  "" 
  "")

(define_insn "*xordi3_3"
  [(set (match_operand:DI 0 "nonimmediate_operand"          "=rm")
        (xor:DI (match_operand:DI 1 "nonimmediate_operand"  "%0")
                (match_operand:DI 2 "general_operand"  	    " rmi")))]
""
"* return msp430_xordi_code(insn, operands, NULL);"
  [(set_attr "length" "4")
   (set_attr "cc" "set_n")])





;;============================================================================
;;============================================================================
;;============================================================================
;;============================================================================
;;============================================================================
;;============================================================================
;;============================================================================
;;============================================================================
;;============================================================================
;;============================================================================
;; neg
;; same as above

(define_expand "negqi2"
  [(set (match_operand:QI 0 "nonimmediate_operand" "")
        (neg:QI (match_operand:QI 1 "nonimmediate_operand" "")))]
  ""
  "")

(define_insn "*negqi2_2"
  [(set (match_operand:QI 0 "nonimmediate_operand" 	   "=r,m")
        (neg:QI (match_operand:QI 1 "nonimmediate_operand" " 0,0")))]
  ""
  "inv.b	%0
	inc.b	%0"
  [(set_attr "length" "2,4")
   (set_attr "cc" "set_czn,set_czn")])


;;============================================================================
;; neg HI	x = (0 - x)
;; - twos component

(define_expand "neghi2"
  [(set (match_operand:HI 0 "nonimmediate_operand" "")
        (neg:HI (match_operand:HI 1 "nonimmediate_operand" "0")))]
  ""
  "")

(define_insn "*neghi2_2"
  [(set (match_operand:HI 0 "nonimmediate_operand" 	   "=r, m")
        (neg:HI (match_operand:HI 1 "nonimmediate_operand" " 0, 0")))]
  ""
  "inv	%0
	inc	%0"
  [(set_attr "length" "2,4")
   (set_attr "cc" "set_czn,set_czn")])



;;============================================================================
;; neg SI	x = (0 - x)
;; - twos component

(define_expand "negsi2"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
        (neg:SI (match_operand:SI 1 "nonimmediate_operand" "0")))]
  ""
  "")

(define_insn "*negsi2_2"
  [(set (match_operand:SI 0 "nonimmediate_operand" 	   "=r, m")
        (neg:SI (match_operand:SI 1 "nonimmediate_operand" " 0, 0")))]
  ""
  "inv	%A0
	inv	%B0
	inc	%A0
	adc	%B0"
  [(set_attr "length" "4,8")
   (set_attr "cc" "set_n,set_n")])


;;============================================================================
;; neg DI	x = (0 - x)
;; - twos component

(define_expand "negdi2"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
        (neg:DI (match_operand:DI 1 "nonimmediate_operand" "0")))]
  ""
  "")

(define_insn "*negdi2_2"
  [(set (match_operand:DI 0 "nonimmediate_operand" 	   "=r, m")
        (neg:DI (match_operand:DI 1 "nonimmediate_operand" " 0, 0")))]
  ""
  "inv	%A0
	inv	%B0
	inv	%C0
	inv	%D0
	inc	%A0
	adc	%B0
	adc	%C0
	adc	%D0"
  [(set_attr "length" "8,16")
   (set_attr "cc" "set_n,set_n")])

;;============================================================================
;; neg SF       x = (0 - x)
(define_insn "negsf2"
  [(set (match_operand:SF 0 "nonimmediate_operand" "=r,m")
        (neg:SF (match_operand:SF 1 "nonimmediate_operand" "0,0")))]
  ""
  "xor	#0x8000, %0"
[(set_attr "length" "2,3")
 (set_attr "cc" "clobber,clobber")])




;;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;; not	x = !x
;; ones component

(define_expand "one_cmplqi2"
  [(set (match_operand:QI 0 "nonimmediate_operand_msp430" "")
        (not:QI (match_operand:QI 1 "nonimmediate_operand_msp430" "")))]
  ""
  "")

(define_insn "*one_cmplqi2_2"
  [(set (match_operand:QI 0 "nonimmediate_operand_msp430" 	   "=r,m")
        (not:QI (match_operand:QI 1 "nonimmediate_operand_msp430" " 0, 0")))]
  ""
  "inv.b	%0"
  [(set_attr "length" "1,2")
   (set_attr "cc" "set_czn,set_czn")])


;;============================================================================
;; not HI	x = !x
;; - ones component

(define_expand "one_cmplhi2"
  [(set (match_operand:HI 0 "nonimmediate_operand_msp430" "")
        (not:HI (match_operand:HI 1 "nonimmediate_operand_msp430" "0")))]
  ""
  "")

(define_insn "*one_cmplhi2_2"
  [(set (match_operand:HI 0 "nonimmediate_operand_msp430" 	   "=r, m")
        (not:HI (match_operand:HI 1 "nonimmediate_operand_msp430" " 0, 0")))]
  ""
  "inv	%0"
  [(set_attr "length" "1,2")
   (set_attr "cc" "set_czn,set_czn")])



;;============================================================================
;; not SI	x = !x 
;; - ones component

(define_expand "one_cmplsi2"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
        (not:SI (match_operand:SI 1 "nonimmediate_operand" "0")))]
  ""
  "")

(define_insn "*one_cmplsi2_2"
  [(set (match_operand:SI 0 "nonimmediate_operand" 	   "=r, m")
        (not:SI (match_operand:SI 1 "nonimmediate_operand" " 0, 0")))]
""
  "inv	%A0
	inv	%B0"
  [(set_attr "length" "2,4")
   (set_attr "cc" "set_n,set_n")])


;;============================================================================
;; not DI	x = !x
;; - ones component

(define_expand "one_cmpldi2"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
        (not:DI (match_operand:DI 1 "nonimmediate_operand" "0")))]
  ""
  "")

(define_insn "*one_cmpldi2_2"
  [(set (match_operand:DI 0 "nonimmediate_operand" 	   "=r, m")
        (not:DI (match_operand:DI 1 "nonimmediate_operand" " 0, 0")))]
  ""
  "inv	%A0
	inv	%B0
	inv	%C0
	inv	%D0"
  [(set_attr "length" "4,8")
   (set_attr "cc" "set_n,set_n")])



;;============================================================================
;;============================================================================
;;============================================================================
;;============================================================================
;;============================================================================
;;============================================================================
;;============================================================================
;;============================================================================
;;============================================================================
;; abs
;; x = |x|

(define_expand "absqi2"
  [(set (match_operand:QI 0 "nonimmediate_operand" "")
        (abs:QI (match_operand:QI 1 "nonimmediate_operand" "")))]
  ""
  "")

(define_insn "*absqi2_2"
  [(set (match_operand:QI 0 "nonimmediate_operand" 	   "=r,m")
        (abs:QI (match_operand:QI 1 "nonimmediate_operand" " 0, 0")))]
  ""
	"tst.b	%0
	jge	.Leaq%=
	inv.b	%0
	inc.b	%0
.Leaq%=:"
  [(set_attr "length" "4,7")
   (set_attr "cc" "set_czn,set_czn")])


;;============================================================================
;; abs HI	x = |x|
;; 

(define_expand "abshi2"
  [(set (match_operand:HI 0 "nonimmediate_operand" "")
        (abs:HI (match_operand:HI 1 "nonimmediate_operand" "0")))]
  ""
  "")


(define_insn "*abshi2_2"
  [(set (match_operand:HI 0 "nonimmediate_operand" 	   "=r, m")
        (abs:HI (match_operand:HI 1 "nonimmediate_operand" " 0, 0")))]
  ""
	"tst	%0
	jge	.Lae%=
	inv	%0
	inc	%0
.Lae%=:"
  [(set_attr "length" "4,7")
   (set_attr "cc" "set_czn,set_czn")])


;;============================================================================
;; abs SI	x = |x|

(define_expand "abssi2"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
        (abs:SI (match_operand:SI 1 "nonimmediate_operand" "0")))]
  ""
  "")

(define_insn "*abssi2_2"
  [(set (match_operand:SI 0 "nonimmediate_operand" 	   "=r, m")
        (abs:SI (match_operand:SI 1 "nonimmediate_operand" " 0, 0")))]
  ""
  "* return msp430_emit_abssi(insn, operands,NULL);"
  [(set_attr "length" "7,13")
   (set_attr "cc" "clobber,clobber")])


;;============================================================================
;; abs DI	x = |x|

(define_expand "absdi2"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
        (abs:DI (match_operand:DI 1 "nonimmediate_operand" "0")))]
  ""
  "")

(define_insn "*absdi2_2"
  [(set (match_operand:DI 0 "nonimmediate_operand" 	   "=r, m")
        (abs:DI (match_operand:DI 1 "nonimmediate_operand" " 0, 0")))]
  ""
  "* return msp430_emit_absdi(insn, operands,NULL);"
  [(set_attr "length" "11,23")
   (set_attr "cc" "clobber,clobber")])

;;============================================================================
;; abs SF

(define_insn "abssf2"
  [(set (match_operand:SF 0 "nonimmediate_operand" "=r,m")
        (abs:SF (match_operand:SF 1 "nonimmediate_operand" "0,0")))]
""
"and	#0x7fff, %0"
  [(set_attr "length" "2,3")
   (set_attr "cc" "clobber,clobber")])


;; ==========================================================================
;; there are shift helpers

(define_insn "trunchiqi"
  [(set (match_operand:QI 0 "register_operand" "=r") 
	(truncate:QI (match_operand:HI 1 "register_operand" "r")))]
""
"mov.b	%1, %0"
  [(set_attr "length" "1")
   (set_attr "cc" "none")])

(define_insn "truncsihi"
  [(set (match_operand:HI 0 "register_operand" "=r") 
	(truncate:HI (match_operand:SI 1 "register_operand" "r")))]
""
"mov	%1, %0"
  [(set_attr "length" "1")
   (set_attr "cc" "none")])


(define_insn "truncsiqi"
  [(set (match_operand:QI 0 "register_operand" "=r") 
	(truncate:QI (match_operand:SI 1 "register_operand" "r")))]
""
"mov.b	%1, %0"
  [(set_attr "length" "1")
   (set_attr "cc" "none")])


(define_insn "truncdiqi"
  [(set (match_operand:QI 0 "register_operand" "=r") 
	(truncate:QI (match_operand:DI 1 "register_operand" "r")))]
""
"mov.b	%1, %0"
  [(set_attr "length" "1")
   (set_attr "cc" "none")])

(define_insn "truncdisi"
  [(set (match_operand:SI 0 "register_operand" "=r") 
	(truncate:SI (match_operand:DI 1 "register_operand" "r")))]
""
"mov	%A1,%A0
	mov    %B1,%B0"
  [(set_attr "length" "2")
   (set_attr "cc" "none")])



;;<< << << << << << << << << << << << << << << << << << << << << << << << <<
;; << << << << << << << << << << << << << << << << << << << << << << << <<
;;<< << << << << << << << << << << << << << << << << << << << << << << << <<
;; << << << << << << << << << << << << << << << << << << << << << << << <<
;;<< << << << << << << << << << << << << << << << << << << << << << << << <<
;; arithmetic shift left

(define_expand "ashlqi3"
  [(set (match_operand:QI 0 "nonimmediate_operand"       "")
        (ashift:QI (match_operand:QI 1 "nonimmediate_operand" "")
                   (match_operand:QI 2 "general_operand"  "")))]
""
"{
   if(TARGET_CALL_SHIFT)
   {
	if(!register_operand(operands[1], QImode)) 
		operands[1] = copy_to_mode_reg(QImode,operands[1]);

	if(GET_CODE(operands[2]) != CONST_INT) 
	{
		rtx ops[3];
		ops[2] = copy_to_mode_reg(QImode,operands[2]);
		emit_insn (gen_ashlqi3_call_cnt(operands[0], operands[1], ops[2]));
   	}
	else
	{
		emit_insn (gen_ashlqi3_call_const(operands[0], operands[1], operands[2]));
	}
	DONE;
   }
   else if(!register_operand(operands[1], QImode) 
		&& is_shift_better_in_reg(operands))
   {
      operands[1] = copy_to_mode_reg(QImode,operands[1]);
      emit_insn (gen_ashlqi3fnl(operands[0], operands[1], operands[2]));
      DONE;
   }
}")

(define_expand "ashlqi3_call_const"
  [(set (reg:QI 15) (match_operand:QI 1 "register_operand" "0"))
   (set (reg:QI 15) (ashift:QI (reg:QI 15) (match_operand 2 "const_int_operand" "")))
   (set (match_operand:QI 0 "nonimmediate_operand" "=mr") (reg:QI 15) )]
"TARGET_CALL_SHIFT"
"")

(define_insn "*ashlqi3_call_const"
  [(set (reg:QI 15) (ashift:QI (reg:QI 15) (match_operand 0 "const_int_operand" "i")))]
"TARGET_CALL_SHIFT"
"* {
	return msp430_emit_ashlqi3(insn, operands, NULL);
}"
  [(set_attr "length" "1")
   (set_attr "cc" "clobber")])

(define_expand "ashlqi3_call_cnt"
  [(set (reg:QI 15) (match_operand:QI 1 "register_operand" "0"))
   (set (reg:QI 14) (match_operand:QI 2 "register_operand" ""))
   (parallel [(set (reg:QI 15) (ashift:QI (reg:QI 15) (reg:QI 14)))
	      (clobber (reg:QI 14))])
   (set (match_operand:QI 0 "nonimmediate_operand" "=rm") (reg:QI 15) )]
"TARGET_CALL_SHIFT"
"")
   
(define_insn "*ashlqi3_call_cnt"
  [(set (reg:QI 15) (ashift:QI (reg:QI 15) (reg:QI 14)))
   (clobber (reg:QI 14))]
"TARGET_CALL_SHIFT"
"* return msp430_emit_ashlqi3(insn, operands, NULL);"
  [(set_attr "length" "1")
   (set_attr "cc" "clobber")])

;; a peephole for final move.

(define_peephole2
  [(set (match_operand:QI 0 "register_operand" "") (reg:QI 15))
   (set (match_operand:QI 1 "nonimmediate_operand" "") (match_dup 0))]
"(TARGET_CALL_SHIFT && dead_or_set_in_peep(0,insn, operands[0]))"
  [(set (match_dup 1) (reg:QI 15))]
"")

(define_insn "ashlqi3fnl"
  [(set (match_operand:QI 0 "register_operand"       "=r")
        (ashift:QI (match_operand:QI 1 "register_operand" "0")
                   (match_operand:QI 2 "general_operand"  "rmi")))]
  "(is_shift_better_in_reg(operands) && !TARGET_CALL_SHIFT)"
  "* return msp430_emit_ashlqi3(insn, operands,NULL);"
  [(set_attr "length" "1")
   (set_attr "cc" "clobber")])
  
(define_insn "*ashlqi3"
  [(set (match_operand:QI 0 "nonimmediate_operand"       "=rm")
        (ashift:QI (match_operand:QI 1 "nonimmediate_operand" "0")
                   (match_operand:QI 2 "general_operand"  "rmi")))]
  "(!is_shift_better_in_reg(operands) && !TARGET_CALL_SHIFT)"
  "* return msp430_emit_ashlqi3(insn, operands,NULL);"
  [(set_attr "length" "8")
   (set_attr "cc" "clobber")])


;; HImode  ======================================

(define_expand "ashlhi3"
  [(set (match_operand:HI 0 "nonimmediate_operand"       "")
        (ashift:HI (match_operand:HI 1 "nonimmediate_operand" "")
                   (match_operand:HI 2 "general_operand"  "")))]
""
"{
   if(TARGET_CALL_SHIFT)
   {
	if(!register_operand(operands[1], HImode)) 
		operands[1] = copy_to_mode_reg(HImode,operands[1]);

	if(GET_CODE(operands[2]) != CONST_INT) 
	{
		rtx ops[3];
		ops[2] = copy_to_mode_reg(HImode,operands[2]);
		emit_insn (gen_ashlhi3_call_cnt(operands[0], operands[1], ops[2]));
   	}
	else
	{
		emit_insn (gen_ashlhi3_call_const(operands[0], operands[1], operands[2]));
	}
	DONE;
   }
   else if(!register_operand(operands[1], HImode) 
		&& is_shift_better_in_reg(operands))
   {
      operands[1] = copy_to_mode_reg(HImode,operands[1]);
      emit_insn (gen_ashlhi3fnl(operands[0], operands[1], operands[2]));
      DONE;
   }
}")

(define_expand "ashlhi3_call_const"
  [(set (reg:HI 15) (match_operand:HI 1 "register_operand" "0"))
   (set (reg:HI 15) (ashift:HI (reg:HI 15) (match_operand 2 "const_int_operand" "")))
   (set (match_operand:HI 0 "nonimmediate_operand" "=mr") (reg:HI 15) )]
"TARGET_CALL_SHIFT"
"")

(define_insn "*ashlhi3_call_const"
  [(set (reg:HI 15) (ashift:HI (reg:HI 15) (match_operand 0 "const_int_operand" "i")))]
"TARGET_CALL_SHIFT"
"* {
	return msp430_emit_ashlhi3(insn, operands, NULL);
}"
  [(set_attr "length" "1")
   (set_attr "cc" "clobber")])

(define_expand "ashlhi3_call_cnt"
  [(set (reg:HI 15) (match_operand:HI 1 "register_operand" "0"))
   (set (reg:HI 14) (match_operand:HI 2 "register_operand" ""))
   (parallel [(set (reg:HI 15) (ashift:HI (reg:HI 15) (reg:HI 14)))
	      (clobber (reg:HI 14))])
   (set (match_operand:HI 0 "nonimmediate_operand" "=rm") (reg:HI 15) )]
"TARGET_CALL_SHIFT"
"")
   
(define_insn "*ashlhi3_call_cnt"
  [(set (reg:HI 15) (ashift:HI (reg:HI 15) (reg:HI 14)))
   (clobber (reg:HI 14))]
"TARGET_CALL_SHIFT"
"* return msp430_emit_ashlhi3(insn, operands, NULL);"
  [(set_attr "length" "1")
   (set_attr "cc" "clobber")])

;; a peephole for final move.

(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "") (reg:HI 15))
   (set (match_operand:HI 1 "nonimmediate_operand" "") (match_dup 0))]
"(TARGET_CALL_SHIFT && dead_or_set_in_peep(0,insn, operands[0]))"
  [(set (match_dup 1) (reg:HI 15))]
"")

(define_insn "ashlhi3fnl"
  [(set (match_operand:HI 0 "register_operand"       "=r")
        (ashift:HI (match_operand:HI 1 "register_operand" "0")
                   (match_operand:HI 2 "general_operand"  "rmi")))]
  "(is_shift_better_in_reg(operands) && !TARGET_CALL_SHIFT)"
  "* return msp430_emit_ashlhi3(insn, operands,NULL);"
  [(set_attr "length" "1")
   (set_attr "cc" "clobber")])

  
(define_insn "*ashlhi3"
  [(set (match_operand:HI 0 "nonimmediate_operand"       "=rm")
        (ashift:HI (match_operand:HI 1 "nonimmediate_operand" "0")
                   (match_operand:HI 2 "general_operand"  "rmi")))]
  "(!is_shift_better_in_reg(operands) && !TARGET_CALL_SHIFT)"
  "* return msp430_emit_ashlhi3(insn, operands,NULL);"
  [(set_attr "length" "8")
   (set_attr "cc" "clobber")])

;;
;; special case - 
;; adjust some types indices
;; perform adjustment inline
;;
(define_insn "*object_index"
  [(set (match_operand:HI 0 "register_operand"       "=r")
        (ashift:HI (match_operand:HI 1 "register_operand" "0")
                   (match_operand:HI 2 "const_int_operand"  "i")))]
  "(TARGET_CALL_SHIFT
    && REG_NOTES(insn)
    && XEXP(REG_NOTES(insn),0)
    && (GET_CODE(XEXP(REG_NOTES(insn),0)) == MULT))"
  "* return msp430_emit_ashlhi3(insn, operands,NULL);"
  [(set_attr "length" "8")
   (set_attr "cc" "clobber")])

(define_insn "*object_index_r14_6"
  [(set (reg:HI 14)
        (ashift:HI (reg:HI 14) (const_int 2)))]
  "TARGET_CALL_SHIFT"
  "rla	r14
	rla	r14"
  [(set_attr "length" "2")
   (set_attr "cc" "clobber")])

(define_peephole2
  [(set (reg:HI 10) (match_operand: HI 0 "register_operand" ""))
   (set (reg:HI 12) (const_int 6))
   (parallel [(set (reg:HI 14)
	(mult:HI (reg:HI 10) (reg:HI 12)))
	(clobber (reg:HI 10))
	(clobber (reg:HI 12))])
   (set (match_dup 0) (reg:HI 14))]
"TARGET_CALL_SHIFT"
   [(set (reg:HI 14) (match_dup 0))
    (set (reg:HI 14) (ashift:HI (reg:HI 14) (const_int 2)))
    (set (match_dup 0) (plus:HI (match_dup 0) (reg:HI 14)))]
""
)


(define_insn "*object_index_r14_10"
  [(set (reg:HI 14)
        (ashift:HI (reg:HI 14) (const_int 3)))]
  "TARGET_CALL_SHIFT"
  "rla	r14
	rla	r14
	rla	r14"
  [(set_attr "length" "3")
   (set_attr "cc" "clobber")])

(define_peephole2
  [(set (reg:HI 10) (match_operand: HI 0 "register_operand" ""))
   (set (reg:HI 12) (const_int 10))
   (parallel [(set (reg:HI 14)
	(mult:HI (reg:HI 10) (reg:HI 12)))
	(clobber (reg:HI 10))
	(clobber (reg:HI 12))])
   (set (match_dup 0) (reg:HI 14))]
"TARGET_CALL_SHIFT"
   [(set (reg:HI 14) (match_dup 0))
    (set (reg:HI 14) (ashift:HI (reg:HI 14) (const_int 3)))
    (set (match_dup 0) (plus:HI (match_dup 0) (reg:HI 14)))]
""
)



;; SImode ======================================

(define_expand "ashlsi3"
  [(set (match_operand:SI 0 "nonimmediate_operand"       "")
        (ashift:SI (match_operand:SI 1 "nonimmediate_operand" "")
                   (match_operand:SI 2 "general_operand"  "")))]
""
"{
   if(TARGET_CALL_SHIFT)
   {
	if(!register_operand(operands[1], SImode)) 
		operands[1] = copy_to_mode_reg(SImode,operands[1]);

	if(GET_CODE(operands[2]) != CONST_INT) 
	{
		rtx ops[3];
		ops[2] = copy_to_mode_reg(SImode,operands[2]);
		emit_insn (gen_ashlsi3_call_cnt(operands[0], operands[1], ops[2]));
   	}
	else
	{
		emit_insn (gen_ashlsi3_call_const(operands[0], operands[1], operands[2]));
	}
	DONE;
   }
   else if(!register_operand(operands[1], SImode) 
		&& is_shift_better_in_reg(operands))
   {
      operands[1] = copy_to_mode_reg(SImode,operands[1]);
      emit_insn (gen_ashlsi3fnl(operands[0], operands[1], operands[2]));
      DONE;
   }
}")

(define_expand "ashlsi3_call_const"
  [(set (reg:SI 14) (match_operand:SI 1 "register_operand" "0"))
   (set (reg:SI 14) (ashift:SI (reg:SI 14) (match_operand 2 "const_int_operand" "")))
   (set (match_operand:SI 0 "nonimmediate_operand" "=mr") (reg:SI 14) )]
"TARGET_CALL_SHIFT"
"")

(define_insn "*ashlsi3_call_const"
  [(set (reg:SI 14) (ashift:SI (reg:SI 14) (match_operand 0 "const_int_operand" "i")))]
"TARGET_CALL_SHIFT"
"* {
	return msp430_emit_ashlsi3(insn, operands, NULL);
}"
  [(set_attr "length" "1")
   (set_attr "cc" "clobber")])

(define_expand "ashlsi3_call_cnt"
  [(set (reg:SI 14) (match_operand:SI 1 "register_operand" "0"))
   (set (reg:HI 13) (truncate:HI (match_operand:SI 2 "register_operand" "")))
   (parallel [(set (reg:SI 14) (ashift:SI (reg:SI 14) (reg:HI 13)))
	      (clobber (reg:HI 13))])
   (set (match_operand:SI 0 "nonimmediate_operand" "=rm") (reg:SI 14) )]
"TARGET_CALL_SHIFT"
"")
   
(define_insn "*ashlsi3_call_cnt"
  [(set (reg:SI 14) (ashift:SI (reg:SI 14) (reg:HI 13)))
   (clobber (reg:HI 13))]
"TARGET_CALL_SHIFT"
"* return msp430_emit_ashlsi3(insn, operands, NULL);"
  [(set_attr "length" "1")
   (set_attr "cc" "clobber")])

;; a peephole for final move.

(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "") (reg:SI 14))
   (set (match_operand:SI 1 "nonimmediate_operand" "") (match_dup 0))]
"(TARGET_CALL_SHIFT && dead_or_set_in_peep(0,insn, operands[0]))"
  [(set (match_dup 1) (reg:SI 14))]
"")

(define_insn "ashlsi3fnl"
  [(set (match_operand:SI 0 "register_operand"       "=r")
        (ashift:SI (match_operand:SI 1 "register_operand" "0")
                   (match_operand:SI 2 "general_operand"  "rmi")))]
  "(is_shift_better_in_reg(operands) && !TARGET_CALL_SHIFT)"
  "* return msp430_emit_ashlsi3(insn, operands,NULL);"
  [(set_attr "length" "1")
   (set_attr "cc" "clobber")])
  
(define_insn "*ashlsi3"
  [(set (match_operand:SI 0 "nonimmediate_operand"       "=rm")
        (ashift:SI (match_operand:SI 1 "nonimmediate_operand" "0")
                   (match_operand:SI 2 "general_operand"  "rmi")))]
  "(!is_shift_better_in_reg(operands) && !TARGET_CALL_SHIFT)"
  "* return msp430_emit_ashlsi3(insn, operands,NULL);"
  [(set_attr "length" "8")
   (set_attr "cc" "clobber")])



;; DImode ======================================

(define_expand "ashldi3"
  [(set (match_operand:DI 0 "nonimmediate_operand"       "")
        (ashift:DI (match_operand:DI 1 "nonimmediate_operand" "")
                   (match_operand:DI 2 "general_operand"  "")))]
""
"{
   if(TARGET_CALL_SHIFT)
   {
	if(!register_operand(operands[1], DImode)) 
		operands[1] = copy_to_mode_reg(DImode,operands[1]);

	if(GET_CODE(operands[2]) != CONST_INT) 
	{
		rtx ops[3];
		ops[2] = copy_to_mode_reg(DImode,operands[2]);
		emit_insn (gen_ashldi3_call_cnt(operands[0], operands[1], ops[2]));
   	}
	else
	{
		emit_insn (gen_ashldi3_call_const(operands[0], operands[1], operands[2]));
	}
	DONE;
   }
   else if(!register_operand(operands[1], DImode) 
		&& is_shift_better_in_reg(operands))
   {
      operands[1] = copy_to_mode_reg(DImode,operands[1]);
      emit_insn (gen_ashldi3fnl(operands[0], operands[1], operands[2]));
      DONE;
   }
}")

(define_expand "ashldi3_call_const"
  [(set (reg:DI 12) (match_operand:DI 1 "register_operand" "0"))
   (set (reg:DI 12) (ashift:DI (reg:DI 12) (match_operand 2 "const_int_operand" "")))
   (set (match_operand:DI 0 "nonimmediate_operand" "=mr") (reg:DI 12) )]
"TARGET_CALL_SHIFT"
"")

(define_insn "*ashldi3_call_const"
  [(set (reg:DI 12) (ashift:DI (reg:DI 12) (match_operand 0 "const_int_operand" "i")))]
"TARGET_CALL_SHIFT"
"* {
	return msp430_emit_ashldi3(insn, operands, NULL);
}"
  [(set_attr "length" "1")
   (set_attr "cc" "clobber")])

(define_expand "ashldi3_call_cnt"
  [(set (reg:DI 12) (match_operand:DI 1 "register_operand" "0"))
   (set (reg:HI 11) (truncate:HI (match_operand:DI 2 "register_operand" "")))
   (parallel [(set (reg:DI 12) (ashift:DI (reg:DI 12) (reg:HI 11)))
	      (clobber (reg:HI 11))])
   (set (match_operand:DI 0 "nonimmediate_operand" "=rm") (reg:DI 12) )]
"TARGET_CALL_SHIFT"
"")
   
(define_insn "*ashldi3_call_cnt"
  [(set (reg:DI 12) (ashift:DI (reg:DI 12) (reg:HI 11)))
   (clobber (reg:HI 11))]
"TARGET_CALL_SHIFT"
"* return msp430_emit_ashldi3(insn, operands, NULL);"
  [(set_attr "length" "1")
   (set_attr "cc" "clobber")])

;; a peephole for final move.

(define_peephole2
  [(set (match_operand:DI 0 "register_operand" "") (reg:DI 12))
   (set (match_operand:DI 1 "nonimmediate_operand" "") (match_dup 0))]
"(TARGET_CALL_SHIFT && dead_or_set_in_peep(0,insn, operands[0]))"
  [(set (match_dup 1) (reg:DI 12))]
"")

(define_insn "ashldi3fnl"
  [(set (match_operand:DI 0 "register_operand"       "=r")
        (ashift:DI (match_operand:DI 1 "register_operand" "0")
                   (match_operand:DI 2 "general_operand"  "rmi")))]
  "(is_shift_better_in_reg(operands) && !TARGET_CALL_SHIFT)"
  "* return msp430_emit_ashldi3(insn, operands,NULL);"
  [(set_attr "length" "1")
   (set_attr "cc" "clobber")])
  
(define_insn "*ashldi3"
  [(set (match_operand:DI 0 "nonimmediate_operand"       "=rm")
        (ashift:DI (match_operand:DI 1 "nonimmediate_operand" "0")
                   (match_operand:DI 2 "general_operand"  "rmi")))]
  "(!is_shift_better_in_reg(operands) && !TARGET_CALL_SHIFT)"
  "* return msp430_emit_ashldi3(insn, operands,NULL);"
  [(set_attr "length" "8")
   (set_attr "cc" "clobber")])



;; >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >>
;;  >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >>      
;; >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >>      
;;  >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >>      
;; >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >>      
;;  >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >>     
;; arithmetic shift right

(define_expand "ashrqi3"
  [(set (match_operand:QI 0 "nonimmediate_operand"       "")
        (ashiftrt:QI (match_operand:QI 1 "nonimmediate_operand" "")
                   (match_operand:QI 2 "general_operand"  "")))]
""
"{
   if(!register_operand(operands[1], QImode) &&
	is_shift_better_in_reg(operands))
   {
      operands[1] = copy_to_mode_reg(QImode,operands[1]);
      emit_insn (gen_ashrqi3fnl(operands[0], operands[1], operands[2]));
      DONE;
   }
}")
  
(define_insn "ashrqi3fnl"
  [(set (match_operand:QI 0 "register_operand"       "=r")
        (ashiftrt:QI (match_operand:QI 1 "register_operand" "0")
                   (match_operand:QI 2 "general_operand"  "rmi")))]
  "is_shift_better_in_reg(operands)"
  "* return msp430_emit_ashrqi3(insn, operands,NULL);"
  [(set_attr "length" "1")
   (set_attr "cc" "clobber")])
  
(define_insn "*ashrqi3"
  [(set (match_operand:QI 0 "nonimmediate_operand"       "=rm")
        (ashiftrt:QI (match_operand:QI 1 "nonimmediate_operand" "0")
                   (match_operand:QI 2 "general_operand"  "rmi")))]
  "!is_shift_better_in_reg(operands)"
  "* return msp430_emit_ashrqi3(insn, operands,NULL);"
  [(set_attr "length" "8")
   (set_attr "cc" "clobber")])

;;======================================

(define_expand "ashrhi3"
  [(set (match_operand:HI 0 "nonimmediate_operand"       "")
        (ashiftrt:HI (match_operand:HI 1 "nonimmediate_operand" "")
                   (match_operand:QI 2 "general_operand"  "")))]
""
"{
   if(!register_operand(operands[1], HImode) &&
	is_shift_better_in_reg(operands))
   {
      operands[1] = copy_to_mode_reg(HImode,operands[1]);
      emit_insn (gen_ashrhi3fnl(operands[0], operands[1], operands[2]));
      DONE;
   }
}")
  
(define_insn "ashrhi3fnl"
  [(set (match_operand:HI 0 "register_operand"       "=r")
        (ashiftrt:HI (match_operand:HI 1 "register_operand" "0")
                   (match_operand:QI 2 "general_operand"  "rmi")))]
  "is_shift_better_in_reg(operands)"
  "* return msp430_emit_ashrhi3(insn, operands,NULL);"
  [(set_attr "length" "1")
   (set_attr "cc" "clobber")])
  
(define_insn "*ashrhi3"
  [(set (match_operand:HI 0 "nonimmediate_operand"       "=rm")
        (ashiftrt:HI (match_operand:HI 1 "nonimmediate_operand" "0")
                   (match_operand:QI 2 "general_operand"  "rmi")))]
  "!is_shift_better_in_reg(operands)"
  "* return msp430_emit_ashrhi3(insn, operands,NULL);"
  [(set_attr "length" "8")
   (set_attr "cc" "clobber")])



;;======================================

(define_expand "ashrsi3"
  [(set (match_operand:SI 0 "nonimmediate_operand"       "")
        (ashiftrt:SI (match_operand:SI 1 "nonimmediate_operand" "")
                   (match_operand:QI 2 "general_operand"  "")))]
""
"{
   if(!register_operand(operands[1], SImode) &&
	is_shift_better_in_reg(operands))
   {
      operands[1] = copy_to_mode_reg(SImode,operands[1]);
      emit_insn (gen_ashrsi3fnl(operands[0], operands[1], operands[2]));
      DONE;
   }
}")
  
(define_insn "ashrsi3fnl"
  [(set (match_operand:SI 0 "register_operand"       "=r")
        (ashiftrt:SI (match_operand:SI 1 "register_operand" "0")
                   (match_operand:QI 2 "general_operand"  "rmi")))]
  "is_shift_better_in_reg(operands)"
  "* return msp430_emit_ashrsi3(insn, operands,NULL);"
  [(set_attr "length" "1")
   (set_attr "cc" "clobber")])
  
(define_insn "*ashrsi3"
  [(set (match_operand:SI 0 "nonimmediate_operand"       "=rm")
        (ashiftrt:SI (match_operand:SI 1 "nonimmediate_operand" "0")
                   (match_operand:QI 2 "general_operand"  "rmi")))]
  "!is_shift_better_in_reg(operands)"
  "* return msp430_emit_ashrsi3(insn, operands,NULL);"
  [(set_attr "length" "8")
   (set_attr "cc" "clobber")])


;;======================================

(define_expand "ashrdi3"
  [(set (match_operand:DI 0 "nonimmediate_operand"       "")
        (ashiftrt:DI (match_operand:DI 1 "nonimmediate_operand" "")
                   (match_operand:QI 2 "general_operand"  "")))]
""
"{
   if(!register_operand(operands[1], DImode) &&
	is_shift_better_in_reg(operands))
   {
      operands[1] = copy_to_mode_reg(DImode,operands[1]);
      emit_insn (gen_ashrdi3fnl(operands[0], operands[1], operands[2]));
      DONE;
   }
}")
  
(define_insn "ashrdi3fnl"
  [(set (match_operand:DI 0 "register_operand"       "=r")
        (ashiftrt:DI (match_operand:DI 1 "register_operand" "0")
                   (match_operand:QI 2 "general_operand"  "rmi")))]
  "is_shift_better_in_reg(operands)"
  "* return msp430_emit_ashrdi3(insn, operands,NULL);"
  [(set_attr "length" "1")
   (set_attr "cc" "clobber")])
  
(define_insn "*ashrdi3"
  [(set (match_operand:DI 0 "nonimmediate_operand"       "=rm")
        (ashiftrt:DI (match_operand:DI 1 "nonimmediate_operand" "0")
                   (match_operand:QI 2 "general_operand"  "rmi")))]
  "!is_shift_better_in_reg(operands)"
  "* return msp430_emit_ashrdi3(insn, operands,NULL);"
  [(set_attr "length" "8")
   (set_attr "cc" "clobber")])




;; >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >>
;;  >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >>   
;; >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >>   
;;  >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >>   
;; >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >>   
;;  >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >> >>   
;; logical shift right

(define_expand "lshrqi3"
  [(set (match_operand:QI 0 "nonimmediate_operand"       "")
        (lshiftrt:QI (match_operand:QI 1 "nonimmediate_operand" "")
                   (match_operand:QI 2 "general_operand"  "")))]
""
"{
   if(!register_operand(operands[1], QImode) &&
	is_shift_better_in_reg(operands))
   {
      operands[1] = copy_to_mode_reg(QImode,operands[1]);
      emit_insn (gen_lshrqi3fnl(operands[0], operands[1], operands[2]));
      DONE;
   }
}")
  
(define_insn "lshrqi3fnl"
  [(set (match_operand:QI 0 "register_operand"       "=r")
        (lshiftrt:QI (match_operand:QI 1 "register_operand" "0")
                   (match_operand:QI 2 "general_operand"  "rmi")))]
  "is_shift_better_in_reg(operands)"
  "* return msp430_emit_lshrqi3(insn, operands,NULL);"
  [(set_attr "length" "1")
   (set_attr "cc" "clobber")])
  
(define_insn "*lshrqi3"
  [(set (match_operand:QI 0 "nonimmediate_operand"       "=rm")
        (lshiftrt:QI (match_operand:QI 1 "nonimmediate_operand" "0")
                   (match_operand:QI 2 "general_operand"  "rmi")))]
  "!is_shift_better_in_reg(operands)"
  "* return msp430_emit_lshrqi3(insn, operands,NULL);"
  [(set_attr "length" "8")
   (set_attr "cc" "clobber")])

;;======================================

(define_expand "lshrhi3"
  [(set (match_operand:HI 0 "nonimmediate_operand"       "")
        (lshiftrt:HI (match_operand:HI 1 "nonimmediate_operand" "")
                   (match_operand:QI 2 "general_operand"  "")))]
""
"{
   if(!register_operand(operands[1], HImode) &&
	is_shift_better_in_reg(operands))
   {
      operands[1] = copy_to_mode_reg(HImode,operands[1]);
      emit_insn (gen_lshrhi3fnl(operands[0], operands[1], operands[2]));
      DONE;
   }
}")
  
(define_insn "lshrhi3fnl"
  [(set (match_operand:HI 0 "register_operand"       "=r")
        (lshiftrt:HI (match_operand:HI 1 "register_operand" "0")
                   (match_operand:QI 2 "general_operand"  "rmi")))]
  "is_shift_better_in_reg(operands)"
  "* return msp430_emit_lshrhi3(insn, operands,NULL);"
  [(set_attr "length" "1")
   (set_attr "cc" "clobber")])
  
(define_insn "*lshrhi3"
  [(set (match_operand:HI 0 "nonimmediate_operand"       "=rm")
        (lshiftrt:HI (match_operand:HI 1 "nonimmediate_operand" "0")
                   (match_operand:QI 2 "general_operand"  "rmi")))]
  "!is_shift_better_in_reg(operands)"
  "* return msp430_emit_lshrhi3(insn, operands,NULL);"
  [(set_attr "length" "8")
   (set_attr "cc" "clobber")])



;;======================================

(define_expand "lshrsi3"
  [(set (match_operand:SI 0 "nonimmediate_operand"       "")
        (lshiftrt:SI (match_operand:SI 1 "nonimmediate_operand" "")
                   (match_operand:QI 2 "general_operand"  "")))]
""
"{
   if(!register_operand(operands[1], SImode) &&
	is_shift_better_in_reg(operands))
   {
      operands[1] = copy_to_mode_reg(SImode,operands[1]);
      emit_insn (gen_lshrsi3fnl(operands[0], operands[1], operands[2]));
      DONE;
   }
}")
  
(define_insn "lshrsi3fnl"
  [(set (match_operand:SI 0 "register_operand"       "=r")
        (lshiftrt:SI (match_operand:SI 1 "register_operand" "0")
                   (match_operand:QI 2 "general_operand"  "rmi")))]
  "is_shift_better_in_reg(operands)"
  "* return msp430_emit_lshrsi3(insn, operands,NULL);"
  [(set_attr "length" "1")
   (set_attr "cc" "clobber")])
  
(define_insn "*lshrsi3"
  [(set (match_operand:SI 0 "nonimmediate_operand"       "=rm")
        (lshiftrt:SI (match_operand:SI 1 "nonimmediate_operand" "0")
                   (match_operand:QI 2 "general_operand"  "rmi")))]
  "!is_shift_better_in_reg(operands)"
  "* return msp430_emit_lshrsi3(insn, operands,NULL);"
  [(set_attr "length" "8")
   (set_attr "cc" "clobber")])


;;======================================

(define_expand "lshrdi3"
  [(set (match_operand:DI 0 "nonimmediate_operand"       "")
        (lshiftrt:DI (match_operand:DI 1 "nonimmediate_operand" "")
                   (match_operand:QI 2 "general_operand"  "")))]
""
"{
   if(!register_operand(operands[1], DImode) &&
	is_shift_better_in_reg(operands))
   {
      operands[1] = copy_to_mode_reg(DImode,operands[1]);
      emit_insn (gen_lshrdi3fnl(operands[0], operands[1], operands[2]));
      DONE;
   }
}")
  
(define_insn "lshrdi3fnl"
  [(set (match_operand:DI 0 "register_operand"       "=r")
        (lshiftrt:DI (match_operand:DI 1 "register_operand" "0")
                   (match_operand:QI 2 "general_operand"  "rmi")))]
  "is_shift_better_in_reg(operands)"
  "* return msp430_emit_lshrdi3(insn, operands,NULL);"
  [(set_attr "length" "1")
   (set_attr "cc" "clobber")])
  
(define_insn "*lshrdi3"
  [(set (match_operand:DI 0 "nonimmediate_operand"       "=rm")
        (lshiftrt:DI (match_operand:DI 1 "nonimmediate_operand" "0")
                   (match_operand:QI 2 "general_operand"  "rmi")))]
  "!is_shift_better_in_reg(operands)"
  "* return msp430_emit_lshrdi3(insn, operands,NULL);"
  [(set_attr "length" "8")
   (set_attr "cc" "clobber")])





;; xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x
;; xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x
;; xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x
;; xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x
;; xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x
;; xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x xx<---x
;; sign extend

(define_insn "extendqihi2"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=rm,rm")
        (sign_extend:HI (match_operand:QI 1 "general_operand" "0,*rmi")))]
  ""
  "* return signextendqihi(insn, operands,NULL);"
  [(set_attr "length" "2,2")
   (set_attr "cc" "set_n,set_n")])

(define_insn "extendqisi2"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm,rm")
        (sign_extend:SI (match_operand:QI 1 "general_operand" "0,*rmi")))]
  ""
  "* return signextendqisi(insn, operands,NULL);"
  [(set_attr "length" "6,6")
   (set_attr "cc" "set_n,set_n")])

(define_insn "extendqidi2"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm,rm")
        (sign_extend:DI (match_operand:QI 1 "general_operand" "0,*rmi")))]
  ""
  "* return signextendqidi(insn, operands,NULL);"
  [(set_attr "length" "6,6")
   (set_attr "cc" "set_n,set_n")])

(define_insn "extendhisi2"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm,rm")
        (sign_extend:SI (match_operand:HI 1 "general_operand" "0,*rmi")))] 
  ""
  "* return signextendhisi(insn, operands,NULL);"
  [(set_attr "length" "6,6")  
   (set_attr "cc" "set_n,set_n")])      

(define_insn "extendhidi2"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm,rm")
        (sign_extend:DI (match_operand:HI 1 "general_operand" "0,*rmi")))]
  ""
  "* return signextendhidi(insn, operands,NULL);"
  [(set_attr "length" "6,6")  
   (set_attr "cc" "set_n,set_n")])

(define_insn "extendsidi2"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm,rm")
        (sign_extend:DI (match_operand:SI 1 "general_operand" "0,*rmi")))]
  ""
  "* return signextendsidi(insn, operands,NULL);"
  [(set_attr "length" "6,6")
   (set_attr "cc" "set_n,set_n")])

;; xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0
;; xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0
;; xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0
;; xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0
;; xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0
;; xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0 xx<---0
;; zero extend

(define_insn "zero_extendqihi2"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=rm,rm")
        (zero_extend:HI (match_operand:QI 1 "general_operand" "0,*rmi")))]
  ""
  "* return zeroextendqihi(insn, operands,NULL);"
  [(set_attr "length" "2,2")
   (set_attr "cc" "set_n,set_n")])

(define_insn "zero_extendqisi2"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm,rm")
        (zero_extend:SI (match_operand:QI 1 "general_operand" "0,*rmi")))]
  ""
  "* return zeroextendqisi(insn, operands,NULL);"
  [(set_attr "length" "6,6")
   (set_attr "cc" "set_n,set_n")])

(define_insn "zero_extendqidi2"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm,rm")
        (zero_extend:DI (match_operand:QI 1 "general_operand" "0,*rmi")))]
  ""
  "* return zeroextendqidi(insn, operands,NULL);"
  [(set_attr "length" "6,6")
   (set_attr "cc" "set_n,set_n")])


(define_insn "zero_extendhisi2"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm,rm")
        (zero_extend:SI (match_operand:HI 1 "general_operand" "0,*rmi")))] 
  ""
  "* return zeroextendhisi(insn, operands,NULL);"
  [(set_attr "length" "6,6")  
   (set_attr "cc" "set_n,set_n")])      

(define_insn "zero_extendhidi2"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm,rm")
        (zero_extend:DI (match_operand:HI 1 "general_operand" "0,*rmi")))]
  ""
  "* return zeroextendhidi(insn, operands,NULL);"
  [(set_attr "length" "6,6")  
   (set_attr "cc" "set_n,set_n")])

(define_insn "zero_extendsidi2"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm,rm")
        (zero_extend:DI (match_operand:SI 1 "general_operand" "0,*rmi")))]
  ""
  "* return zeroextendsidi(insn, operands,NULL);"
  [(set_attr "length" "6,6")  
   (set_attr "cc" "set_n,set_n")])

;;=======================================================================
;;  BRANCH insns...
;;
;;

;; Unconditional jump instruction.
(define_insn "jump"
  [(set (pc) (label_ref (match_operand 0 "" "")))]
  ""
  "*
{
  if (get_attr_length (insn)  == 1)
    return \"jmp	%0\";
  return \"br	#%0\"; 
}"
  [(set (attr "length")
        (if_then_else (and (ge (minus (pc) (match_dup 0)) (const_int -511))
                           (le (minus (pc) (match_dup 0)) (const_int 512)))
                      (const_int 1)
                      (const_int 2)))
   (set_attr "cc" "none")])


; indirect jump
(define_expand "indirect_jump"
  [(set (pc) (match_operand:HI 0 "nonimmediate_operand" ""))]
  ""
  "")

(define_insn "*indirect_jump_idx"
  [(set (pc) (match_operand:HI 0 "memory_operand" "m"))]
  "indexed_location(operands[0])"
  "br	@%E0"
  [(set_attr "length" "1")
   (set_attr "cc" "none")])

(define_insn "*indirect_jump_mem"
  [(set (pc) (match_operand:HI 0 "memory_operand" "m"))]
  "!indexed_location(operands[0])"
  "br	%0"
  [(set_attr "length" "2")
   (set_attr "cc" "none")])


(define_insn "*indirect_jump_reg"
  [(set (pc) (match_operand:HI 0 "register_operand" "r"))]
  ""
  "br	%0"
  [(set_attr "length" "1")
   (set_attr "cc" "none")])


;;=======================================================================
;;=======================================================================
;;=======================================================================
;;=======================================================================
;; conditionals
;; 

;; define exotic branches first:

(define_insn "blt0si"
  [(set (pc)
        (if_then_else (match_operator 1 "comparison_operator" 
			[(match_operand:SI 2 "register_operand" "r") 
			 (const_int 0)])
                      (pc)
                      (label_ref (match_operand 0 "" ""))))]
  "(GET_CODE (operands[1]) == LT)"
  "* return msp430_emit_blt0si(operands, get_attr_length(insn));"
  [(set (attr "length")
        (if_then_else (and (ge (minus (pc) (match_dup 0)) (const_int -509))
                           (le (minus (pc) (match_dup 0)) (const_int 514)))
                      (const_int 2)
                      (const_int 4)))
   (set_attr "cc" "none")])





(define_insn "beq"
  [(set (pc)
        (if_then_else (eq (cc0)
                          (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "* return msp430_emit_beq(operands, get_attr_length(insn));"
  [(set (attr "length")
        (if_then_else (and (ge (minus (pc) (match_dup 0)) (const_int -511))
                           (le (minus (pc) (match_dup 0)) (const_int 512)))
                      (const_int 1)
                      (const_int 3)))
   (set_attr "cc" "none")])

(define_insn "beq_r"
  [(set (pc)
        (if_then_else (eq (cc0)
                          (const_int 0))
                      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "* return msp430_emit_bne(operands, get_attr_length(insn));"
  [(set (attr "length")
        (if_then_else (and (ge (minus (pc) (match_dup 0)) (const_int -511))
                           (le (minus (pc) (match_dup 0)) (const_int 512)))
                      (const_int 1)
                      (const_int 3)))
   (set_attr "cc" "none")])



(define_insn "bne"
  [(set (pc)
        (if_then_else (ne (cc0)
                          (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "* return msp430_emit_bne(operands, get_attr_length(insn));"
  [(set (attr "length")
        (if_then_else (and (ge (minus (pc) (match_dup 0)) (const_int -511))
                           (le (minus (pc) (match_dup 0)) (const_int 512)))
                      (const_int 1)
                      (const_int 3)))
   (set_attr "cc" "none")])

(define_insn "bne_r"
  [(set (pc)
        (if_then_else (ne (cc0)
                          (const_int 0))
                      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "* return msp430_emit_beq(operands, get_attr_length(insn));"
  [(set (attr "length")
        (if_then_else (and (ge (minus (pc) (match_dup 0)) (const_int -511))
                           (le (minus (pc) (match_dup 0)) (const_int 512)))
                      (const_int 1)
                      (const_int 3)))
   (set_attr "cc" "none")])





(define_insn "bgt"
  [(set (pc)
        (if_then_else (gt (cc0)
                          (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "* return msp430_emit_bgt(operands, get_attr_length(insn));"
  [(set (attr "length")
        (if_then_else (and (ge (minus (pc) (match_dup 0)) (const_int -511))
                           (le (minus (pc) (match_dup 0)) (const_int 512)))
                      (const_int 2)
                      (const_int 4)))
   (set_attr "cc" "none")])


(define_insn "bgtu"
  [(set (pc)
        (if_then_else (gtu (cc0)
                           (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "* return msp430_emit_bgtu(operands, get_attr_length(insn));"
  [(set (attr "length")
        (if_then_else (and (ge (minus (pc) (match_dup 0)) (const_int -511))
                           (le (minus (pc) (match_dup 0)) (const_int 512)))
                      (const_int 2)
                      (const_int 4)))
   (set_attr "cc" "none")])


(define_insn "blt"
  [(set (pc)
        (if_then_else (lt (cc0)
                          (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "* return msp430_emit_blt(operands, get_attr_length(insn));"
  [(set (attr "length")
        (if_then_else (and (ge (minus (pc) (match_dup 0)) (const_int -511))
                           (le (minus (pc) (match_dup 0)) (const_int 512)))
                      (const_int 1)
                      (const_int 3)))
   (set_attr "cc" "none")])


(define_insn "bltu"
  [(set (pc)
        (if_then_else (ltu (cc0)
                           (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "* return msp430_emit_bltu(operands, get_attr_length(insn));"
  [(set (attr "length")
        (if_then_else (and (ge (minus (pc) (match_dup 0)) (const_int -511))
                           (le (minus (pc) (match_dup 0)) (const_int 512)))
                      (const_int 1)
                      (const_int 3)))
   (set_attr "cc" "none")])



(define_insn "bge"
  [(set (pc)
        (if_then_else (ge (cc0)
                          (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "* return msp430_emit_bge(operands, get_attr_length(insn));"
  [(set (attr "length")
        (if_then_else (and (ge (minus (pc) (match_dup 0)) (const_int -511))
                           (le (minus (pc) (match_dup 0)) (const_int 512)))
                      (const_int 1)
                      (const_int 3)))
   (set_attr "cc" "none")])



(define_insn "bgeu"
  [(set (pc)
        (if_then_else (geu (cc0)
                           (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "* return msp430_emit_bgeu(operands, get_attr_length(insn));"
  [(set (attr "length")
        (if_then_else (and (ge (minus (pc) (match_dup 0)) (const_int -511))
                           (le (minus (pc) (match_dup 0)) (const_int 512)))
                      (const_int 1)
                      (const_int 3)))
   (set_attr "cc" "none")])



(define_insn "ble"
  [(set (pc)
        (if_then_else (le (cc0)
                          (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "* return msp430_emit_ble(operands, get_attr_length(insn));"
  [(set (attr "length")
        (if_then_else (and (ge (minus (pc) (match_dup 0)) (const_int -511))
                           (le (minus (pc) (match_dup 0)) (const_int 512)))
                      (const_int 2)
                      (const_int 4)))
   (set_attr "cc" "none")])


(define_insn "bleu"
  [(set (pc)
        (if_then_else (leu (cc0)
                           (const_int 0))
                      (label_ref (match_operand 0 "" ""))
                      (pc)))]
  ""
  "* return msp430_emit_bleu(operands, get_attr_length(insn));"
  [(set (attr "length")
        (if_then_else (and (ge (minus (pc) (match_dup 0)) (const_int -511))
                           (le (minus (pc) (match_dup 0)) (const_int 512)))
                      (const_int 2)
                      (const_int 4)))
   (set_attr "cc" "none")])




;;=======================================================================
;;
;;    CASE
;;

/*
(define_expand "casesi"
  [(set (match_dup 6)  
        (minus:HI (subreg:HI (match_operand:SI 0 "register_operand" "") 0)
                  (match_operand:HI 1 "register_operand" "")))
   (parallel [(set (cc0)
                   (compare (match_dup 6)
                            (match_operand:HI 2 "register_operand" "")))])
   (set (pc)
        (if_then_else (gtu (cc0)
                           (const_int 0))
                      (label_ref (match_operand 4 "" ""))
                      (pc)))
   (set (match_dup 6)
        (plus:HI (match_dup 6) (label_ref (match_operand:HI 3 "" ""))))

   (parallel [(set (pc) (unspec:HI [(match_dup 6)] 1))
              (use (label_ref (match_dup 3)))
              (clobber (match_dup 6))])]
  ""
  " 
{   
  operands[6] = gen_reg_rtx (HImode);
}")

*/ 

;; Table helper
(define_insn "tablejump"
  [(set (pc) (match_operand:HI 0 "general_operand" "rP,i,m"))
   (use (label_ref (match_operand 1 "" "")))]
  ""
  "br	%0	;	%1"
   [(set_attr "length" "1,2,2")   
   (set_attr "cc" "clobber")])




;; =============================================================
;; PEEPHOLES

;; (these peepholes were created because of tcpip...)
;; these two for:
;; (ulong) x = (ulong) func() << 16;
;; x |= func();
;; func() is uint
;;


(define_peephole2
   [(set (match_operand:SI 1 "register_operand" "")
         (zero_extend:SI (match_operand:HI 0 "register_operand" "")))
    (set (match_dup 1) (ashift:SI (match_dup 1) (const_int 16)))]
""
  [(set (subreg:HI (match_dup 1) 2) (match_dup 0)) 
   (set (subreg:HI (match_dup 1) 0) (const_int 0))]
"")

/********** suspisious
(define_peephole2
   [(set (match_operand:HI 0 "register_operand" "")  
         (match_operand:HI 1 "register_operand" ""))
    (set (match_operand:SI 2 "register_operand" "") 
         (zero_extend:SI (match_dup 0)))
    (set (match_dup 2) (ashift:SI (match_dup 2) (const_int 16)))]
"dead_or_set_in_peep(1,insn, operands[0])"
  [(set (subreg:HI (match_dup 2) 2) (match_dup 1))
   (set (subreg:HI (match_dup 2) 0) (const_int 0))]
"")
***********/

(define_peephole2
   [(set (match_operand:SI 0 "register_operand" "")
         (zero_extend:SI (match_operand:HI 1 "register_operand" "")))
    (set (match_operand:SI 2 "register_operand" "")
         (ior:SI (match_dup 2) (match_dup 0)))]
"dead_or_set_in_peep(1,insn, operands[0])"
  [(set (subreg:HI (match_dup 2) 0) 
        (ior:HI (subreg:HI (match_dup 2) 0) (match_dup 1)))]
"")


(define_peephole2
   [(set (match_operand:HI 0 "register_operand" "")  
         (match_operand:HI 1 "general_operand_msp430" ""))
    (set (match_operand:SI 2 "register_operand" "")
         (zero_extend:SI (match_dup 0)))
    (set (match_operand:SI 3 "register_operand" "") 
         (ior:SI (match_dup 3) (match_dup 2)))]
"dead_or_set_in_peep(2,insn, operands[0])"
  [(set (subreg:HI (match_dup 3) 0) 
        (ior:HI (subreg:HI (match_dup 3) 0) (match_dup 1)))]
"")


;; (ulong) x = (ulong) func() >> 16;
;; x |= func();
;; func() is ulong
;;
(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "") 
	(match_operand:SI 1 "register_operand" "")) 
   (set (match_dup 0) 
	(lshiftrt:SI (match_dup 0) 
		     (const_int 16)))]
"dead_or_set_in_peep(1,insn, operands[0])"
  [(set (subreg:HI (match_dup 0) 0) (subreg:HI (match_dup 1) 1))
   (set (subreg:HI (match_dup 0) 2) (const_int 0))]
"")

(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "") 
	(match_operand:SI 1 "register_operand" ""))
   (set (match_operand:SI 2 "register_operand" "")
	(ior:SI (match_dup 2) (match_dup 0)))]
"dead_or_set_in_peep(1,insn, operands[0])"
  [(set (match_dup 2) (ior:SI (match_dup 2) 
		              (match_dup 1)))]
"")


(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "") 
	(zero_extend:SI (match_operand:HI 1 "general_operand" "")))
   (set (match_dup 0) 
	(ashift:SI (match_dup 0) (const_int 16)))]
"dead_or_set_in_peep(1,insn, operands[0])"
  [(set (subreg:HI (match_dup 0) 2) (match_dup 1))
   (set (subreg:HI (match_dup 0) 0) (const_int 0))]
"")


;; shift right & set
(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "") 
	(match_operand:HI 1 "register_operand" ""))
   (set (match_operand:HI 2 "register_operand" "")
	(match_dup 0))
   (set (match_dup 2) 
	(and:HI (match_dup 2) 
		(match_operand 3 "const_int_operand" "")))
   (set (match_dup 2) 
	(lshiftrt:HI (match_dup 2) 
		     (match_operand 4 "const_int_operand" ""))) 
   (set (match_dup 1) (match_dup 2))]
"dead_or_set_in_peep(4,insn, operands[2])"
  [(set (match_dup 0) (match_dup 1))
   (set (match_dup 1)  
	(and:HI (match_dup 1)  
		(match_dup 3))) 
   (set (match_dup 1) 
	(lshiftrt:HI (match_dup 1) 
		     (match_dup 4)))] 
"")

;; shift left and set
(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "") 
	(match_operand:HI 1 "register_operand" ""))
   (set (match_operand:HI 2 "register_operand" "")
	(match_dup 0))
   (set (match_dup 2) 
	(and:HI (match_dup 2) 
		(match_operand 3 "const_int_operand" "")))
   (set (match_dup 2) 
	(ashift:HI (match_dup 2) 
		   (match_operand 4 "const_int_operand" ""))) 
   (set (match_dup 1) (match_dup 2))]
"dead_or_set_in_peep(4,insn, operands[2])"
  [(set (match_dup 0) (match_dup 1))
   (set (match_dup 1)  
	(and:HI (match_dup 1)  
		(match_dup 3))) 
   (set (match_dup 1) 
	(ashift:HI (match_dup 1) 
		   (match_dup 4)))] 
"")


;;
;; these for some shifts and stuff.
;; every peephole saves up to 4 bytes.
;;

(define_insn "*addc_reg"
  [(set (match_operand:HI 0 "register_operand" "=r,r") 
	(unspec:HI [(match_operand:HI 1 "register_operand" "%0,0") 
		    (match_operand:HI 2 "general_operand_msp430" "rP,mi")] 0))]
""
"addc	%2, %0"
[(set_attr "length" "1,2")
   (set_attr "cc" "clobber,clobber")])


(define_insn "*addc_any"
  [(set (match_operand:HI 0 "nonimmediate_operand_msp430" "=m,m") 
	(unspec:HI [(match_operand:HI 1 "nonimmediate_operand_msp430" "%0,0") 
		    (match_operand:HI 2 "general_operand_msp430" "rP,mi")] 5))]
""
"addc	%2, %0"
[(set_attr "length" "2,3")
   (set_attr "cc" "clobber,clobber")])

(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "") 
	(match_operand:HI 1 "general_operand_msp430" ""))
   (set (match_operand:SI 2 "register_operand" "") 
	(zero_extend:SI (match_dup 0)))
   (set (match_operand:SI 3 "register_operand" "") 
	(plus:SI (match_dup 3) (match_dup 2)))]
"dead_or_set_in_peep(2,insn, gen_lowpart(HImode,operands[2]))"
  [(set (subreg:HI (match_dup 3) 0) 
	(plus:HI (subreg:HI (match_dup 3) 0) 
		 (match_dup 1)))
   (set (subreg:HI (match_dup 3) 2) 
	(unspec:HI [(subreg:HI (match_dup 3) 2) (const_int 0)] 0))]
"")

(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "") 
	(match_operand:HI 1 "general_operand_msp430" ""))
   (set (match_operand:SI 2 "register_operand" "") 
	(zero_extend:SI (match_dup 0)))
   (set (match_operand:SI 3 "nonimmediate_operand_msp430" "") 
	(plus:SI (match_dup 3) (match_dup 2)))]
"dead_or_set_in_peep(2,insn, gen_lowpart(HImode,operands[2]))"
  [(set (subreg:HI (match_dup 3) 0) 
	(plus:HI (subreg:HI (match_dup 3) 0) 
		 (match_dup 1)))
   (set (subreg:HI (match_dup 3) 2) 
	(unspec:HI [(subreg:HI (match_dup 3) 2) (const_int 0)] 5))]
"")

(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "")
        (match_operand:HI 1 "general_operand_msp430" ""))
   (set (match_operand:SI 2 "nonimmediate_operand_msp430" "")
        (zero_extend:SI (match_dup 0)))]
"dead_or_set_in_peep(1,insn, gen_lowpart(HImode,operands[0]))"
  [(set (subreg:HI (match_dup 2) 0) (match_dup 1))
   (set (subreg:HI (match_dup 2) 2) (const_int 0))]
"")

;;
;; these are for redudant moves.
;;

(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "") 
	(match_operand:SI 1 "nonimmediate_operand_msp430" ""))
   (set (match_operand:SI 2 "register_operand" "") 
	(ior:SI (match_dup 2) (match_dup 0)))
   (set (match_dup 1) (match_dup 2))]
"dead_or_set_in_peep(1,insn, operands[0])"
  [(set (match_dup 1) (ior:SI (match_dup 1) (match_dup 2)))]
"")

(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "")
	(ior:SI (match_dup 0) 
		(match_operand:SI 1 "register_operand" "")))
   (set (match_dup 1) (match_dup 0))]
"dead_or_set_in_peep(1,insn, operands[0])"
  [(set (match_dup 1) (ior:SI (match_dup 1) (match_dup 0)))]
"")

(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "") 
	(match_operand:HI 1 "register_operand" ""))
   (set (match_dup 0) 
	(not:HI (match_dup 0)))
   (set (match_operand:HI 2 "register_operand" "") 
	(match_dup 0))]
"dead_or_set_in_peep(2,insn, operands[0]) && dead_or_set_in_peep(0,insn, operands[1])"
  [(set (match_dup 1) (not:HI (match_dup 1)))
   (set (match_dup 2) (match_dup 1))]
"")

(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "") 
	(match_operand:SI 1 "register_operand" ""))
   (set (match_dup 0) 
	(not:SI (match_dup 0)))
   (set (match_operand:SI 2 "register_operand" "") 
	(match_dup 0))]
"dead_or_set_in_peep(2,insn, operands[0]) && dead_or_set_in_peep(0,insn, operands[1])"
  [(set (match_dup 1) (not:SI (match_dup 1)))
   (set (match_dup 2) (match_dup 1))]
"")

(define_peephole2
  [(set (match_operand:SF 0 "register_operand" "")
	(match_operand:SF 1 "general_operand_msp430" ""))
   (set (match_operand:SF 2 "nonimmediate_operand_msp430" "") 
	(match_dup 0))]
"dead_or_set_in_peep(1,insn, operands[0])"
  [(set (match_dup 2) (match_dup 1))]
"")


(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "")
	(match_operand:SI 1 "general_operand_msp430" ""))
   (set (match_operand:SI 2 "nonimmediate_operand_msp430" "") 
	(match_dup 0))]
"dead_or_set_in_peep(1,insn, operands[0])"
  [(set (match_dup 2) (match_dup 1))]
"")

(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "")
        (match_operand:HI 1 "general_operand_msp430" ""))
   (set (match_operand:HI 2 "nonimmediate_operand_msp430" "")
        (match_dup 0))]
"dead_or_set_in_peep(1,insn, operands[0])"
  [(set (match_dup 2) (match_dup 1))]
"")



;; =========================================================================
;;  This one for bit tests like:
;;	volatile long a;
;;	while(a&CONST_HALFNIBBLE) ;

(define_insn "*bittest_lo"
  [(set (cc0) 
	(unspec:SI [(match_operand:SI 0 "nonimmediate_operand_msp430" "r,r,m,m") 
		    (match_operand:SI 1 "general_operand_msp430" "rPS,mi,rPS,mi")] 1))]
""
"bit	%A1,%A0"
[(set_attr "length" "1,2,2,3")
   (set_attr "cc" "compare,compare,compare,compare")])

(define_insn "*bittest_hi"
  [(set (cc0) 
	(unspec:SI [(match_operand:SI 0 "nonimmediate_operand_msp430" "r,r,m,m") 
		    (match_operand:SI 1 "general_operand_msp430" "rPS,mi,rPS,mi")] 2))]
""
"bit	%B1,%B0"
[(set_attr "length" "1,2,2,3")
   (set_attr "cc" "compare,compare,compare,compare")])


(define_peephole2
 [(set (match_operand:SI 0 "register_operand" "")
       (match_operand:SI 1 "nonimmediate_operand_msp430" ""))
  (set (match_dup 0) (and:SI (match_dup 0) 
                             (match_operand 2 "const_int_operand" "")))
  (parallel [(set (cc0) (match_dup 0))
        (clobber (match_operand:SI 3 "register_operand" ""))])]
"(halfnibble_integer(operands[2], VOIDmode) 
   || halfnibble_constant(operands[2], VOIDmode))
        && dead_or_set_in_peep(2,insn, operands[0])
	&& which_nibble(INTVAL(operands[2])) == 0"
  [(set (cc0) 
	(unspec:SI [(match_dup 1) (match_dup 2)] 1))]
"")


(define_peephole2
 [(set (match_operand:SI 0 "register_operand" "")
       (match_operand:SI 1 "nonimmediate_operand_msp430" ""))
  (set (match_dup 0) (and:SI (match_dup 0) 
                             (match_operand 2 "const_int_operand" "")))
  (parallel [(set (cc0) (match_dup 0))
        (clobber (match_operand:SI 3 "register_operand" ""))])]
"(halfnibble_integer(operands[2], VOIDmode) 
   || halfnibble_constant(operands[2], VOIDmode))
        && dead_or_set_in_peep(2,insn, operands[0])
	&& which_nibble(INTVAL(operands[2])) == 1"
  [(set (cc0) 
	(unspec:SI [(match_dup 1) (match_dup 2)] 2))]
"")

;;
;;  The same for HI mode: while(smts&0xXXXX) ;
;;
(define_insn "*bittest"
  [(set (cc0)
        (unspec:HI [(match_operand:HI 0 "general_operand_msp430" "r,r,m,m")
                    (match_operand:HI 1 "general_operand_msp430" "rPS,mi,rPS,mi")] 6))]
""
"bit	%1,%0"
[(set_attr "length" "1,2,2,3")
   (set_attr "cc" "compare,compare,compare,compare")])


(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "") 
	(match_operand:HI 1 "general_operand_msp430" ""))
   (set (match_dup 0) 
	(and:HI (match_dup 0) 
		(match_operand:HI 2 "general_operand_msp430" "")))
   (set (cc0) (match_dup 0))]
"dead_or_set_in_peep(2,insn, operands[0])"
  [(set (cc0) 
	(unspec:HI [(match_dup 1) (match_dup 2)] 6))]
"")


;;===========================================================================
;; these seem to break the code!!!

(define_peephole2
  [(set (match_operand:QI 0 "register_operand" "")
        (match_operand:QI 1 "general_operand_msp430" ""))
   (set (match_dup 0)
	(minus:QI (match_dup 0) 
		  (match_operand:QI 2 "general_operand_msp430" "")))
   (set (match_operand:QI 3 "register_operand" "")
   	(match_dup 0))]
"dead_or_set_in_peep(2,insn, operands[0]) && 0"
  [(set (match_dup 3) (match_dup 1))
   (set (match_dup 3) (minus:QI (match_dup 3) (match_dup 2)))]
"")


(define_peephole2
  [(set (match_operand:QI 0 "register_operand" "")
        (match_operand:QI 1 "general_operand_msp430" ""))
   (set (match_dup 0)
	(plus:QI (match_dup 0) 
		 (match_operand:QI 2 "general_operand_msp430" "")))
   (set (match_operand:QI 3 "register_operand" "")
   	(match_dup 0))]
"dead_or_set_in_peep(2,insn, operands[0]) && 0"
  [(set (match_dup 3) (match_dup 1))
   (set (match_dup 3) (plus:QI (match_dup 3) (match_dup 2)))]
"")


(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "")
        (match_operand:HI 1 "general_operand_msp430" ""))
   (set (match_dup 0)
	(minus:HI (match_dup 0) 
		  (match_operand:HI 2 "general_operand_msp430" "")))
   (set (match_operand:HI 3 "register_operand" "")
   	(match_dup 0))]
"dead_or_set_in_peep(2,insn, operands[0]) && 0"
  [(set (match_dup 3) (match_dup 1))
   (set (match_dup 3) (minus:HI (match_dup 3) (match_dup 2)))]
"")


(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "")
        (match_operand:HI 1 "general_operand_msp430" ""))
   (set (match_dup 0)
	(plus:HI (match_dup 0) 
		 (match_operand:HI 2 "general_operand_msp430" "")))
   (set (match_operand:HI 3 "register_operand" "")
   	(match_dup 0))]
"dead_or_set_in_peep(2,insn, operands[0]) && 0"
  [(set (match_dup 3) (match_dup 1))
   (set (match_dup 3) (plus:HI (match_dup 3) (match_dup 2)))]
"")


(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "")
        (match_operand:SI 1 "general_operand_msp430" ""))
   (set (match_dup 0)
	(minus:SI (match_dup 0) 
		  (match_operand:SI 2 "general_operand_msp430" "")))
   (set (match_operand:SI 3 "register_operand" "")
   	(match_dup 0))]
"dead_or_set_in_peep(2,insn, operands[0]) && 0"
  [(set (match_dup 3) (match_dup 1))
   (set (match_dup 3) (minus:SI (match_dup 3) (match_dup 2)))]
"")


(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "")
        (match_operand:SI 1 "general_operand_msp430" ""))
   (set (match_dup 0)
	(plus:SI (match_dup 0) 
		 (match_operand:SI 2 "general_operand_msp430" "")))
   (set (match_operand:SI 3 "register_operand" "")
   	(match_dup 0))]
"dead_or_set_in_peep(2,insn, operands[0]) && 0"
  [(set (match_dup 3) (match_dup 1))
   (set (match_dup 3) (plus:SI (match_dup 3) (match_dup 2)))]
"")


;; =============================================================
;; 
;;  adjust frame pointer index
;;
(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "") 
	(sign_extend:HI (match_operand:QI 1 "general_operand_msp430" "")))
   (set (match_dup 0) 
	(plus:HI (match_dup 0) (match_operand:HI 2 "general_operand_msp430" "")))
   (set (match_operand:HI 3 "register_operand" "")
	(match_dup 0))]
"dead_or_set_in_peep(2,insn, operands[0])"
  [(set (match_dup 3) (sign_extend:HI (match_dup 1)))
   (set (match_dup 3) (plus:HI (match_dup 3) (match_dup 2)))]
"")

(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "") 
	(sign_extend:SI (match_operand:HI 1 "general_operand_msp430" "")))
   (set (match_dup 0) 
	(plus:SI (match_dup 0) (match_operand:SI 2 "general_operand_msp430" "")))
   (set (match_operand:SI 3 "register_operand" "")
	(match_dup 0))]
"dead_or_set_in_peep(2,insn, operands[0])"
  [(set (match_dup 3) (sign_extend:SI (match_dup 1)))
   (set (match_dup 3) (plus:SI (match_dup 3) (match_dup 2)))]
"")

(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "") 
	(sign_extend:HI (match_operand:QI 1 "general_operand_msp430" "")))
   (set (match_dup 0) 
	(minus:HI (match_dup 0) (match_operand:HI 2 "general_operand_msp430" "")))
   (set (match_operand:HI 3 "register_operand" "")
	(match_dup 0))]
"dead_or_set_in_peep(2,insn, operands[0])"
  [(set (match_dup 3) (sign_extend:HI (match_dup 1)))
   (set (match_dup 3) (minus:HI (match_dup 3) (match_dup 2)))]
"")

(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "") 
	(sign_extend:SI (match_operand:HI 1 "general_operand_msp430" "")))
   (set (match_dup 0) 
	(minus:SI (match_dup 0) (match_operand:SI 2 "general_operand_msp430" "")))
   (set (match_operand:SI 3 "register_operand" "")
	(match_dup 0))]
"dead_or_set_in_peep(2,insn, operands[0])"
  [(set (match_dup 3) (sign_extend:SI (match_dup 1)))
   (set (match_dup 3) (minus:SI (match_dup 3) (match_dup 2)))]
"")

;; =============================================================
;; mov & 'and'

(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "") 
	(match_operand:HI 1 "nonimmediate_operand_msp430" ""))
   (set (match_dup 0) 
	(and:HI (match_dup 0) 
		(match_operand:HI 2 "general_operand_msp430" ""))) 
   (set (match_dup 1) (match_dup 0))]
"dead_or_set_in_peep(2,insn, operands[0])"
  [(set (match_dup 1) 
	(and:HI (match_dup 1) (match_dup 2)))]
"")


(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "") 
	(match_operand:SI 1 "nonimmediate_operand_msp430" ""))
   (set (match_dup 0) 
	(and:SI (match_dup 0) 
		(match_operand:SI 2 "general_operand_msp430" ""))) 
   (set (match_dup 1) (match_dup 0))]
"dead_or_set_in_peep(2,insn, operands[0])"
  [(set (match_dup 1) 
	(and:SI (match_dup 1) (match_dup 2)))]
"")



;; =============================================================
;; SWAP BYTES (should be a pattern for:
;;   r = (a<<8)|(a>>8);

(define_insn "*swpb"
  [(set (match_operand:HI 0 "nonimmediate_operand_msp430" "=rS,m") 
	(unspec:HI [(match_operand:HI 1 "nonimmediate_operand_msp430" "0,0")] 4))]
""
"swpb	%0"
[(set_attr "length" "1,2")
   (set_attr "cc" "clobber,clobber")])

(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "") 
        (match_operand:HI 1 "nonimmediate_operand_msp430" ""))
   (set (match_dup 1) 
        (ashift:HI (match_dup 1) (const_int 8)))
   (set (match_dup 0) 
        (lshiftrt:HI (match_dup 0) (const_int 8)))
   (set (match_dup 1) 
        (ior:HI (match_dup 1) (match_dup 0)))]
"dead_or_set_in_peep(3,insn,operands[0])"
  [(set (match_dup 1) 
        (unspec:HI [(match_dup 1)] 4))]
"")


(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "") 
	(match_operand:HI 1 "nonimmediate_operand_msp430" ""))
   (set (match_operand:HI 2 "register_operand" "") 
	(match_dup 0))
   (set (match_dup 2) 
	(ashift:HI (match_dup 2) (const_int 8)))
   (set (match_dup 0) 
	(lshiftrt:HI (match_dup 0) (const_int 8)))
   (set (match_dup 2) 
	(ior:HI (match_dup 2) (match_dup 0)))
   (set (match_dup 1) (match_dup 2))]
"dead_or_set_in_peep(5,insn,operands[2]) && dead_or_set_in_peep(4,insn,operands[0])"
  [(set (match_dup 1) 
	(unspec:HI [(match_dup 1)] 4))]
"")


(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "") 
	(match_operand:HI 1 "nonimmediate_operand_msp430" ""))
   (set (match_operand:HI 2 "register_operand" "") 
	(match_dup 0))
   (set (match_dup 2) 
	(lshiftrt:HI (match_dup 2) (const_int 8)))
   (set (match_dup 0) 
	(ashift:HI (match_dup 0) (const_int 8)))
   (set (match_dup 0) 
	(ior:HI (match_dup 0) (match_dup 2)))
   (set (match_dup 1) (match_dup 0))]
"dead_or_set_in_peep(5,insn,operands[2]) && dead_or_set_in_peep(4,insn,operands[0])"
  [(set (match_dup 1) 
	(unspec:HI [(match_dup 1)] 4))]
"")


(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "") 
	(match_operand:HI 1 "nonimmediate_operand_msp430" ""))
   (set (match_operand:HI 2 "register_operand" "") 
	(match_dup 0))
   (set (match_dup 2) 
	(ashift:HI (match_dup 2) (const_int 8)))
   (set (match_dup 0) 
	(lshiftrt:HI (match_dup 0) (const_int 8)))
   (set (match_dup 2) 
	(ior:HI (match_dup 2) (match_dup 0)))]
"dead_or_set_in_peep(4,insn,operands[2])"
  [(set (match_dup 0) (match_dup 1))
   (set (match_dup 0) 
	(unspec:HI [(match_dup 0)] 4))]
"")


(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "") 
	(match_operand:HI 1 "nonimmediate_operand_msp430" ""))
   (set (match_operand:HI 2 "register_operand" "") 
	(match_dup 0))
   (set (match_dup 2) 
	(lshiftrt:HI (match_dup 2) (const_int 8)))
   (set (match_dup 0) 
	(ashift:HI (match_dup 0) (const_int 8)))
   (set (match_dup 0) 
	(ior:HI (match_dup 0) (match_dup 2)))]
"dead_or_set_in_peep(4,insn,operands[2])"
  [(set (match_dup 0) (match_dup 1))
   (set (match_dup 0) 
	(unspec:HI [(match_dup 0)] 4))]
"")

;;
;; after mult and stuff
;;
(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "") 
	(reg:SI 14))
   (set (match_operand:SI 1 "nonimmediate_operand_msp430" "") 
	(match_dup 0))]
"dead_or_set_in_peep(1,insn,operands[0])"
  [(set (match_dup 1) (reg:SI 14))]
"")

(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "") 
	(reg:HI 14))
   (set (match_operand:HI 1 "nonimmediate_operand_msp430" "") 
	(match_dup 0))]
"dead_or_set_in_peep(1,insn,operands[0])"
  [(set (match_dup 1) (reg:HI 14))]
"")

(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "") 
	(reg:SI 12))
   (set (match_operand:SI 1 "nonimmediate_operand_msp430" "") 
	(match_dup 0))]
"dead_or_set_in_peep(1,insn,operands[0])"
  [(set (match_dup 1) (reg:SI 12))]
"")

(define_peephole2
  [(set (match_operand:HI 0 "register_operand" "") 
	(reg:HI 12))
   (set (match_operand:HI 1 "nonimmediate_operand_msp430" "") 
	(match_dup 0))]
"dead_or_set_in_peep(1,insn,operands[0])"
  [(set (match_dup 1) (reg:HI 12))]
"")

(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "") 
	(sign_extend:SI (match_operand:QI 1 "general_operand_msp430" "")))
   (set (match_operand:SI 2 "nonimmediate_operand_msp430" "") 
	(match_dup 0))]
"dead_or_set_in_peep(1,insn,operands[0])"
  [(set (match_dup 2) (sign_extend:SI (match_dup 1)))]
"")

(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "") 
	(sign_extend:SI (match_operand:HI 1 "general_operand_msp430" "")))
   (set (match_operand:SI 2 "nonimmediate_operand_msp430" "") 
	(match_dup 0))]
"dead_or_set_in_peep(1,insn,operands[0])"
  [(set (match_dup 2) (sign_extend:SI (match_dup 1)))]
"")


;; =============================================================

(define_peephole 
  [(set (match_operand:HI 0 "register_operand" "") 
	(sign_extend:HI (match_operand:QI 1 "register_operand" ""))) 
   (set (match_operand:HI 2 "register_operand" "") 
	(plus:HI (match_dup 2) (match_dup 0)))]
"dead_or_set_in_peep(1,insn,operands[0])" 
"sxt	%1
	add	%1, %2"
[(set_attr "length" "3")
   (set_attr "cc" "clobber")])


(define_peephole 
  [(set (match_operand:HI 0 "register_operand" "") 
	(sign_extend:HI (match_operand:QI 1 "nonimmediate_operand_msp430" ""))) 
   (set (match_operand:HI 2 "register_operand" "") (match_dup 0))]
"dead_or_set_in_peep(1,insn,operands[0])" 
"mov.b	%1, %2
	sxt	%2"
[(set_attr "length" "2")
   (set_attr "cc" "clobber")])

;; ============================================================= 

(define_peephole2
  [(set (match_operand:DI 0 "register_operand" "")
	(match_operand:DI 1 "general_operand" ""))
   (set (match_dup 0) 
	(ashiftrt:DI (match_dup 0) (const_int 32)))
   (set (match_operand:SI 2 "nonimmediate_operand" "") 
	(match_operand:SI 3 "register_operand" ""))]
"REGNO(operands[0]) == REGNO(operands[3]) 
 && dead_or_set_in_peep(2,insn,operands[3])"
  [(set (match_dup 2) (subreg:SI (match_dup 1) 4))]
"")















