/*  -*- Mode: Asm -*-  */


	.section .text.libgcc, "ax", @progbits

#if defined (L_cmpdi2)
	
	.global	__cmpdi2
	.func	__cmpdi2
__cmpdi2:
	push	r7
	push	r8
	push	r9
	push	r10
	push	r11
	mov	#llo(10), r10 
	add	r1, r10
	mov	r10, r11 
	mov	r12, r7
	mov	r13, r8
	mov	r14, r9
	mov	r15, r10
	mov	6(r11), r14
	mov	4(r11), r13
	mov	2(r11), r12
	mov	@r11, r11
	cmp	r11, r7
	jne	.L2
	cmp	r12, r8
	jne	.L2
	cmp	r13, r9
	jne	.L2
	cmp	r14, r10
	jne	.L2
	mov	#llo(0), r15 
	jmp	.L1
.L2:
	cmp	r14, r10
	jeq	+2
	jge	.L4
	jne	.L3
	cmp	r13, r9
	jeq	+2
	jhs	.L4
	jne	.L3
	cmp	r12, r8
	jeq	+2
	jhs	.L4
	jne	.L3
	cmp	r11, r7
	jeq	.L3
	jlo	.L3
.L4:
	mov	#llo(1), r15 
	jmp	.L1
.L3:
	mov	#llo(-1), r15 
.L1:
	pop	r11
	pop	r10
	pop	r9
	pop	r8
	pop	r7
	ret
.endfunc
#endif


#if defined (L_cmpsi2)
	.global __cmpsi2
	.func	__cmpsi2
__cmpsi2:
        cmp     r13, r15
        jeq     +2
        jhs     .Lcmpos
        jne     +6
        cmp     r12, r14
        jeq     +2
        jhs     .Lcmpos
        cmp     r15, r13
        jeq     +2
        jhs     +8
        jne     +10
        cmp     r14, r12
        jeq     +6
        jlo     +4
        mov     #llo(-1), r15 
        jmp     +6
        mov     #llo(0), r15 
        jmp     +2
.Lcmpos:
        mov     #llo(1), r15 
        ret
.endfunc

#endif


/*******************************************************
               Multiplication  8 x 8
*******************************************************/
#if defined (L_mulqi3)
/* 
	a = reg:qi 10	clobber
	b = reg:qi 12	clobber
	res = reg:qi 14
*/

	.global	__mulqi3
	.func	__mulqi3
__mulqi3:
	clr	r14
	tst.b	r12
	jz	.L__mulqiexit
.L__mulqiloop:
	clrc
	rrc.b	r12
	jnc	+2
	add.b	r10, r14
	rla.b	r10
	tst.b	r12
	jne	.L__mulqiloop
.L__mulqiexit:
	ret
	.endfunc
#endif 	/* defined (L_mulqi3) */


#if defined (L_mulqihi3)
	.global	__mulqihi3
	.func	__mulqihi3
__mulqihi3:
	sxt	r10
	sxt	r12
	br	#__mulhi3
.endfunc
#endif /* defined (L_mulqihi3) */

#if defined (L_umulqihi3)
	.global	__umulqihi3
	.func	__umulqihi3
__umulqihi3:
	and.b	#-1, r10
	and.b	#-1, r12
	br	#__mulhi3
	.endfunc
#endif /* defined (L_umulqihi3) */

/*******************************************************
               Multiplication  16 x 16
*******************************************************/
#if defined (L_mulhi3)
/* 
	a = reg:hi 10	clobber
	b = reg:hi 12	clobber
	res = reg:hi 14
*/

	.global	__mulhi3
	.func	__mulhi3
__mulhi3:
	clr	r14
	tst	r12
	jz	.L__mulhiexit
.L__mulhiloop:
	clrc
	rrc	r12
	jnc	+2
	add	r10, r14
	rla	r10
	tst     r12
	jne	.L__mulhiloop
.L__mulhiexit:
	ret
	.endfunc
#endif /* defined (L_mulhi3) */

#if defined (L_mulhisi3)
/* clobber r11, r13 */
	.global	__mulhisi3
	.func	__mulhisi3
__mulhisi3:
	br	#__mulsi3
	.endfunc
#endif /* defined (L_mulhisi3) */

#if defined (L_umulhisi3)
	.global	__umulhisi3
	.func	__umulhisi3
__umulhisi3:
	br	#__mulsi3
	.endfunc
#endif /* defined (L_umulhisi3) */

#if defined (L_mulsi3)
/*******************************************************
               Multiplication  32 x 32
*******************************************************/
/*
res = a*b
	a - reg:SI 10 clobber
	b - reg:SI 12 clobber
	res - reg: SI 14
*/
#ifndef MSP430_HAS_HW_MUL
	.global	__mulsi3
	.func	__mulsi3

__mulsi3:
	clr	r14
	clr	r15
	jmp	.L__mulsi3st
.L__mulsi3loop:
	clrc
	rrc	r13		;	b >>= 1
	rrc 	r12
	jnc	+4		;	
	add	r10, r14	;	res = res + a
	addc	r11, r15
	rla	r10
	rlc	r11		;	a <<= 1
.L__mulsi3st:
	tst	r12		; if b ne 0 goto L__mulsi3loop
	jne	.L__mulsi3loop
	tst	r13
	jne	.L__mulsi3loop
	ret
	.endfunc

#else
__MPY=0x130
__MPYS=0x132
__MAC=0x134
__MACS=0x136
__OP2=0x138
__RESLO=0x13a
__RESHI=0x13c
__SUMEXT=0x13e

	.global	__umulsi3hw
	.func	__umulsi3hw
__umulsi3hw:
	mov	r12, &__MPY
	mov	r10, &__OP2
	mov	r12, &__MAC
	mov	&__RESLO, r14
	mov	&__RESHI, &__RESLO
	mov	r11, &__OP2
	mov	r13, &__MAC
	mov	r10, &__OP2
	mov	&__RESLO, r15
	ret
.endfunc

/*
	.global	__mulsi3hw
	.func	__mulsi3hw
__mulsi3hw:
	mov	r12, &__MPYS
	mov	r10, &__OP2
	mov	r12, &__MACS
	mov	&__RESLO, r14
	mov	&__RESHI, &__RESLO
	mov	r11, &__OP2
	mov	r13, &__MACS
	mov	r10, &__OP2
	mov	&__RESLO, r15
	ret
.endfunc
*/

#endif

#endif /* defined (L_mulsi3) */
	
/*******************************************************
       Division 8 / 8 => (result + remainder)
*******************************************************/

#define r_rem   r14	/* remainder */
#define r_arg1  r12	/* dividend, quotient */
#define r_arg2  r10	/* divisor */
#define r_cnt   r11	/* loop count */
#define r_tmp	r13	/* save carry flag */


#if defined (L_udivmodqi4)
	.global	__udivmodqi4
	.func	__udivmodqi4
__udivmodqi4:
	xor.b	r_rem, r_rem		; clear reminder and carry
	mov.b	#9, r_cnt
	jmp	.L__udivmodqi4_ep
.L__udivmodqi4_loop:	
	rrc	r_tmp			; restore carry bit
	rlc.b	r_rem
	cmp.b	r_arg2, r_rem
	jlo	.L__udivmodqi4_ep
	sub.b	r_arg2, r_rem		; FIXME: will this clobber carry ?
.L__udivmodqi4_ep:
	rlc.b	r_arg1			; shift divident
	rlc	r_tmp			; save carry bit
	dec.b	r_cnt			; this clobbers C bit.
	jnz	.L__udivmodqi4_loop
	ret
	.endfunc
#endif /* defined (L_udivmodqi4) */


#if defined (L_divmodqi4)
	.global	__divmodqi4
	.func	__divmodqi4
__divmodqi4:
	clr	r_tmp
	bit	#0x80, r_arg1		; save divident sign
	jnc	.L__divmodqi4arg1pos
	inv.b	r_arg1			; negate
	inc.b	r_arg1
	bis	#4, r_tmp

.L__divmodqi4arg1pos:
	bit	#0x80, r_arg2		; check divisor sign
	jnc	.L__divmodqi4arg2pos
	inv.b	r_arg2			; negate
	inc.b	r_arg2
	bis	#8, r_tmp

.L__divmodqi4arg2pos:
	
	call	#__udivmodqi4		; do unsigned division
	rrc	r_tmp			; restore carry and sign bits

	bit	#4, r_tmp		; is divident < 0 ?
	jnc	.L__divmodqi4rem	; no. skip
	inv.b	r_rem			; negate remainder
	inc.b	r_rem

;;	bit	#8, r_tmp
;;	jc	.L__divmodqi4end
	inv.b	r_arg1			; negate quotient
	inc.b	r_arg1

.L__divmodqi4rem:
	bit	#8, r_tmp
	jnc	.L__divmodqi4end
	inv.b	r_arg1
	inc.b	r_arg1

.L__divmodqi4end:
	ret

	.endfunc
#endif /* defined (L_divmodqi4) */

#undef r_rem
#undef r_arg1
#undef r_arg2
#undef r_cnt 
#undef r_tmp


/*******************************************************
       Division 16 / 16 => (result + remainder)
*******************************************************/

#define r_rem   r14	/* remainder */
#define r_arg1  r12	/* dividend, quotient */
#define r_arg2  r10	/* divisor */
#define r_cnt   r11	/* loop count */
#define r_tmp	r13


#if defined (L_udivmodhi4)
	.global	__udivmodhi4
	.func	__udivmodhi4
__udivmodhi4:
	xor	r_rem, r_rem		; clear reminder and carry
	mov	#17, r_cnt
	jmp	.L__udivmodhi4_ep
.L__udivmodhi4_loop:	
	rrc	r_tmp			; restore carry bit
	rlc	r_rem
	cmp	r_arg2, r_rem
	jlo	.L__udivmodhi4_ep
	sub	r_arg2, r_rem
.L__udivmodhi4_ep:
	rlc	r_arg1
	rlc	r_tmp			; save carry bit
	dec	r_cnt			; this clobbers C bit.
	jnz	.L__udivmodhi4_loop
	ret
	.endfunc
#endif /* defined (L_udivmodhi4) */


#if defined (L_divmodhi4)
#define r_rem   r14     /* remainder */
#define r_arg1  r12     /* dividend, quotient */
#define r_arg2  r10     /* divisor */   
#define r_cnt   r11     /* loop count */
#define r_tmp   r13


	.global	__divmodhi4
	.func	__divmodhi4
__divmodhi4:
	clr	r_tmp			; clear reg is cheaper than clr 2 bits.
	bit	#0x8000, r_arg1		; save divident sign
	jnc	.L__divmodhi4arg1pos
	inv	r_arg1			; negate
	inc	r_arg1
	bis	#4, r_tmp

.L__divmodhi4arg1pos:
	bit	#0x8000, r_arg2		; check divisor sign
	jnc	.L__divmodhi4arg2pos
	inv	r_arg2			; negate
	inc	r_arg2
	bis	#8, r_tmp

.L__divmodhi4arg2pos:	
	call	#__udivmodhi4		; do unsigned division
	rrc	r_tmp			; restore carry and sign bits

	bit	#4, r_tmp		; is divident < 0 ?
	jnc	.L__divmodhi4rem	; no. skip
	inv	r_rem			; negate remainder
	inc	r_rem

;;	bit	#8, r_tmp
;;	jc	.L__divmodhi4end
	inv	r_arg1			; negate quotient
	inc	r_arg1

.L__divmodhi4rem:
	bit	#8, r_tmp
	jnc	.L__divmodhi4end
	inv	r_arg1
	inc	r_arg1

.L__divmodhi4end:
	ret
	.endfunc
#endif /* defined (L_divmodhi4) */

#undef r_rem
#undef r_arg1
#undef r_arg2
#undef r_cnt 
#undef r_tmp

/*******************************************************
       Division 32 / 32 => (result + remainder)
*******************************************************/

#if defined (L_udivmodsi4)

#define r_remh  r15  
#define r_reml  r14	/* remainder */
#define r_arg1h r13
#define r_arg1l r12	/* dividend, quotient */
#define r_arg2h r11   
#define r_arg2l r10	/* divisor */
#define r_cnt   r9	/* loop count */
#define r_tmp   r8

	.global	__udivmodsi4
	.func	__udivmodsi4
__udivmodsi4:
	xor	r_remh, r_remh		; clear reminder and carry
	xor	r_reml, r_reml
	mov	#33, r_cnt
	jmp	.L__udivmodsi4_ep
.L__udivmodsi4_loop:	
	rrc	r_tmp			; restore carry bit
	rlc	r_reml
	rlc	r_remh

	cmp	r_arg2h, r_remh		; is reminder < divisor ?
	jlo	.L__udivmodsi4_ep	; yes, skip correction
	jne	.L__udivmodsi4_ep
					; they equal. check LSBytes
	cmp	r_arg2l, r_reml
	jlo	.L__udivmodsi4_ep	; is reminder still < divisor ?

	sub	r_arg2l, r_reml		; adjust reminder
	subc	r_arg2h, r_remh

.L__udivmodsi4_ep:
	rlc	r_arg1l
	rlc	r_arg1h
	rlc	r_tmp
	dec	r_cnt			; this clobbers C bit.
	jnz	.L__udivmodsi4_loop
	ret
	.endfunc

#undef r_remh
#undef r_reml  
#undef r_arg1h
#undef r_arg1l
#undef r_arg2h
#undef r_arg2l

#undef r_cnt
#undef r_tmp

#endif /* defined (L_udivmodsi4) */


#if defined (L_divmodsi4)
#define r_remh  r15  
#define r_reml  r14     /* remainder */
#define r_arg1h r13
#define r_arg1l r12     /* dividend, quotient */
#define r_arg2h r11   
#define r_arg2l r10     /* divisor */   
#define r_cnt   r9      /* loop count */
#define r_tmp   r8

	.global	__divmodsi4
	.func	__divmodsi4
__divmodsi4:
	clr	r_tmp			; clear reg is cheaper than clr 2 bits.
	bit	#0x8000, r_arg1h		; save divident sign
	jz	.L__divmodsi4arg1pos
	inv	r_arg1h			; negate
	inv	r_arg1l
	inc	r_arg1l
	adc	r_arg1h
	bis	#4, r_tmp

.L__divmodsi4arg1pos:
	bit	#0x8000, r_arg2h		; check divisor sign
	jz	.L__divmodsi4arg2pos
	inv	r_arg2h			; negate
	inv	r_arg2l
	inc	r_arg2l
	adc	r_arg2h
	bis	#8, r_tmp		; save divisor sign

.L__divmodsi4arg2pos:
	
	call	#__udivmodsi4		; do unsigned division
	rrc	r_tmp			; restore carry and sign bits

	bit	#4, r_tmp		; is divident < 0 ?
	jz	.L__divmodsi4rem	; no. skip
	inv	r_reml			; negate remainder
	inv	r_remh
	inc	r_reml
	adc	r_remh

;;	bit	#8, r_tmp
;;	jc	.L__divmodsi4end
	inv	r_arg1l			; negate quotient
	inv	r_arg1h
	inc	r_arg1l
	adc	r_arg1h

.L__divmodsi4rem:
	bit	#8, r_tmp
	jz	.L__divmodsi4end
	inv	r_arg1l
	inv	r_arg1h
	inc	r_arg1l
	adc	r_arg1h

.L__divmodsi4end:
	ret
	.endfunc

#undef r_remh  
#undef r_reml  
#undef r_arg1h 
#undef r_arg1l
#undef r_arg2h
#undef r_arg2l

#undef r_cnt
#undef r_tmp

#endif /* defined (L_divmodsi4) */


/******* CRT support functions *********/

#if defined(L__stop_progExec__)
	.global __stop_progExec__
	.weak	__stop_progExec__
	.func  __stop_progExec__
__stop_progExec__:
	bis	#0xf0, r2
	jmp	__stop_progExec__
	.endfunc
#endif	/* #if defined(L__stop_progExec__) */

#if defined(L_reset_vector__)
/*****************************************************************
 * Initialize data: copy data from _etext to __data_start
 * Can be overwritten.
 *****************************************************************/
	.extern _etext
	.extern __data_start
	.extern _edata
	.extern __bss_start
	.extern __bss_end
	.extern __stack

	.section .init, "ax", @progbits

	.global	_reset_vector__

.func _reset_vector__
_reset_vector__:
	mov	#23168,	&288
	mov     #_etext,	r15     ; load r15 with end of .text segment
	mov     #__data_start,  r14     ; load ram start
	mov     #_edata,	r13     ; end of data segment
	cmp     r14,	    r13
	jeq     .Lend_of_data_loop 
;;	inc     r13
.Lcopy_data_loop:  
	/* copy data from @r15 to @r14 */
	mov.b   @r15+,  @r14	    ; move one byte
	inc     r14
	cmp     r13,    r14	     ; check if end of data reached
	jlo     .Lcopy_data_loop
.Lend_of_data_loop:

	mov     #__bss_start,   r15
	mov     #__bss_end,     r13
	cmp     r15,	    r13
	jeq     .Lend_of_bss_loop  
;;	inc     r13
.Lzero_bss:
	clr.b   @r15
	inc     r15 
	cmp     r13,    r15     ; check if r15 < r13
	jlo     .Lzero_bss
.Lend_of_bss_loop:
	br      #main	;	jump to main procedure
.endfunc

#endif



/********************** SHIFT LEFT ***********************/
/* QI */
#if defined(L_lshiftqi_1_6)
	.global	__lshiftqi_1_6
.func	__lshiftqi_1_6
__lshiftqi_1_6:
	rla.b	r15	; 1
	rla.b   r15 	; 2
	rla.b   r15 	; 3
	rla.b   r15 	; 4 
	rla.b   r15 	; 5
	rla.b   r15	; 6
	ret 
.endfunc
#endif

#if defined(L_lshiftqi_7)
	.global __lshiftqi_7
.func	__lshiftqi_7
__lshiftqi_7:
	rra.b	r15
	clr 	r15
	rrc.b	r15
	ret
.endfunc
#endif

#if defined(L_lshiftqi_cnt)
	.global __lshiftqi_cnt
.func	__lshiftqi_cnt
__lshiftqi_cnt:
	tst	r14
	jz	+6	; r14 - argument
	rla.b	r15
	dec	r14
	jnz	-4
	ret
.endfunc
#endif



/* HI */
#if defined(L_lshifthi_1_7)
	.global __lshifthi_1_7
.func	__lshifthi_1_7
__lshifthi_1_7:
	rla	r15
	rla     r15
	rla     r15
	rla     r15
	rla     r15
	rla     r15
	rla     r15
	ret
.endfunc
#endif

#if defined(L_lshifthi_8)
	.global	__lshifthi_8
.func	__lshifthi_8
__lshifthi_8:
	and.b	#-1, r15
	swpb	r15
	ret
.endfunc
#endif

#if defined(L_lshifthi_15)
	.global	__lshifthi_15
.func	__lshifthi_15
__lshifthi_15:
	rra	r15
	clr 	r15
	rrc	r15
	ret
.endfunc
#endif


#if defined(L_lshifthi_cnt)
	.global	__lshifthi_cnt
.func	__lshifthi_cnt
__lshifthi_cnt:
	tst	r14
	jz	+6	; r14 - argument
	rla	r15
	dec	r14
	jnz	-4
	ret
.endfunc
#endif




/* SI */

#if defined(L_lshiftsi_1_7)
	.global	__lshiftsi_1_7
.func	__lshiftsi_1_7
__lshiftsi_1_7:
	rla	r14
	rlc	r15
	rla	r14
	rlc	r15
	rla	r14
	rlc	r15
	rla	r14
	rlc	r15
	rla	r14
	rlc	r15
	rla	r14
	rlc	r15
	rla	r14
	rlc	r15
	ret
.endfunc
#endif


#if defined(L_lshiftsi_8)
	.global __lshiftsi_8
.func   __lshiftsi_8
__lshiftsi_8:
	xor.b	r14, r15
	xor 	r14, r15
	swpb	r15
	and.b	#-1, r14
	swpb	r14
	ret
.endfunc
#endif

#if defined(L_lshiftsi_16)
	.global __lshiftsi_16
.func	__lshiftsi_16
__lshiftsi_16:
	mov 	r14, r15
	clr 	r14
	ret
.endfunc
#endif

#if defined(L_lshiftsi_31)
	.global __lshiftsi_31
.func	__lshiftsi_31
__lshiftsi_31:
	rra	r14
	clr 	r14
	clr 	r15
	rrc	r15
	ret
.endfunc
#endif


#if defined(L_lshiftsi_cnt)
	.global	__lshiftsi_cnt
.func	__lshiftsi_cnt
__lshiftsi_cnt:
	tst	r13
	jz	+8	; r13 - argument
	rla	r14
	rlc	r15
	dec	r13
	jnz	-6
	ret
.endfunc
#endif


/* DI */

#if defined(L_lshiftdi_1_15)
	.global	__lshiftdi_1_15
.func	__lshiftdi_1_15
__lshiftdi_1_15:
	rla	r12	; 1
	rlc	r13
	rlc	r14
	rlc	r15
	rla	r12	;
	rlc	r13
	rlc	r14
	rlc	r15
	rla	r12	;
	rlc	r13
	rlc	r14
	rlc	r15
	rla	r12	;
	rlc	r13
	rlc	r14
	rlc	r15
	rla	r12	;
	rlc	r13
	rlc	r14
	rlc	r15
	rla	r12	;
	rlc	r13
	rlc	r14
	rlc	r15
	rla	r12	;
	rlc	r13
	rlc	r14
	rlc	r15
	rla	r12	;
	rlc	r13
	rlc	r14
	rlc	r15
	rla	r12	;
	rlc	r13
	rlc	r14
	rlc	r15
	rla	r12	;
	rlc	r13
	rlc	r14
	rlc	r15
	rla	r12	;
	rlc	r13
	rlc	r14
	rlc	r15
	rla	r12	;
	rlc	r13
	rlc	r14
	rlc	r15
	rla	r12	;
	rlc	r13
	rlc	r14
	rlc	r15
	rla	r12	;
	rlc	r13
	rlc	r14
	rlc	r15
	rla	r12	; 15
	rlc	r13
	rlc	r14
	rlc	r15
	ret
.endfunc
#endif


#if defined(L_lshiftdi_1_15_lhi)
	.global	__lshiftdi_1_15_lhi
.func	__lshiftdi_1_15_lhi
__lshiftdi_1_15_lhi:
	rla	r13
	rlc	r14
	rlc	r15
	rla	r13
	rlc	r14
	rlc	r15
	rla	r13
	rlc	r14
	rlc	r15
	rla	r13
	rlc	r14
	rlc	r15
	rla	r13
	rlc	r14
	rlc	r15
	rla	r13
	rlc	r14
	rlc	r15
	rla	r13
	rlc	r14
	rlc	r15
	rla	r13
	rlc	r14
	rlc	r15
	rla	r13
	rlc	r14
	rlc	r15
	rla	r13
	rlc	r14
	rlc	r15
	rla	r13
	rlc	r14
	rlc	r15
	rla	r13
	rlc	r14
	rlc	r15
	rla	r13
	rlc	r14
	rlc	r15
	rla	r13
	rlc	r14
	rlc	r15
	rla	r13
	rlc	r14
	rlc	r15
	ret
.endfunc
#endif


#if defined(L_lshiftdi_16)
	.global	__lshiftdi_16
.func	__lshiftdi_16
__lshiftdi_16:
	mov	r14, r15
	mov	r13, r14
	mov	r12, r13
	clr 	r12
	ret
.endfunc
#endif


#if defined(L_lshiftdi_32)
	.global __lshiftdi_32
.func	__lshiftdi_32
__lshiftdi_32:
	mov	r13, r15
	mov	r12, r14
	clr 	r12
	clr	r13
	ret
.endfunc
#endif

#if defined(L_lshiftsi_48)
	.global	__lshiftsi_48
.func	__lshiftsi_48
	mov	r12, r15
	clr	r12,
	clr 	r13
	clr 	r14
	ret
.endfunc
#endif

#if defined(L_lshiftdi_63)
	.global	__lshiftdi_63
.func	__lshiftdi_63
__lshiftdi_63:
	rra	r12
	clr 	r12
	clr 	r13
	clr 	r14
	clr 	r15
	rrc	r15
	ret
.endfunc
#endif


#if defined(L_lshiftdi_cnt)
	.global __lshiftdi_cnt
.func	__lshiftdi_cnt
__lshiftdi_cnt:
	tst	r11
	jz	+12	; r11 - argument
	rla	r12
	rlc	r13
	rlc	r14
	rlc	r15
	dec	r11
	jnz	-10
	ret
.endfunc
#endif


/********************** SHIFT RIGHT (signed) ***********************/
/* QI */
#if defined(L_rshiftqi_1_6)
	.global	__rshiftqi_1_6
.func	__rshiftqi_1_6
__rshiftqi_1_6:
	rra.b	r15	; 1
	rra.b   r15 	; 2
	rra.b   r15 	; 3
	rra.b   r15 	; 4 
	rra.b   r15 	; 5
	rra.b   r15	; 6
	ret 
.endfunc
#endif

#if defined(L_rshiftqi_7)
	.global __rshiftqi_7
.func	__rshiftqi_7
__rshiftqi_7:
	sxt	r15
	swpb	r15
	and.b	#-1, r15
	ret
.endfunc
#endif

#if defined(L_rshiftqi_cnt)
	.global __rshiftqi_cnt
.func	__rshiftqi_cnt
__rshiftqi_cnt:
	tst	r14
	jz	+6	; r14 - argument
	rra.b	r15
	dec	r14
	jnz	-4
	ret
.endfunc
#endif



/* HI */
#if defined(L_rshifthi_1_7)
	.global __rshifthi_1_7
.func	__rshifthi_1_7
__rshifthi_1_7:
	rra	r15
	rra     r15
	rra     r15
	rra     r15
	rra     r15
	rra     r15
	rra     r15
	ret
.endfunc
#endif

#if defined(L_rshifthi_8)
	.global	__rshifthi_8
.func	__rshifthi_8
__rshifthi_8:
	swpb    r15
	sxt 	r15
	ret
.endfunc
#endif

#if defined(L_rshifthi_15)
	.global	__rshifthi_15
.func	__rshifthi_15
__rshifthi_15:
	swpb	r15
	sxt 	r15
	swpb	r15
	sxt	r15
	ret
.endfunc
#endif


#if defined(L_rshifthi_cnt)
	.global	__rshifthi_cnt
.func	__rshifthi_15
__rshifthi_15:
	tst	r14
	jz	+6	; r14 - argument
	rra	r15
	dec	r14
	jnz	-4
	ret
.endfunc
#endif



/* SI */

#if defined(L_rshiftsi_1_7)
	.global	__rshiftsi_1_7
.func	__rshiftsi_1_7
__rshiftsi_1_7:
	rra	r15
	rrc	r14
	rra	r15
	rrc	r14
	rra	r15
	rrc	r14
	rra	r15
	rrc	r14
	rra	r15
	rrc	r14
	rra	r15
	rrc	r14
	rra	r15
	rrc	r14
	ret
.endfunc
#endif


#if defined(L_rshiftsi_8)
	.global __rshiftsi_8
.func   __rshiftsi_8
__rshiftsi_8:
	swpb	r14
	swpb	r15
	xor.b	r15, r14
	xor 	r15, r14
	sxt	r15
	swpb	r14
	ret
.endfunc
#endif

#if defined(L_rshiftsi_16)
	.global __rshiftsi_16
.func	__rshiftsi_16
__rshiftsi_16:
	mov 	r15, r14
	bit	#0x8000, r15
	jz	+4
	bis	#-1, r15
	jmp	+2
	clr	r15
	ret
.endfunc
#endif

#if defined(L_rshiftsi_31)
	.global __rshiftsi_31
.func	__rshiftsi_31
__rshiftsi_31:
	rla	r15
	jnc	+6
	mov 	#-1, r14
	mov	#-1,r15
	ret
	clr	r14
	clr 	r15
	ret
.endfunc
#endif


#if defined(L_rshiftsi_cnt)
	.global	__rshiftsi_cnt
.func	__rshiftsi_cnt
__rshiftsi_cnt:
	tst	r13
	jz	+8	; r13 - argument
	rra	r14
	rrc	r15
	dec	r13
	jnz	-6
	ret
.endfunc
#endif


/* DI */

#if defined(L_rshiftdi_1_15)
	.global	__rshiftdi_1_15
.func	__rshiftdi_1_15
__rshiftdi_1_15:
	rra	r15	; 1
	rrc	r14
	rrc	r13
	rrc	r12
        rra     r15     ; 2
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 3
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 4
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 5
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 6
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 7
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 8
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 9
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 10
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 11
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 12
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 13
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 14
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 15
        rrc     r14
        rrc     r13
        rrc     r12
	ret
.endfunc
#endif


#if defined(L_rshiftdi_16)
	.global	__rshiftdi_16
.func	__rshiftdi_16
__rshiftdi_16:
	mov	r13, r12
	mov	r14, r13
	mov	r15, r14
	swpb	r15
	sxt	r15
	swpb	r15
	sxt	r15
	ret
.endfunc
#endif


#if defined(L_rshiftdi_32)
	.global __rshiftdi_32
.func	__rshiftdi_32
__rshiftdi_32:
	mov	r15, r12
	mov	r14, r13
	swpb    r15
        sxt     r15
        swpb    r15
        sxt     r15
	mov	r15, r14
	ret
.endfunc
#endif

#if defined(L_rshiftsi_48)
	.global	__rshiftsi_48
.func	__rshiftsi_48
	mov	r15, r12
	swpb    r15
        sxt     r15
        swpb    r15
        sxt     r15
        mov     r15, r14
	mov	r15, r13
	ret
.endfunc
#endif

#if defined(L_rshiftdi_63)
	.global	__rshiftdi_63
.func	__rshiftdi_63
__rshiftdi_63:
        swpb    r15
        sxt     r15
        swpb    r15
        sxt     r15
        mov     r15, r14
        mov     r15, r13
	mov	r15, r12
	ret
.endfunc
#endif


#if defined(L_rshiftdi_cnt)
	.global __rshiftdi_cnt
.func	__rshiftdi_cnt
__rshiftdi_cnt:
	tst	r11
	jz	+12	; r11 - argument
	rra	r15
	rrc	r14
	rrc	r13
	rrc	r12
	dec	r11
	jnz	-10
	ret
.endfunc
#endif





/********************** SHIFT RIGHT (unsigned) ***********************/
/* QI */

/* the first issue is 'clrc' and 'rrc X'*/

#if defined(L_rlshiftqi_1_6)
	.global	__rlshiftqi_2_6
.func	__rlshiftqi_2_6
__rlshiftqi_2_6:
	rra.b	r15
	rra.b   r15 	; 2
	rra.b   r15 	; 3
	rra.b   r15 	; 4 
	rra.b   r15 	; 5
	rra.b   r15	; 6
	ret 
.endfunc
#endif

#if defined(L_rlshiftqi_7)
	.global __rlshiftqi_7
.func	__rlshiftqi_7
__rlshiftqi_7:
	rla.b	r15
	clr.b	r15
	rlc.b	r15
	ret
.endfunc
#endif

#if defined(L_rlshiftqi_cnt)
	.global __rlshiftqi_cnt
.func	__rlshiftqi_cnt
__rlshiftqi_cnt:
	tst	r14
	jz	+14	; r14 - argument
	clrc
	rrc.b	r15
	dec	r14
	jz	+6	; r14 - argument
	rra.b	r15
	dec	r14
	jnz	-4
	ret
.endfunc
#endif



/* HI */
#if defined(L_rlshifthi_1_7)
	.global __rlshifthi_1_7
.func	__rlshifthi_1_7
__rlshifthi_1_7:
	rra	r15
	rra     r15
	rra     r15
	rra     r15
	rra     r15
	rra     r15
	rra     r15
	ret
.endfunc
#endif

#if defined(L_rlshifthi_8)
	.global	__rlshifthi_8
.func	__rlshifthi_8
__rlshifthi_8:
	swpb    r15
	and.b 	#-1, r15
	ret
.endfunc
#endif

#if defined(L_rlshifthi_15)
	.global	__rlshifthi_15
.func	__rlshifthi_15
__rlshifthi_15:
	rla	r15
	clr 	r15
	rla	r15
	ret
.endfunc
#endif


#if defined(L_rlshifthi_cnt)
	.global	__rlshifthi_cnt
.func	__rlshifthi_cnt
__rlshifthi_cnt:
	tst	r14
	jz	+14	; r14 - argument
	clrc
	rrc	r15
	dec	r14
	jz	+6	; r14 - argument
	rra	r15
	dec	r14
	jnz	-4
	ret
.endfunc
#endif




/* SI */

#if defined(L_rlshiftsi_1_7)
	.global	__rlshiftsi_1_7
.func	__rlshiftsi_1_7
__rlshiftsi_1_7:
	rra	r15
	rrc	r14
	rra	r15
	rrc	r14
	rra	r15
	rrc	r14
	rra	r15
	rrc	r14
	rra	r15
	rrc	r14
	rra	r15
	rrc	r14
	rra	r15
	rrc	r14
	ret
.endfunc
#endif

#if defined(L_rlshiftsi_8)
	.global __rlshiftsi_8
.func   __rlshiftsi_8
__rlshiftsi_8:
	swpb	r14
	swpb	r15
	xor.b	r15, r14
	xor 	r15, r14
	and.b	#-1, r15
	ret
.endfunc
#endif

#if defined(L_rlshiftsi_16)
	.global __rlshiftsi_16
.func	__rlshiftsi_16
__rlshiftsi_16:
	mov 	r15, r14
	clr	r15
	ret
.endfunc
#endif

#if defined(L_rlshiftsi_31)
	.global __rlshiftsi_31
.func	__rlshiftsi_31
__rlshiftsi_31:
	rla	r15
	clr 	r14
	clr 	r15
	rrc	r14
	ret
.endfunc
#endif


#if defined(L_rlshiftsi_cnt)
	.global	__rlshiftsi_cnt
.func	__rlshiftsi_cnt
__rlshiftsi_cnt:
	tst	r13
	jz	+18	; r13 - argument
	clrc
	rrc	r15
	rrc	r14
	dec	r13
	jz	+8	; r13 - argument
	rra	r15
	rrc	r14
	dec	r13
	jnz	-6
	ret
.endfunc
#endif


/* DI */

#if defined(L_rlshiftdi_1_15)
	.global	__rlshiftdi_1_15
.func	__rlshiftdi_1_15
__rlshiftdi_1_15:
	rra	r15	; 1
	rrc	r14
	rrc	r13
	rrc	r12
        rra     r15     ; 2
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 3
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 4
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 5
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 6
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 7
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 8
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 9
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 10
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 11
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 12
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 13
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 14
        rrc     r14
        rrc     r13
        rrc     r12
        rra     r15     ; 15
        rrc     r14
        rrc     r13
        rrc     r12
	ret
.endfunc
#endif

#if defined(L_rlshiftdi_16)
	.global	__rlshiftdi_16
.func	__rlshiftdi_16
__rlshiftdi_16:
	mov	r13, r12
	mov	r14, r13
	mov	r15, r14
	clr	r15
	ret
.endfunc
#endif


#if defined(L_rlshiftdi_32)
	.global __rlshiftdi_32
.func	__rlshiftdi_32
__rlshiftdi_32:
	mov	r15, r12
	mov	r14, r13
        clr     r14
        clr     r15
	ret
.endfunc
#endif

#if defined(L_rlshiftsi_48)
	.global	__rlshiftsi_48
.func	__rlshiftsi_48
	mov	r15, r12
	clr 	r15
	clr 	r14
	clr	r13
	ret
.endfunc
#endif

#if defined(L_rlshiftdi_63)
	.global	__rlshiftdi_63
.func	__rlshiftdi_63
__rlshiftdi_63:
	rla	r15
	clr 	r15
	clr 	r14
	clr	r13
	clr	r12
	rlc	r12
	ret
.endfunc
#endif


#if defined(L_rlshiftdi_cnt)
	.global __rlshiftdi_cnt
.func	__rlshiftdi_cnt
__rlshiftdi_cnt:
	tst	r11
	jz	+26	; r11 - argument
	clrc
	rrc	r15
	rrc	r14
	rrc	r13
	rrc	r12
	dec	r11

	jz	+12	; r11 - argument
	rra	r15
	rrc	r14
	rrc	r13
	rrc	r12
	dec	r11
	jnz	-10

	ret
.endfunc
#endif






