#!/usr/bin/env python

# this script is for un*x/linux users. it creates hardlinks from this
# directory to a target source tree.
# this allows to check out the patch to a separate directory rather than
# mixing the original gcc/binutils sources with this patch directly.

# cliechti@gmx.net
# $Id: createlinks_gcc.py,v 1.4 2002-01-20 03:24:47 cliechti Exp $

import sys,os, string
VERSION = string.split("$Revision: 1.4 $")[1]   #extract CVS version

#this is the name of the directory of the gcc sources
#it starts with "./"
versiondir = './gcc-3.0/'

#first scan for files in the source directory
#leave out CVS dirs
files = []
dirs = []
def visitor(arg, dirname, names):
    dirname = dirname[len(versiondir):]
    for name in names:
        if name and name[-3:] != 'CVS' and (dirname[-3:] != 'CVS'):
            if os.path.isdir(name):
                dirs.append(os.path.join(dirname,name))
            else:
                files.append(os.path.join(dirname,name))

os.path.walk(versiondir, visitor, None)

#option(s) for the ln command
lnopts = '' #'-s' #to be used when symbolic links should be genereated, empty string for hardlinks

if len(sys.argv) < 2:
        print """USAGE: %s targetdir
        version: %s

        this script replaces the files that are in this patch with
        links to this directory.
        please specify the directory where the gcc sources are located
        i.e. where '%s' is.

        warning the original files in the target directory tree are
        deleted!!

        the following files will be modifed in the target directory:
""" % (sys.argv[0], VERSION, versiondir[2:])
        for f in files:
                print "\t\t%s" % os.path.join(versiondir[1:], f)

        print """\n\tscroll up if you don't see the help message ;-)"""
        sys.exit(1)

#make paths absolute so that the links are absolute too
source = os.path.abspath(versiondir)
target = os.path.abspath(os.path.join(sys.argv[1], versiondir))

print "source dir: %s" % source
print "target dir: %s" % target

if source == target:
        print "no, no! don't specify the source directory as target."
        sys.exit(1)

for d in dirs:
        tgt = os.path.join(target, d)
        print "dir: %s" % tgt
        try:
                if os.stat(tgt):
                        pass
        except OSError, msg:
                print "creating directory: %s" % tgt
                cmd = "mkdir %s " % (tgt)
                os.system(cmd)

for f in files:
        tgt = os.path.join(target, f)
        print "    %s" % tgt
        try:
                if os.stat(tgt):
                        os.system("rm %s" % tgt)
        except OSError, msg:
                print "the file %s did not existed." % tgt
                #its likely to be an error. maybe wrong target dir?" % tgt
                #sys.exit(1)    #we abort here because we dont want to destroy anything
        cmd = "ln %s %s %s" % (lnopts, os.path.join(source, f), tgt)
        os.system(cmd)

print "successful"
