#!/usr/bin/env python

import glob, os, stat

v = []
for f in glob.glob("*.calls"):
    mode = os.stat(f)[stat.ST_MODE]
    if stat.S_ISREG(mode):
        var = f.replace("-", "").replace("_", "").replace("+", "").split(".")[0]
        v.append(var)
        print '%s <- read.table("%s", col.names=c("count", "fun"))' % (var, f)

for var in v:
    print "cat('%s:', summary(%s$count), '\n')" % (var, var)

if glob.glob("analyze.output.sort"):
    print "postscript('calls-summary.eps', onefile=FALSE, horizontal=TRUE)"
    s = "boxplot("
    for l in open("analyze.output.sort").readlines():
        s += "%s$count, " % (l.strip())
    s = s.strip(", ") + ")"
    print s
    print "dev.off()"
