#!/usr/bin/env python2.4

import sys, re, subprocess

if len(sys.argv) == 1:
    print "Usage:", sys.argv[0], "[--calls] [--fun-stats] lib.so"
    sys.exit()

print_calls = "--calls" in sys.argv
print_fun_stats = "--fun-stats" in sys.argv
debug = "--debug" in sys.argv

objdump = subprocess.Popen(["objdump", "-j", ".text", "-d", sys.argv[-1]], stdout=subprocess.PIPE)
output = objdump.stdout.readlines()

funs = []
for line in output:
    r = re.match("[0-9a-f]* <([^>]*)>:", line.strip())
    if r:
        funs.append(r.group(1))

current_fun = None
fun_calls = 0
local_fun_calls = 0
local = {}
for line in output:
    r = re.match("[0-9a-f]* <([^>]*)>:", line.strip())
    if r:
        if current_fun != None:
            if print_fun_stats:
                print current_fun, "local:", local_fun_calls, "all:", fun_calls
        current_fun = r.group(1)
        fun_calls = 0
        local_fun_calls = 0
    r = re.search("call\s* [0-9a-f]* <([^>]*)>", line.strip())
    if r:
        fun = r.group(1).split("+")[0]
        fun_calls += 1
        if fun in funs:
            local_fun_calls += 1
            if fun not in local:
                local[fun] = []
            if fun != current_fun:
                local[fun].append(current_fun)
        if debug:
            print r.group(1), "|", fun
if print_fun_stats:
    print current_fun, "local:", local_fun_calls, "all:", fun_calls

if debug:
    print funs
if print_calls:
    for (fun, calls) in local.items():
        print len(local[fun]), fun
