#!/bin/bash -v

export mosesdecoder=/home/pkoehn/moses
export marian=/home/pkoehn/statmt/project/marian-browsermt
SRC=fr
TGT=ja

$marian/build/marian-decoder \
    -c config.yml \
    --vocabs vocab.$SRC$TGT.spm vocab.$SRC$TGT.spm \
    -i dev.tok.$SRC -o dev.out \
    --beam-size 1 --mini-batch 32 --maxi-batch 100 --maxi-batch-sort src -w 128 \
    --skip-cost --cpu-threads 1 \
    --quiet --quiet-translation --log dev.log

$mosesdecoder/scripts/generic/multi-bleu.perl ../data/dev.tok.$TGT < dev.out > dev.bleu
