"""Module containing skeleton methods/classes for decision tree implementation.

Note that I don't have the decision tree itself as its own object.
The decision tree is represented by its 'parameters', which is stored
in the Classifier object.
"""

class Node:

	def __init__(self, parent=None):
		self.parent = parent
		self.children = []
		if self.parent is not None:
			self.parent.children.append(self)
		"""There's other information that you want
		the node to store that should be defined here...
		"""


def predict(params, data):
	root_node = params['root_node']
	# now traverse the tree to get a classification and return it

def test(params, test_data):
	root_node = params['root_node']
	# now you can iterate through all the test_data 
	# and for each data vector call the predict method
	# and then compare the prediction to the actual 
	# classification to get accuracy, precision, recall statistics

def train(params, training_data):
	root_node = params['root_node'] # remember params is a dictionary
	# now use the training_data to build the rest of the tree
	# then you can call test on your training data to get
	# the accuracy, precision, recall





