#include <stdio.h>
#include <stdlib.h>
#include <Fourier.h>
#include <cmdLineParser.h>
#include <image.h>
#include <sstream>
#include <iomanip>
#include "gridIO.h"

using namespace std;
using namespace Util;
using namespace Image;

CmdLineParameter< string > Input( "in" ) , OutputExtension( "ext" , "jpg" ) , OutputHeader( "out" );
CmdLineParameter< int > Frames( "frames" );
CmdLineParameter< float > Duration( "duration" , 1 );
CmdLineReadable Double( "double" );

CmdLineReadable* params[] =
{
	&Input , &OutputHeader , &OutputExtension , &Frames , &Duration , &Double ,
	NULL
};

void ShowUsage( const string &ex )
{
	cout << "Usage " << ex << ":" << endl;
	cout << "\t --" << Input.name           << " <input image>"         << endl;
	cout << "\t --" << OutputHeader.name    << " <output image header>" << endl;
	cout << "\t --" << Frames.name          << " <number of frames>]"   << endl;
	cout << "\t[--" << Duration.name        << " <animation duration>=" << Frames.value      << "]" << endl;
	cout << "\t[--" << OutputExtension.name << " <extension name>=" << OutputExtension.value << "]" << endl;
	cout << "\t[--" << Double.name                                                           << "]" << endl;
}

template< typename Real >
void Execute( void )
{
	SquareGrid< Real > rgb[CHANNEL_COUNT];
	FourierKey2D< Real > keys[CHANNEL_COUNT] , tempKeys[CHANNEL_COUNT];
	FourierTransform< Real > xForm;

	// Read in the image and compute the Fourier transform of the different channels
	ReadImage( Input.value , rgb );
	for( int c=0 ; c<CHANNEL_COUNT ; c++ ) xForm.ForwardFourier( rgb[c] , keys[c] );

	// Allocate space for the temporary Fourier coefficients
	for( int c=0 ; c<CHANNEL_COUNT ; c++ ) tempKeys[c].resize( keys[c].resolution() );

	for( int f=0 ; f<Frames.value ; f++ )
	{
		Real t = (Real)( Duration.value * f ) / ( Frames.value - 1 );

		/*************************************************************/
		/* Do wave propagation here.                                 */
		/* Compute the values of the Fourier coefficients at time t, */
		/* and write them into the FourierKey2D objects tempKeys[].  */
		/*************************************************************/
		WARN( "functionality not implemented" );


		// Output the frame for this time-step
		stringstream outputNameStream;
		outputNameStream << OutputHeader.value << "." << setfill( '0' ) << setw( 3 ) << f << "." << OutputExtension.value;
		string outputName;
		outputNameStream >> outputName;
		WriteImage( outputName , rgb );
	}
}

int main( int argc , char *argv[] )
{
	CmdLineParse( argc-1 , argv+1 , params );
	if( !Input.set || !OutputHeader.set || !Frames.set ){ ShowUsage( argv[0] ) ; return EXIT_FAILURE; }
	try
	{
		if( Double.set ) Execute< double >();
		else             Execute< float  >();
	}
	catch( Exception e )
	{
		cout << e.what() << endl;
		return EXIT_FAILURE;
	}

	return EXIT_SUCCESS;
}
