#include <stdio.h>
#include <stdlib.h>
#include <Fourier.h>
#include <cmdLineParser.h>
#include <image.h>
#include "gridIO.h"

using namespace std;
using namespace Util;
using namespace Image;

CmdLineParameter< string > Input( "in" ) , Output( "out" );
CmdLineParameter< int > Rotations( "rotations" );
CmdLineReadable Double( "double" );

CmdLineReadable* params[] =
{
	&Input , &Output , &Rotations , &Double ,
	NULL
};

void ShowUsage( const string &ex )
{
	cout << "Usage " << ex << ":" << endl;
	cout << "\t --" << Input.name     << " <input image>"            << endl;
	cout << "\t --" << Output.name    << " <output image>"           << endl;
	cout << "\t[--" << Rotations.name << " <rotational symmetries>]" << endl;
	cout << "\t[--" << Double.name    << "]"                         << endl;
}

template< typename Real >
void Execute( void )
{
	SquareGrid< Real > rgb[CHANNEL_COUNT];

	// Read in the image and set the resolution
	ReadImage( Input.value , rgb );
	int res = rgb[0].resolution();

	if( Rotations.set && Rotations.value>0 )
	{
		// Set the size of the output array equal to the maximum value of k for which the k-fold symmetry will be computed.
		CircularArray< Real > out;
		out.resize( Rotations.value );

		/*********************************************************************************************/
		/* Do rotational symmetry detection here.                                                    */
		/* Set the k-th entry of the array "out" equal to the normalized measure of k-fold symmetry. */
		/* That is, the value in the k-th entry should alway be in the range [0,1].                  */
		/* It should be equal to 1 if and only if the image has full k-fold symmetric.               */
		/*********************************************************************************************/
		WARN( "functionality not implemented" );


		// Write out the histogram as an image.
		DrawHistogram( Output.value , out , res );
	}
	else
	{
		// Set the size of the output array equal to the resolution (this will be the number of lines about which reflective symmetry will be computed).
		CircularArray< Real > out;
		out.resize( res );

		/**************************************************************************************************************************************/
		/* Do reflective symmetry detection here.                                                                                             */
		/* Set the k-th entry of the array "out" equal to the normalized measure of reflective symmetry about the line with angle 2*PI*k/res. */
		/* That is, the value in the k-th entry should alway be in the range [0,1].                                                           */
		/* It should be equal to 1 if and only if the image is fully reflectively symmetric about the line with angle 2*PI*k/res.             */
		/**************************************************************************************************************************************/
		WARN( "functionality not implemented" );


		// Write the circular array of reflective symmetry values as an image.
		DrawCircularArray( Output.value , out , res );
	}
}
int main( int argc , char *argv[] )
{
	CmdLineParse( argc-1 , argv+1 , params );
	if( !Input.set || !Output.set ){ ShowUsage( argv[0] ) ; return EXIT_FAILURE; }
	try
	{
		if( Double.set ) Execute< double >();
		else             Execute< float  >();
	}
	catch( Exception e )
	{
		cout << e.what() << endl;
		return EXIT_FAILURE;
	}

	return EXIT_SUCCESS;
}
