#ifndef COMPLEX_INCLUDED
#define COMPLEX_INCLUDED

// This templated class represents a complex number, supporting the standard
// arithmetic operations
template< class Real >
class Complex
{
public:
	Real r,i;

	Complex(Real r=0,Real i=0);

	Complex operator + (Real r) const;
	Complex operator - (Real r) const;
	Complex operator * (Real r) const;
	Complex operator / (Real r) const;
	Complex& operator = (Real r);
	Complex& operator += (Real r);
	Complex& operator -= (Real r);
	Complex& operator *= (Real r);
	Complex& operator /= (Real r);

	
	Complex operator + (const Complex& c) const;
	Complex operator - (const Complex& c) const;
	Complex operator * (const Complex& c) const;
	Complex operator / (const Complex& c) const;
	Complex& operator = (const Complex& r);
	Complex& operator += (const Complex& c);
	Complex& operator -= (const Complex& c);
	Complex& operator *= (const Complex& c);
	Complex& operator /= (const Complex& c);

	Complex operator - (void) const;
	Complex conjugate(void) const;
	Real squareNorm(void) const;
};
#include "Complex.inl"
#endif // COMPLEX_INCLUDED
