#include <stdio.h>
#include <stdlib.h>
#include <Fourier.h>
#include <cmdLineParser.h>
#include <image.h>
#include "gridIO.h"

using namespace std;
using namespace Util;
using namespace Image;

CmdLineParameter< string > Input( "in" ) , Output( "out" );
CmdLineParameter< float > StandardDeviation( "stddev" , 0.8f );
CmdLineReadable Gradient( "gradient" ) , CLaplacian( "cLaplacian" ) , Smooth( "smooth" ) , DLaplacian( "dLaplacian" ) , Sharpen( "sharpen" ) , Double( "double" );

CmdLineReadable* params[] =
{
	&Input , &Output , &Smooth , &DLaplacian , &Sharpen , &Gradient , &CLaplacian , &StandardDeviation , &Double ,
	NULL
};

void ShowUsage( const string &ex )
{
	cout << "Usage " << ex << ":" << endl;
	cout << "\t --" << Input.name             << " <input image>"                                                    << endl;
	cout << "\t --" << Output.name            << " <output image>"                                                   << endl;
	cout << "\t[--" << StandardDeviation.name << " <Gaussian standard deviation>=" << StandardDeviation.value << "]" << endl;
	cout << "\t[--" << Smooth.name                                                                            << "]" << endl;
	cout << "\t[--" << DLaplacian.name                                                                        << "]" << endl;
	cout << "\t[--" << Sharpen.name                                                                           << "]" << endl;
	cout << "\t[--" << Gradient.name                                                                          << "]" << endl;
	cout << "\t[--" << CLaplacian.name                                                                        << "]" << endl;
	cout << "\t[--" << Double.name                                                                            << "]" << endl;
}

template< typename Real >
void Execute( void )
{
	SquareGrid< Real > grids[CHANNEL_COUNT];
	FourierKey2D< Real > keys[CHANNEL_COUNT];
	FourierTransform< Real > xForm;

	// Read in the red, green, and blue components of the image and get the Fourier coefficients
	ReadImage( Input.value ,grids );
	for( int c=0 ; c<CHANNEL_COUNT ; c++ ) xForm.ForwardFourier( grids[c] , keys[c] );

	// The standard deviation of the Gaussian
	Real standardDeviation = StandardDeviation.value;

	if( Smooth.set )
	{
		/***********************************/
		/* Do the Gaussian smoothing here. */
		/***********************************/
		WARN( "functionality not implemented" );
	}

	if( Gradient.set )
	{
		/***********************************************************************/
		/* Do the boundary detection using the magnitude of the gradient here. */
		/***********************************************************************/
		WARN( "functionality not implemented" );
	}

	if( CLaplacian.set )
	{
		/********************************************************************/
		/* Do the boundary detection using the (continuous) Laplacian here. */
		/********************************************************************/
		WARN( "functionality not implemented" );
	}

	if( DLaplacian.set )
	{
		/******************************************************************/
		/* Do the boundary detection using the (discrete) Laplacian here. */
		/* To do this you will need to compute the difference between the */
		/* original signal and the smoothed signal.                       */
		/******************************************************************/
		WARN( "functionality not implemented" );
	}

	if( Sharpen.set )
	{
		/************************************/
		/* Do the Gaussian sharpening here. */
		/************************************/
		WARN( "functionality not implemented" );
	}

	WriteImage( Output.value , grids );
}
int main( int argc , char *argv[] )
{
	CmdLineParse( argc-1 , argv+1 , params );
	if( !Input.set || !Output.set ){ ShowUsage( argv[0] ) ; return EXIT_FAILURE; }
	try
	{
		if( Double.set ) Execute< double >();
		else             Execute< float  >();
	}
	catch( Exception e )
	{
		cout << e.what() << endl;
		return EXIT_FAILURE;
	}

	return EXIT_SUCCESS;
}