#include <stdio.h>
#include <stdlib.h>
#include <Fourier.h>
#include <cmdLineParser.h>

using namespace std;
using namespace Util;

CmdLineParameter< string > Input( "in" );
CmdLineReadable Double( "double" );

CmdLineReadable* params[] =
{
	&Input , &Double ,
	NULL
};

void ShowUsage( const string &ex )
{
	cout << "Usage " << ex << ":" << endl;
	cout << "\t --" << Input.name  << " <input file>" << endl;
	cout << "\t[--" << Double.name << "]"             << endl;
}

template< typename Real >
void ForwardFFT( const CircularArray< Real > &values , Complex< Real > *coeffs )
{
	/****************************/
	/* Do the forward FFT here. */
	/****************************/
	WARN( "functionality not implemented" );
}

template< typename Real >
void InverseFFT( const Complex< Real > *coeffs , CircularArray< Real > &values )
{
	/****************************/
	/* Do the inverse FFT here. */
	/****************************/
	WARN( "functionality not implemented" );
}

template< typename Real >
void Execute( void )
{
	int res;
	CircularArray< Real > cIn , cOut;
	Complex< Real > *coeffs;

	// Read in the array
	{
		CircularArray< float > _cIn;
		_cIn.read( Input.value.c_str() );
		cIn.resize( _cIn.resolution() );
		for( int i=0 ; i<_cIn.resolution() ; i++ ) cIn(i) = (Real)_cIn(i);
	}
	res = cIn.resolution();
	cOut.resize( res );

	// Allocate space for the Fourier coefficients
	coeffs = new Complex< Real >[res];
	// Run the forward and inverse Fourier transforms
	ForwardFFT( cIn , coeffs );
	InverseFFT( coeffs , cOut );

	// Test that the Fourier coefficients satisfy the conjugacy relations (difference should be zero)
	{
		Real l2 = 0;
		for( int i=0 ; i<res ; i++ ) l2 += ( coeffs[i] - coeffs[(res-i)%res].conjugate() ).squareNorm();
		printf( "      Conjugacy Test: %g\n" , l2 );
	}

	// Compare the input and output (the difference should be zero)
	{
		printf( "Forward-Inverse Test: %g\n" , CircularArray< Real >::SquareDifference( cIn , cOut ) );
	}

	// Now compare the values of the Fourier coefficients (difference should be zero)
	{
		FourierKey1D< Real > key;
		FourierTransform< Real > xForm;

		xForm.ForwardFourier( cIn , key );

		Real l2 = 0;
		for( int i=0 ; i<key.size() ; i++ ) l2 += ( key(i) - coeffs[i] ).squareNorm();
		printf( "    Coefficient test: %g\n" , l2 );
	}
}

int main( int argc , char *argv[] )
{
	CmdLineParse( argc-1 , argv+1 , params );

	if( !Input.set ){ ShowUsage( argv[0] ) ; return EXIT_FAILURE; }
	try
	{
		if( Double.set ) Execute< double >();
		else             Execute< float  >();
	}
	catch( Exception e )
	{
		cout << e.what() << endl;
		return EXIT_FAILURE;
	}

	return EXIT_SUCCESS;
}