#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <limits>
#include "Fourier.h"
#include "SphericalGrid.h"
#include "cmdLineParser.h"
#include "gridIO.h"

using namespace std;
using namespace Util;

CmdLineParameter< string > Input( "in" ) , Output( "out" );
CmdLineReadable Double( "double" );

CmdLineReadable* params[] =
{
	&Input , &Output , &Double ,
	NULL
};

void ShowUsage( const string &ex )
{
	cout << "Usage " << ex << ":" << endl;
	cout << "\t --" << Input.name  << " <input spherical grid>"      << endl;
	cout << "\t --" << Output.name << " <output axial symmetry grid>" << endl;
	cout << "\t[--" << Double.name                             << "]" << endl;
}

template< typename Real >
void Execute( void )
{
	SphericalGrid< Real > in , out , temp;
	FourierKeyS2< Real > key , tempKey;
	HarmonicTransform< Real > hForm;

	// Read in the input spherical function
	ReadSphericalGrid( Input.value , in );

	// Kill off the 0th order frequency component and normalize so that the function has unit norm.
	hForm.ForwardFourier( in , key );
	key(0,0) = 0;
	hForm.InverseFourier( key , in );
	Real l = (Real)sqrt( in.squareNorm() );
	for( int i=0 ; i<in.resolution() ; i++ ) for( int j=0 ; j<in.resolution() ; j++ ) in(i,j) /= l;

	// Allocate memory for the axial symmetry descriptor
	out.resize( in.resolution() );

	// Compute the spherical harmonic transform
	hForm.ForwardFourier( in , key );

	// Allocate memory for the temporary key
	tempKey.resize( key.resolution() );

	/**************************************************************************/
	/* Compute the axial symmetry here.                                       */
	/* Set the axial symmetry descriptor values into the SphericalGrid "out". */
	/**************************************************************************/
	WARN( "functionality not implemented" );


	// Print out the maximal measure of axial symmetry
	Real maxSymmetry = -std::numeric_limits< Real >::infinity();
	for( int i=0 ; i<out.resolution() ; i++ ) for( int j=0 ; j<out.resolution() ; j++ ) maxSymmetry = std::max< Real >( maxSymmetry , out(i,j) );
	cout << "Axial symmetry: " << maxSymmetry << endl;

	// Write out the symmetry descriptor
	WriteSphericalGrid( Output.value , out );
}

int main( int argc , char *argv[] )
{
	CmdLineParse( argc-1 , argv+1 , params );
	if( !Input.set || !Output.set ){ ShowUsage( argv[0] ) ; return EXIT_FAILURE; }
	try
	{
		if( Double.set ) Execute< double >();
		else             Execute< float  >();
	}
	catch( Exception e )
	{
		cout << e.what() << endl;
		return EXIT_FAILURE;
	}

	return EXIT_SUCCESS;
}

