#include <stdio.h>
#include <stdlib.h>
#include <omp.h>
#include <sys/timeb.h>
#ifndef WIN32
#include <sys/time.h>
#endif // WIN32
#include <GL/glew.h>
#include <GL/glut.h>
#include <Util/CmdLineParser.h>
#include <Util/Algebra.h>
#include <Util/Ply.h>
#include <Util/camera.h>
#include <Util/Visualization.h>
#include "PLYViewer.inl"

cmdLineParameter< int > Width( "width" , 512 ) , Height( "height" , 512 );
cmdLineReadable NoLight( "noLight" ) , NoColor( "noColor" ) , Edges( "edges" ) , Boundary( "boundary" ) , Cull( "cull" );
cmdLineReadable* params[] = { &Width , &Height , &NoLight , &NoColor , &Edges , &Boundary , &Cull , NULL };

void ShowUsage( const char* ex )
{
	printf( "Usage %s: <input file name>\n" , ex );
	printf( "\t[--%s <screen width>=%d]\n" , Width.name , Width.value );
	printf( "\t[--%s <screen height>=%d]\n" , Height.name , Height.value );
	printf( "\t[--%s]\n" , NoLight.name );
	printf( "\t[--%s]\n" , NoColor.name );
	printf( "\t[--%s]\n" , Edges.name );
	printf( "\t[--%s]\n" , Boundary.name );
	printf( "\t[--%s]\n" , Cull.name );
}

struct SurfaceVisualizationWrapper
{
	static SurfaceVisualization sv;
	static void Idle        ( void )                                  { return sv.Idle(); }
	static void Display     ( void )                                  { return sv.Display(); }
	static void KeyboardFunc( unsigned char key , int x , int y )     { return sv.KeyboardFunc( key , x , y ); }
	static void SpecialFunc ( int key , int x , int y )               { return sv.SpecialFunc( key , x , y ); }
	static void Reshape     ( int w , int h )                         { return sv.Reshape( w , h ); }
	static void MouseFunc   ( int button , int state , int x , int y ){ return sv.MouseFunc( button , state , x , y ); }
	static void MotionFunc  ( int x , int y )                         { return sv.MotionFunc( x , y ); }
};
SurfaceVisualization SurfaceVisualizationWrapper::sv;

int main( int argc , char* argv[] )
{
	if( argc<2 ){ ShowUsage( argv[0] ) ; return EXIT_FAILURE; }
	cmdLineParse( argc-2 , argv+2 , params );

	SurfaceVisualization& sv = SurfaceVisualizationWrapper::sv;
	sv.init( argv[1] , false );
	sv.screenWidth = Width.value;
	sv.screenHeight = Height.value;
	sv.info.resize( 1 );
	sv.info[0] = new char[512];
	sv.useLight = !NoLight.set;
	sv.showColor = !NoColor.set;
	sv.showEdges = Edges.set;
	sv.showBoundary = Boundary.set;
	sv.cull = Cull.set;
	sprintf( sv.info[0] , "Vertices / Triangles: %d / %d" , sv.vertices.size() , sv.triangles.size() );

	glutInitDisplayMode( GLUT_DEPTH | GLUT_RGB | GLUT_DOUBLE );
	glutInitWindowSize( sv.screenWidth , sv.screenHeight );
	glutInit( &argc , argv );
	char windowName[1024];
	sprintf( windowName , "Surface Viewer: %s" , argv[1] );
	glutCreateWindow( windowName );

	if( glewInit()!=GLEW_OK ) fprintf( stderr , "[ERROR] glewInit failed\n" ) , exit( 0 );
	glutIdleFunc    ( SurfaceVisualizationWrapper::Idle );
	glutDisplayFunc ( SurfaceVisualizationWrapper::Display );
	glutReshapeFunc ( SurfaceVisualizationWrapper::Reshape );
	glutMouseFunc   ( SurfaceVisualizationWrapper::MouseFunc );
	glutMotionFunc  ( SurfaceVisualizationWrapper::MotionFunc );
	glutKeyboardFunc( SurfaceVisualizationWrapper::KeyboardFunc );
	glutSpecialFunc ( SurfaceVisualizationWrapper::SpecialFunc );

	glutMainLoop();
	return EXIT_SUCCESS;

}
