#ifndef HALF_EDGE_INCLUDED
#define HALF_EDGE_INCLUDED

#include <functional>

template< typename VData , typename HEData , typename FData >
struct HalfEdge
{
	struct V;
	struct HE;
	struct F;

	typedef std::function< void (        V * ) >       VFunctor;
	typedef std::function< void ( const  V * ) >  ConstVFunctor;
	typedef std::function< void (       HE * ) >      HEFunctor;
	typedef std::function< void ( const HE * ) > ConstHEFunctor;
	typedef std::function< void (        F * ) >       FFunctor;
	typedef std::function< void ( const  F * ) >  ConstFFunctor;

	struct V
	{
		V( VData d=VData() ) : data(d) , outHalfEdge(NULL) {}

		HE *outHalfEdge;
		VData data;

		void processHalfEdges(      HEFunctor processFunctor )       { for(       HE *he=outHalfEdge ; he ; he=he->opposite->next ){ processFunctor(he) ; if( he->opposite->next==outHalfEdge ) break; } }
		void processHalfEdges( ConstHEFunctor processFunctor ) const { for( const HE *he=outHalfEdge ; he ; he=he->opposite->next ){ processFunctor(he) ; if( he->opposite->next==outHalfEdge ) break; } }
		void processFaces    (      FFunctor processFunctor )       { processHalfEdges( [&](       HE *he ){ return processFunctor( he->face ); } ); }
		void processFaces    ( ConstFFunctor processFunctor ) const { processHalfEdges( [&]( const HE *he ){ return processFunctor( he->face ); } ); }
	};

	struct HE
	{
		HE( HEData d=HEData() ) : data(d) , opposite(NULL) , previous(NULL) , next(NULL) , startVertex(NULL) , face(NULL) {}

		HE *opposite , *previous , *next;
		V *startVertex;
		F *face;

		HEData data;
	};

	struct F
	{
		F( FData d=FData() ) : data(d) , halfEdge(NULL) {}

		HE *halfEdge;
		FData data;

		void processHalfEdges(      HEFunctor processFunctor )       { for(       HE *he=halfEdge ; he ; he=he->next ){ processFunctor(he) ; if( he->next==halfEdge ) break; } }
		void processHalfEdges( ConstHEFunctor processFunctor ) const { for( const HE *he=halfEdge ; he ; he=he->next ){ processFunctor(he) ; if( he->next==halfEdge ) break; } }
		void processVertices (      VFunctor processFunctor )       { processHalfEdges( [&](       HE *he ){ return processFunctor( he->startVertex ); } ); }
		void processVertices ( ConstVFunctor processFunctor ) const { processHalfEdges( [&]( const HE*he ){ return processFunctor( he->startVertex ); } ); }
	};
};
#endif // HALF_EDGE_INCLUDED