namespace Geometry
{
	///////////
	// Point //
	///////////
	template< unsigned int Dim , typename CType > CType &Point< Dim , CType >::operator[] ( unsigned int i ) { return coordinates[i]; }
	template< unsigned int Dim , typename CType > const CType &Point< Dim , CType >::operator[] ( unsigned int i ) const { return coordinates[i]; }
	template< unsigned int Dim , typename CType > bool Point< Dim , CType >::operator == ( const Point &p ) const
	{
		for( int d=0 ; d<Dim ; d++ ) if( coordinates[d]!=p.coordinates[d] ) return false;
		return true;
	}
	template< unsigned int Dim , typename CType > bool Point< Dim , CType >::operator != ( const Point &p ) const { return !( (*this)==p ); }
	template< unsigned int Dim , typename CType >
	std::ostream &operator << ( std::ostream &os , const Point< Dim , CType > &p )
	{
		os << "( ";
		for( int d=0 ; d<Dim-1 ; d++ ) std::cout << p[d] << " , ";
		return std::cout << p[Dim-1] << " )";
	}

	/////////////
	// Simplex // 
	/////////////
	template< unsigned int Dim > unsigned int &Simplex< Dim >::operator[]( unsigned int i ) { return indices[i]; }
	template< unsigned int Dim > const unsigned int &Simplex< Dim >::operator[]( unsigned int i ) const { return indices[i]; }
	template< unsigned int Dim >
	std::ostream &operator << ( std::ostream &os , const Simplex< Dim > &s )
	{
		os << "( ";
		for( int d=0 ; d<Dim-1 ; d++ ) std::cout << s[d] << " , ";
		return std::cout << s[Dim-1] << " )";
	}

	//////////////
	// Bisector //
	//////////////
	Bisector::Bisector( void ){}
	Bisector::Bisector( Geometry::Point2i p1 , Geometry::Point2i p2 )
	{
		midpoint2[0] = p1[0]+p2[0] , midpoint2[1] = p1[1]+p2[1];
		direction[0] = p2[1]-p1[1] , direction[1] = p1[0]-p2[0];
	}

	Geometry::Point2d Bisector::Intersection( Bisector b1 , Bisector b2 )
	{
		Geometry::Point2d intersection;

		////////////////////////////////
		// You need to implement this //
		////////////////////////////////
		ERROR_OUT( "Method undefined" );

		return intersection;
	}

	std::pair< Geometry::Point2d , double > Bisector::CircumcenterAndRadius( Geometry::Point2i p1 , Geometry::Point2i p2 , Geometry::Point2i p3 )
	{
		////////////////////////////////
		// You need to implement this //
		////////////////////////////////
		ERROR_OUT( "Method undefined" );
		return std::pair< Geometry::Point2d , double >( Geometry::Point2d() , 0 );
	}


	std::ostream &operator << ( std::ostream &os , const Bisector &b ){ return os << b.midpoint2 << " -> " << b.direction; }
};
