#include <stdio.h>
#include <stdlib.h>
#include "Fourier.h"
#include "SphericalGrid.h"
#include "cmdLineParser.h"
#include "gridIO.h"

using namespace std;
using namespace Util;

CmdLineParameter< string > Input( "in" ) , Output( "out" );
CmdLineParameter< float > Smooth( "smooth" , 0.f );
CmdLineReadable Double( "double" );

CmdLineReadable* params[] =
{
	&Input , &Output , &Smooth , &Double ,
	NULL
};

void ShowUsage( const string &ex )
{
	cout << "Usage " << ex << ":" << endl;
	cout << "\t --" << Input.name  << " <input spherical grid>"           << endl;
	cout << "\t --" << Output.name << " <output smoothed spherical grid>" << endl;
	cout << "\t --" << Smooth.name << " <smoothing parameter>"            << endl;
	cout << "\t[--" << Double.name                                 << "]" << endl;
}

template< typename Real >
void Execute( void )
{
	SphericalGrid< Real > grid;
	FourierKeyS2< Real > key;
	HarmonicTransform< Real > xForm;

	// Read in the input spherical function
	ReadSphericalGrid( Input.value , grid );

	// Compute the spherical harmonic transform
	xForm.ForwardFourier( grid , key );

	/*************************************************************/
	/* Smooth the spherical harmonic coefficients in "key" here. */
	/*************************************************************/
	WARN( "functionality not implemented" );


	// Compute the inverse spherical harmonic transform
	xForm.InverseFourier( key , grid );

	// Write out the smoothed function
	WriteSphericalGrid( Output.value , grid );
}

int main( int argc , char *argv[] )
{
	CmdLineParse( argc-1 , argv+1 , params );
	if( !Input.set || !Output.set ){ ShowUsage( argv[0] ) ; return EXIT_FAILURE; }
	try
	{
		if( Double.set ) Execute< double >();
		else             Execute< float  >();
	}
	catch( Exception e )
	{
		cout << e.what() << endl;
		return EXIT_FAILURE;
	}

	return EXIT_SUCCESS;
}

