#ifndef IMAGE_INCLUDED
#define IMAGE_INCLUDED

#include <stdio.h>
#include <string>
#include <stdexcept>

namespace Image
{
	/** This class represents a 4-channel, 32-bit, RGBA pixel. */
	class Pixel32
	{
	public:
		/** The red component of the pixel */
		unsigned char r;

		/** The green component of the pixel */
		unsigned char g;

		/** The blue component of the pixel */
		unsigned char b;

		/** The alpha component of the pixel */
		unsigned char a;

		/** The default constructor instantiates a pixel with 0 for the red, green and blue components, and 255 for the alpha.*/
		Pixel32( void );
	};

	/** This class represents an RGBA image with 8 bits per channel. */
	class Image32
	{
		/** The dimensions of the image */
		int _width , _height;

		/** The pixel values */
		Pixel32* _pixels;

		/** The method validates that the pixel index is valid */
		void _assertInBounds( int x , int y ) const;
	public:
		/** The default constructor */
		Image32( void );

		/** The copy constructor copies pixel values */
		Image32( const Image32& img );

		/** The move constructor moves pixel ownership from the input to the new object. */
		Image32( Image32&& img );

		/** The copy assignment operator copies pixel values */
		Image32& operator = ( const Image32& img );

		/** The move assignment operator moves pixel ownership from the input to the new object. */
		Image32& operator = ( Image32&& img );

		/** The destructor deallocates memory associated with the image. */
		~Image32( void );

		/** This method sets the dimension of the image. */
		void setSize( int width , int height );

		/** This method returns the width of the image */
		int width( void ) const;

		/** This method returns the height of the image */
		int height( void ) const;

		/** This method returns a reference to the indexed pixel.
		*** An exception is thrown if the index is out of bounds. */
		Pixel32& operator() ( int x , int y );

		/** This method returns a reference to the indexed pixel.
		*** An exception is thrown if the index is out of bounds. */
		const Pixel32& operator() ( int x , int y ) const;

		/** This method reads in an image from the specified file. It uses the file extension to determine if the file should be read in as a BMP file or as a JPEG file. */
		void read( std::string fileName );

		/** This method writes in an image out to the specified file. It uses the file extension to determine if the file should be written out as a BMP file or as a JPEG file. */
		void write( std::string fileName ) const;
	};
}
#endif // IMAGE_INCLUDED

