#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fftw3.h>
#include <Complex.h>



template< class Real >
SquareGrid< Real >::SquareGrid( void ){
	res=0;
	values=NULL;
}
template< class Real >
SquareGrid< Real >::~SquareGrid( void ){if(values){resize(0);}}
template< class Real >
int SquareGrid< Real >::read(const char* fileName){
	FILE* fp=fopen(fileName,"rb");
	if(!fp){return 0;}
	int r=read(fp);
	fclose(fp);
	return r;
}
template< class Real >
int SquareGrid< Real >::write(const char* fileName) const{
	FILE* fp=fopen(fileName,"wb");
	if(!fp){return 0;}
	int w=write(fp);
	fclose(fp);
	return w;
}
template< class Real >
int SquareGrid< Real >::read(FILE* fp){
	int io,r;
	io=int(fread(&r,sizeof(int),1,fp));
	if(!io){return 0;}
	resize(r);
	io=int(fread(values,sizeof(Real),res*res,fp));
	if(io==res*res){return 1;}
	else{return 0;}
}
template< class Real >
int SquareGrid< Real >::write(FILE* fp) const {
	int io;
	io=int(fwrite(&res,sizeof(int),1,fp));
	if(!io){return 0;}
	io=int(fwrite(values,sizeof(Real),res*res,fp));
	if(io==res*res){return 1;}
	else{return 0;}
}
template< class Real >
int SquareGrid< Real >::resolution( void ) const{return res;}

template<>
int SquareGrid<float>::resize(int r){
	if(r<0){return 0;}
	else{
		if(values){fftwf_free(values);}
		values=NULL;
		res=0;
		if(r){
			values=(float*)fftwf_malloc(sizeof(float)*r*r);
			if(!values){return 0;}
			else{res=r;}
			clear();
		}
		return 1;
	}
}

template<>
int SquareGrid<double>::resize(int r){
	if(r<0){return 0;}
	else{
		if(values){fftw_free(values);}
		values=NULL;
		res=0;
		if(r){
			values=(double*)fftw_malloc(sizeof(double)*r*r);
			if(!values){return 0;}
			else{res=r;}
			clear();
		}
		return 1;
	}
}

template<>
int SquareGrid<Complex<float> >::resize(int r){
	if(r<0){return 0;}
	else{
		if(values){fftwf_free(values);}
		values=NULL;
		res=0;
		if(r){
			values=(Complex<float>*)fftwf_malloc(sizeof(fftwf_complex)*r*r);
			if(!values){return 0;}
			else{res=r;}
			clear();
		}
		return 1;
	}
}

template<>
int SquareGrid<Complex<double> >::resize(int r){
	if(r<0){return 0;}
	else{
		if(values){fftw_free(values);}
		values=NULL;
		res=0;
		if(r){
			values=(Complex<double>*)fftw_malloc(sizeof(fftw_complex)*r*r);
			if(!values){return 0;}
			else{res=r;}
			clear();
		}
		return 1;
	}
}

template< class Real >
int SquareGrid< Real >::resize(int r){
	if(r<0){return 0;}
	else{
		if(values){delete[] values;}
		values=NULL;
		res=0;
		if(r){
			values=new Real[r*r];
			if(!values){return 0;}
			else{res=r;}
			clear();
		}
		return 1;
	}
}
template< class Real >
void SquareGrid< Real >::clear( void ){if(res){memset(values,0,sizeof(Real)*res*res);}}

template< class Real >
Real *SquareGrid< Real >::operator[] ( int i ){ return &values[i*res]; }

template< class Real >
Real &SquareGrid< Real >::operator() ( int i , int j )
{
	if( i<0 ) i = res-((-i)%res);
	i %= res;
	if( j<0 ) j = res-((-j)%res);
	j%=res;
	return values[i*res+j];
}

template< class Real >
Real SquareGrid< Real >::operator() ( Real x , Real y )
{
	int x1,y1;
	Real dx,dy;

	if( x<0 ) x1 = -int(-x)-1;
	else      x1 =  int( x);
	if( y<0 ) y1 = -int(-y)-1;
	else      y1 =  int( y);

	dx=x-x1;
	dy=y-y1;
	return (*this)(x1,y1)*(Real(1.0)-dx)*(Real(1.0)-dy)+(*this)(x1+1,y1)*dx*(Real(1.0)-dy)+(*this)(x1,y1+1)*(Real(1.0)-dx)*dy+(*this)(x1+1,y1+1)*dx*dy;
}
template< class Real >
Real SquareGrid< Real >::squareNorm( void ) const{return Dot(*this,*this);}
template< class Real >
Real SquareGrid< Real >::SquareDifference(const SquareGrid& g1,const SquareGrid& g2){return g1.squareNorm()+g2.squareNorm()-2*Dot(g1,g2);}
template< class Real >
Real SquareGrid< Real >::Dot(const SquareGrid& g1,const SquareGrid& g2){
	Real d=0;
	if(g1.res != g2.res){
		fprintf(stderr,"Could not compare arrays of different sizes: %d != %d\n",g1.res,g2.res);
		exit(0);
	}
	for(int i=0;i<g1.res*g1.res;i++){d+=g1.values[i]*g2.values[i];}
	return Real(d/(g1.res*g1.res)*4*PI*PI);
}