/***************************************************************************************************
 * File:         $URL: https://svn.bolitho.us/Library/Trunk/Src/Graphics/DirectX/VertexShader.cpp $
 * Author:       $Author: OBTUSE\matthew $
 * Revision:     $Rev: 1588 $
 * Last Updated: $Date: 2008-08-23 09:36:02 -0700 (Sat, 23 Aug 2008) $
 * 
 * 
 * Copyright (c) 2004-2007, Matthew G Bolitho
 * All rights reserved.
 *
 *
 * Microsoft Reference License (Ms-RL)
 *   
 * This license governs use of the accompanying software. If you use the software, you accept 
 * this license. If you do not accept the license, do not use the software.
 *
 * 1. Definitions
 *  - The terms "reproduce," "reproduction" and "distribution" have the same meaning here as under 
 *    U.S. copyright law.
 *  - "You" means the licensee of the software.
 *  - "Your company" means the company you worked for when you downloaded the software.
 *  - "Reference use" means use of the software within your company as a reference, in read only 
 *    form, for the sole purposes of debugging your products, maintaining your products, or 
 *    enhancing the interoperability of your products with the software, and specifically excludes 
 *    the right to distribute the software outside of your company.
 *  - "Licensed patents" means any Licensor patent claims which read directly on the software as 
 *    distributed by the Licensor under this license.
 * 
 * 2. Grant of Rights
 *  (A) Copyright Grant- Subject to the terms of this license, the Licensor grants you a non-transferable, 
 *      non-exclusive, worldwide, royalty-free copyright license to reproduce the software for reference use.
 *  (B) Patent Grant- Subject to the terms of this license, the Licensor grants you a non-transferable,
 *      non-exclusive, worldwide, royalty-free patent license under licensed patents for reference use.
 * 
 * 3. Limitations
 *  (A) No Trademark License - This license does not grant you any rights to use the Licensor's name
 *      logo, or trademarks.
 *  (B) If you begin patent litigation against the Licensor over patents that you think may apply 
 *      to the software (including a cross-claim or counterclaim in a lawsuit), your license to the 
 *      software ends automatically.
 *  (C) The software is licensed "as-is." You bear the risk of using it. The Licensor gives no express 
 *      warranties, guarantees or conditions. You may have additional consumer rights under your local 
 *      laws which this license cannot change. To the extent permitted under your local laws, the 
 *      Licensor excludes the implied warranties of merchantability, fitness for a particular purpose 
 *      and non-infringement.
 *
 ***************************************************************************************************/




#include "CodeLibrary.hpp"

#if defined(USE_DIRECTX9)

#include "Graphics/DirectX.hpp"
#include "Graphics/DirectX/VertexShader.hpp"
#include "Graphics/DirectX/DirectXException.hpp"

using namespace Bolitho;
using namespace Bolitho::Graphics;
using namespace Bolitho::Graphics::DirectX;

//------------------------------------------------------------------------------------------------------------------------------------------------------
ImplementRuntimeType(Bolitho::Graphics::DirectX,VertexShader,Shader);
//------------------------------------------------------------------------------------------------------------------------------------------------------
LPCTSTR VertexShader::Profile11 = TEXT("vs_1_1");
LPCTSTR VertexShader::Profile20 = TEXT("vs_2_0");
LPCTSTR VertexShader::Profile2a = TEXT("vs_2_a");
LPCTSTR VertexShader::Profile30 = TEXT("vs_3_0");
//------------------------------------------------------------------------------------------------------------------------------------------------------
VertexShader::VertexShader( LPDIRECT3DDEVICE9 pDevice, CONST Buffer<DWORD>& Tokens ) 
  : Shader( pDevice, Tokens )
{
  HRESULT Result = pDevice->CreateVertexShader(m_Buffer.GetBuffer(), &m_pVertexShader );
  if (FAILED(Result))
    throw RenderException( this, Result );
}
//------------------------------------------------------------------------------------------------------------------------------------------------------
VertexShader::VertexShader( LPDIRECT3DDEVICE9 pDevice, CONST DWORD* pTokens, SIZE_T Length ) 
  : Shader( pDevice, pTokens, Length )
{
  HRESULT Result = pDevice->CreateVertexShader(m_Buffer.GetBuffer(), &m_pVertexShader );
  if (FAILED(Result))
    throw RenderException( this, Result );
}
//------------------------------------------------------------------------------------------------------------------------------------------------------
VertexShader::VertexShader( LPDIRECT3DDEVICE9 pDevice, LPCSTR Source, LPCSTR FunctionName, LPCSTR Profile, DWORD Flags )
  : Shader( pDevice, Source, FunctionName, Profile, Flags )
{
  HRESULT Result = pDevice->CreateVertexShader(m_Buffer.GetBuffer(), &m_pVertexShader );
  if (FAILED(Result))
    throw RenderException( this, Result );
}
//------------------------------------------------------------------------------------------------------------------------------------------------------
VertexShader::~VertexShader()
{
  if (m_pVertexShader)
  {
    m_pVertexShader->Release();
    m_pVertexShader = 0;
  }
}
//------------------------------------------------------------------------------------------------------------------------------------------------------

#endif