#ifndef UTIL_INCLUDED
#define UTIL_INCLUDED
#include <sys/timeb.h>
#ifndef WIN32
#include <sys/time.h>
#endif // WIN32
#ifdef WIN32
#include <Windows.h>
#include <Psapi.h>
#endif // WIN32

inline double Time( void )
{
#ifdef WIN32
	struct _timeb t;
	_ftime( &t );
	return double(t.time)+double(t.millitm)/1000.0;
#else // WIN32
	struct timeval t;
	gettimeofday(&t,NULL);
	return t.tv_sec+(double)t.tv_usec/1000000;
#endif // WIN32
}
#ifdef WIN32
int PeakWorkingSetMB( void )
{
	HANDLE h = GetCurrentProcess();
	PROCESS_MEMORY_COUNTERS pmc;
	if( (int)GetProcessMemoryInfo( h , &pmc , sizeof(pmc) ) ) return (int)(pmc.PeakWorkingSetSize>>20);
	else return 0;
}
#else // !WIN32

#ifndef __APPLE__               // Linux variants

unsigned int PeakWorkingSetMB( void )
{
	int peak = 0;
	FILE* f = fopen( "/proc/self/status" , "r" );

	if( f )
	{
        char line[512];
 
		while( fgets( line , 511 , f )!=NULL )
		{
			int value;
            if( sscanf( line , " VmPeak: %d kB " , &value ) ) peak = ( (long long)(value) )>>10;
        }
        fclose( f );
	}
	return peak;
}

#else // __APPLE__: has no "/proc" pseudo-file system

#pragma message ( "[WARNING] No PeakWorkingSetMB for apple" )
unsigned int PeakWorkingSetMB( void ){ return 0; }
#endif // !__APPLE__  
#endif // WIN32

#endif // UTIL_INCLUDED