#ifndef TIMER_INCLUDED
#define TIMER_INCLUDED
#include <Util/Util.h>
#ifdef WIN32
struct Timer
{
	struct _timeb t;
	Timer( void ){ _ftime( &t ); }
	void reset( void ){ _ftime( &t ); }
	double elapsed( void ) const
	{
		struct _timeb _t;
		_ftime( &_t );
		return (double)(_t.time-t.time)+(double)(_t.millitm-t.millitm)/1000.;
	}
};
#else // !WIN32
struct Timer
{
	struct timeval t;
	Timer( void ){ gettimeofday( &t , NULL ); }
	void reset( void ){ gettimeofday( &t , NULL ); }
	double elapsed( void ) const
	{
		struct timeval _t;
		gettimeofday( &_t , NULL );
		return (double)(_t.tv_sec-t.tv_sec)+(double)(_t.tv_usec-t.tv_usec)/1000000;
	}
};
#endif // WIN32
#endif // TIMER_INCLUDED