/*
Copyright (c) 2008, Michael Kazhdan
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/
#include "Time.h"
/*
void PrintError(DWORD err)
{
	char error[1024];
	int sz=FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, err, 0,(LPTSTR)error, 1024, NULL);
	if(sz>0)
	{
		fprintf(stderr,"\t");
		for(int i=0;i<sz;i++)	printf("%c",error[2*i]);
	}
}
void PrintError(void)	{PrintError(GetLastError());}
*/
inline DWORD MySetFilePointer(HANDLE hFile,LONGLONG distanceToMove)
{
	LARGE_INTEGER li;
	li.QuadPart=distanceToMove;
	DWORD ret=SetFilePointer(hFile,li.LowPart,&li.HighPart,FILE_BEGIN);
	if(ret==INVALID_SET_FILE_POINTER)
	{
		PrintError();
		exit(0);
	}
	return ret;
}
void MyReadFile(HANDLE hFile,LPVOID lpBuffer,DWORD nNumberOfBytesToRead,LPDWORD lpNumberOfBytesRead,LPOVERLAPPED lpOverlapped)
{
//	if(!ReadFile(hFile,lpBuffer,nNumberOfBytesToRead,lpNumberOfBytesRead,lpOverlapped) || *lpNumberOfBytesRead!=nNumberOfBytesToRead)
	if(!ReadFile(hFile,lpBuffer,nNumberOfBytesToRead,lpNumberOfBytesRead,lpOverlapped))
	{
		fprintf(stderr,"Failed to read file: %d / %d\n",*lpNumberOfBytesRead,nNumberOfBytesToRead);
		PrintError();
		exit(0);
	}
}
void MyWriteFile(HANDLE hFile,LPCVOID lpBuffer,DWORD nNumberOfBytesToWrite,LPDWORD lpNumberOfBytesWritten,LPOVERLAPPED lpOverlapped)
{
	if(!WriteFile(hFile,lpBuffer,nNumberOfBytesToWrite,lpNumberOfBytesWritten,lpOverlapped))
	{
		fprintf(stderr,"Failed to write file\n");
		PrintError();
		exit(0);
	}
}

///////////////////////////
// BufferedStreamingGrid //
///////////////////////////
BufferedStreamingGrid::BufferedStreamingGrid(StreamingGrid* sg)
{
	data=NULL;
	current=0;
	this->sg=sg;
}
BufferedStreamingGrid::~BufferedStreamingGrid(void)
{
	if(data)	free(data);
	data=NULL;
	sg=NULL;
}
int BufferedStreamingGrid::rows		(void) const	{return sg->rows();}
int BufferedStreamingGrid::rowSize	(void) const	{return sg->rowSize();}
//void BufferedStreamingGrid::reset	(bool read,bool write,int minWindowSize)
void BufferedStreamingGrid::reset	(bool read,int minWindowSize)
{
	this->read=read;
	win=minWindowSize<rows() ? minWindowSize : rows();

	if(data)	free(data), data=NULL;
	data=malloc(rowSize()*win);
	if(!data)
	{
		fprintf(stderr,"Failed to allocate memory for BufferedStreamingGrid\n");
		exit(0);
	}
	sg->reset(read,1);
	if(read)
	{
		for(int w=0;w<win;w++)
		{
			void* row=(*sg)[w];
			memcpy((void*)(long long(data)+w*rowSize()),row,rowSize());
			sg->advance();
		}
	}
	current=0;
}
void BufferedStreamingGrid::advance(void)
{
	if(read)
	{
		current++;
		if(current+win-1<rows())
		{
			sg->advance();
			memcpy((void*)(long long(data)+((current+win-1)%win)*rowSize()),(*sg)[current+win-1],rowSize());
		}
	}
	else
	{
		if(current-win+1>=0)
		{
			memcpy((*sg)[current-win+1],(void*)(long long(data)+((current-win+1)%win)*rowSize()),rowSize());
			sg->advance();
		}
		current++;
	}
}
void* BufferedStreamingGrid::operator[]	(int idx)
{
#if ASSERT_MEMORY_ACCESS
	if(idx<0 || idx<current || idx>=rows() || idx>=current+win)
		fprintf(stderr,"BufferedStreamingGrid: Index out of bounds: %d\t[%d, %d]\t%d x %d\n",idx,current,current+win,rowSize(),rows()), exit(0);
#endif // ASSERT_MEMORY_ACCESS
	return (void*)(long long(data)+(idx%win)*rowSize());
}
/*
class BufferedStreamingGrid
{
	void* data;
	int currentRow;
	StreamingGrid* sg;
public:
	void	advance			(void);
};
*/
//////////////////////
// MemoryBackedGrid //
//////////////////////
MemoryBackedGrid::MemoryBackedGrid(void* data,int rs,int r)
{
	_del=false;
	_r=r, _rs=rs;
	_data=data;
}
MemoryBackedGrid::MemoryBackedGrid(int rs,int r)
{
	_del=true;
	_r=r, _rs=rs;
	_data=malloc(r*rs);
	if(!_data)	fprintf(stderr,"Failed to allocate\n"), exit(0);
}
MemoryBackedGrid::~MemoryBackedGrid(void)
{
	if(_del)	free(_data);
	_data=NULL;
	_r=_rs=0;
}
int	MemoryBackedGrid::rows(void) const
{
	return _r;
}
int MemoryBackedGrid::rowSize(void) const
{
	return _rs;
}
void* MemoryBackedGrid::operator[](int idx)
{
#if ASSERT_MEMORY_ACCESS
	if(idx<0 || idx>=_r)	fprintf(stderr,"Index out of bounds: %d [%d, %d]\n",idx,0,_r), exit(0);
#endif // ASSERT_MEMORY_ACCESS
	return (void*)(LONGLONG(_data)+_rs*idx);
}
