/*
Copyright (c) 2008, Michael Kazhdan
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/
template<class Real>
Color<Real>::Color(void)					{ c[0]=c[1]=c[2]=0;   }
template<class Real>
Color<Real>::Color(Real clr)				{ c[0]=c[1]=c[2]=clr; }
template<class Real>
Color<Real>::Color(Real c0,Real c1,Real c2)	{ c[0]=c0;	c[1]=c1;	c[2]=c2; }

template<class Real>
template<class Real2>
Color<Real>::Color(const Color<Real2>& clr)
{
	c[0]=Real(clr[0]);
	c[1]=Real(clr[1]);
	c[2]=Real(clr[2]);
}

template<class Real>
Real Color<Real>::luminance(void) const		{return Real(c[0]*0.3+c[1]*0.59+c[2]*0.11);}

template<class Real>
Real& Color<Real>::operator[] (int i) {return c[i];}
template<class Real>
const Real& Color<Real>::operator[] (int i) const {return c[i];}

template<class Real>
Color<Real> Color<Real>::operator + (const Color& clr) const { return Color(c[0]+clr.c[0],c[1]+clr.c[1],c[2]+clr.c[2]); };
template<class Real>
Color<Real> Color<Real>::operator - (const Color& clr) const { return Color(c[0]-clr.c[0],c[1]-clr.c[1],c[2]-clr.c[2]); };
template<class Real>
Color<Real> Color<Real>::operator - (void            ) const { return Color(-c[0],-c[1],-c[2]); };
template<class Real>
Color<Real> Color<Real>::operator * (const Real& s   ) const { return Color(c[0]*s,c[1]*s,c[2]*s); };
template<class Real>
Color<Real> Color<Real>::operator / (const Real& s   ) const { return Color(c[0]/s,c[1]/s,c[2]/s); };
// An essential method for getting the conjugate gradient solver to work
template<class Real>
Real  Color<Real>::operator * (const Color& clr) const { return c[0]*clr[0]+c[1]*clr[1]+c[2]*clr[2]; };

template<class Real>
Color<Real>& Color<Real>::operator += (const Color& clr)
{
	c[0]+=clr.c[0];
	c[1]+=clr.c[1];
	c[2]+=clr.c[2];
	return *this;
};
template<class Real>
Color<Real>& Color<Real>::operator -= (const Color& clr)
{
	c[0]-=clr.c[0];
	c[1]-=clr.c[1];
	c[2]-=clr.c[2];
	return *this;
};
template<class Real>
Color<Real>& Color<Real>::operator *= (const Real& s)
{
	c[0]*=s;
	c[1]*=s;
	c[2]*=s;
	return *this;
};
template<class Real>
Color<Real>& Color<Real>::operator /= (const Real& s)
{
	c[0]/=s;
	c[1]/=s;
	c[2]/=s;
	return *this;
};
template<class Real>
bool Color<Real>::operator == (const Color<Real>& clr)	const
{
	return c[0]==clr[0] && c[1]==clr[1] && c[2]==clr[2];
}
template<class Real>
bool Color<Real>::operator != (const Color<Real>& clr) const
{
	return c[0]!=clr[0] || c[1]!=clr[1] || c[2]!=clr[2];
}
