#include <windows.h>
#include <stdio.h>

/* constants for the biCompression field */
#define BI_RGB        0L
#define BI_RLE8       1L
#define BI_RLE4       2L
#define BI_BITFIELDS  3L

/* Some magic numbers */

#define BMP_BF_TYPE 0x4D42
/* word BM */

#define BMP_BF_OFF_BITS 54
/* 14 for file header + 40 for info header (not sizeof(), but packed size) */

#define BMP_BI_SIZE 40
/* packed size of info header */

struct BMPWriteInfo
{
	FILE* fp;
	int width;
};

void* BMPInitWrite(char* fileName,int width,int height,int quality)
{
	BMPWriteInfo* info=(BMPWriteInfo*)malloc(sizeof(BMPWriteInfo));
	info->fp=fopen(fileName,"wb");
	if(!info->fp)	fprintf(stderr,"Failed to open: %s\n",fileName)	,	exit(0);
	info->width=width;

	BITMAPFILEHEADER bmfh;
	BITMAPINFOHEADER bmih;
	int lineLength;

	lineLength = width * 3;	/* RGB */
	if ((lineLength % 4) != 0)	lineLength = (lineLength / 4 + 1) * 4;
	/* Write file header */

	bmfh.bfType = BMP_BF_TYPE;
	bmfh.bfSize = BMP_BF_OFF_BITS + lineLength * height;
	bmfh.bfReserved1 = 0;
	bmfh.bfReserved2 = 0;
	bmfh.bfOffBits = BMP_BF_OFF_BITS;

	fwrite(&bmfh,sizeof(BITMAPFILEHEADER),1,info->fp);

	bmih.biSize = BMP_BI_SIZE;
	bmih.biWidth = width;
	bmih.biHeight = -height;
	bmih.biPlanes = 1;
	bmih.biBitCount = 24;		/* RGB */
	bmih.biCompression = BI_RGB;	/* RGB */
	bmih.biSizeImage = lineLength * (DWORD) bmih.biHeight;	/* RGB */
	bmih.biXPelsPerMeter = 2925;
	bmih.biYPelsPerMeter = 2925;
	bmih.biClrUsed = 0;
	bmih.biClrImportant = 0;

	fwrite(&bmih,sizeof(BITMAPINFOHEADER),1,info->fp);

	return info;
}
void BMPWriteRow(void* pixels,void* v)
{
	unsigned char* _pixels = (unsigned char*) pixels;
	BMPWriteInfo* info=(BMPWriteInfo*)v;
	for(int x=0;x<info->width;x++)
	{
		unsigned char tmp=_pixels[x*3];
		_pixels[x*3+0]=_pixels[x*3+2];
		_pixels[x*3+2]=tmp;
	}
	fwrite(pixels,sizeof(unsigned char),info->width*3,info->fp);
	int nbytes=info->width*3;
	while ((nbytes % 4) != 0) {
		putc(0,info->fp);
		nbytes++;
	}
}
void BMPFinalizeWrite(void* v)
{
	BMPWriteInfo* info=(BMPWriteInfo*)v;
	fclose(info->fp);
	free(info);
}
