/*
Copyright (c) 2008, Michael Kazhdan
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/
#ifndef LAPLACIAN_SOLVER_INCLUDED
#define LAPLACIAN_SOLVER_INCLUDED
#include "StreamingSolver.h"

enum
{
	CONJUGATE_GRADIENTS,
	JACOBI,
	GAUSS_SEIDEL,
	SOLVER_COUNT
};

template<class Real,int Type,int Degree,int Channels>
class MultigridSolver
{
public:
	static const int VERBOSE,FULL_VERBOSE;
	static int verbose;
	static void SolveInCore(Vector<Real>& in,Vector<Real>& out,int w,int h,int multiGrid,int minMGRes,int solverType,bool symmetric,double average[Channels],int cWidth,int cHeight,int fWidth,int fHeight);

	template<class PartialType>
	static void SolveInCore(StreamingGrid* dX,StreamingGrid* dY,Vector<Real>& out,int w,int h,int multiGrid,int minMGRes,int solverType,bool symmetric,double average[Channels],int cWidth,int cHeight,int fWidth,int fHeight,int iters=1);

	template<class PartialType,class StorageType>
	static void SolveOutOfCore(StreamingGrid* dX,StreamingGrid* dY,StreamingGrid* out,int w,int h,int multiGrid,int inCoreRes,int minMGRes,int solverType,bool symmetric,double average[Channels],int cWidth,int cHeight,int iters=1);
	template<class PartialType,class StorageType>
	static void SolveOutOfCore(StreamingGrid* dX,StreamingGrid* dY,StreamingGrid* out,int w,int h,int multiGrid,int inCoreRes,int minMGRes,int solverType,bool symmetric,double average[Channels],int cWidth,int cHeight,
		std::vector<StreamingGrid*>& inStreams,std::vector<StreamingGrid*>& outStreams,int iters=1);
};
#include "MultigridSolver.inl"
#endif // LAPLACIAN_SOLVER_INCLUDED