/*
Copyright (c) 2008, Michael Kazhdan
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/
#ifndef LAPLACIAN_MATRIX_2D_INCLUDED
#define LAPLACIAN_MATRIX_2D_INCLUDED
#include "LaplacianMatrix/LaplacianMatrix1D.h"

//////////////////////
// FiniteElements2D //
//////////////////////
template<class Real,int Type1,int Degree1,int Type2=Type1,int Degree2=Degree1>
class FiniteElements2D
{
public:
	template<class Data>
	static bool UpSample(Vector<Data>& in,Vector<Data>& out,int lowD1,int lowD2,int& highD1,int& highD2);
	template<class Data>
	static bool DownSample(Vector<Data>& in,Vector<Data>& out,int highD1,int highD2,int& lowD1,int& lowD2);
	template<class Data>
	static bool UpSample(const Data* in,Data* out,int lowD1,int lowD2,int& highD1,int& highD2);
	template<class Data>
	static bool DownSample(const Data* in,Data* out,int highD1,int highD2,int& lowD1,int& lowD2);

	static bool UpSample(const Real* in,Real* out,int lowD1,int lowD2,int& highD1,int& highD2,int Channels);
	static bool DownSample(const Real* in,Real* out,int highD1,int highD2,int& lowD1,int& lowD2,int Channels);

	static bool IsUpSamplable(int lowD1,int lowD2,int& highD1,int& highD2);
	static bool IsDownSamplable(int highD1,int highD2,int& lowD1,int& lowD2);
	static bool UpSampleMatrix(SparseMatrix<Real>& M,int lowD1,int lowD2,int& highD1,int& highD2);
	static bool DownSampleMatrix(SparseMatrix<Real>& M,int highD1,int highD2,int& lowD1,int& lowD2);

	static bool TensorMatrix(int inDim1,int outDim1,const SparseMatrix<Real>& m1,const SparseMatrix<Real>& m2,SparseMatrix<Real>& m);
	template<class Data>
	static bool TensorMatrixMultiply(int inDim1,int outDim1,int inDim2,int outDim2,const SparseMatrix<Real>& m1,const SparseMatrix<Real>& m2,const Vector<Data>& in,Vector<Data>& out);
	template<class Data>
	static bool TensorMatrixMultiply(int inDim1,int outDim1,int inDim2,int outDim2,const SparseMatrix<Real>& m1,const SparseMatrix<Real>& m2,const Data* in,Data* out);
	static bool TensorMatrixMultiply(int inDim1,int outDim1,int inDim2,int outDim2,const SparseMatrix<Real>& m1,const SparseMatrix<Real>& m2,const Real* in,Real* out,int Channels);
	static bool DotProductMatrix(int dim1,int dim2,SparseMatrix<Real>& m);
	static bool DotProductMatrix(int dim1,int dim2,SparseMatrix<Real>& m,Real min1,Real max1,Real min2,Real max2);
	static bool LaplacianMatrix(int dim1,int dim2,SparseMatrix<Real>& m,bool weakForm,bool negate=false);
	static bool LaplacianMatrix(int dim1,int dim2,SparseMatrix<Real>& m,Real min1,Real max1,Real min2,Real max2,bool weakForm,bool negate=false);
	static void StripDiagonal(const SparseMatrix<Real>& M,Vector<MatrixEntry<Real> >& D,bool clearDiagonal);

	template<class Data>
	static bool Gradient(const Vector<Data>& in,Vector<Data>& dX,Vector<Data>& dY,int w,int h,int& ww,int& hh);
	template<class Data>
	static bool Laplacian(const Vector<Data>& dX,const Vector<Data>& dY,Vector<Data>& out,int w,int h,int ww,int hh);

	class FullDivergenceStencil
	{
	public:
		class DivergenceStencil
		{
		public:
			Real values1[2*Degree1][2*Degree2+1];
			Real values2[2*Degree1+1][2*Degree2];
		};
		DivergenceStencil caseTable[2*Degree1+1][2*Degree2+2];
	};
	static bool DivergenceStencil(int dim1,int dim2,FullDivergenceStencil& s);

	class FullMatrixStencil
	{
	public:
		class MatrixStencil
		{
		public:
			Real values[2*Degree1+1][2*Degree2+1];
		};
		MatrixStencil caseTable[2*Degree1+1][2*Degree2+1];
	};
	static bool LaplacianStencil(int dim1,int dim2,FullMatrixStencil& s,bool weakForm,bool negate=false);

	class FullProlongationStencil
	{
	public:
		class ProlongationStencil
		{
		public:
			Real values[Degree1+2][Degree2+2];
		};
		ProlongationStencil caseTable[2*Degree1+1][2*Degree2+1];
	};
	static bool ProlongationStencil(int lowD1,int lowD2,FullProlongationStencil &s,int& highD1,int& highD2);
#if NEW_LAPLACIAN_CODE
	class FullRestrictionStencil
	{
	public:
		class RestrictionStencil
		{
		public:
			Real values[(Degree1+3)>>1][(Degree2+3)>>1];
		};
		RestrictionStencil caseTable[2*Degree1+2][2*Degree2+2];
	};
	static bool RestrictionStencil(int highD1,int highD2,FullRestrictionStencil &s,int& lowD1,int& lowD2);
#endif // NEW_LAPLACIAN_CODE
};
#include "LaplacianMatrix/LaplacianMatrix2D.inl"
#endif // LAPLACIAN_MATRIX_INCLUDED