/*
Copyright (c) 2005, Michael Kazhdan
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/
#include "marchingCubes.h"

const int MarchingCubes::edges[256]={
	   0,  265,  515,  778, 1030, 1295, 1541, 1804, 
	2060, 2309, 2575, 2822, 3082, 3331, 3593, 3840, 
	 400,  153,  915,  666, 1430, 1183, 1941, 1692, 
	2460, 2197, 2975, 2710, 3482, 3219, 3993, 3728, 
	 560,  825,   51,  314, 1590, 1855, 1077, 1340, 
	2620, 2869, 2111, 2358, 3642, 3891, 3129, 3376, 
	 928,  681,  419,  170, 1958, 1711, 1445, 1196, 
	2988, 2725, 2479, 2214, 4010, 3747, 3497, 3232, 
	1120, 1385, 1635, 1898,  102,  367,  613,  876, 
	3180, 3429, 3695, 3942, 2154, 2403, 2665, 2912, 
	1520, 1273, 2035, 1786,  502,  255, 1013,  764, 
	3580, 3317, 4095, 3830, 2554, 2291, 3065, 2800, 
	1616, 1881, 1107, 1370,  598,  863,   85,  348, 
	3676, 3925, 3167, 3414, 2650, 2899, 2137, 2384, 
	1984, 1737, 1475, 1226,  966,  719,  453,  204, 
	4044, 3781, 3535, 3270, 3018, 2755, 2505, 2240, 
	2240, 2505, 2755, 3018, 3270, 3535, 3781, 4044, 
	 204,  453,  719,  966, 1226, 1475, 1737, 1984, 
	2384, 2137, 2899, 2650, 3414, 3167, 3925, 3676, 
	 348,   85,  863,  598, 1370, 1107, 1881, 1616, 
	2800, 3065, 2291, 2554, 3830, 4095, 3317, 3580, 
	 764, 1013,  255,  502, 1786, 2035, 1273, 1520, 
	2912, 2665, 2403, 2154, 3942, 3695, 3429, 3180, 
	 876,  613,  367,  102, 1898, 1635, 1385, 1120, 
	3232, 3497, 3747, 4010, 2214, 2479, 2725, 2988, 
	1196, 1445, 1711, 1958,  170,  419,  681,  928, 
	3376, 3129, 3891, 3642, 2358, 2111, 2869, 2620, 
	1340, 1077, 1855, 1590,  314,   51,  825,  560, 
	3728, 3993, 3219, 3482, 2710, 2975, 2197, 2460, 
	1692, 1941, 1183, 1430,  666,  915,  153,  400, 
	3840, 3593, 3331, 3082, 2822, 2575, 2309, 2060, 
	1804, 1541, 1295, 1030,  778,  515,  265,    0, 
};
const int MarchingCubes::triangles[256][16] = {
	{ -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  0,   3,   8,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  1,   0,   9,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  8,   9,   1,   8,   1,   3,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  2,   1,  10,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  0,   3,   8,   2,   1,  10,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  9,  10,   2,   9,   2,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  8,   9,  10,   8,  10,   2,   8,   2,   3,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  3,   2,  11,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 11,   8,   0,  11,   0,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  1,   0,   9,   3,   2,  11,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 11,   8,   9,  11,   9,   1,  11,   1,   2,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 10,  11,   3,  10,   3,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 10,  11,   8,  10,   8,   0,  10,   0,   1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  9,  10,  11,   9,  11,   3,   9,   3,   0,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  8,   9,  10,   8,  10,  11,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  8,   7,   4,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  7,   4,   0,   3,   7,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  7,   4,   8,   1,   0,   9,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  1,   3,   7,   9,   1,   7,   4,   9,   7,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  2,   1,  10,   8,   7,   4,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  2,   1,  10,   7,   4,   0,   3,   7,   0,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  7,   4,   8,   9,  10,   2,   9,   2,   0,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  9,  10,   4,   4,  10,   2,   4,   2,   7,   7,   2,   3,  -1,  -1,  -1, -1},
	{  2,  11,   3,   4,   8,   7,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  4,   0,   2,   7,   4,   2,  11,   7,   2,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  1,   0,   9,   3,   2,  11,   8,   7,   4,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  1,   4,   9,   1,   7,   4,   1,   2,   7,   2,  11,   7,  -1,  -1,  -1, -1},
	{  4,   8,   7,   3,   1,  10,   3,  10,  11,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  1,   4,   0,   7,   4,   1,  10,   7,   1,  11,   7,  10,  -1,  -1,  -1, -1},
	{  9,  10,  11,   9,  11,   3,   9,   3,   0,   8,   7,   4,  -1,  -1,  -1, -1},
	{  9,  10,   4,   4,  10,   7,  11,   7,  10,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  9,   4,   5,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  5,   9,   4,   3,   8,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  0,   4,   5,   0,   5,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  5,   1,   3,   4,   5,   3,   8,   4,   3,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  5,   9,   4,   1,  10,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  2,   1,  10,   0,   3,   8,   9,   4,   5,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  2,   0,   4,   2,   4,   5,   2,   5,  10,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  2,   5,  10,   2,   4,   5,   2,   3,   4,   3,   8,   4,  -1,  -1,  -1, -1},
	{  3,   2,  11,   9,   4,   5,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  5,   9,   4,   0,   2,  11,   0,  11,   8,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  3,   2,  11,   4,   5,   1,   0,   4,   1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  4,  11,   8,   2,  11,   4,   5,   2,   4,   1,   2,   5,  -1,  -1,  -1, -1},
	{  5,   9,   4,  11,   3,   1,  10,  11,   1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 10,  11,   8,  10,   8,   0,  10,   0,   1,   9,   4,   5,  -1,  -1,  -1, -1},
	{ 10,  11,   5,   5,  11,   3,   5,   3,   4,   4,   3,   0,  -1,  -1,  -1, -1},
	{ 10,  11,   5,   5,  11,   4,   8,   4,  11,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  5,   9,   8,   7,   5,   8,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  3,   7,   5,   0,   3,   5,   9,   0,   5,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  7,   5,   1,   8,   7,   1,   0,   8,   1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  3,   7,   5,   1,   3,   5,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  1,  10,   2,   8,   7,   5,   9,   8,   5,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  3,   7,   5,   0,   3,   5,   9,   0,   5,  10,   2,   1,  -1,  -1,  -1, -1},
	{  8,   2,   0,  10,   2,   8,   7,  10,   8,   5,  10,   7,  -1,  -1,  -1, -1},
	{ 10,   7,   5,   2,   7,  10,   7,   2,   3,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  2,  11,   3,   7,   5,   9,   7,   9,   8,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  0,   2,   9,   9,   2,  11,   9,  11,   5,   5,  11,   7,  -1,  -1,  -1, -1},
	{  7,   5,   1,   8,   7,   1,   0,   8,   1,   2,  11,   3,  -1,  -1,  -1, -1},
	{  2,   5,   1,  11,   5,   2,   5,  11,   7,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 10,  11,   3,  10,   3,   1,   5,   9,   8,   7,   5,   8,  -1,  -1,  -1, -1},
	{  0,   7,   9,   9,   7,   5,   7,   0,   1,   1,  10,  11,   1,  11,   7, -1},
	{  8,   5,   0,   7,   5,   8,   3,   0,   5,  10,  11,   3,   5,  10,   3, -1},
	{ 10,  11,   7,  10,   7,   5,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 10,   5,   6,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  0,   3,   8,  10,   5,   6,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  9,   1,   0,  10,   5,   6,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 10,   5,   6,   3,   8,   9,   1,   3,   9,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  6,   2,   1,   6,   1,   5,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  0,   3,   8,   5,   6,   2,   1,   5,   2,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  6,   2,   0,   6,   0,   9,   6,   9,   5,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  5,   8,   9,   3,   8,   5,   6,   3,   5,   2,   3,   6,  -1,  -1,  -1, -1},
	{  2,  11,   3,   6,  10,   5,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  6,  10,   5,   8,   0,   2,  11,   8,   2,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  3,   2,  11,   1,   0,   9,  10,   5,   6,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 11,   8,   9,  11,   9,   1,  11,   1,   2,  10,   5,   6,  -1,  -1,  -1, -1},
	{  3,   1,   5,   3,   5,   6,   3,   6,  11,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 11,   8,   6,   6,   8,   0,   6,   0,   5,   5,   0,   1,  -1,  -1,  -1, -1},
	{  3,   6,  11,   3,   5,   6,   3,   0,   5,   0,   9,   5,  -1,  -1,  -1, -1},
	{ 11,   8,   6,   6,   8,   5,   9,   5,   8,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 10,   5,   6,   8,   7,   4,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 10,   5,   6,   4,   0,   3,   4,   3,   7,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 10,   5,   6,   8,   7,   4,   1,   0,   9,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  1,   3,   7,   9,   1,   7,   4,   9,   7,   6,  10,   5,  -1,  -1,  -1, -1},
	{  8,   7,   4,   6,   2,   1,   6,   1,   5,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  6,   2,   1,   6,   1,   5,   7,   4,   0,   3,   7,   0,  -1,  -1,  -1, -1},
	{  6,   2,   0,   6,   0,   9,   6,   9,   5,   4,   8,   7,  -1,  -1,  -1, -1},
	{  9,   3,   4,   4,   3,   7,   3,   9,   5,   5,   6,   2,   5,   2,   3, -1},
	{  8,   7,   4,  10,   5,   6,   3,   2,  11,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  4,   0,   2,   7,   4,   2,  11,   7,   2,  10,   5,   6,  -1,  -1,  -1, -1},
	{  1,   0,   9,   3,   2,  11,   8,   7,   4,  10,   5,   6,  -1,  -1,  -1, -1},
	{ 10,   5,   6,   1,   4,   9,   1,   7,   4,   1,   2,   7,   2,  11,   7, -1},
	{  3,   1,   5,   3,   5,   6,   3,   6,  11,   7,   4,   8,  -1,  -1,  -1, -1},
	{ 11,   1,   6,   6,   1,   5,   1,  11,   7,   7,   4,   0,   7,   0,   1, -1},
	{  8,   7,   4,   3,   6,  11,   3,   5,   6,   3,   0,   5,   0,   9,   5, -1},
	{  9,   5,  11,  11,   5,   6,  11,   7,   9,   7,   4,   9,  -1,  -1,  -1, -1},
	{  6,  10,   9,   4,   6,   9,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  3,   8,   0,   4,   6,  10,   4,  10,   9,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  0,   4,   6,   0,   6,  10,   0,  10,   1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  4,   6,   8,   8,   6,  10,   8,  10,   3,   3,  10,   1,  -1,  -1,  -1, -1},
	{  4,   6,   2,   4,   2,   1,   4,   1,   9,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  4,   6,   2,   4,   2,   1,   4,   1,   9,   0,   3,   8,  -1,  -1,  -1, -1},
	{  0,   4,   6,   0,   6,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  4,   6,   8,   8,   6,   3,   2,   3,   6,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  2,  11,   3,   9,   4,   6,  10,   9,   6,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 11,   8,   0,  11,   0,   2,   6,  10,   9,   4,   6,   9,  -1,  -1,  -1, -1},
	{  0,   4,   6,   0,   6,  10,   0,  10,   1,   2,  11,   3,  -1,  -1,  -1, -1},
	{  1,   4,  10,  10,   4,   6,   4,   1,   2,   2,  11,   8,   2,   8,   4, -1},
	{ 11,   4,   6,   9,   4,  11,   3,   9,  11,   1,   9,   3,  -1,  -1,  -1, -1},
	{  1,  11,   0,   0,  11,   8,  11,   1,   9,   9,   4,   6,   9,   6,  11, -1},
	{  0,   4,   3,   3,   4,  11,   6,  11,   4,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 11,   8,   4,  11,   4,   6,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 10,   9,   8,   6,  10,   8,   7,   6,   8,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  0,  10,   9,   6,  10,   0,   3,   6,   0,   7,   6,   3,  -1,  -1,  -1, -1},
	{ 10,   1,   6,   1,   0,   6,   0,   7,   6,   0,   8,   7,  -1,  -1,  -1, -1},
	{  6,   3,   7,  10,   3,   6,   3,  10,   1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  6,   2,   7,   7,   2,   1,   7,   1,   8,   8,   1,   9,  -1,  -1,  -1, -1},
	{  0,   7,   9,   3,   7,   0,   1,   9,   7,   6,   2,   1,   7,   6,   1, -1},
	{  6,   2,   7,   7,   2,   8,   0,   8,   2,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  6,   2,   3,   6,   3,   7,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 10,   9,   8,   6,  10,   8,   7,   6,   8,   3,   2,  11,  -1,  -1,  -1, -1},
	{  6,   9,   7,  10,   9,   6,  11,   7,   9,   0,   2,  11,   9,   0,  11, -1},
	{  3,   2,  11,  10,   1,   6,   1,   0,   6,   0,   7,   6,   0,   8,   7, -1},
	{  1,  11,   7,   2,  11,   1,   7,  10,   1,   7,   6,  10,  -1,  -1,  -1, -1},
	{ 11,   1,   6,   3,   1,  11,   7,   6,   1,   9,   8,   7,   1,   9,   7, -1},
	{  7,   6,  11,   9,   0,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  6,  11,   0,   0,  11,   3,   0,   8,   6,   8,   7,   6,  -1,  -1,  -1, -1},
	{  7,   6,  11,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 11,   6,   7,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  6,   7,  11,   0,   3,   8,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  1,   0,   9,  11,   6,   7,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  6,   7,  11,   8,   9,   1,   8,   1,   3,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 10,   2,   1,  11,   6,   7,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  0,   3,   8,   2,   1,  10,  11,   6,   7,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 11,   6,   7,   0,   9,  10,   2,   0,  10,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  8,   9,  10,   8,  10,   2,   8,   2,   3,  11,   6,   7,  -1,  -1,  -1, -1},
	{  3,   2,   6,   7,   3,   6,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  0,   2,   6,   8,   0,   6,   7,   8,   6,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  1,   0,   9,   6,   7,   3,   2,   6,   3,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  8,   9,   7,   7,   9,   1,   7,   1,   6,   6,   1,   2,  -1,  -1,  -1, -1},
	{  7,   3,   1,   7,   1,  10,   7,  10,   6,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  0,   7,   8,   0,   6,   7,   0,   1,   6,   1,  10,   6,  -1,  -1,  -1, -1},
	{  6,   9,  10,   0,   9,   6,   7,   0,   6,   3,   0,   7,  -1,  -1,  -1, -1},
	{  8,   9,   7,   7,   9,   6,  10,   6,   9,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  4,   8,  11,   6,   4,  11,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  6,   4,   0,  11,   6,   0,   3,  11,   0,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  1,   0,   9,   8,  11,   6,   8,   6,   4,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  9,   6,   4,  11,   6,   9,   1,  11,   9,   3,  11,   1,  -1,  -1,  -1, -1},
	{ 10,   2,   1,   4,   8,  11,   6,   4,  11,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  6,   4,   0,  11,   6,   0,   3,  11,   0,   1,  10,   2,  -1,  -1,  -1, -1},
	{  9,  10,   2,   9,   2,   0,   4,   8,  11,   6,   4,  11,  -1,  -1,  -1, -1},
	{ 11,   4,   3,   6,   4,  11,   2,   3,   4,   9,  10,   2,   4,   9,   2, -1},
	{  2,   6,   4,   3,   2,   4,   8,   3,   4,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  0,   2,   6,   4,   0,   6,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  2,   6,   4,   3,   2,   4,   8,   3,   4,   9,   1,   0,  -1,  -1,  -1, -1},
	{  9,   6,   4,   1,   6,   9,   6,   1,   2,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  6,   4,  10,  10,   4,   8,  10,   8,   1,   1,   8,   3,  -1,  -1,  -1, -1},
	{  1,   4,   0,  10,   4,   1,   4,  10,   6,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  3,   6,   8,   8,   6,   4,   6,   3,   0,   0,   9,  10,   0,  10,   6, -1},
	{  9,  10,   6,   9,   6,   4,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 11,   6,   7,   9,   4,   5,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  9,   4,   5,  11,   6,   7,   0,   3,   8,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 11,   6,   7,   5,   1,   0,   5,   0,   4,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  5,   1,   3,   4,   5,   3,   8,   4,   3,  11,   6,   7,  -1,  -1,  -1, -1},
	{ 11,   6,   7,   9,   4,   5,   2,   1,  10,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 11,   6,   7,   9,   4,   5,   2,   1,  10,   0,   3,   8,  -1,  -1,  -1, -1},
	{  2,   0,   4,   2,   4,   5,   2,   5,  10,   6,   7,  11,  -1,  -1,  -1, -1},
	{ 11,   6,   7,   2,   5,  10,   2,   4,   5,   2,   3,   4,   3,   8,   4, -1},
	{  9,   4,   5,   7,   3,   2,   7,   2,   6,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  0,   2,   6,   8,   0,   6,   7,   8,   6,   5,   9,   4,  -1,  -1,  -1, -1},
	{  0,   4,   5,   0,   5,   1,   3,   2,   6,   7,   3,   6,  -1,  -1,  -1, -1},
	{  4,   1,   8,   5,   1,   4,   7,   8,   1,   2,   6,   7,   1,   2,   7, -1},
	{  7,   3,   1,   7,   1,  10,   7,  10,   6,   5,   9,   4,  -1,  -1,  -1, -1},
	{  9,   4,   5,   0,   7,   8,   0,   6,   7,   0,   1,   6,   1,  10,   6, -1},
	{  6,   3,  10,   7,   3,   6,   5,  10,   3,   0,   4,   5,   3,   0,   5, -1},
	{ 10,   6,   8,   8,   6,   7,   8,   4,  10,   4,   5,  10,  -1,  -1,  -1, -1},
	{  9,   8,  11,   5,   9,  11,   6,   5,  11,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  9,   0,   5,   0,   3,   5,   3,   6,   5,   3,  11,   6,  -1,  -1,  -1, -1},
	{  8,  11,   0,   0,  11,   6,   0,   6,   1,   1,   6,   5,  -1,  -1,  -1, -1},
	{ 11,   1,   3,   6,   1,  11,   1,   6,   5,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  9,   8,  11,   5,   9,  11,   6,   5,  11,   2,   1,  10,  -1,  -1,  -1, -1},
	{  2,   1,  10,   9,   0,   5,   0,   3,   5,   3,   6,   5,   3,  11,   6, -1},
	{ 10,   0,   5,   2,   0,  10,   6,   5,   0,   8,  11,   6,   0,   8,   6, -1},
	{  5,   2,   3,  10,   2,   5,   3,   6,   5,   3,  11,   6,  -1,  -1,  -1, -1},
	{  3,   9,   8,   5,   9,   3,   2,   5,   3,   6,   5,   2,  -1,  -1,  -1, -1},
	{  5,   2,   6,   9,   2,   5,   2,   9,   0,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  8,   5,   0,   0,   5,   1,   5,   8,   3,   3,   2,   6,   3,   6,   5, -1},
	{  1,   2,   6,   5,   1,   6,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  6,   3,  10,  10,   3,   1,   3,   6,   5,   5,   9,   8,   5,   8,   3, -1},
	{  6,   9,   0,   5,   9,   6,   0,  10,   6,   0,   1,  10,  -1,  -1,  -1, -1},
	{  6,   5,  10,   8,   3,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  6,   5,  10,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  7,  11,  10,   5,   7,  10,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  0,   3,   8,  11,  10,   5,  11,   5,   7,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  9,   1,   0,   7,  11,  10,   5,   7,  10,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  8,   9,   1,   8,   1,   3,   7,  11,  10,   5,   7,  10,  -1,  -1,  -1, -1},
	{  1,   5,   7,   1,   7,  11,   1,  11,   2,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  1,   5,   7,   1,   7,  11,   1,  11,   2,   3,   8,   0,  -1,  -1,  -1, -1},
	{  2,   0,  11,  11,   0,   9,  11,   9,   7,   7,   9,   5,  -1,  -1,  -1, -1},
	{  2,   5,  11,  11,   5,   7,   5,   2,   3,   3,   8,   9,   3,   9,   5, -1},
	{  5,   7,   3,   5,   3,   2,   5,   2,  10,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 10,   0,   2,   8,   0,  10,   5,   8,  10,   7,   8,   5,  -1,  -1,  -1, -1},
	{  5,   7,   3,   5,   3,   2,   5,   2,  10,   1,   0,   9,  -1,  -1,  -1, -1},
	{ 10,   7,   2,   5,   7,  10,   1,   2,   7,   8,   9,   1,   7,   8,   1, -1},
	{  3,   1,   5,   3,   5,   7,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  1,   5,   0,   0,   5,   8,   7,   8,   5,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  5,   7,   9,   9,   7,   0,   3,   0,   7,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  8,   9,   5,   8,   5,   7,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  8,  11,  10,   4,   8,  10,   5,   4,  10,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 11,  10,   3,   3,  10,   5,   3,   5,   0,   0,   5,   4,  -1,  -1,  -1, -1},
	{  8,  11,  10,   4,   8,  10,   5,   4,  10,   1,   0,   9,  -1,  -1,  -1, -1},
	{  9,   3,   4,   1,   3,   9,   5,   4,   3,  11,  10,   5,   3,  11,   5, -1},
	{  2,   8,  11,   4,   8,   2,   1,   4,   2,   5,   4,   1,  -1,  -1,  -1, -1},
	{  2,   5,  11,   1,   5,   2,   3,  11,   5,   4,   0,   3,   5,   4,   3, -1},
	{  5,   2,   9,   9,   2,   0,   2,   5,   4,   4,   8,  11,   4,  11,   2, -1},
	{  5,   4,   9,  11,   2,   3,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  8,   3,   4,   3,   2,   4,   2,   5,   4,   2,  10,   5,  -1,  -1,  -1, -1},
	{ 10,   0,   2,   5,   0,  10,   0,   5,   4,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  1,   0,   9,   8,   3,   4,   3,   2,   4,   2,   5,   4,   2,  10,   5, -1},
	{  4,   1,   2,   9,   1,   4,   2,   5,   4,   2,  10,   5,  -1,  -1,  -1, -1},
	{  3,   1,   8,   8,   1,   4,   5,   4,   1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  5,   4,   0,   1,   5,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  5,   4,   3,   3,   4,   8,   3,   0,   5,   0,   9,   5,  -1,  -1,  -1, -1},
	{  5,   4,   9,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 11,  10,   9,   7,  11,   9,   4,   7,   9,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 11,  10,   9,   7,  11,   9,   4,   7,   9,   0,   3,   8,  -1,  -1,  -1, -1},
	{  1,  11,  10,   7,  11,   1,   0,   7,   1,   4,   7,   0,  -1,  -1,  -1, -1},
	{  4,   1,   8,   8,   1,   3,   1,   4,   7,   7,  11,  10,   7,  10,   1, -1},
	{ 11,   2,   7,   2,   1,   7,   1,   4,   7,   1,   9,   4,  -1,  -1,  -1, -1},
	{  0,   3,   8,  11,   2,   7,   2,   1,   7,   1,   4,   7,   1,   9,   4, -1},
	{  2,   0,  11,  11,   0,   7,   4,   7,   0,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  4,   7,   2,   2,   7,  11,   2,   3,   4,   3,   8,   4,  -1,  -1,  -1, -1},
	{ 10,   9,   2,   2,   9,   4,   2,   4,   3,   3,   4,   7,  -1,  -1,  -1, -1},
	{  8,   2,   7,   0,   2,   8,   4,   7,   2,  10,   9,   4,   2,  10,   4, -1},
	{ 10,   7,   2,   2,   7,   3,   7,  10,   1,   1,   0,   4,   1,   4,   7, -1},
	{  4,   7,   8,  10,   1,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  7,   3,   4,   4,   3,   9,   1,   9,   3,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  1,   9,   7,   7,   9,   4,   7,   8,   1,   8,   0,   1,  -1,  -1,  -1, -1},
	{  0,   4,   7,   0,   7,   3,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  4,   7,   8,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  8,  11,  10,   9,   8,  10,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  0,  10,   9,   3,  10,   0,  10,   3,  11,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  1,  11,  10,   0,  11,   1,  11,   0,   8,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  3,  11,  10,   1,   3,  10,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  2,   8,  11,   1,   8,   2,   8,   1,   9,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  9,   3,  11,   0,   3,   9,  11,   1,   9,  11,   2,   1,  -1,  -1,  -1, -1},
	{  0,   8,  11,   2,   0,  11,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 11,   2,   3,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  3,   9,   8,   2,   9,   3,   9,   2,  10,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  2,  10,   9,   0,   2,   9,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ 10,   0,   8,   1,   0,  10,   8,   2,  10,   8,   3,   2,  -1,  -1,  -1, -1},
	{ 10,   1,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  1,   9,   8,   3,   1,   8,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  9,   0,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{  8,   3,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
	{ -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -1},
};

int MarchingCubes::vertexIndexList[12];

int MarchingCubes::AddTriangles(double (*z1)[2],double (*z2)[2],double iso,EdgeFunction* f,int idx,vector<TriangleIndex>& list,int& zIdx,int useZFront){
	int ntriang = 0;
	TriangleIndex tri;

	if(useZFront){zIdx>>=4;}
	else{
		zIdx=0;
		if (z1[0][0] < iso) zIdx |=   1;  // {0,0,0}
		if (z1[1][0] < iso) zIdx |=   2;  // {1,0,0}
		if (z1[1][1] < iso) zIdx |=   4;  // {1,1,0}
		if (z1[0][1] < iso) zIdx |=   8;  // {0,1,0}
	}
	if (z2[0][0] < iso) zIdx |=  16;  // {0,0,1}
	if (z2[1][0] < iso) zIdx |=  32;  // {1,0,1}
	if (z2[1][1] < iso) zIdx |=  64;  // {1,1,1}
	if (z2[0][1] < iso) zIdx |= 128;  // {0,1,1}

	/* Cube is entirely in/out of the surface */
	if (!edges[zIdx]) return 0;

	/* Find the vertices where the surface intersects the cube */
	int i,ii=1;
	for(i=0;i<12;i++){
		if(edges[zIdx] & ii){vertexIndexList[i] = f->getIndex(idx,i);}
		ii<<=1;
	}
	/* Create the triangle */
	for (i=0;triangles[zIdx][i]!=-1;i+=3) {
		tri.idx[0]=vertexIndexList[triangles[zIdx][i  ]];
		tri.idx[1]=vertexIndexList[triangles[zIdx][i+1]];
		tri.idx[2]=vertexIndexList[triangles[zIdx][i+2]];
		list.push_back(tri);
		ntriang++;
	}
	return ntriang;
}
/////////////////////////
// MarchingCubesWriter //
/////////////////////////
// Vertex mapping
//   1 -> (0,0,0)
//   2 -> (1,0,0)
//   4 -> (1,1,0)
//   8 -> (0,1,0)
//  16 -> (0,0,1)
//  32 -> (1,0,1)
//  64 -> (1,1,1)
// 128 -> (0,1,1)

// Edge Mapping
//    1 -> (0,0,0) - (1,0,0)  =   (  1,  2)
//    2 -> (1,0,0) - (1,1,0)  =   (  2,  4)
//    4 -> (1,1,0) - (0,1,0)  =   (  4,  8)
//    8 -> (0,1,0) - (0,0,0)  =   (  8,  1)
//   16 -> (0,0,1) - (1,0,1)  =   ( 16, 32)
//   32 -> (1,0,1) - (1,1,1)  =   ( 32, 64)
//   64 -> (1,1,1) - (0,1,1)  =   ( 64,128)
//  128 -> (0,1,1) - (0,0,1)  =   (128, 16)
//  256 -> (0,0,0) - (0,0,1)  =   (  1, 16)
//  512 -> (1,0,0) - (1,0,1)  =   (  2, 32)
// 1024 -> (1,1,0) - (1,1,1)  =   (  4, 64)
// 2048 -> (0,1,0) - (0,1,1)  =   (  8,128)
int MarchingCubesWriter::vertices1[8][3]={
	{0,0,0},{1,0,0},{1,1,0},{0,1,0},{0,0,1},{1,0,1},{1,1,1},{0,1,1}
};
int MarchingCubesWriter::vertices2[2][2][2]={
	0,4,3,7,1,5,2,6
};
int MarchingCubesWriter::edges1[12][2]={
	{0,1},{1,2},{2,3},{3,0},{4,5},{5,6},{6,7},{7,4},{0,4},{1,5},{2,6},{3,7}
};
int MarchingCubesWriter::edges2[8][8]={
	 -1,  0, -1,  3,  8, -1, -1, -1,
	  0, -1,  1, -1, -1,  9, -1, -1,
	 -1,  1, -1,  2, -1, -1, 10, -1,
	  3, -1,  2, -1, -1, -1, -1, 11,
	  8, -1, -1, -1, -1,  4, -1,  7,
	 -1,  9, -1, -1,  4, -1,  5, -1,
	 -1, -1, 10, -1, -1,  5, -1,  6,
	 -1, -1, -1, 11,  7, -1,  6, -1
};

void MarchingCubesWriter::writeEdges(FILE* fp){
	for(int idx=0;idx<256;idx++){
		int i=0;
		for(int j=0;j<12;j++){
			if( ((idx & 1<<edges1[j][0]) && !(idx & 1<<edges1[j][1])) || (!(idx & 1<<edges1[j][0]) && (idx & 1<<edges1[j][1]))){i|=1<<j;}
		}
		if(!(idx%8)){fprintf(fp,"\t");}
		fprintf(fp,"%4d, ",i);
		if((idx%8)==7){fprintf(fp,"\n");}
	}
}
int MarchingCubesWriter::Flip(int in){
	int out=0;
	int ii=1;
	for(int i=0;i<8;i++){
		if(!(in & ii)){out |= ii;}
		ii<<=1;
	}
	return out;
}

int MarchingCubesWriter::MinIndex(int in,int& x,int &y,int &z,int& a,int &f){
	int i,j,k,l;
	int out=in;
	x=y=z=a=f=0;
	for(i=0;i<4;i++){
		for(j=0;j<4;j++){
			for(k=0;k<4;k++){
				for(l=0;l<2;l++){
					int temp=Transform(in,i,j,k,l);
					if(temp<out){
						out=temp;
						x=i;
						y=j;
						z=k;
						a=l;
						f=0;
					}
					temp=Flip(temp);
					if(temp<out){
						out=temp;
						x=i;
						y=j;
						z=k;
						a=l;
						f=1;
					}
				}
			}
		}
	}
	return out;
}
int MarchingCubesWriter::MinIndex(int in,int& x,int &y,int &z,int& a){
	int i,j,k,l;
	int out=in;
	x=y=z=a=0;
	for(i=0;i<4;i++){
		for(j=0;j<4;j++){
			for(k=0;k<4;k++){
				for(l=0;l<2;l++){
					int temp=Transform(in,i,j,k,l);
					if(temp<out){
						out=temp;
						x=i;
						y=j;
						z=k;
						a=l;
					}
				}
			}
		}
	}
	return out;
}
void MarchingCubesWriter::RotateX(int in[3],int out[3]){
	out[0]= in[0];
	out[1]= in[2];
	out[2]= (in[1]+1)%2;
}
void MarchingCubesWriter::RotateY(int in[3],int out[3]){
	out[1]= in[1];
	out[0]= in[2];
	out[2]= (in[0]+1)%2;
}
void MarchingCubesWriter::RotateZ(int in[3],int out[3]){
	out[2]= in[2];
	out[0]= in[1];
	out[1]= (in[0]+1)%2;
}
int MarchingCubesWriter::RotateZ(int in){
	int out=0;
	int ii=1;
	int i2[3];
	for(int i=0;i<8;i++){
		if(in & ii){
			RotateZ(vertices1[i],i2);
			out |= 1<<vertices2[i2[0]][i2[1]][i2[2]];
		}
		ii<<=1;
	}
	return out;
}
int MarchingCubesWriter::RotateY(int in){
	int out=0;
	int ii=1;
	int i2[3];
	for(int i=0;i<8;i++){
		if(in & ii){
			RotateY(vertices1[i],i2);
			out |= 1<<vertices2[i2[0]][i2[1]][i2[2]];
		}
		ii<<=1;
	}
	return out;
}
int MarchingCubesWriter::RotateX(int in){
	int out=0;
	int ii=1;
	int i2[3];
	for(int i=0;i<8;i++){
		if(in & ii){
			RotateX(vertices1[i],i2);
			out |= 1<<vertices2[i2[0]][i2[1]][i2[2]];
		}
		ii<<=1;
	}
	return out;
}
int MarchingCubesWriter::Antipode(int in){
	int out=0;
	if( in &   1){out |=  64;}
	if( in &   2){out |= 128;}
	if( in &   4){out |=  16;}
	if( in &   8){out |=  32;}
	if( in &  16){out |=   4;}
	if( in &  32){out |=   8;}
	if( in &  64){out |=   1;}
	if( in & 128){out |=   2;}
	return out;
}



int MarchingCubesWriter::Transform(int idx,int x,int y,int z,int a){
	int i,out;
	out=idx;
	if(x<0){x=(4-((-x)%4))%4;}
	else{x%=4;}
	if(y<0){y=(4-((-y)%4))%4;}
	else{y%=4;}
	if(z<0){z=(4-((-z)%4))%4;}
	else{z%=4;}
	for(i=0;i<x;i++){out=RotateX(out);}
	for(i=0;i<y;i++){out=RotateY(out);}
	for(i=0;i<z;i++){out=RotateZ(out);}
	if(a){out=Antipode(out);}
	return out;
}
int MarchingCubesWriter::ITransform(int idx,int x,int y,int z,int a){
	int i,out;
	out=idx;
	x=-x;
	y=-y;
	z=-z;
	if(x<0){x=(4-((-x)%4))%4;}
	else{x%=4;}
	if(y<0){y=(4-((-y)%4))%4;}
	else{y%=4;}
	if(z<0){z=(4-((-z)%4))%4;}
	else{z%=4;}
	if(a){out=Antipode(out);}
	for(i=0;i<z;i++){out=RotateZ(out);}
	for(i=0;i<y;i++){out=RotateY(out);}
	for(i=0;i<x;i++){out=RotateX(out);}
	return out;
}
int MarchingCubesWriter::ITransformEdge(int e,int x,int y,int z,int a){
	int i,ii,idx1,idx2;
	idx1=ITransform(1<<edges1[e][0],x,y,z,a);
	idx2=ITransform(1<<edges1[e][1],x,y,z,a);
	ii=1;
	for(i=0;i<8;i++){
		if(idx1==ii){idx1=i;break;}
		ii<<=1;
	}
	ii=1;
	for(i=0;i<8;i++){
		if(idx2==ii){idx2=i;break;}
		ii<<=1;
	}
	return edges2[idx1][idx2];
}

void MarchingCubesWriter::ITransformTriangle(int* tIdx,int x,int y,int z,int a,int f){
	tIdx[0]=ITransformEdge(tIdx[0],x,y,z,a);
	tIdx[1]=ITransformEdge(tIdx[1],x,y,z,a);
	tIdx[2]=ITransformEdge(tIdx[2],x,y,z,a);
	if((a && !f) || (!a && f)){
		int temp=tIdx[0];
		tIdx[0]=tIdx[2];
		tIdx[2]=temp;
	}
}
void MarchingCubesWriter::ITransformTriangle(int* tIdx,int x,int y,int z,int a){
	tIdx[0]=ITransformEdge(tIdx[0],x,y,z,a);
	tIdx[1]=ITransformEdge(tIdx[1],x,y,z,a);
	tIdx[2]=ITransformEdge(tIdx[2],x,y,z,a);
	if(a){
		int temp=tIdx[0];
		tIdx[0]=tIdx[2];
		tIdx[2]=temp;
	}
}
// This code is based on the work of Lorensen and Cline
// Marching Cubes: A High Resolution 3D Surface Construction Algorithm
// Computer Graphics, Volume 21, Number 4, July 1987
// The implementation differs from the description in the paper in two ways:
// 1] The implementation uses the symmetries obtained through the antipodal map, in addition to
//    those obtained by rotation. (This makes cases 11 and 14 equivalent, in Figure 3 of the
//    referenced paper.)
// 2] The algorithm is not symmetric so that flipping the bit-encoding associated to a
//    voxel will not necessarily give rise to the same iso-surface. This is necessary to
//    ensure consistancy across adjacent faces. In particular we define the cases in such a way
//    that an edge that passes through a given face is completely determined by the 4 values at
//    the corners of that face.
int MarchingCubesWriter::GetTriangles(int in,int* tIdx){
	int x,y,z,a,f=0,out,c=0;
	// CCW normal points to on points
	out=MinIndex(in,x,y,z,a);
	switch(out){
	case   0: //  0
	case 255:
		break;
	case  1: //  1
		tIdx[ 0]=0;
		tIdx[ 1]=3;
		tIdx[ 2]=8;
		c=1;
		break;
	case  3: //  2
		tIdx[ 0]=8;
		tIdx[ 1]=9;
		tIdx[ 2]=1;

		tIdx[ 3]=8;
		tIdx[ 4]=1;
		tIdx[ 5]=3;
		c=2;
		break;
	case  5: //  3 
		c+=GetTriangles( 1,&tIdx[c*3]);
		c+=GetTriangles( 4,&tIdx[c*3]);
		break;
	case 20: //  4
		c+=GetTriangles( 4,&tIdx[c*3]);
		c+=GetTriangles(16,&tIdx[c*3]);
		break;
	case  7: //  5
		tIdx[ 0]=8;
		tIdx[ 1]=9;
		tIdx[ 2]=10;

		tIdx[ 3]=8;
		tIdx[ 4]=10;
		tIdx[ 5]=2;

		tIdx[ 6]=8;
		tIdx[ 7]=2;
		tIdx[ 8]=3;
		c=3;
		break;
	case 21: //  6
		c+=GetTriangles( 4,&tIdx[c*3]);
		c+=GetTriangles(17,&tIdx[c*3]);
		break;
	case 26: // 7
		c+=GetTriangles( 2,&tIdx[3*c]);
		c+=GetTriangles( 8,&tIdx[3*c]);
		c+=GetTriangles(16,&tIdx[3*c]);
		break;
	case 15: //  8
		tIdx[ 0]=8;
		tIdx[ 1]=9;
		tIdx[ 2]=10;

		tIdx[ 3]=8;
		tIdx[ 4]=10;
		tIdx[ 5]=11;
		c=2;
		break;
	case 27: // 9
		tIdx[ 0]=1;
		tIdx[ 1]=4;
		tIdx[ 2]=9;

		tIdx[ 3]=1;
		tIdx[ 4]=7;
		tIdx[ 5]=4;

		tIdx[ 6]=1;
		tIdx[ 7]=2;
		tIdx[ 8]=7;

		tIdx[ 9]=2;
		tIdx[10]=11;
		tIdx[11]=7;
		c=4;
		break;
	case 60: //10
		c+=GetTriangles(12,&tIdx[c*3]);
		c+=GetTriangles(48,&tIdx[c*3]);
		break;
	case 23: // 11
		tIdx[ 0]=9;
		tIdx[ 1]=10;
		tIdx[ 2]=4;

		tIdx[ 3]=4;
		tIdx[ 4]=10;
		tIdx[ 5]=2;

		tIdx[ 6]=4;
		tIdx[ 7]=2;
		tIdx[ 8]=7;

		tIdx[ 9]=7;
		tIdx[10]=2;
		tIdx[11]=3;
		c=4;
		break;
	case 30: // 12
		c+=GetTriangles(14,&tIdx[c*3]);
		c+=GetTriangles(16,&tIdx[c*3]);
		break;
	case 90: //13
		c+=GetTriangles( 2,&tIdx[c*3]);
		c+=GetTriangles( 8,&tIdx[c*3]);
		c+=GetTriangles(16,&tIdx[c*3]);
		c+=GetTriangles(64,&tIdx[c*3]);
		break;
		// Four or mor on points
	case 127: // -1
		c+=GetTriangles(128,tIdx);
		f=1;
		break;
	case 63:  // -2
		c+=GetTriangles(192,&tIdx[c*3]);
		f=1;
		break;
	case 95:  // -3
		tIdx[ 0]=9;
		tIdx[ 1]=5;
		tIdx[ 2]=11;

		tIdx[ 3]=11;
		tIdx[ 4]=5;
		tIdx[ 5]=6;

		tIdx[ 6]=11;
		tIdx[ 7]=7;
		tIdx[ 8]=9;

		tIdx[ 9]=7;
		tIdx[10]=4;
		tIdx[11]=9;
		c=4;
		break;
	case 125: //-4
		c+=GetTriangles(128,&tIdx[c*3]);
		c+=GetTriangles(  2,&tIdx[c*3]);
		f=1;
		break;
	case 31:  // -5
		tIdx[ 0]=9;
		tIdx[ 1]=10;
		tIdx[ 2]=4;

		tIdx[ 3]=4;
		tIdx[ 4]=10;
		tIdx[ 5]=7;

		tIdx[ 6]=11;
		tIdx[ 7]=7;
		tIdx[ 8]=10;
		c=3;
		break;
	case 61:  //-6
		tIdx[ 0]=0;
		tIdx[ 1]=7;
		tIdx[ 2]=9;

		tIdx[ 3]=9;
		tIdx[ 4]=7;
		tIdx[ 5]=5;

		tIdx[ 6]=7;
		tIdx[ 7]=0;
		tIdx[ 8]=1;

		tIdx[ 9]=1;
		tIdx[10]=10;
		tIdx[11]=11;

		tIdx[12]=1;
		tIdx[13]=11;
		tIdx[14]=7;
		c=5;
		break;
	case 91:  //-7
		c+=GetTriangles(64,&tIdx[c*3]);
		c+=GetTriangles(27,&tIdx[c*3]);
		break;
	default:
		printf("Badness: %d %d\n",in,out);
	};
	for(int i=0;i<c;i++){ITransformTriangle(&tIdx[3*i],x,y,z,a,f);}
	return c;
}
void MarchingCubesWriter::writeTriangles(FILE* fp){
	int triangleIndex[16];

	for(int i=0;i<256;i++){
		int j,cnt=GetTriangles(i,triangleIndex);
		fprintf(fp,"\t{");
		for(j=0;j<cnt;j++){fprintf(fp,"%3d, %3d, %3d, ",triangleIndex[j*3],triangleIndex[j*3+1],triangleIndex[j*3+2]);}
		for(j=cnt*3;j<15;j++){fprintf(fp," -1, ");}
		fprintf(fp,"-1},\n");

	}
}
