/*
Copyright (c) 2009, Michael Kazhdan
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/
#ifndef RANGE_GRID_INCLUDED
#define RANGE_GRID_INCLUDED

#include <vector>
#include "Grid.h"
#include "Geometry.h"
template<class Vertex,class Real>
class RangeGrid
{
public:
	class Sample
	{
	public:
		bool validSample;
		Vertex v;
	};
	XForm4x4<Real> xForm;
	Grid<int> grid;
	std::vector<Vertex> vertices;

	bool Read(char* rangeGridFile,char* xFormFile=NULL);
	size_t width() const;
	size_t height() const;
	int &operator () (size_t i,size_t j);
	const int &operator () (size_t i,size_t j) const;
	Sample sample(float x,float y) const;
	Sample sample(double x,double y) const;
	Vertex& operator[] (size_t i);
	const Vertex& operator[] (size_t i) const;

	XForm4x4<Real> backProjectionXForm(bool full=true) const;

	Vertex cumulativeVertex(int& count);
};

#include "RangeGrid.inl"
#endif // RANGE_GRID_INCLUDED
