/*
Copyright (c) 2006, Michael Kazhdan and Matthew Bolitho
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

#ifndef BINARY_NODE_INCLUDED
#define BINARY_NODE_INCLUDED

template<class Real>
class BinaryNode
{
public:
	static inline int CenterCount( int depth ){ return 1<<depth; }
	static inline int CornerCount( int depth ){ return CenterCount( depth ) + 1; }
	static inline int CumulativeCenterCount( int maxDepth ){ return (1<<(maxDepth+1))-1; }
	static inline int CumulativeCornerCount( int maxDepth ){ return CumulativeCenterCount( maxDepth ) + maxDepth + 1; }
	static inline int CenterIndex( int depth , int offset ){ return CumulativeCenterCount( depth-1 ) + offset; }
	static inline int CornerIndex( int depth , int offset ){ return CumulativeCornerCount( depth-1 ) + offset; }
	static inline Real CornerIndexPosition( int index , int maxDepth ){ return Real(index)/(1<<maxDepth); }
	static inline Real Width( int depth , Real start=Real(0.) , Real end=Real(1.) ){ return (end-start)/(1<<depth); }
	static inline void CenterAndWidth( int depth , int offset , Real& center , Real& width , Real start=Real(0.) , Real end=Real(1.) )
	{
		width  = (end-start)/(1<<depth);
		center = Real( (0.5+offset)*width ) + start;
	}
	static inline void CornerAndWidth( int depth , int offset , Real& corner , Real& width , Real start=Real(0.) , Real end=Real(1.) )
	{
		width  = (end-start)/(1<<depth);
		corner = Real( offset*width ) + start;
	}
	static inline void CenterAndWidth( int idx , Real& center , Real& width , Real start=(0.) , Real end=(1.) )
	{
		int depth , offset;
		CenterDepthAndOffset( idx , depth , offset );
		CenterAndWidth( depth , offset , center , width , start , end );
	}
	static inline void CornerAndWidth( int idx , Real& corner , Real& width , Real start=Real(0.) , Real end=(1.) )
	{
		int depth , offset;
		CornerDepthAndOffset( idx , depth , offset );
		CornerAndWidth( depth , offset , corner , width , start , end );
	}
	static inline void CenterDepthAndOffset( int idx , int& depth , int& offset )
	{
		offset = idx;
		depth = 0;
		while( offset>=CenterCount( depth ) )
		{
			offset -= CenterCount( depth );
			depth++;
		}
	}
	static inline void CornerDepthAndOffset( int idx , int& depth , int& offset )
	{
		offset = idx;
		depth = 0;
		while( offset>=CornerCount( depth ) )
		{
			offset -= CornerCount( depth );
			depth++;
		}
	}
};
#endif // BINARY_NODE_INCLUDED
