/*
Copyright (c) 2011, Michael Kazhdan and Ming Chuang
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/
template< >
const double TriangleIntegrator< 1 >::_SamplePositionsAndWeights[] =
{
	1./3 , 1./3 , 1.0
};
template< >
const double TriangleIntegrator< 3 >::_SamplePositionsAndWeights[] =
{
	1./6 , 1./6 , 1./3 ,
	1./6 , 2./3 , 1./3 ,
	2./3 , 1./6 , 1./3
};
template< >
const double TriangleIntegrator< 6 >::_SamplePositionsAndWeights[] =
{
	0.816847572980459  , 0.0915762135097705 , 0.109951743655322 ,
	0.0915762135097705 , 0.816847572980459  , 0.109951743655322 ,
	0.0915762135097705 , 0.0915762135097705 , 0.109951743655322 ,
	0.108103018168070  , 0.445948490915965  , 0.223381589678011 ,
	0.445948490915965  , 0.108103018168070  , 0.223381589678011 ,
	0.445948490915965  , 0.445948490915965  , 0.223381589678011
};
template< >
const double TriangleIntegrator< 11 >::_SamplePositionsAndWeights[] =
{
	0.05725498667747686 , 0.89549814678987949 , 0.01903403592647780 ,
	0.89536264002457910 , 0.06182822125032195 , 0.01918967765387641 ,
	0.68447574845651404 , 0.02334373849768273 , 0.02310022837228092 ,
	0.06874625591502953 , 0.06003027574726300 , 0.02673379472209950 ,
	0.61567620557583957 , 0.33346180834137717 , 0.04187791348287284 ,
	0.62794614119778946 , 0.15918918599215148 , 0.05082241651275853 ,
	0.06290913834186357 , 0.65529509370545247 , 0.05093076223068348 ,
	0.06837821192050991 , 0.30911768542826723 , 0.05571091583000085 ,
	0.28752945837439225 , 0.63642650917962018 , 0.05600472513147303 ,
	0.32878355641313461 , 0.07702400564246342 , 0.06239378571877916 ,
	0.31229040501364480 , 0.35234478644589950 , 0.09420174441869741
};
template< >
const double TriangleIntegrator< 24 >::_SamplePositionsAndWeights[] =
{
	5.0550507373529086e-01 , 2.0776116575484826e-01 , 1.7344807725532943e-01 ,
	2.7542385024412980e-01 , 4.8123289062464247e-01 , 1.9053311454269983e-01 ,
	2.6481531651496770e-01 , 2.7586334089315967e-01 , 1.6882888511942015e-01 ,
	7.5329402776254240e-01 , 1.0954959855585467e-01 , 1.0546076281767805e-01 ,
	5.2433682558924433e-01 , 3.6419744430339263e-01 , 1.4815929467355968e-01 ,
	2.9530445535851102e-01 , 6.4203365318662664e-01 , 1.0983120878770872e-01 ,
	1.0614642990289996e-01 , 7.6777680170023954e-01 , 1.0507331820482332e-01 ,
	6.3491832379200652e-01 , 3.6036266787907723e-02 , 8.5924658784158670e-02 ,
	3.8729657913960353e-01 , 8.4198522115543739e-02 , 1.2537585060182724e-01 ,
	1.6929927488966462e-01 , 1.0999439055630450e-01 , 1.1594828119739846e-01 ,
	8.0491894656105567e-02 , 5.7966325105486349e-01 , 1.3237226895051976e-01 ,
	9.5379208487721689e-02 , 3.3947290311800554e-01 , 1.2348449173239080e-01 ,
	9.2899486985787905e-01 , 4.7768381772022417e-02 , 2.9216658446243379e-02 ,
	7.4726591728868819e-01 , 2.2376358774275851e-01 , 6.4605204046914597e-02 ,
	5.0365825075943971e-01 , 4.8798437805397499e-01 , 3.9118824435043810e-02 ,
	1.6134650499890957e-01 , 8.3865349500109043e-01 , 2.2133893564494179e-02 ,
	2.9553592846822851e-02 , 9.3049846900263089e-01 , 3.0406188052025412e-02 ,
	8.6854386943076545e-01 , 3.8102570854643414e-03 , 2.1333382551825181e-02 ,
	3.9366774470722010e-01 , 0.0000000000000000e+00 , 2.3800609628471206e-02 ,
	1.7690730625559031e-01 , 1.0939142057119933e-02 , 2.9693247293360987e-02 ,
	3.5319656252586096e-02 , 3.9099745550423282e-02 , 3.5311689185924387e-02 ,
	0.0000000000000000e+00 , 7.7757518429429107e-01 , 2.6798161571713618e-02 ,
	0.0000000000000000e+00 , 4.6374383867430541e-01 , 3.0312523835131357e-02 ,
	3.0573404093099332e-02 , 1.9305903224251936e-01 , 6.2829404721337689e-02
};

template< >
const double TriangleIntegrator< 27 >::_SamplePositionsAndWeights[] =
{
	4.6494564773693992e-01 , 2.9133859436942361e-01 , 1.3648275991498204e-01 ,
	3.2081957909482994e-01 , 5.3634228112084714e-01 , 1.2438630022250971e-01 ,
	5.1353143433447235e-01 , 1.2454405910544103e-01 , 1.1329177024539897e-01 ,
	2.8790310224819649e-01 , 2.2789955884347501e-01 , 1.3228489176992250e-01 ,
	2.6677168071577745e-01 , 4.1132499178904658e-01 , 1.1722353681481934e-01 ,
	1.1698976413323442e-01 , 3.1909737814681871e-01 , 1.0998202543484477e-01 ,
	8.1626233715968810e-01 , 2.7719522918618567e-02 , 4.7284119131529377e-02 ,
	5.6938486195327997e-01 , 3.4992914334288650e-01 , 1.0994399601768742e-01 ,
	3.7272769861629096e-01 , 5.9895439629934211e-01 , 6.5193746289815974e-02 ,
	2.6807150626772580e-02 , 8.1562969693268217e-01 , 4.6224760707242137e-02 ,
	7.0099267949645228e-01 , 1.4118119730952799e-01 , 1.0412107067624195e-01 ,
	3.2719878157552895e-01 , 8.1721404855381763e-02 , 8.5195409796230526e-02 ,
	1.3667083534390506e-01 , 1.3035453031942690e-01 , 9.1076518240300441e-02 ,
	1.3828000204292318e-01 , 7.1027868107761583e-01 , 9.8381989816749074e-02 ,
	2.2592651051306589e-02 , 3.8913981113319357e-01 , 5.3445574349465230e-02 ,
	9.3614893514675623e-01 , 3.2899822292186298e-02 , 2.6211869704176473e-02 ,
	8.0454974747615537e-01 , 1.6429286715713465e-01 , 5.5191800300359820e-02 ,
	6.1948431533135195e-01 , 3.7802163891336921e-01 , 2.2550142431420638e-02 ,
	1.6655614492060572e-01 , 8.0364834053903877e-01 , 5.3513272326506316e-02 ,
	3.3268560622678411e-02 , 9.3551434285897095e-01 , 2.6748618572925459e-02 ,
	6.1924873232110123e-01 , 2.6297199713764152e-02 , 5.8869116212867049e-02 ,
	3.9659731669586495e-01 , 1.4354532010930898e-02 , 3.6717768780272685e-02 ,
	1.6892970982290229e-01 , 2.2120535196161750e-02 , 4.2755616195827365e-02 ,
	3.2916403878999745e-02 , 3.4222771841359190e-02 , 2.9096217361124159e-02 ,
	2.5660186833052434e-02 , 6.1758873171277151e-01 , 5.7443554735054178e-02 ,
	1.2417148586801485e-01 , 5.3141960154079959e-01 , 1.0824295295050959e-01 ,
	2.5252704638304480e-02 , 1.7400571673032256e-01 , 4.8140601001216463e-02
};

template< >
const double TriangleIntegrator< 32 >::_SamplePositionsAndWeights[] = 
{
	3.7986021093401956e-01 , 2.1078525939140391e-01 , 1.1887566790227083e-01 ,
	3.0141709320909305e-01 , 4.0978657777002531e-01 , 1.5044412520664885e-01 ,
	5.5802528953120256e-01 , 2.1377743253005960e-01 , 1.2632909284531338e-01 ,
	1.2512299505810387e-01 , 6.1938125736255578e-01 , 1.0192984975357525e-01 ,
	2.1117939909804934e-01 , 2.4498296509349016e-01 , 9.4999150650614317e-02 ,
	8.5431474947580432e-01 , 7.1871496101589105e-02 , 4.4981492398316447e-02 ,
	7.1788185898052326e-01 , 2.0376848107772977e-01 , 7.9147211585943858e-02 ,
	4.6631787462323071e-01 , 4.0896380449124475e-01 , 1.1997941465421234e-01 ,
	2.5015500335339214e-01 , 6.2768261568031403e-01 , 1.0670416609764186e-01 ,
	7.9955384841381316e-02 , 8.2600331401756000e-01 , 6.1058344824144795e-02 ,
	7.1008125956836521e-01 , 6.4413220382260550e-02 , 8.2563774790925248e-02 ,
	4.9732063377796598e-01 , 7.0566724344036824e-02 , 9.6297610073814668e-02 ,
	2.6077068256562896e-01 , 9.5428585810584610e-02 , 9.1875684331583440e-02 ,
	8.9602705800587434e-02 , 1.1638649906727733e-01 , 6.1150555208077911e-02 ,
	2.3088148766115757e-02 , 7.4918973979067949e-01 , 4.3370170834023010e-02 ,
	1.2953296900433620e-01 , 4.2260565743346001e-01 , 1.0829374522633514e-01 ,
	9.3448087604440955e-02 , 2.4345813394879973e-01 , 5.5887468639759713e-02 ,
	9.5526919357006035e-01 , 2.3551733249578710e-02 , 1.3351800054734712e-02 ,
	8.4593539837314391e-01 , 1.5406460162685609e-01 , 1.5428984747249670e-02 ,
	6.1600929617267497e-01 , 3.6118159118967208e-01 , 5.0198346855370224e-02 ,
	3.9316510319604808e-01 , 5.8168921474014745e-01 , 5.6291117210426664e-02 ,
	1.8920633061715936e-01 , 7.8860171922313160e-01 , 4.1240008239364231e-02 ,
	4.3010560106405471e-02 , 9.4547507322097091e-01 , 1.4239502872161450e-02 ,
	8.5815888421533082e-01 , 0.0000000000000000e+00 , 1.3691069308687381e-02 ,
	6.2731531923241179e-01 , 0.0000000000000000e+00 , 1.9309417484872689e-02 ,
	3.6384660446077510e-01 , 1.4566514788346974e-02 , 3.7090960843213061e-02 ,
	1.5557066896897953e-01 , 2.1152223383121949e-02 , 3.6967371622461546e-02 ,
	2.9754117496841759e-02 , 2.7110971356255786e-02 , 2.1018653471205032e-02 ,
	0.0000000000000000e+00 , 9.2734897448394982e-01 , 9.7760996293200769e-03 ,
	2.5716283623693881e-02 , 5.4444667627192522e-01 , 5.6339308919459923e-02 ,
	2.4506286636990005e-02 , 3.3212908394764507e-01 , 4.9808146403015403e-02 ,
	9.2296909059649268e-03 , 1.4604496167217568e-01 , 2.1361687315256585e-02 
};
////////////////////////
// TriangleIntegrator //
////////////////////////
template< int Samples >
TriangleIntegrator< Samples >::TriangleIntegrator( void )
{
	_area = 0;
	memset( _samplePositions , 0 , sizeof( _samplePositions ) );
	memset( weights , 0 , sizeof( weights ) );
}

template< int Samples >
void TriangleIntegrator< Samples >::_init( const Point3D< double >& p1 , const Point3D< double >& p2 , const Point3D< double >& p3 )
{
	Point3D< double > q1 = p2 - p1;
	Point3D< double > q2 = p3 - p1;
	_area = Length( Point3D< double >::CrossProduct( q1 , q2 ) ) / 2;
	for( int i=0 ; i<Samples ; i++ )
	{
		_samplePositions[i] = p1 + q1 * _SamplePositionsAndWeights[ 3*i+0 ] + q2 * _SamplePositionsAndWeights[ 3*i+1 ];
		weights[i] = _SamplePositionsAndWeights[3*i+2] * _area;
	}
#if 1
	double weightSum = 0;
	for( int i=0 ; i<Samples ; i++ ) weightSum += _SamplePositionsAndWeights[3*i+2];
	for( int i=0 ; i<Samples ; i++ ) weights[i] /= weightSum;
#endif
}
template< int Samples >
void TriangleIntegrator< Samples >::_init( const Point3D< float >& p1 , const Point3D< float >& p2 , const Point3D< float >& p3 )
{
	Point3D< double > q1 = Point3D< double >( p2 - p1 );
	Point3D< double > q2 = Point3D< double >( p3 - p1 );
	_area = Length( Point3D< double >::CrossProduct( q1 , q2 ) ) / 2;
	for( int i=0 ; i<Samples ; i++ )
	{
		_samplePositions[i] = Point3D< double >( p1 ) + q1 * _SamplePositionsAndWeights[ 3*i+0 ] + q2 * _SamplePositionsAndWeights[ 3*i+1 ];
		weights[i] = _SamplePositionsAndWeights[3*i+2] * _area;
	}
#if 1
	double weightSum = 0;
	for( int i=0 ; i<Samples ; i++ ) weightSum += _SamplePositionsAndWeights[3*i+2];
	for( int i=0 ; i<Samples ; i++ ) weights[i] /= weightSum;
#endif
}
#if 1
template< int Samples >
template< class VectorType >
VectorType TriangleIntegrator< Samples >::integrate( const VectorType* values ) const
{
	VectorType integral;
	integral *= 0;
	for( int i=0 ; i<Samples ; i++ ) integral += values[i] * weights[i];
	return integral;
}
#else
template< int Samples >
template< class VectorType >
VectorType TriangleIntegrator< Samples >::Integrate( const VectorType* values )
{
	VectorType integral;
	integral *= 0;
	for( int i=0 ; i<Samples ; i++ ) integral += values[i] * _SamplePositionsAndWeights[ 3*i+2 ];
	return integral;
}
#endif

template< int Samples > inline const Point3D< double >& TriangleIntegrator< Samples >::operator [] ( int idx ) const { return _samplePositions[idx]; }
template< int Samples > inline double TriangleIntegrator< Samples >::area( void ) const { return _area; }


template< class TIntegrator >
void TriangulatingPolygonIntegrator< TIntegrator >::set( const Point3D< double >* verts , int vCount )
{
	_tIntegrators.resize( vCount-2 );
	for( int j=1 ; j<vCount-1 ; j++ ) _tIntegrators[j-1] = TIntegrator( verts[0] , verts[j] , verts[j+1] );
}
template< class TIntegrator >
void TriangulatingPolygonIntegrator< TIntegrator >::set( const Point3D< float >* verts , int vCount )
{
	_tIntegrators.resize( vCount-2 );
	for( int j=1 ; j<vCount-1 ; j++ ) _tIntegrators[j-1] = TIntegrator( verts[0] , verts[j] , verts[j+1] );
}
template< class TIntegrator >
inline const Point3D< double >& TriangulatingPolygonIntegrator< TIntegrator >::operator[]( int idx ) const
{
	int tIdx = idx / TIntegrator::SampleNum;
	int tOff = idx % TIntegrator::SampleNum;
	return _tIntegrators[tIdx][tOff];
}
template< class TIntegrator >
inline double TriangulatingPolygonIntegrator< TIntegrator >::weight( int idx ) const
{
	int tIdx = idx / TIntegrator::SampleNum;
	int tOff = idx % TIntegrator::SampleNum;
	return _tIntegrators[tIdx].weights[tOff];
}
template< class TIntegrator >
inline double TriangulatingPolygonIntegrator< TIntegrator >::area( void ) const
{
	double a = 0;
	for( int i=0 ; i<_tIntegrators.size() ; i++ ) a += _tIntegrators[i].area();
	return a;
}
template< class TIntegrator >
template< class VectorType >
VectorType TriangulatingPolygonIntegrator< TIntegrator >::integrate( const VectorType* values ) const
{
	VectorType integral;
	integral *= 0;

	for( int i=0 ; i<_tIntegrators.size() ; i++ ) integral += _tIntegrators[i].integrate( values + (i*TIntegrator::SampleNum) );
	return integral;
}
template< class Real >
double TriangleArea( Point3D< Real > p1 , Point3D< Real > p2 , Point3D< Real > p3 )
{
	return Length( Point3D< double >::CrossProduct( Point3D< double >( p2-p1 ) , Point3D< double >( p3-p1 ) ) ) / 2;
}

void MedianPolygonIntegrator::set( const Point3D< double >* verts , int vCount )
{
	Point3D< double > center;
	for( int i=0 ; i<vCount ; i++ ) center += verts[i];
	center /= vCount;
	_samples.resize( vCount );
	for( int i=0 ; i<vCount ; i++ ) _samples[i] = ( verts[i] + center ) / 2;
	_area = 0;
	for( int i=1 ; i<vCount-1 ; i++ ) _area += TriangleArea( verts[0] , verts[i] , verts[i+1] );
}
void MedianPolygonIntegrator::set( const Point3D< float >* verts , int vCount )
{
	Point3D< double > center;
	for( int i=0 ; i<vCount ; i++ ) center += verts[i];
	center /= vCount;
	_samples.resize( vCount );
	for( int i=0 ; i<vCount ; i++ ) _samples[i] = ( Point3D< double >( verts[i] ) + center ) / 2;
	_area = 0;
	for( int i=1 ; i<vCount-1 ; i++ ) _area += TriangleArea( verts[0] , verts[i] , verts[i+1] );
}
inline const Point3D< double >& MedianPolygonIntegrator::operator[] ( int idx ) const { return _samples[idx]; }
inline double MedianPolygonIntegrator::weight( int idx ) const { return _area / _samples.size(); }
inline double MedianPolygonIntegrator::area( void ) const { return _area; }
template< class VectorType >
VectorType MedianPolygonIntegrator::integrate( const VectorType* values ) const
{
	VectorType integral;
	integral *= 0;
	for( int i=0 ; i<_samples.size() ; i++ ) integral += values[i];
	return integral * _area / _samples.size();
}
