/*
Copyright (c) 2011, Michael Kazhdan and Ming Chuang
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/
template< >
const double LineIntegrator< 1 >::_SamplePositionsAndWeights[] =
{
	0.5 , 1.0 ,
};
template< >
const double LineIntegrator< 2 >::_SamplePositionsAndWeights[] =
{
	-sqrt(1./12) + 0.5 , 0.5 ,
	 sqrt(1./12) + 0.5 , 0.5 ,
};
template< >
const double LineIntegrator< 3 >::_SamplePositionsAndWeights[] =
{
	0.5                , 4./ 9 ,
	-sqrt(3./20) + 0.5 , 5./18 ,
	 sqrt(3./20) + 0.5 , 5./18 ,
};
template< >
const double LineIntegrator< 4 >::_SamplePositionsAndWeights[] =
{
	-sqrt( (3. - 2.*sqrt(6./5)) / 28 ) +0.5 , ( 18. + sqrt( 30. ) ) / 72 ,
	 sqrt( (3. - 2.*sqrt(6./5)) / 28 ) +0.5 , ( 18. + sqrt( 30. ) ) / 72 ,
	-sqrt( (3. + 2.*sqrt(6./5)) / 28 ) +0.5 , ( 18. - sqrt( 30. ) ) / 72 ,
	 sqrt( (3. + 2.*sqrt(6./5)) / 28 ) +0.5 , ( 18. - sqrt( 30. ) ) / 72 ,
};
template< >
const double LineIntegrator< 5 >::_SamplePositionsAndWeights[] =
{
	0.5 , 64. / 225 ,
	-1./6 * sqrt( 5. - 2. * sqrt( 10. / 7 ) ) + 0.5 , ( 322. + 13. * sqrt( 70. ) ) / 1800. ,
	 1./6 * sqrt( 5. - 2. * sqrt( 10. / 7 ) ) + 0.5 , ( 322. + 13. * sqrt( 70. ) ) / 1800. ,
	-1./6 * sqrt( 5. + 2. * sqrt( 10. / 7 ) ) + 0.5 , ( 322. - 13. * sqrt( 70. ) ) / 1800. ,
	 1./6 * sqrt( 5. + 2. * sqrt( 10. / 7 ) ) + 0.5 , ( 322. - 13. * sqrt( 70. ) ) / 1800. ,
};

////////////////////
// LineIntegrator //
////////////////////
template< int Samples >
LineIntegrator< Samples >::LineIntegrator( void )
{
	_length = 0;
	memset( _samplePositions , 0 , sizeof( _samplePositions ) );
	memset( weights , 0 , sizeof( weights ) );
}

template< int Samples >
void LineIntegrator< Samples >::_init( const Point3D< double >& p1 , const Point3D< double >& p2 )
{
	Point3D< double > q = p2 - p1;
	_length = Length( q );
	for( int i=0 ; i<SampleNum ; i++ )
	{
		_samplePositions[i] = p1 + q * _SamplePositionsAndWeights[ 2*i+0 ];
		weights[i]  = _SamplePositionsAndWeights[2*i+1] * _length;
	}
}
template< int Samples >
void LineIntegrator< Samples >::_init( const Point3D< float >& p1 , const Point3D< float >& p2 )
{
	Point3D< double > q = Point3D< double >( p2 - p1 );
	_length = Length( q );
	for( int i=0 ; i<SampleNum ; i++ )
	{
		_samplePositions[i] = Point3D< double >( p1 ) + q * _SamplePositionsAndWeights[ 2*i+0 ];
		weights[i]  = _SamplePositionsAndWeights[2*i+1] * _length;
	}
}
template< int Samples >
template< class VectorType >
VectorType LineIntegrator< Samples >::Integrate( const VectorType* values )
{
	VectorType integral;
	integral *= 0;
	for( int i=0 ; i<SampleNum ; i++ ) integral += values[i] * _SamplePositionsAndWeights[ 2*i+1 ];
	return integral;
}

template< int Samples > inline const Point3D< double >& LineIntegrator< Samples >::operator [] ( int idx ) const { return _samplePositions[idx]; }
template< int Samples > inline double LineIntegrator< Samples >::length( void ) const { return _length; }

