/*
Copyright (c) 2011, Michael Kazhdan and Ming Chuang
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

const char fragment_code[] =
"																									\
varying vec4 pos;																					\
varying vec3 V2L;																					\
varying float inColor;																				\
void main()																							\
{																									\
	vec3 normal = normalize( cross(dFdx(pos.xyz),dFdy(pos.xyz)) );									\
	vec3 r		= normalize( reflect(V2L, normal) );												\
	vec3 v		= normalize( pos.xyz );																\
	vec4 gray = vec4( 0.8 , 0.8 , 0.8 , 1.0 );														\
	vec4 blue = vec4( 0.0 , 0.0 , 1.0 , 1.0 );														\
	vec4 red  = vec4( 1.0 , 0.0 , 0.0 , 1.0 );														\
	vec4 color;																						\
	if(inColor < 0 ) color = blue * (-inColor) + gray * (1.+inColor);								\
	else             color = red  * inColor + gray * ( 1.0 - inColor );								\
	color = ( color+gray ) / 2;																		\
	gl_FragColor = color * dot(normal,normalize(V2L)) + vec4(1) * pow( max(0.0,dot(r,v)), 100.0 ) ;	\
}																									\
";
const char vertex_code[] =
"														\
varying vec4 pos;										\
varying vec3 V2L;										\
varying float inColor;									\
void main()												\
{														\
	inColor = (gl_Vertex.w);							\
	gl_Vertex.w = 1;									\
														\
	pos = gl_ModelViewMatrix * gl_Vertex;				\
	V2L = vec3( gl_LightSource[0].position - pos );		\
														\
	gl_Position = ftransform();							\
}														\
";
const char selection_vertex_code[] =
"																\
void main()														\
{																\
	gl_Vertex.w=1;												\
	gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;		\
}																\
";
const char selection_fragment_code[] =
"																		\
void main()																\
{																		\
	gl_FragColor.x = float(  gl_PrimitiveID      % 256 ) / float(255);	\
	gl_FragColor.y = float( (gl_PrimitiveID>>8)  % 256 ) / float(255);	\
	gl_FragColor.z = float( (gl_PrimitiveID>>16) % 256 ) / float(255);	\
}																		\
";
