/*
Copyright (c) 2011, Michael Kazhdan and Ming Chuang
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/
// 09032009: this version binds with cpp for compilation convenience.
#ifndef MOUSE_INCLUDED
#define MOUSE_INCLUDED
#include "geometry.h"
/** This class represents the current state of the mouse */
class Mouse{
public:
	/** Was the shift button depressed when the mouse state was updated */
	int shiftDown;

	/** Was the control button depressed when the mouse state was updated */
	int ctrlDown;

	/** Was the alt button depressed when the mouse state was updated */
	int altDown;

	/** Was the left mouse button depressed when the mouse state was updated */
	int leftDown;

	/** Was the middle mouse button depressed when the mouse state was updated */
	int middleDown;

	/** Was the right mouse button depressed when the mouse state was updated */
	int rightDown;

	/** Was the scroll wheel depressed when the mouse state was updated */
	int scrollDown;

	/** The screen coordinates when the mouse state was updated */
	int startX,startY;

	/** The screen coordinates when the mouse was last moved */
	int endX,endY;

	int shiftX,shiftY;

	
	/** This constructor instantiates the mouse members */
	Mouse(void);

	/** This method updates the state of the mouse when the state of a mouse button is changed */
	void update(int button,int state,int x, int y);

	/** This method udpates the state of the mouse when the mouse is moved. The returned value
	  * indicates the distance (in screen coordinates) that the mouse has moved */
	void move(int x, int y);
};


Mouse::Mouse( void )
{
	startX=endX=-1;
	startY=endY=-1;
	scrollDown=leftDown=middleDown=rightDown=0;
	shiftDown=ctrlDown=leftDown=0;
}

void Mouse::update(int button,int state,int x, int y){
	int c;

	if( state==GLUT_DOWN )
	{
		shiftX=shiftY=0;
		startX=endX=x;
		startY=endY=y;
		if(button==GLUT_LEFT_BUTTON		){leftDown=1;}
		if(button==GLUT_MIDDLE_BUTTON	){middleDown=1;}
		if(button==GLUT_RIGHT_BUTTON	){rightDown=1;}
#ifdef GLUT_SCROLL_WHEEL
		if(button==GLUT_SCROLL_WHEEL	){scrollDown=1;}
#endif

		c=glutGetModifiers();
		if(c&GLUT_ACTIVE_SHIFT){shiftDown=1;}
		else{shiftDown=0;}
		if(c&GLUT_ACTIVE_CTRL){ctrlDown=1;}
		else{ctrlDown=0;}
		if(c&GLUT_ACTIVE_ALT){altDown=1;}
		else{altDown=0;}
	}
	else if(state==GLUT_UP){
		endX=x;
		endY=y;
		if(button==GLUT_LEFT_BUTTON		){leftDown=0;}
		if(button==GLUT_MIDDLE_BUTTON	){middleDown=0;}
		if(button==GLUT_RIGHT_BUTTON	){rightDown=0;}
#ifdef GLUT_SCROLL_WHEEL
		if(button==GLUT_SCROLL_WHEEL	){scrollDown=0;}
#endif
	}
}

void Mouse::move(int x,int y)
{
	shiftX=x-endX;
	shiftY=y-endY;
	endX=x;	
	endY=y;
}
#endif // MOUSE_INCLUDED
