/*
Copyright (c) 2011, Michael Kazhdan and Ming Chuang
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer. Redistributions in binary form must reproduce
the above copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the distribution. 

Neither the name of the Johns Hopkins University nor the names of its contributors
may be used to endorse or promote products derived from this software without specific
prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

#include< cutil_math.h >
__global__ void _kernelPrimal( float4* pos , unsigned int* eIndices , float* eValues , float4* cValues , unsigned int num , unsigned int eNum )
{
    unsigned int idx = blockIdx.x*blockDim.x + threadIdx.x;
	if(idx<num)
	{
		float* _eValues = eValues + idx*8;
		unsigned int* _eIndices = eIndices + idx*8;

		pos[idx]  = cValues[ _eIndices[ 0] ] * _eValues[ 0];
		pos[idx] += cValues[ _eIndices[ 1] ] * _eValues[ 1];
		pos[idx] += cValues[ _eIndices[ 2] ] * _eValues[ 2];
		pos[idx] += cValues[ _eIndices[ 3] ] * _eValues[ 3];
		pos[idx] += cValues[ _eIndices[ 4] ] * _eValues[ 4];
		pos[idx] += cValues[ _eIndices[ 5] ] * _eValues[ 5];
		pos[idx] += cValues[ _eIndices[ 6] ] * _eValues[ 6];
		pos[idx] += cValues[ _eIndices[ 7] ] * _eValues[ 7];
	}
}
__global__ void _kernelPrimal2( float4* pos , unsigned int* eIndices , unsigned int* nIndices , float* eValues , float4* pValues , float* cValues , unsigned int num , unsigned int eNum , unsigned int nNum )
{
    unsigned int idx = blockIdx.x*blockDim.x + threadIdx.x;
	if( idx<num )
	{
		float* _eValues = eValues + idx*8;
		unsigned int* _eIndices = eIndices + idx*8;

		pos[idx]  = pValues[ _eIndices[ 0] ] * _eValues[ 0];
		pos[idx] += pValues[ _eIndices[ 1] ] * _eValues[ 1];
		pos[idx] += pValues[ _eIndices[ 2] ] * _eValues[ 2];
		pos[idx] += pValues[ _eIndices[ 3] ] * _eValues[ 3];
		pos[idx] += pValues[ _eIndices[ 4] ] * _eValues[ 4];
		pos[idx] += pValues[ _eIndices[ 5] ] * _eValues[ 5];
		pos[idx] += pValues[ _eIndices[ 6] ] * _eValues[ 6];
		pos[idx] += pValues[ _eIndices[ 7] ] * _eValues[ 7];
		
		pos[idx].w = cValues[ nIndices[idx] ];
	}
}
#define BLOCK_SIZE 64
extern "C" void cuKernelPrimal( float4* pos , unsigned int* eIndices , float* eValues , float4* cValues , unsigned int num , unsigned int eNum )
{
    dim3 block( BLOCK_SIZE, 1, 1 );
    dim3 grid ( num/BLOCK_SIZE+1, 1, 1 );
    _kernelPrimal<<< grid, block>>>( pos , eIndices , eValues , cValues , num , eNum );
}
extern "C" void cuKernelPrimal2( float4* pos , unsigned int* eIndices , unsigned int* nIndices , float* eValues , float4* pValues , float* cValues , unsigned int num , unsigned int eNum , unsigned int nNum )
{
    dim3 block( BLOCK_SIZE, 1, 1 );
    dim3 grid ( num/BLOCK_SIZE+1, 1, 1 );
    _kernelPrimal2<<< grid, block>>>( pos , eIndices , nIndices , eValues , pValues , cValues , num , eNum , nNum );
}
