//////////////////
// MemoryStream //
//////////////////
template<class Data>
MemoryStream<Data>::MemoryStream(size_t size,int byteAlignment,bool zeroMemory)
{
	data = AlignedAllocArray< Data >( size , byteAlignment , "MemoryStream< Data >::data" );
	if( zeroMemory ) memset( data , 0 , sizeof( Data ) * size );
	_size=size;
	deleteData=true;
}
template<class Data>
MemoryStream<Data>::MemoryStream( Pointer( Data ) data,size_t size)
{
	this->data = data;
	_size=size;
	deleteData=false;
}
template<class Data>
MemoryStream<Data>::~MemoryStream(void)
{
	if( deleteData && data ) AlignedFreeArray( data );
	data = NullPointer< byte >( );
	_size=0;
}
template<class Data>
inline Data& MemoryStream<Data>::operator [] (size_t idx)
{
	return *(data+idx);
}
template<class Data>
inline size_t MemoryStream<Data>::size(void) const	{ return _size; }
template<class Data>
inline void MemoryStream<Data>::reset(void){ ; }


#if 0
//////////////////////
// FileMappedStream //
//////////////////////
#include <cstringt.h>
#include <atlstr.h>


template<class Data>
FileMappedStream<Data>::FileMappedStream(const char* fileName,size_t blockSize,int byteAlignment)
{
	hFile = CreateFileHandle( fileName );
	data  = CreateFileMapping( hFile , NULL , PAGE_READWRITE | SEC_COMMIT , 0 , 0 , NULL );
	_baseData = (Data*)MapViewOfFile(data,FILE_MAP_ALL_ACCESS,0,0,0);
	baseData  = (Data*)(((size_t)(_baseData)+byteAlignment-1) & ~(byteAlignment-1));
	_size=0;
	_blockSize=blockSize;
}

template<class Data>
FileMappedStream<Data>::FileMappedStream( size_t size , size_t blockSize , int byteAlignment )
{
	hFile = CreateFileHandle( NULL , NULL , true );
	data  = CreateFileMapping( hFile , NULL , PAGE_READWRITE | SEC_COMMIT , 0 , size*sizeof(Data)+byteAlignment-1 , NULL );
	_baseData = (Data*)MapViewOfFile(data,FILE_MAP_ALL_ACCESS,0,0,size*sizeof(Data)+byteAlignment-1);
	baseData  = (Data*)(((size_t)(_baseData)+byteAlignment-1) & ~(byteAlignment-1));
	_size=size;
	_blockSize=blockSize;
}
template<class Data>
FileMappedStream<Data>::~FileMappedStream(void)
{
	UnmapViewOfFile(_baseData);
	CloseFileHandle( hFile );
}
template<class Data>
void FileMappedStream<Data>::reset(void)
{
	dataPtr = baseData;
}
template<class Data>
size_t FileMappedStream<Data>::size(void) const
{
	return _size;
}
template<class Data>
Data& FileMappedStream<Data>::operator [] (size_t idx)
{
	dataPtr=baseData+idx;
	return *dataPtr;
}
#endif