#include "XPlatform.h"
#include "BaseMultiStreamIO.h"
#include "Socket.h"

//////////////
// IOClient //
//////////////
const int IOClient::BYTES_PER_SECTOR = 1<<9;					// 512B Sector sizes
//const int IOClient::IO_BLOCK_SIZE = BYTES_PER_SECTOR<<13;		// 4MB IO Chunks
const int IOClient::IO_BLOCK_SIZE = BYTES_PER_SECTOR<<12;		// 2MB IO Chunks
long long IOClient::ReadBytes  = 0;
long long IOClient::WriteBytes = 0;

IOClient::IOClient( void )
{
	InitializeCriticalSection( &lock );
	server = NULL;
}
IOClient::~IOClient( void )
{
	DeleteCriticalSection( &lock );
}
void IOClient::SetServer( class MultiStreamIOServer* server )
{
	this->server = server;
	if( server ) server->AddClient( this );
}
/////////////////////////
// MultiStreamIOServer //
/////////////////////////
MultiStreamIOServer::MultiStreamIOServer( void )
{
	InitializeCriticalSection( &_pendingLock );
	InitializeCriticalSection( &_clientLock );

	_allowNewClients = true;
	_pendingClient = NULL;
	_ioThread = RunThread( _IOThread , this );
	if( !TestThreadHandle( _ioThread ) ) fprintf( stderr , "[ERROR] MultiStreamIOServer::MultiStreamIOServer: Failed to create I/O thread\n" ) , exit( 0 );
}
MultiStreamIOServer::~MultiStreamIOServer( void )
{
	// First get _ioThread to terminate, if it's still active
	if( IsActiveThread( _ioThread ) )
	{
		while( 1 )
		{
			// As long as the server has work to do, it cannot be terminated.
			EnterCriticalSection( &_clientLock );
			if( !_clients.size() )
			{
#if 1			// [WARNING] Dead-lock potential. Trying to interrupt while holding onto _clientLock.
				// _IOThread may block waiting for the lock before reaching the interrupt point.
				_allowNewClients = false;
				LeaveCriticalSection( &_clientLock );
				if( !InterruptThread( _ioThread ) ) fprintf( stderr , "[WARNING] MultiStreamIOServer::~MultiStreamIOServer: Failed to interrupt MultiStreamIOServer thread\n" );
#else
				if( !InterruptThread( _ioThread ) ) fprintf( stderr , "[WARNING] MultiStreamIOServer::~MultiStreamIOServer: Failed to interrupt MultiStreamIOServer thread\n" );
				LeaveCriticalSection( &_clientLock );
#endif
				break;
			}
			LeaveCriticalSection( &_clientLock );
		}
	}

	DeleteCriticalSection( &_pendingLock );
	DeleteCriticalSection( &_clientLock );
}
bool MultiStreamIOServer::SetPending( IOClient* client )
{
	EnterCriticalSection( &_pendingLock );
	if( !_pendingClient && client )
	{
		_pendingClient = client;
		LeaveCriticalSection( &_pendingLock );
		return true;
	}
	else
	{
		LeaveCriticalSection( &_pendingLock );
		return false;
	}
}
void MultiStreamIOServer::AddClient( IOClient* client )
{
	EnterCriticalSection( &_clientLock );
	if( _allowNewClients ) _clients.push_back( client );
	else fprintf( stderr , "[ERROR] MultiStreamIOServer::AddClient: Adding new clients disallowed\n" );
	LeaveCriticalSection( &_clientLock );
}
int MultiStreamIOServer::clientNum( void )
{
	EnterCriticalSection( &_clientLock );
	int sz = int( _clients.size() );
	LeaveCriticalSection( &_clientLock );
	return sz;
}
THREAD_FUNCTION_OUT MultiStreamIOServer::_IOThread( THREAD_FUNCTION_IN vparams )
{
	MultiStreamIOServer* server = (MultiStreamIOServer*)vparams;
	std::vector< IOClient* >& clients = server->_clients;
	int idx = 0;
	{
		while( 1 )
		{
#ifdef USE_BOOST_THREADS
			if( boost::this_thread::interruption_requested() ) break;
#endif // USE_BOOST_THREADS
			bool hasPending = false;
			{
				EnterCriticalSection( &server->_pendingLock );
				if( server->_pendingClient )
				{
					if( server->_pendingClient->Service() == IOClient::NONE ) SleepThisThread( 0 );
					else server->_pendingClient = NULL;
					hasPending = true;
				}
				LeaveCriticalSection( &server->_pendingLock );
			}
			if( !hasPending )
			{
				EnterCriticalSection( &server->_clientLock );
				bool ioDone = false;
				for( int i=0 ; i<clients.size() && !ioDone ; i++ )
				{
					idx = (idx+1)%clients.size();
					switch( clients[idx]->Service() )
					{
					case IOClient::COMPLETE:
						clients[idx]->SetServer( NULL );
						clients[idx] = clients[clients.size()-1];
						clients.pop_back();
					case IOClient::SUCCESS:
						ioDone = true;
						break;
					}
				}
				LeaveCriticalSection( &server->_clientLock );
				if( !ioDone ) SleepThisThread( 1 );
				else SleepThisThread( 0 );
			}
		}
	}
	return 0;
}
