from CourseListing import CourseListing
from Course import Course

class SemesterListing:
    """
    Class to represent a collection of CourseListings for a particular semester, 
    mapped with unique CourseIDs to the actual CourseListings.
    """

    def __init__(self, when, year):
        """
        Create a semester listing based on when (Fall/Spring) and year,
        with an empty mapping of CourseID strings to CourseListings.
        Save the when parameter with a capital first letter and the
        rest in lower case as data member "_season".

        """
        pass


    def __str__(self):
        """
        Return a string representation which is the semester info
        (season & year), followed by the courses ordered by number,
        one per line.  Include all information for each course, in the
        format generated by it's standard string representation.
        >>> str(SemesterListing(spring, 2016))
        SPRING 2016

        """
        pass


    def code(self):
        """
        Return short-cut semester code.
        >>> SemesterListing("fall", 2015).code()
        'FA15'
        """
        return self._season[:2].upper() + str(self._year)[-2:]


    def add(self, crse):
        """

        Add a course to this semester if it doesn't already exist
        there.  If the crse parameter is only a Course object and not
        yet a CourseListing object, then create a CourseListing from
        it by getting user input for the instructor and timeblock and
        using this semester's season and year.  If the crse parameter
        is a CourseListing object already, then make sure its
        semester and year match this semester's data.  Return True if
        added, False otherwise.

        >>> sem = SemesterListing("Fall", 2015) 
        >>> cl = CourseListing(Course("en.600.107", "intro java", 4), "Selinski", "MWF 3", "spring", 2015) 
        >>> sem.add(cl) 
        True 
        >>> print cl 
        EN.600.107 intro java (4.0) Selinski [MWF 3] 
        >>> cl._semester 
        'Fall'

        """
        pass


    def delete(self, cid):
        """
        Remove a course from this semester listing if it's there, based on
        a course num (cid).  Return True if deleted, false otherwise.

        """
        pass

