"""
Menu-driven program to manipulate course listings and a central catalog.
"""
from CourseID import CourseID
from Course import Course
from CourseListing import CourseListing
from SemesterListing import SemesterListing

def menu():
    """
    Print menu and get user choice.
    """
    print "0) Quit program (saves courses)"
    print "1) Create new course"
    print "2) Create new semester"
    print "3) Add course to semester"
    print "4) Remove course from semester"
    print "5) List all courses"
    print "6) List semester courses"
    print "7) Add courses to catalog from text file"
    print "8) Save semester to excel file"
    print "9) Load semester from excel file"
    choice = int(input("enter choice # "))
    return choice


def newCourse(catalog, cid):
    """
    Add new course to catalog, given course number object (cid)
    """
    cstr = str(cid)
    if cstr not in catalog:
        name = raw_input("course title? ")
        crds = input("credits? ")
        crse = Course(cid, name, crds)
        catalog[cstr] = crse
        return crse
    else:
        return catalog[cstr]


def readCourseNum():
    """
    Read course number information, returning CourseID object.
    """
    cnum = raw_input("enter full course number in format DV.###.### ")
    return CourseID(cnum)
    

def readSemester():
    """
    Read semester information from keyboard.
    """
    season = raw_input("Season? ").lower().capitalize()
    year = int(input("Year (4 digits)? "))
    semCode = season.upper()[:2] + str(year)[-2:]
    return season, year, semCode


def newSemester(semesters):
    season, year, semCode = readSemester()
    if semCode in semesters:
        print "ERROR: " + semCode + " already exists"
    else: # add it
        sem = SemesterListing(season, year)
        semesters[semCode] = sem
        return sem


def saveSemester(semester):
    """
    Save a particular semester to an excel workbook.  The name of the
    workbook must match the semester code, such as "FA15.xls".

    """
    print "SAVE SEMESTER (excel format) not yet implemented"


def loadSemester(semester):
    """
    Load a semester from an excel workbook.  The name of the workbook
    must match the semester code, such as "FA15.xls".
    """
    print "LOAD SEMESTER (excel format) not yet implemented"


def saveCatalog(filename, catalog):
    """
    Save the current state of the catalog to plain text file using the
    specified filename.  The format of this file should be: 
    """
    print "SAVE CATALOG not yet implemented"


def loadCatalog(filename, catalog):
    """
    Add courses to catalog from text file, given by filename.  The
    filename could be either a local text file or a URL location for a
    plain text file.  URL will contain 'http', whereas a local
    filename will not.  If a course already exists in the catalog,
    update its details according to the new information.
    """
    print "LOAD CATALOG not yet implemented"


def main():
    catalog = {}   # central catalog of all courses
    print "loading courses from Courses.db file"
    loadCatalog("Courses.db", catalog)
    semesters = {}  # central collection of all semester listings
    choice = 1
    while choice != 0:
        choice = menu()
        if choice == 0:
            print "saving courses to Courses.db file"
            saveCatalog("Courses.db", catalog)
        elif choice == 1:
            cid = readCourseNum()
            newCourse(catalog, cid)
        elif choice == 2:
            newSemester(semesters)
        elif choice == 3:
            # add course to semester
            cid = readCourseNum()
            crse = newCourse(catalog, cid)
            sem, yr, scode = readSemester()
            if scode in semesters:
                semesters[scode].add(crse)
            else:
                print "ERROR: " + scode + " doesn't exist, please add first"
        elif choice == 4:
            # remove course from semester
            cid = readCourseNum()
            sem, yr, scode = readSemester()
            if scode in semesters:
                semesters[scode].delete(cid)
            else:
                print "ERROR: " + scode + " doesn't exist"
        elif choice == 5:
            # list all courses
            for k in catalog:
                print catalog[k]
        elif choice == 6:
            # list all semester courses
            sem, yr, semCode = readSemester()
            if semCode in semesters:
                print semesters[semCode]
            else:
                print "ERROR: " + semCode + " doesn't exist"
        elif choice == 7:
            # add courses to catalog from text file
            filename = raw_input("filename? ")
            loadCatalog(filename, catalog)
        elif choice == 8:
            # save semester to excel file
            sem, yr, semCode = readSemester()
            if semCode in semesters:
                saveSemester(semesters[semCode])
            else:
                print "ERROR: " + semCode + " doesn't exist"
        elif choice == 9:
            # load semester from excel file
            sem, yr, semCode = readSemester()
            if semCode not in semesters:
                semesters[semCode] = SemesterListing(sem, yr)
                loadSemester(semesters[semCode])
            else:
                print "ERROR: " + semCode + " already exists"
        else:
            print "ERROR: invalid menu option, try again"


main()
