from Course import Course

class CourseListing(Course):
    """
    Extension of core Course object to include semester-specific information.
    """
    
    def __init__(self, core, instr, times, sem, year):
        """
        Initialize with core (Course), instructor, meeting times, 
        semester, and year.  (Need to add validity checks!)
        """
        Course.__init__(self, core._number, core._title, core._credits)
        self._instr = instr
        self._when = times
        self._semester = sem.lower().capitalize()  # Fall or Spring
        self._year = year


    def __str__(self):
        """
        >>> print CourseListing(Course("en.600.112", "IPSE", 4), "Selinski", "MWF 12", "FALL", 2015)
        EN.600.112 IPSE (4.0) Selinski [MWF 12]
        """
        return Course.__str__(self) + " " + self._instr + " [" + self._when + "]"
        

    def __eq__(self, other):
        """
        """
        return self._number == other._number and self._instr == other._instr and \
            self._semester == other._semester and self._year == other._year and \
            self._when == other._when


    def __ne__(self, other):
        return not self == other


    def __cmp__(self, other):
        """
        Compare CourseListings chronologically by semester, then by course number.
        """
        diff = self._year - other._year
        if diff == 0:
            if self._semester == other._semester:
                return cmp(self._number, other._number)
            elif self._semester == 'Spring':
                return -1
            else:
                return 1
        else:
            return diff

    # inherits getID, number, name, credits from Course class
