from CourseID import CourseID

class Course:
    """
    Hold and manipulate core information for a course.
    """

    def __init__(self, cnum, name, creds):
        """
        Initialize from course number/ID string (cnum), name, and credits.
        """
        if type(cnum) is str:
            self._number = CourseID(cnum)
        elif isinstance(cnum, CourseID):
            self._number = cnum
        else:
            print "ERROR - invalid course number"
            self._number = CourseID("DV.###.###")
        self._title = name
        self._credits = float(creds)


    def __str__(self):
        """
        Return string representation of course.
        >>> print Course("EN.600.112", "IPSE", 4.0)
        EN.600.112 IPSE (4.0)
        >>> print Course(CourseID("e.60.30"), "blah", 3)
        E.060.030 blah (3.0)
        """
        return str(self._number) + " " + self._title + \
            " (" + "%0.1f"%float(self._credits) + ")"


    def __eq__(self, other):
        return self._number == other._number


    def __ne__(self, other):
        return self._number != other._number


    def __cmp__(self, other):
        """
        Compare courses based on number.
        >>> Course("en.060.112", "what", 3) < Course("py.300.492", "blah", 3.5)
        True
        >>> Course("en.60.112", "what", 3) > Course("en.300.492", "blah", 3.5)
        False
        """
        return self._number.__cmp__(other._number)


    def getID(self):
        """
        Return course ID as string
        >>> print Course("en.600.112", "IPSE", 4).getID()
        EN.600.112
        """
        return str(self._number)


    def name(self):
        """
        >>> Course("en.600.112", "IPSE", 4).name()
        'IPSE'
        """
        return self._title


    def credits(self):
        """
        >>> Course("en.600.112", "IPSE", 4).credits()
        4.0
        """
        return self._credits
