import java.util.Random;

/** Player class for LCR game.  
   Your version should have javadoc comments for each method
 */
public class Player {

   private static Random rand = new Random();
   private static final int START = 3;
   private static final int SIDES = 6;
   
   private String name;
   private int chips;
   
   public Player(String n) {
      name = n;
      chips = START;
   }
   
   public void addChip() {
      chips++;
   }
   
   public void loseChip() {
      chips--;
   }
   
   public int chips() {
      return chips;
   }
   
   public String getName() {
      return name;
   }
   
   public boolean out() {
      return chips == 0;
   }
   
   /** Generate a random letter to represent rolling one die.
       @return the letter on the face generated
   */
   public static char rollDie() {
      switch (rand.nextInt(SIDES)) {
         case 0: 
            return 'L';  // left
         case 1: 
            return 'C';  // center
         case 2: 
            return 'R';  // right
         default: 
            return '.';  // 3 sides are dots (keep)
      }
   }
   
   
}