package pqueue;
import container.*;

/** A "priority deque" is like a priority queue, except that
 * items can be removed from either end.  
 * 
 * We start with a priority queue, and add max() and removeMax()
 * methods to get the entry with maximum key.  We already have a way
 * to get the entry with minimum key.
 */

public interface PriorityDeque extends PriorityQueue {

  /** Returns but does not remove an entry with maximum key. */
  public Entry max() throws EmptyPriorityQueueException;

  /** Removes and returns an entry with maximum key. */
  public Entry removeMax() throws EmptyPriorityQueueException;
}
