package election;

import container.Entry;
import pqueue.AdaptablePriorityQueue;
import java.util.Stack;

public class BallotPile {

  /** e.value() is a Stack of ballots, and e.key() is 
   * the total weight of the ballots in that stack.  So all the
   * information about the pile is actually stored inside e.
   * 
   * e itself is a location-aware entry on an adaptable priority
   * deque.  When we change the key, it moves the entry
   * on the queue or deque.  
   */

  Entry e;
  
  /** This constructor wraps up an entry from a priority queue or deque
   * into a BallotPile object, which doesn't store any additional
   * data, but supports our nice methods.
   */
  public BallotPile(Entry e) {
    this.e = e;
  }

  /** This constructor creates an empty new ballot pile 
   * on a given repriority queue (or deque).
   */
  public BallotPile(AdaptablePriorityQueue pq) {
    this(pq.insert(new Float(0), new Stack()));
  }

  // --------- PUT YOUR METHODS HERE -------------
  // You should have appropriate methods for doing things with
  // ballot piles.  The names of these methods should describe
  // actions on ballot piles, which are the conceptual objects you
  // are manipulating -- they should not mention the IMPLEMENTATION
  // in terms of stacks and entries and such.
  //
  // It would probably be good to have methods to add and remove
  // ballots from the pile, to find out the total number of
  // votes on the pile, to remove the pile from a given priority
  // queue, and anything else that comes in handy as you write
  // your STVElection class.  Oh yes, and it's always helpful to 
  // write toString() and a main() test method.
}  
