// Code from the textbook.

/** Interface for the priority queue ADT */
public interface PriorityQueue {

  /** Returns the number of items in the priority queue. */
  public int size();

  /** Returns whether the priority queue is empty. */
  public boolean isEmpty();

  /** Returns but does not remove an entry with minimum key. */
  public Entry min() throws EmptyPriorityQueueException;

  /** Inserts a key-value pair and return the entry created. */
  public Entry insert(Object key, Object value) throws InvalidKeyException;

  /** Removes and returns an entry with minimum key. */
  public Entry removeMin() throws EmptyPriorityQueueException;
}
