/**
 * DataReaderTest.java  1.00 99/03/11 Merlin Hughes
 *
 * Copyright (c) 1999 Merlin Hughes. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * for non-commercial purposes and without fee is hereby granted
 * provided that this copyright notice appears in all copies.
 *
 * http://merlin.org/                          merlin@merlin.org
 *
 * Modified by Jason Eisner <jason@cs.jhu.edu> to illustrate
 * methods useful in a homework for 600.226 Data Structures.
 */

import java.io.*;
import org.merlin.io.*;

public class DataReaderTest {
  public static void main (String[] args) throws IOException {

    DataReader data = new DataReader (new StringReader ("  35.3e26.345  67.8.9 / 0"),
				      false, true);

    /* We'll just use a couple of the several public methods
       in DataReader.  You can look at org/merlin/io/DataReader.java
       to see the others.  But the ones below will probably be most
       useful to you in this homework.
    */

    while (!data.peekEOF ()) { 
      System.out.println (data.readDouble());  // eats the longest possible double
      System.out.println ((char)data.peek());  // peeks at next character, but leaves
                                               //   it there to be eaten later
    }

    /****************************************
     Here is the output.  See if you can figure out why!

        hw5-expr-josh$ java DataReaderTest
        3.53E27
        .
        0.345
        6
        67.8
        .
        0.9
        /
        Exception in thread "main" java.lang.NumberFormatException: empty String
        	at java.lang.FloatingDecimal.readJavaFormatString(FloatingDecimal.java:986)
        	at java.lang.Double.valueOf(Double.java:184)
        	at org.merlin.io.DataReader.readDecimal(DataReader.java:246)
        	at org.merlin.io.DataReader.readDouble(DataReader.java:234)
        	at DataReaderTest.main(DataReaderTest.java:24)
    ***************************************/
  }
}
