/** A test class for FancyList.  Each instance is an
 * integer/string pair.  Instances are sorted only on the
 * strings, so 0/hello and 2/hello are considered to be
 * equal, and a stable sort will preserve their order in
 * the input sequence.
 */

public class NumberedString implements Comparable {
  int i;
  String s;

  public NumberedString(int i, String s) {
    this.i = i;
    this.s = s;
  }

  public String toString() {
    return i + " / " + s;
  }

  public int compareTo(Object val) {
    return s.compareTo( ((NumberedString) val).s );
  }

  public boolean equals(Object val) {
    return (compareTo(val) == 0);
  }

  /** Given an array of strings such as
   *   {"hello", "i love you", "hello", "goodbye"}
   * return a FancyList of NumberedStrings that pairs
   * each string with its index in the array:
   *   0 / hello,
   *   1 / i love you,
   *   2 / hello,
   *   3 / goodbye
   */
  public static FancyList listify(String[] args) {
    // fill this in
  }

  /** Given an iterator, create a new list of the elements it produces,
   * in order.  This can be used to non-destructively copy, reverse,
   * or sort a list!
   */
  public static FancyList listFromIter(java.util.Iterator iter) {
    // fill this in
  }

  /** Iterate over objects and print each one. */
  public static void printIter(String header, java.util.Iterator iter) {
    System.out.println("--- " + header + " ---");
    while (iter.hasNext())
      System.out.println("  " + iter.next());
  }

  /** Construct various iterators over the given FancyList,
   * and run printIter on each one.
   */
  public static void test(String descrip, FancyList fl) {
    printIter(descrip, fl.iterator());
    printIter(descrip + " [in reverse order]", fl.iteratorReverse());
    printIter(descrip + " [in sorted order]", fl.iteratorSorted());
    System.out.println("============================================================");
  }

  /** A test method for the FancyList interface. */
  public static void main(String[] args) {

    FancyList example = listify(new String[] 
                                 {"hello", "i love you", "hello", "goodbye"});
    test("example", example);
    test("sort(example)", listFromIter(example.iteratorSorted()));

    FancyList fl = listify(args);
    test("args", fl);

    fl = fl.reverse_destructive();    
    test("reverse(args)", fl);

    fl = fl.append_destructive(example).append_destructive(listify(args));
    test("reverse(args) + example + args", fl);
  }
}
